/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.omcmplinbill;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.consts.BizTypeConsts;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.algorithm.TaxAlgorithmForForm;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.ErrorCodeHelper;
import kd.scmc.im.business.helper.SetValueForBotpWBHelper;
import kd.scmc.im.business.helper.SupplierHelper;
import kd.scmc.im.common.mdc.consts.PrecisionAccountEnum;
import kd.scmc.im.common.mdc.utils.EntityNameUtils;
import kd.scmc.im.common.mdc.utils.MDCDyObjUtil;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OmCmplInBillEditPlugin
extends ImBillEditPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private TaxAlgorithmForForm algo = null;

    protected TaxAlgorithmForForm getAlgorithm() {
        if (this.algo == null) {
            this.algo = new TaxAlgorithmForForm(this.getView());
        }
        return this.algo;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"providersupplier", "receivesupplier", "invoicesupplier", "providerlinkman", "bizoperatorgroup", "bizoperator", "bizdept", "entrysettleorg", "owner", "outowner", "keeper", "outkeeper", "supplier", "taxrateid"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel bill = this.getModel();
        DynamicObject bizOrg = (DynamicObject)bill.getValue("bizorg");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        switch (key) {
            case "supplier": {
                this.supplierSelect(e);
                break;
            }
            case "providersupplier": 
            case "invoicesupplier": 
            case "receivesupplier": {
                this.supplierInfoSelect(e);
                break;
            }
            case "providerlinkman": {
                this.providerLinkmanSelect(e, rowIndex, showParameter);
                break;
            }
            case "bizoperatorgroup": {
                this.bizOperatorGroupSelect(e, bizOrg, showParameter);
                break;
            }
            case "bizoperator": {
                this.bizOperatorSelect(e, bizOrg, showParameter);
                break;
            }
            case "bizdept": {
                this.bizDeptSelect(e, bizOrg, showParameter);
                break;
            }
            case "owner": {
                this.ownerSelect(e);
                break;
            }
            case "taxrateid": {
                this.taxrateSelect(e, showParameter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("backflushout".equals(operateKey)) {
            this.beforeDoBackFlushOut();
        }
        if ("chargeagainst".equals(operateKey)) {
            String formId = this.getView().getFormShowParameter().getFormId();
            OperateOption option = operate.getOption();
            if ("im_mdc_omcmplinbil_opm".equals(formId)) {
                option.setVariableValue("fromid", "im_mdc_omcmplinbil_opm");
            }
        }
    }

    private void beforeDoBackFlushOut() {
        ArrayList<String> billNos = new ArrayList<String>(16);
        billNos.add(this.getModel().getValue("billno").toString());
        Object entryReqOrg = this.getModel().getValue("entryreqorg", 0);
        if (entryReqOrg instanceof DynamicObject) {
            DynamicObject entryReqOrgDyObj = (DynamicObject)entryReqOrg;
            Object orgPkValue = entryReqOrgDyObj.getPkValue();
            BillShowParameter showParameter = this.createAddNewBillShowParam(billNos, orgPkValue);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private BillShowParameter createAddNewBillShowParam(List<String> billnos, Object pkID) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("im_mdc_ombackflushform");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("bfBillnosList", billnos);
        showParameter.setCustomParam("productionOrg", pkID);
        showParameter.setCustomParam("billType", (Object)"im_mdc_omcmplinbill");
        return showParameter;
    }

    private void supplierSelect(BeforeF7SelectEvent e) {
        this.addVMISelect(e);
    }

    private void addVMISelect(BeforeF7SelectEvent e) {
        Object bizTypeId;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && ((bizTypeId = bizType.getPkValue()).equals(BizTypeConsts.BIZTYPE_PURIN_VMI) || bizTypeId.equals(BizTypeConsts.BIZTYPE_PURINRETURN_VMI))) {
            QFilter q = new QFilter("enablevmi", "=", (Object)"1");
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)q);
        }
    }

    private void supplierInfoSelect(BeforeF7SelectEvent e) {
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
        if (supplier == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_SUPPLIER(), (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void providerLinkmanSelect(BeforeF7SelectEvent e, int rowIndex, ListShowParameter showParameter) {
        DynamicObject providerSupplier = (DynamicObject)this.getModel().getValue("providersupplier", rowIndex);
        if (providerSupplier == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_PROVIDERSUPPLIER(), (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("supplierid", "=", providerSupplier.getPkValue()).and("invalid", "=", (Object)false)));
        }
    }

    private void bizOperatorGroupSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%1$s\u201d\u3002", (String)"OmCmplInBillEditPlugin_10", (String)"scmc-mm-mdc", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        DynamicObject bizoperator = (DynamicObject)this.getModel().getValue("bizoperator");
        if (bizoperator == null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0));
        } else {
            bizoperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizoperator.getPkValue(), (String)"bd_operator");
            QFilter qFilter01 = new QFilter("operatorid", "=", bizoperator.getDynamicObject("operatorid").getPkValue());
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter01});
            if (map.size() != 0) {
                ArrayList list = new ArrayList(map.values());
                ArrayList<Long> groupList = new ArrayList<Long>();
                for (int i = 0; i < list.size(); ++i) {
                    groupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", groupList));
            }
        }
    }

    private void bizOperatorSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
        QFilter enableFilter;
        long bizOrgId;
        QFilter operatorGroupIdFilter;
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%1$s\u201d\u3002", (String)"OmCmplInBillEditPlugin_10", (String)"scmc-mm-mdc", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        BasedataEdit control = (BasedataEdit)this.getControl("bizoperatorgroup");
        BasedataProp property = (BasedataProp)control.getProperty();
        FilterBuilder buildCoreFilter = property.buildCoreFilter(this.getModel());
        QFilter filterGridFilter = buildCoreFilter.getQFilter();
        Map currentBizOrgBizOperatorGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{filterGridFilter, operatorGroupIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)(bizOrgId = Long.parseLong(bizOrg.getPkValue().toString()))), enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (currentBizOrgBizOperatorGroup != null && !currentBizOrgBizOperatorGroup.isEmpty()) {
            HashSet keySet = new HashSet(currentBizOrgBizOperatorGroup.keySet());
            QFilter qFilter = new QFilter("operatorgrpid", "in", new ArrayList(keySet));
            QFilter qFilter1 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter, qFilter1));
        } else if (currentBizOrgBizOperatorGroup == null || currentBizOrgBizOperatorGroup.isEmpty()) {
            showParameter.getListFilterParameter().setFilter(new QFilter("operatorgrpid", "in", null));
        }
    }

    private void bizDeptSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
    }

    private void ownerSelect(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        String type = (String)this.getModel().getValue("ownertype", rowIndex);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        switch (type) {
            case "bos_org": 
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                this.addVMISelect(e);
                break;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    protected void taxrateSelect(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        IDataModel dataModel = this.getModel();
        Object bizTime = dataModel.getValue("biztime");
        if (bizTime == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_BIZTIME()));
            e.setCancel(true);
            return;
        }
        QFilter f = new QFilter("activedate", "<=", bizTime);
        QFilter fExpdate = new QFilter("expdate", ">=", bizTime);
        fExpdate.or(new QFilter("expdate", "is null", null));
        f.and(fExpdate);
        showParameter.getListFilterParameter().setFilter(f);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("billno")) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        HashMap<String, DynamicObject> number_objMap = new HashMap<String, DynamicObject>(2);
        number_objMap.put("110", BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"110")}));
        number_objMap.put("113", BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"113")}));
        for (int i = 0; i < valueSet.length; ++i) {
            ChangeData changedata;
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            if ("qualitystatus".equals(propName) && (changedata = valueSet[i]).getNewValue() != null) {
                switch (changedata.getNewValue().toString()) {
                    case "A": 
                    case "B": {
                        this.getModel().setValue("invstatus", number_objMap.get("110"), changedata.getRowIndex());
                        break;
                    }
                    case "D": {
                        this.getModel().setValue("invstatus", number_objMap.get("113"), changedata.getRowIndex());
                        break;
                    }
                }
            }
            if ("currency".equals(propName)) {
                this.changeExchangeRate();
            } else if ("settlecurrency".equals(propName)) {
                this.changeSettleCurrency();
            } else if ("exratetable".equals(propName)) {
                this.changeExchangeRate();
            } else if ("exratedate".equals(propName)) {
                this.changeExchangeRate();
            } else if ("supplier".equals(propName)) {
                this.changeSupplier(newValue);
            } else if ("providersupplier".equals(propName)) {
                this.changeProviderSupplier((DynamicObject)newValue, rowIndex);
            } else if ("istax".equals(propName)) {
                this.changeIsTax(newValue);
            } else if ("ispresent".equals(propName)) {
                this.changeIsPresent(newValue, rowIndex);
            } else if ("priceandtax".equals(propName)) {
                this.changePriceAndTax(rowIndex, newValue, oldValue);
            } else if ("actualprice".equals(propName)) {
                this.changeActualPrice(rowIndex, newValue, oldValue);
            } else if ("actualtaxprice".equals(propName)) {
                this.changeActualTaxPrice(oldValue, newValue, rowIndex);
            } else if ("discounttype".equals(propName) || "discountrate".equals(propName)) {
                this.changeDiscountType(propName, oldValue, newValue, rowIndex);
            } else if ("discountamount".equals(propName)) {
                this.changeDiscountAmount(propName, oldValue, (BigDecimal)newValue, rowIndex);
            } else if ("taxamount".equals(propName)) {
                this.changeTaxMount(propName, oldValue, newValue, rowIndex);
            } else if ("taxrateid".equals(propName)) {
                this.changeTaxRateID((DynamicObject)newValue, rowIndex);
            } else if ("exchangerate".equals(propName)) {
                this.changeExChangeRate(propName, oldValue, newValue);
            } else if ("bizoperator".equals(propName)) {
                this.changeBizOperator((DynamicObject)newValue);
            } else if ("bizoperatorgroup".equals(propName)) {
                this.changeBizOperatorGroup((DynamicObject)newValue);
            } else if ("bizorg".equals(propName)) {
                this.changeBizOrg(newValue);
                this.change4BizOrg((DynamicObject)newValue);
            } else if ("entryreqorg".equals(propName)) {
                this.changeEntryReqOrg((DynamicObject)newValue, rowIndex);
            } else if ("biztime".equals(propName)) {
                this.changeBizTime(this.getModel());
            } else if ("qty".equals(propName) || "unit".equals(propName)) {
                IDataModel model = this.getModel();
                SetValueForBotpWBHelper.purInSetValueByQtyChange((IDataModel)model, (int)rowIndex);
            } else if ("invscheme".equals(propName)) {
                this.changeInvScheme((DynamicObject)newValue);
            } else if ("warehouse".equals(propName)) {
                this.changeWarehouse((DynamicObject)newValue, rowIndex);
            } else if ("location".equals(propName)) {
                this.changeLocation((DynamicObject)newValue, rowIndex);
            } else if ("outwarehouse".equals(propName)) {
                this.changeOutWarehouse((DynamicObject)newValue, rowIndex);
            }
            boolean calByChange = true;
            Object calByChangeObj = this.getView().getFormShowParameter().getCustomParam("calByChange");
            if (calByChangeObj != null) {
                calByChange = (Boolean)calByChangeObj;
            }
            if (!calByChange) continue;
            this.getAlgorithm().calByChange(e);
        }
    }

    private void changeLocation(DynamicObject newValue, int rowIndex) {
        DynamicObject invscheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (invscheme == null) {
            return;
        }
        boolean isoutupdate = invscheme.getBoolean("isoutupdate");
        if (isoutupdate) {
            DynamicObject outlocation = (DynamicObject)this.getModel().getValue("outlocation", rowIndex);
            DynamicObject location = (DynamicObject)this.getModel().getValue("location", rowIndex);
            if (outlocation == null && location != null) {
                Long warehouseId = (Long)this.getModel().getValue("warehouse_id", rowIndex);
                Long outwarehouseId = (Long)this.getModel().getValue("outwarehouse_id", rowIndex);
                if (Long.compare(warehouseId, outwarehouseId) == 0) {
                    this.getModel().setValue("outlocation", (Object)location, rowIndex);
                }
            }
        }
    }

    private void changeOutWarehouse(DynamicObject outWareHouse, int rowIndex) {
        if (outWareHouse != null) {
            DynamicObject outlocation = (DynamicObject)this.getModel().getValue("outlocation");
            boolean isopenlocation = outWareHouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowIndex, new String[]{"outlocation"});
            if (outlocation == null) {
                Long wareHouseId = (Long)this.getModel().getValue("warehouse_id", rowIndex);
                Long outWareHouseId = outWareHouse.getLong("id");
                if (Long.compare(wareHouseId, outWareHouseId) == 0) {
                    this.getModel().setValue("outlocation", this.getModel().getValue("location", rowIndex), rowIndex);
                }
            }
            if (!isopenlocation) {
                this.getModel().setValue("outlocation", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"outlocation"});
            }
        } else {
            this.getModel().setValue("outlocation", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"outlocation"});
        }
    }

    private void changeWarehouse(DynamicObject warehouse, int rowIndex) {
        DynamicObject outwarehouse = (DynamicObject)this.getModel().getValue("outwarehouse", rowIndex);
        boolean isoutupdate = ((DynamicObject)this.getModel().getValue("invscheme")).getBoolean("isoutupdate");
        if (outwarehouse == null && isoutupdate) {
            this.getModel().setValue("outwarehouse", (Object)warehouse, rowIndex);
        }
    }

    private void changeInvScheme(DynamicObject invscheme) {
        if (invscheme == null) {
            return;
        }
        boolean isoutupdate = invscheme.getBoolean("isoutupdate");
        this.getView().setVisible(Boolean.valueOf(isoutupdate), new String[]{"outwarehouse", "outlocation"});
        if (isoutupdate) {
            int count = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < count; ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"outlocation"});
            }
        }
    }

    private void changeBizTime(IDataModel model) {
        int rowCount = model.getEntryRowCount("billentry");
        Date bizTime = (Date)model.getValue("biztime");
        if (rowCount > 0) {
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("billentry");
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                boolean needClear;
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                DynamicObject taxrate = dynamicObject.getDynamicObject("taxrateid");
                if (taxrate == null) continue;
                Date activedate = taxrate.getDate("activedate");
                Date expdate = taxrate.getDate("expdate");
                boolean bl = needClear = bizTime == null || bizTime.before(activedate) || expdate != null && bizTime.after(expdate);
                if (!needClear) continue;
                this.setValue("taxrateid", null, i, false);
                this.changeTaxRateID(null, i);
            }
        }
    }

    private void changeSupplier(Object newValue) {
        DynamicObject supplier = (DynamicObject)newValue;
        Object supplierId = null;
        DynamicObject invoiceSupplier = null;
        DynamicObject receivingSupplier = null;
        DynamicObject deliverSupplier = null;
        DynamicObject settlementCy = null;
        DynamicObject settlementType = null;
        DynamicObject payCond = null;
        IDataModel bill = this.getModel();
        int size = bill.getEntryEntity("billentry").size();
        if (supplier == null) {
            bill.setValue("paycondition", null);
            bill.setValue("settletype", null);
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                bill.setValue("invoicesupplier", null, rowIndex);
                bill.setValue("receivesupplier", null, rowIndex);
                bill.setValue("providersupplier", null, rowIndex);
            }
            return;
        }
        invoiceSupplier = supplier.getDynamicObject("invoicesupplierid");
        receivingSupplier = supplier.getDynamicObject("receivingsupplierid");
        deliverSupplier = supplier.getDynamicObject("deliversupplierid");
        settlementCy = supplier.getDynamicObject("settlementcyid");
        settlementType = supplier.getDynamicObject("settlementtypeid");
        payCond = supplier.getDynamicObject("paycond");
        supplierId = supplier.getPkValue();
        bill.setValue("paycondition", payCond == null ? null : payCond.getPkValue());
        bill.setValue("settletype", settlementType == null ? null : settlementType.getPkValue());
        if (settlementCy != null) {
            bill.setValue("settlecurrency", settlementCy.getPkValue());
        } else {
            DynamicObject currency = (DynamicObject)bill.getValue("currency");
            bill.setValue("settlecurrency", currency == null ? null : currency.getPkValue());
        }
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            String outKeeperType;
            String keeperType;
            String outOwnerType;
            bill.setValue("invoicesupplier", invoiceSupplier == null ? supplier.getPkValue() : invoiceSupplier.getPkValue(), rowIndex);
            bill.setValue("receivesupplier", receivingSupplier == null ? supplier.getPkValue() : receivingSupplier.getPkValue(), rowIndex);
            bill.setValue("providersupplier", deliverSupplier == null ? supplier.getPkValue() : deliverSupplier.getPkValue(), rowIndex);
            String type = (String)bill.getValue("ownertype", rowIndex);
            if ("bd_supplier".equals(type)) {
                bill.setValue("owner", supplierId, rowIndex);
            }
            if ("bd_supplier".equals(outOwnerType = (String)bill.getValue("outownertype", rowIndex))) {
                bill.setValue("outowner", supplierId, rowIndex);
            }
            if ("bd_supplier".equals(keeperType = (String)bill.getValue("keepertype", rowIndex))) {
                bill.setValue("keeper", supplierId, rowIndex);
            }
            if (!"bd_supplier".equals(outKeeperType = (String)bill.getValue("outkeepertype", rowIndex))) continue;
            bill.setValue("outkeeper", supplierId, rowIndex);
        }
    }

    private void changeProviderSupplier(DynamicObject providerSupplier, int rowIndex) {
        IDataModel bill = this.getModel();
        ILocaleString providerAddress = null;
        DynamicObjectCollection linkmans = null;
        if (providerSupplier != null) {
            providerAddress = SupplierHelper.getValidDefaultMultilingualAddress((DynamicObject)providerSupplier);
            linkmans = providerSupplier.getDynamicObjectCollection("entry_linkman");
        }
        Long supplierLinkmanId = null;
        if (linkmans != null) {
            for (DynamicObject linkman : linkmans) {
                boolean isDefault = linkman.getBoolean("isdefault_linkman");
                boolean isInvalid = linkman.getBoolean("invalid");
                if (!isDefault || isInvalid) continue;
                supplierLinkmanId = Long.valueOf(String.valueOf(linkman.getPkValue()));
            }
        }
        if (supplierLinkmanId == null && linkmans != null && linkmans.size() > 0) {
            for (DynamicObject linkman : linkmans) {
                boolean isInvalid = linkman.getBoolean("invalid");
                if (isInvalid) continue;
                supplierLinkmanId = (Long)linkman.getPkValue();
                break;
            }
        }
        bill.setValue("provideraddress", (Object)providerAddress, rowIndex);
        bill.setValue("providerlinkman", supplierLinkmanId, rowIndex);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if ("billentry".equals(entryName)) {
            DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
            DynamicObject invoiceSupplier = null;
            DynamicObject receivingSupplier = null;
            DynamicObject deliverSupplier = null;
            if (supplier != null) {
                invoiceSupplier = supplier.getDynamicObject("invoicesupplierid");
                receivingSupplier = supplier.getDynamicObject("receivingsupplierid");
                deliverSupplier = supplier.getDynamicObject("deliversupplierid");
            }
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.initPriceField(isTax, rowIndex);
                this.initNewEntry(rowIndex, invoiceSupplier, receivingSupplier, deliverSupplier);
            }
            this.setOutWareHouse();
        }
    }

    private void changeTaxRateID(DynamicObject taxRateID, int rowIndex) {
        if (taxRateID == null) {
            this.getModel().setValue("taxrate", (Object)0, rowIndex);
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
    }

    private void changeExChangeRate(String propName, Object oldValue, Object newValue) {
    }

    private void changeDiscountType(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int discountRateScale = 4;
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate == null) {
            discountRate = BigDecimal.ZERO;
        }
        if (discountRate != null && DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            discountRate = discountRate.setScale(discountRateScale, 4);
            model.setValue("discountrate", (Object)discountRate, rowIndex);
            if (discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) > 0) {
                model.setValue(fieldName, oldValue, rowIndex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u5e94\u5c0f\u4e8e\u7b49\u4e8e100%\u3002", (String)"OmCmplInBillEditPlugin_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return;
            }
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountamount"});
        } else if (discountRate != null && DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            if (settleCurrency != null) {
                discountRateScale = this.getPrecision("settlecurrency", "priceprecision");
            }
            discountRate = discountRate.setScale(discountRateScale, 4);
            boolean isTax = (Boolean)model.getValue("istax");
            BigDecimal amount = discountRate;
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                if (amount.compareTo(priceAndTax) > 0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"OmCmplInBillEditPlugin_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    return;
                }
            } else {
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                if (amount.compareTo(price) > 0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5355\u4ef7\u3002", (String)"OmCmplInBillEditPlugin_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    return;
                }
            }
            model.setValue("discountrate", (Object)discountRate, rowIndex);
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountamount"});
        } else {
            model.setValue("discountrate", null, rowIndex);
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
            model.setValue("discountamount", null, rowIndex);
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountamount"});
        }
    }

    private void changeIsTax(Object newValue) {
        if (newValue instanceof Boolean) {
            boolean isTax = (Boolean)newValue;
            IDataModel model = this.getModel();
            int discountRateScale = 4;
            DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
            if (settleCurrency != null) {
                discountRateScale = this.getPrecision("settlecurrency", "priceprecision");
            }
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.initPriceField(isTax, i);
                this.verifyDiscountRate(isTax, model, discountRateScale, i);
            }
        }
    }

    private void verifyDiscountRate(boolean isTax, IDataModel model, int discountRateScale, int i) {
        String discountType = (String)model.getValue("discounttype", i);
        if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", i);
            if (discountRate == null) {
                discountRate = BigDecimal.ZERO;
            }
            BigDecimal amount = discountRate = discountRate.setScale(discountRateScale, 4);
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", i);
                if (amount.compareTo(priceAndTax) > 0) {
                    model.setValue("istax", (Object)Boolean.FALSE, i);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"OmCmplInBillEditPlugin_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                }
            } else {
                BigDecimal price = (BigDecimal)model.getValue("price", i);
                if (amount.compareTo(price) > 0) {
                    model.setValue("istax", (Object)Boolean.TRUE, i);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5355\u4ef7\u3002", (String)"OmCmplInBillEditPlugin_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                }
            }
        }
    }

    private void initPriceField(boolean isTax, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)model.getValue("ispresent", rowIndex);
        view.setEnable(Boolean.valueOf(!isPresent), rowIndex, new String[]{"taxrateid"});
        view.setEnable(Boolean.valueOf(!isPresent), rowIndex, new String[]{"discounttype"});
        boolean isDiscount = DiscountTypeEnum.NULL.getValue().equals(model.getValue("discounttype", rowIndex));
        view.setEnable(Boolean.valueOf(!isDiscount), rowIndex, new String[]{"discountrate"});
        view.setEnable(Boolean.valueOf(!isDiscount), rowIndex, new String[]{"discountamount"});
        boolean isEnable = !isPresent && !isTax;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"price"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"actualprice"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amount"});
        isEnable = !isPresent && isTax;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"priceandtax"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"actualtaxprice"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amountandtax"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"taxamount"});
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)newValue;
        boolean isTax = (Boolean)model.getValue("istax");
        this.initPriceField(isTax, rowIndex);
        if (isPresent) {
            model.setValue("price", (Object)Constants.ZERO, rowIndex);
            model.setValue("priceandtax", (Object)Constants.ZERO, rowIndex);
            model.setValue("actualprice", (Object)Constants.ZERO, rowIndex);
            model.setValue("actualtaxprice", (Object)Constants.ZERO, rowIndex);
            model.setValue("taxrate", (Object)Constants.ZERO, rowIndex);
            model.setValue("taxrateid", null, rowIndex);
            model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            model.setValue("discountrate", (Object)Constants.ZERO, rowIndex);
        }
    }

    private String getBizOrgDisplayName() {
        BasedataEdit bizOrgEdit = (BasedataEdit)this.getControl("bizorg");
        IDataEntityProperty orgProp = bizOrgEdit.getProperty();
        LocaleString displayName = orgProp.getDisplayName();
        return displayName.toString();
    }

    private void changeBizOrg(Object newValue) {
        DynamicObject bizOrg = (DynamicObject)newValue;
        if (bizOrg != null) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            this.changeBizDept(bizOrgId);
            this.getModel().setValue("bizoperator", null);
            this.getModel().setValue("bizoperatorgroup", null);
        }
    }

    private void changeBizDept(Long orgId) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && deptIds.size() > 0) {
            this.getModel().setValue("bizdept", deptIds.get(0));
            return;
        }
        deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptIds != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
            this.getModel().setValue("bizdept", (Object)orgId);
        } else {
            this.getModel().setValue("bizdept", null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        if ("audit".equals(e.getOperateKey())) {
            FormOperate formOperate = (FormOperate)e.getSource();
            String backflushInfo = formOperate.getOption().getVariableValue("backflushInfo", "");
            if (StringUtils.isNotEmpty((CharSequence)backflushInfo)) {
                this.getView().showTipNotification(backflushInfo);
            }
            this.getView().invokeOperation("refresh");
        }
        if ("save".equals(operateKey = e.getOperateKey()) || "unsubmit".equals(operateKey)) {
            this.lockBfRow();
        }
        if ("entryrowsplitop".equals(operateKey) || "newentry".equals(operateKey) || "unaudit".equals(operateKey)) {
            this.setOutWareHouse();
        }
        if ("unaudit".equals(operateKey) || "unbackflush".equals(operateKey) || "updatebfstatus".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
        if ("chargeagainst".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection("billentry");
            ArrayList<Long> manuentryids = new ArrayList<Long>();
            for (DynamicObject dynamicObject : billentry) {
                long manuentryid = dynamicObject.getLong("manuentryid");
                manuentryids.add(manuentryid);
            }
            if (CollectionUtils.isNotEmpty(manuentryids)) {
                this.aculUseQtyByOrderEntryId(manuentryids);
            }
        }
    }

    private void aculUseQtyByOrderEntryId(List<Long> orderEntryIdList) {
        this.batchCulUseQtyByOrderEntryId(orderEntryIdList, "om_mftorder");
    }

    private void batchCulUseQtyByOrderEntryId(List<Long> orderEntryIdList, String orderName) {
        QFilter qf = new QFilter("orderentryid", "in", orderEntryIdList);
        DynamicObject[] stockDymList = BusinessDataServiceHelper.load((String)EntityNameUtils.getEntityName(0, 1, orderName), (String)"transactiontypeid,orderentryid,baseqty,stockentry,stockentry.demandqty,stockentry.wipqty,stockentry.useqty,stockentry.iscannegative,stockentry.qtytype,stockentry.actissueqty,stockentry.feedingqty,stockentry.rejectedqty,stockentry.processseq,stockentry.oprno,stockentry.materialunitid", (QFilter[])new QFilter[]{qf});
        if (stockDymList == null) {
            return;
        }
        ArrayList<DynamicObject> updateStockDymList = new ArrayList<DynamicObject>(orderEntryIdList.size());
        HashSet<Long> updateStockIDSet = new HashSet<Long>(orderEntryIdList.size());
        for (int i = 0; i < stockDymList.length; ++i) {
            DynamicObject stockDy = stockDymList[i];
            DynamicObjectCollection stockEntryDym = stockDy.getDynamicObjectCollection("stockentry");
            if (stockEntryDym == null || stockEntryDym.isEmpty()) continue;
            for (int j = 0; j < stockEntryDym.size(); ++j) {
                DynamicObject stockEntry = (DynamicObject)stockEntryDym.get(j);
                BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
                BigDecimal feedingQty = stockEntry.getBigDecimal("feedingqty");
                BigDecimal rejectedQty = stockEntry.getBigDecimal("rejectedqty");
                BigDecimal oldwipqty = stockEntry.getBigDecimal("wipqty");
                BigDecimal olduseqty = stockEntry.getBigDecimal("useqty");
                BigDecimal outsQty = actissueQty.add(feedingQty).subtract(rejectedQty);
                if (oldwipqty == null) {
                    oldwipqty = BigDecimal.ZERO;
                }
                if (olduseqty == null) {
                    olduseqty = BigDecimal.ZERO;
                }
                DynamicObject transactionType = stockDymList[i].getDynamicObject("transactiontypeid");
                BigDecimal useQty = this.culUseQty(stockEntry, stockDymList[i].getDynamicObject("orderentryid").getPkValue(), transactionType, orderName);
                BigDecimal newWipQty = outsQty.subtract(useQty);
                if (oldwipqty.compareTo(newWipQty) == 0 && olduseqty.compareTo(useQty) == 0) continue;
                stockEntry.set("wipqty", (Object)newWipQty);
                stockEntry.set("useqty", (Object)useQty);
                this.caleQtyPrecision(stockEntry, "materialunitid", "wipqty", "useqty");
                if (updateStockIDSet.contains(stockDy.getLong("id"))) continue;
                updateStockDymList.add(stockDy);
                updateStockIDSet.add(stockDy.getLong("id"));
            }
        }
        if (!updateStockDymList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateStockDymList.toArray(new DynamicObject[updateStockDymList.size()]));
        }
    }

    private void caleQtyPrecision(DynamicObject dynamicObject, String unitKey, String ... qtyFieldKeys) {
        for (String qtyKey : qtyFieldKeys) {
            BigDecimal srcQty = dynamicObject.getBigDecimal(qtyKey);
            if (srcQty == null) continue;
            DynamicObject unitObj = dynamicObject.getDynamicObject(unitKey);
            DynamicObject unit = null;
            if (unitObj instanceof DynamicObject) {
                unit = unitObj;
            } else if (unitObj instanceof Long) {
                Long unitL = (Long)unitObj;
                QFilter qfilters = new QFilter("id", "=", (Object)unitL);
                unit = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (String)"id,precision,precisionaccount", (QFilter[])qfilters.toArray());
            }
            if (unit == null) continue;
            BigDecimal precisQty = srcQty.setScale(unit.getInt("precision"), PrecisionAccountEnum.getEnumByVal(unit.getInt("precisionaccount")));
            dynamicObject.set(qtyKey, (Object)precisQty);
        }
    }

    public BigDecimal culUseQty(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype, String orderName) {
        if (stockEntry.getBoolean("iscannegative")) {
            return BigDecimal.ZERO;
        }
        String deduction = transactiontype.getString("deduction");
        if ("A".equals(deduction)) {
            return this.aculUseQtyA(stockEntry, orderEntryId, orderName);
        }
        if ("B".equals(deduction)) {
            return this.aculUseQtyB(stockEntry, orderEntryId, transactiontype, orderName);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal aculUseQtyA(DynamicObject stockEntry, Object orderEntryId, String orderName) {
        Map<String, Object> orderMap = this.getOrderQtyMap(orderEntryId, orderName);
        if (orderMap.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal orderBaseQty = BigDecimal.ONE;
        BigDecimal stockqty = BigDecimal.ZERO;
        BigDecimal quainwaqty = (BigDecimal)orderMap.get("quainwaqty");
        BigDecimal unquainwaqty = (BigDecimal)orderMap.get("unquainwaqty");
        BigDecimal scrinwaqty = (BigDecimal)orderMap.get("scrinwaqty");
        stockqty = quainwaqty.add(unquainwaqty).add(scrinwaqty);
        orderBaseQty = (BigDecimal)orderMap.get("baseqty");
        String qtytype = stockEntry.getString("qtytype");
        BigDecimal useQty = BigDecimal.ZERO;
        if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            orderBaseQty = BigDecimal.ONE;
        }
        if ("A".equals(qtytype) || "C".equals(qtytype)) {
            BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
            useQty = stockqty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
        }
        if ("B".equals(qtytype)) {
            useQty = stockqty.compareTo(orderBaseQty) >= 0 ? stockEntry.getBigDecimal("demandqty") : BigDecimal.ZERO;
        }
        return useQty;
    }

    private Map<String, Object> getOrderQtyMap(Object orderEntryId, String orderName) {
        String orderKeys = String.valueOf(orderEntryId) + orderName;
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        QFilter qfilter = new QFilter("treeentryentity.id", "=", orderEntryId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-StockCulUtils-getOrderQtyMap", (String)orderName, (String)"treeentryentity.baseqty baseqty ,treeentryentity.qty qty,treeentryentity.reportqty reportqty,treeentryentity.quainwaqty quainwaqty,treeentryentity.unquainwaqty unquainwaqty ,treeentryentity.scrinwaqty scrinwaqty ", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                dataMap.put("baseqty", "0E-10".equals(dsRow.getString("baseqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("baseqty"));
                dataMap.put("quainwaqty", "0E-10".equals(dsRow.getString("quainwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("quainwaqty"));
                dataMap.put("unquainwaqty", "0E-10".equals(dsRow.getString("unquainwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("unquainwaqty"));
                dataMap.put("scrinwaqty", "0E-10".equals(dsRow.getString("scrinwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("scrinwaqty"));
                dataMap.put("qty", "0E-10".equals(dsRow.getString("qty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("qty"));
                dataMap.put("reportqty", "0E-10".equals(dsRow.getString("reportqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("reportqty"));
            }
        }
        return dataMap;
    }

    public BigDecimal aculUseQtyB(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype, String orderName) {
        BigDecimal useQty = BigDecimal.ZERO;
        if (transactiontype.getBoolean("isprocedure")) {
            useQty = this.aculUseQtyC(stockEntry, orderEntryId, orderName);
        } else {
            Map<String, Object> orderMap = this.getOrderQtyMap(orderEntryId, orderName);
            if (orderMap.isEmpty()) {
                return BigDecimal.ZERO;
            }
            BigDecimal orderBaseQty = BigDecimal.ONE;
            BigDecimal reportQty = BigDecimal.ZERO;
            orderBaseQty = (BigDecimal)orderMap.get("qty");
            reportQty = (BigDecimal)orderMap.get("reportqty");
            if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                orderBaseQty = BigDecimal.ONE;
            }
            BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
            String qtytype = stockEntry.getString("qtytype");
            if ("A".equals(qtytype) || "C".equals(qtytype)) {
                useQty = reportQty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
            }
            if ("B".equals(qtytype)) {
                useQty = reportQty.compareTo(orderBaseQty) >= 0 ? demandBaseQty : BigDecimal.ZERO;
            }
        }
        return useQty;
    }

    public BigDecimal aculUseQtyC(DynamicObject stockEntry, Object orderEntryId, String orderName) {
        BigDecimal useQty = BigDecimal.ZERO;
        BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
        DynamicObject manftechDym = this.getManufTechDy(orderEntryId, orderName);
        if (manftechDym == null) {
            return useQty;
        }
        String processseq = stockEntry.getString("processseq");
        String oprno = stockEntry.getString("oprno");
        DynamicObjectCollection workPlanEntrys = manftechDym.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject workPlanEntry : workPlanEntrys) {
            if (!processseq.equals(workPlanEntry.getString("oprparent")) || !oprno.equals(workPlanEntry.getString("oprno"))) continue;
            BigDecimal orderBaseQty = this.getOrderBaseQty(orderEntryId, orderName);
            BigDecimal oprtotalReportQty = workPlanEntry.getBigDecimal("oprtotalreportbaseqty");
            String qtytype = stockEntry.getString("qtytype");
            if ("A".equals(qtytype) || "C".equals(qtytype)) {
                useQty = oprtotalReportQty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
            }
            if (!"B".equals(qtytype)) continue;
            if (oprtotalReportQty.compareTo(orderBaseQty) >= 0) {
                useQty = demandBaseQty;
                continue;
            }
            useQty = BigDecimal.ZERO;
        }
        return useQty;
    }

    public BigDecimal getOrderBaseQty(Object orderEntryId, String orderName) {
        Map<String, Object> orderMap = this.getOrderQtyMap(orderEntryId, orderName);
        if (orderMap.isEmpty()) {
            return BigDecimal.ONE;
        }
        BigDecimal orderBaseQty = BigDecimal.ONE;
        orderBaseQty = (BigDecimal)orderMap.get("baseqty");
        if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            orderBaseQty = BigDecimal.ONE;
        }
        return orderBaseQty;
    }

    private DynamicObject getManufTechDy(Object orderEntryId, String orderName) {
        String orderKeys = String.valueOf(orderEntryId) + orderName;
        HashMap<String, DynamicObject> techMap = new HashMap<String, DynamicObject>();
        DynamicObject manftechDym = (DynamicObject)techMap.get(orderKeys);
        QFilter filter = new QFilter("mftentryseq", "=", orderEntryId);
        manftechDym = BusinessDataServiceHelper.loadSingle((String)EntityNameUtils.getEntityName(0, 2, orderName), (String)"baseqty,oprentryentity.oprtotalreportqty,oprentryentity.oprtotalreportbaseqty,oprentryentity.oprparent,oprentryentity.oprno", (QFilter[])new QFilter[]{filter});
        techMap.put(orderKeys, manftechDym);
        return manftechDym;
    }

    private void changeBizOperatorGroup(DynamicObject bizGrp) {
        if (bizGrp == null) {
            this.getModel().setValue("bizoperator", null);
        }
    }

    private void changeBizOperator(DynamicObject bizOperator) {
        if (bizOperator != null) {
            bizOperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizOperator.getPkValue(), (String)"bd_operator");
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", bizOperator.get("operatorgrpid"));
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
            if (bizOrg == null) {
                return;
            }
            List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)((Long)bizOrg.getPkValue()), (boolean)true);
            if (deptids != null && deptids.size() > 0) {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    for (Long deptId : userdeptIds) {
                        if (!deptids.contains(deptId)) continue;
                        this.getModel().beginInit();
                        this.getModel().setValue("bizdept", (Object)deptId);
                        this.getModel().endInit();
                        this.getView().updateView("bizdept");
                        break;
                    }
                }
            } else {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    this.getModel().beginInit();
                    this.getModel().setValue("bizdept", userdeptIds.get(0));
                    this.getModel().endInit();
                    this.getView().updateView("bizdept");
                }
            }
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", null);
            this.getModel().setValue("bizdept", null);
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            this.getView().updateView("bizdept");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
        if (org != null) {
            this.initCurrencyAndExrateTable((Long)org.getPkValue());
        }
        Date bizDate = (Date)this.getModel().getValue("biztime");
        this.getModel().setValue("exratedate", (Object)bizDate);
        if (bizOrg != null) {
            Long settleOrgId = this.getCompanyByOrg((Long)bizOrg.getPkValue());
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.initSettleOrgDefaultValue(settleOrgId, i);
            }
        }
        this.setOutWareHouse();
        this.initSettleType();
        DynamicObject bizOrgDynamicObject = (DynamicObject)this.getModel().getValue("bizorg");
        this.changeBizOrg(bizOrgDynamicObject);
    }

    private void setOutWareHouse() {
        DynamicObject invscheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (invscheme != null) {
            boolean isoutupdate = invscheme.getBoolean("isoutupdate");
            this.getView().setVisible(Boolean.valueOf(isoutupdate), new String[]{"outwarehouse", "outlocation"});
            if (isoutupdate) {
                int count = this.getModel().getEntryRowCount("billentry");
                for (int i = 0; i < count; ++i) {
                    DynamicObject outwarehouse = (DynamicObject)this.getModel().getValue("outwarehouse", i);
                    if (outwarehouse != null && outwarehouse.getBoolean("isopenlocation")) continue;
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"outlocation"});
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"outwarehouse", "outlocation"});
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        IDataModel dataModel = this.getView().getModel();
        Object srcBillEntity = dataModel.getValue("srcbillentity", 0);
        if ("mal_returnreq".equals(srcBillEntity)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"addrow"});
        }
        this.setOutWareHouse();
    }

    private void initSettleType() {
        this.getModel().setValue("settletype", null);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            this.initCurrencyAndExrateTable((Long)org.getPkValue());
        }
        Date bizDate = (Date)this.getModel().getValue("biztime");
        model.setValue("exratedate", (Object)bizDate);
        this.changeExchangeRate();
        SetValueForBotpWBHelper.purInAfterCopyData((IDataModel)model);
        this.getAlgorithm().calByChange("exchangerate");
    }

    private void initSettleOrgDefaultValue(Object settleOrgId, int rowIndex) {
        this.getModel().setValue("entrysettleorg", settleOrgId, rowIndex);
    }

    private void changeExchangeRate() {
        IDataModel model = this.getModel();
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        Date exrateDate = (Date)model.getValue("exratedate");
        DynamicObject exratetable = (DynamicObject)this.getModel().getValue("exratetable");
        Long exrateTableId = exratetable == null ? null : Long.valueOf(exratetable.getLong("id"));
        boolean calByChange = true;
        if (currency != null && settleCurrency != null && exrateTableId != null) {
            if (currency.getPkValue().equals(settleCurrency.getPkValue())) {
                model.setValue("exchangerate", (Object)new BigDecimal(1));
                this.getView().setEnable(Boolean.FALSE, new String[]{"exchangerate"});
            } else {
                BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)settleCurrency.getLong("id"), (Long)currency.getLong("id"), (Date)exrateDate);
                if (exchangeRate == null) {
                    calByChange = false;
                    this.setValue("exratetable", null, false);
                    this.setValue("exratedate", null, false);
                    this.setValue("exchangerate", null, false);
                    String msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u201c%1$s\u201d\u548c\u201c%2$s\u201d\u95f4\u7684\u6709\u6548\u6c47\u7387\uff0c\u201c\u5355\u4ef7\u201d\u548c\u201c\u91d1\u989d\u4fe1\u606f\u201d\u672a\u66f4\u65b0\u3002", (String)"OmCmplInBillEditPlugin_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), currency.get("name"), settleCurrency.get("name"));
                    ErrorCodeHelper.showErrorCode((String)msg, (String)"n", (String)"tip", null, null, (int)3, null, null, null, (AbstractFormPlugin)this);
                } else {
                    model.setValue("exchangerate", (Object)exchangeRate);
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"exchangerate"});
            }
        } else {
            calByChange = false;
            this.setValue("exratetable", null, false);
            this.setValue("exratedate", null, false);
            this.setValue("exchangerate", null, false);
            if (currency != null && settleCurrency != null) {
                String msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u201c%1$s\u201d\u548c\u201c%2$s\u201d\u95f4\u7684\u6709\u6548\u6c47\u7387\uff0c\u201c\u5355\u4ef7\u201d\u548c\u201c\u91d1\u989d\u4fe1\u606f\u201d\u672a\u66f4\u65b0\u3002", (String)"OmCmplInBillEditPlugin_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), currency.get("name"), settleCurrency.get("name"));
                ErrorCodeHelper.showErrorCode((String)msg, (String)"n", (String)"tip", null, null, (int)3, null, null, null, (AbstractFormPlugin)this);
            } else {
                ErrorCodeHelper.showErrorCode((String)ResManager.loadKDString((String)"\u8bf7\u5728\u5f53\u524d\u6c47\u7387\u8868\u4e2d\u914d\u7f6e\u201c\u672c\u4f4d\u5e01\u201d\u548c\u201c\u7ed3\u7b97\u5e01\u201d\u7684\u6c47\u7387\u3002", (String)"OmCmplInBillEditPlugin_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), (String)"n", (String)"tip", null, null, (int)3, null, null, null, (AbstractFormPlugin)this);
            }
        }
        this.getView().getFormShowParameter().setCustomParam("calByChange", (Object)calByChange);
    }

    private void changeSettleCurrency() {
        this.changeExchangeRate();
    }

    private void change4BizOrg(DynamicObject bizOrg) {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        if (bizOrg == null) {
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("entrysettleorg", null, i);
            }
        } else {
            Long settleOrgId = this.getCompanyByOrg((Long)bizOrg.getPkValue());
            for (int i = 0; i < entryRowCount; ++i) {
                this.initSettleOrgDefaultValue(settleOrgId, i);
            }
        }
    }

    private void changeEntryReqOrg(DynamicObject newValue, int rowIndex) {
        IDataModel model = this.getModel();
        String type = (String)model.getValue("ownertype", rowIndex);
        if ("bos_org".equals(type)) {
            Object defalutOwner = this.getInvSchemeService().getDefalutOwner(type, rowIndex);
            model.setValue("owner", defalutOwner, rowIndex);
        }
    }

    private void changeDiscountAmount(String fieldName, Object oldValue, BigDecimal discountAmount, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal amoutAndTax = BigDecimal.ZERO;
        amoutAndTax = isTax ? (BigDecimal)model.getValue("amountandtax", rowIndex) : (BigDecimal)model.getValue("amount", rowIndex);
        if (discountAmount.compareTo(amoutAndTax) > 0 || discountAmount.compareTo(BigDecimal.ZERO) < 0) {
            model.setValue("discountamount", oldValue, rowIndex);
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_UNITDISAMOUNT()));
        }
    }

    private void changeTaxMount(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        boolean taxAmountCheck;
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal amountAndTax = (BigDecimal)model.getValue("amountandtax", rowIndex);
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
        boolean bl = taxAmountCheck = isTax && (taxAmount.compareTo(amountAndTax) > 0 || taxAmount.compareTo(BigDecimal.ZERO) < 0);
        if (taxAmountCheck) {
            model.setValue("taxamount", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u989d\u5e94\u9700\u6ee1\u8db3\u6761\u4ef6\uff1a0\u2264\u7a0e\u989d\u2264\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"OmCmplInBillEditPlugin_6", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
    }

    private void initCurrencyAndExrateTable(Long orgId) {
        IDataModel model = this.getModel();
        if (orgId == null) {
            model.setValue("currency", null);
            model.setValue("exratetable", null);
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (map == null) {
            model.setValue("currency", null);
            model.setValue("exratetable", null);
            return;
        }
        model.setValue("currency", map.get("baseCurrencyID"));
        Object exRateTableId = map.get("exchangeRateTableID");
        model.setValue("exratetable", exRateTableId);
    }

    private void initNewEntry(int rowIndex, DynamicObject invoiceSupplier, DynamicObject receivingSupplier, DynamicObject deliverSupplier) {
        this.setSettleOrg(rowIndex);
        this.setDefaultSupplierInfo(invoiceSupplier, receivingSupplier, deliverSupplier, rowIndex);
        this.setDefaultQty(rowIndex);
    }

    private void setSettleOrg(int rowIndex) {
        Long settleOrgId;
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
        if (bizOrg != null && (settleOrgId = this.getCompanyByOrg((Long)bizOrg.getPkValue())) != null) {
            this.getModel().setValue("bizorg", (Object)bizOrg, rowIndex);
            this.initSettleOrgDefaultValue(settleOrgId, rowIndex);
        }
    }

    private void setDefaultQty(int rowIndex) {
        IDataModel bill = this.getModel();
        bill.setValue("returnbaseqty", null, rowIndex);
        bill.setValue("returnqty", null, rowIndex);
        bill.setValue("remainreturnqty", null, rowIndex);
        bill.setValue("remainreturnbaseqty", null, rowIndex);
        bill.setValue("joinpriceqty", null, rowIndex);
        bill.setValue("remainjoinpriceqty", null, rowIndex);
    }

    private void setDefaultSupplierInfo(DynamicObject invoiceSupplier, DynamicObject receivingSupplier, DynamicObject deliverSupplier, int rowIndex) {
        this.getModel().setValue("providersupplier", deliverSupplier == null ? null : deliverSupplier.getPkValue(), rowIndex);
        this.getModel().setValue("invoicesupplier", invoiceSupplier == null ? null : invoiceSupplier.getPkValue(), rowIndex);
        this.getModel().setValue("receivesupplier", receivingSupplier == null ? null : receivingSupplier.getPkValue(), rowIndex);
    }

    protected void changePriceAndTax(int rowIndex, Object newValue, Object oldValue) {
        BigDecimal priceAndTax;
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate != null && DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && (priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex)) != null && discountRate != null && priceAndTax.compareTo(discountRate) < 0) {
            model.setValue("priceandtax", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\u989d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"OmCmplInBillEditPlugin_7", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
    }

    protected void changeActualPrice(int rowIndex, Object newValue, Object oldValue) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal actualPrice = (BigDecimal)newValue;
        if (price != null && actualPrice != null && price.compareTo(actualPrice) < 0) {
            model.setValue("actualprice", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5355\u4ef7\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5355\u4ef7\u3002", (String)"OmCmplInBillEditPlugin_8", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
        this.setDefaultDiscountType(rowIndex);
    }

    protected void changeActualTaxPrice(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal actualPrice = (BigDecimal)newValue;
        if (price != null && actualPrice != null && price.compareTo(actualPrice) < 0) {
            this.setValue("actualtaxprice", oldValue, rowIndex, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"OmCmplInBillEditPlugin_9", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
        this.setDefaultDiscountType(rowIndex);
    }

    private void setDefaultDiscountType(int i) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String discountType = (String)model.getValue("discounttype", i);
        if (StringUtils.isEmpty((CharSequence)discountType) || DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            model.beginInit();
            model.setValue("discounttype", (Object)DiscountTypeEnum.UNITDIS.getValue(), i);
            model.endInit();
            BillViewHelper.updateViewField((IFormView)this.getView(), (int)i, (String)"discounttype", (String[])new String[0]);
            view.setEnable(Boolean.TRUE, i, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, i, new String[]{"discountamount"});
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        Object entryObj;
        super.afterImportData(e);
        IDataModel bill = this.getModel();
        BillModel billModel = (BillModel)bill;
        boolean isFromWebApi = billModel.isFromWebApi();
        if (!isFromWebApi) {
            return;
        }
        DynamicObject bizOrg = (DynamicObject)bill.getValue("bizorg");
        if (bizOrg == null) {
            return;
        }
        Map sourceData = e.getSourceData();
        Map bizDept = (Map)sourceData.get("bizdept");
        if (bizDept == null || StringUtils.isBlank((CharSequence)((String)bizDept.get("number")))) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            this.changeBizDept(bizOrgId);
        }
        if ((entryObj = sourceData.get("billentry")) instanceof JSONArray) {
            JSONArray entry = (JSONArray)sourceData.get("billentry");
            for (Object obj : entry) {
                Object outInvType;
                Object invType;
                Object outKeeper;
                Object outOwner;
                Object keeper;
                Object owner;
                Object settleOrg;
                Map map = (Map)obj;
                Object reqOrg = map.get("entryreqorg");
                if (reqOrg == null) {
                    bill.setValue("entryreqorg", null);
                }
                if ((settleOrg = map.get("entrysettleorg")) == null) {
                    bill.setValue("entrysettleorg", null);
                }
                if ((owner = map.get("owner")) == null) {
                    bill.setValue("owner", null);
                }
                if ((keeper = map.get("keeper")) == null) {
                    bill.setValue("keeper", null);
                }
                if ((outOwner = map.get("outowner")) == null) {
                    this.getModel().setValue("outowner", null);
                }
                if ((outKeeper = map.get("outkeeper")) == null) {
                    bill.setValue("outkeeper", null);
                }
                if ((invType = map.get("invtype")) == null) {
                    bill.setValue("invtype", null);
                }
                if ((outInvType = map.get("outinvtype")) != null) continue;
                bill.setValue("outinvtype", null);
            }
        } else {
            SetValueForBotpWBHelper.purInSetValueByWabApi((IDataModel)bill);
        }
    }

    protected void setHeadEnable() {
        super.setHeadEnable();
        IFormView view = this.getView();
        DynamicObject bill = this.getBill();
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        boolean isEnable = currency == null || settleCurrency == null || !currency.getPkValue().equals(settleCurrency.getPkValue());
        view.setEnable(Boolean.valueOf(isEnable), new String[]{"exchangerate"});
    }

    protected void setEnable4IsDraw(boolean isDraw) {
        super.setEnable4IsDraw(isDraw);
        IFormView view = this.getView();
        if (isDraw) {
            view.setEnable(Boolean.FALSE, new String[]{"billtype", "settlecurrency", "bizorg", "supplier", "exchangerate", "exratetable", "transactepath"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"supplier"});
        }
    }

    protected void setBillEntryEnable(RowDataEntity entry) {
        String outKeeperType;
        String keeperType;
        super.setBillEntryEnable(entry);
        DynamicObject bill = this.getBill();
        IFormView view = this.getView();
        int index = entry.getRowIndex();
        boolean isTax = bill.getBoolean("istax");
        this.initPriceField(isTax, index);
        String discountType = (String)this.getModel().getValue("discounttype", index);
        if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            view.setEnable(Boolean.FALSE, index, new String[]{"discountrate"});
            view.setEnable(Boolean.FALSE, index, new String[]{"discountamount"});
        }
        if ((keeperType = entry.getDataEntity().getString("keepertype")) != null) {
            boolean isAccountOrg = "bd_supplier".equalsIgnoreCase(keeperType) || "bd_customer".equalsIgnoreCase(keeperType);
            view.setEnable(Boolean.valueOf(isAccountOrg), new String[]{"keeper"});
        }
        if ((outKeeperType = entry.getDataEntity().getString("outkeepertype")) != null) {
            boolean isAccountOrg = "bd_supplier".equalsIgnoreCase(outKeeperType) || "bd_customer".equalsIgnoreCase(outKeeperType);
            view.setEnable(Boolean.valueOf(isAccountOrg), new String[]{"outkeeper"});
        }
    }

    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        if (isDraw) {
            IFormView view = this.getView();
            int index = row.getRowIndex();
            view.setEnable(Boolean.FALSE, index, new String[]{"ispresent", "model", "unit", "ownertype", "owner", "entrysettleorg", "taxrate", "discounttype", "discountrate"});
            IDataModel dataModel = view.getModel();
            Object srcbillentity = dataModel.getValue("srcbillentity");
            if ("im_purinbill".equals(srcbillentity)) {
                view.setEnable(Boolean.FALSE, index, new String[]{"lotnumber", "producedate", "expirydate"});
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (int rowIndex : rowIndexs) {
            DynamicObject entry = this.getModel().getEntryRowEntity("billentry", rowIndex);
            Long entryId = entry.getLong("id");
            if (!MDCDyObjUtil.isNotEmptyId(entryId)) continue;
            entryIds.add(entryId);
        }
        if (!entryIds.isEmpty()) {
            Map<Long, Map<String, Object>> dataMap = this.getOutDataMap(entryIds);
            ArrayList<String> errMsgLs = new ArrayList<String>(16);
            for (int rowIndex : rowIndexs) {
                Map<String, Object> data;
                DynamicObject entry = this.getModel().getEntryRowEntity("billentry", rowIndex);
                Long entryId = entry.getLong("id");
                if (!MDCDyObjUtil.isNotEmptyId(entryId) || (data = dataMap.get(entryId)) == null) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5df2\u7ecf\u5012\u51b2\uff0c\u5012\u51b2\u9886\u6599\u5355\u7f16\u53f7\u201c%2$s\u201d\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"OmCmplInBillEditPlugin_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), rowIndex + 1, data.get("outBillNo"));
                errMsgLs.add(msg);
            }
            if (!errMsgLs.isEmpty()) {
                StringBuilder errSb = new StringBuilder();
                for (String errMsg : errMsgLs) {
                    errSb.append(errMsg).append("\n");
                }
                this.getView().showTipNotification(errSb.toString());
                e.setCancel(true);
            }
        }
    }

    private Map<Long, Map<String, Object>> getOutDataMap(Set<Long> entryIds) {
        HashMap<Long, Map<String, Object>> dataMap = new HashMap<Long, Map<String, Object>>(16);
        String algoKey = "query-im_mdc_omoutbill";
        QFilter filter = new QFilter("billentry.srcbillentryid", "in", entryIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_omoutbill", (String)"id,billno,billentry.srcbillentryid", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                Long outBillId = row.getLong("id");
                String billNo = row.getString("billno");
                Long srcbillentryid = row.getLong("billentry.srcbillentryid");
                data.put("outBillId", outBillId);
                data.put("outBillNo", billNo);
                dataMap.put(srcbillentryid, data);
            }
        }
        return dataMap;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("A".equals(this.getModel().getValue("billstatus"))) {
            this.lockBfRow();
        }
        this.setOutWareHouse();
    }

    private void lockBfRow() {
        HashSet<Long> entryIds = new HashSet<Long>(16);
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("billentry");
        for (DynamicObject entry : entryColl) {
            Long entryId = entry.getLong("id");
            if (!MDCDyObjUtil.isNotEmptyId(entryId)) continue;
            entryIds.add(entryId);
        }
        if (!entryIds.isEmpty()) {
            ArrayList<String> lockFields = new ArrayList<String>(16);
            lockFields.add("material");
            lockFields.add("qualitystatus");
            lockFields.add("unit");
            lockFields.add("qty");
            lockFields.add("ecostcenter");
            lockFields.add("producedate");
            lockFields.add("expirydate");
            lockFields.add("receivedate");
            lockFields.add("warehouse");
            lockFields.add("location");
            lockFields.add("outwarehouse");
            lockFields.add("outlocation");
            lockFields.add("invtype");
            lockFields.add("invstatus");
            lockFields.add("owner");
            lockFields.add("keeper");
            lockFields.add("entrysettleorg");
            lockFields.add("producedept");
            lockFields.add("outinvtype");
            lockFields.add("outinvstatus");
            lockFields.add("outowner");
            lockFields.add("outkeeper");
            lockFields.add("project");
            lockFields.add("ispresent");
            lockFields.add("taxrateid");
            lockFields.add("taxrate");
            lockFields.add("price");
            lockFields.add("priceandtax");
            lockFields.add("discounttype");
            lockFields.add("discountrate");
            lockFields.add("actualprice");
            lockFields.add("actualtaxprice");
            lockFields.add("discountamount");
            lockFields.add("amount");
            lockFields.add("taxamount");
            lockFields.add("amountandtax");
            lockFields.add("providersupplier");
            lockFields.add("invoicesupplier");
            lockFields.add("receivesupplier");
            lockFields.add("provideraddress");
            lockFields.add("providerlinkman");
            lockFields.add("entrycomment");
            Map<Long, Map<String, Object>> dataMap = this.getOutDataMap(entryIds);
            for (DynamicObject entry : entryColl) {
                Map<String, Object> data;
                Long entryId = entry.getLong("id");
                if (!MDCDyObjUtil.isNotEmptyId(entryId) || (data = dataMap.get(entryId)) == null) continue;
                int seq = entry.getInt("seq");
                this.getView().setEnable(Boolean.valueOf(false), seq - 1, lockFields.toArray(new String[0]));
            }
        }
    }
}

