/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.ominbill;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.consts.BizTypeConsts;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.algorithm.TaxAlgorithmForForm;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.ErrorCodeHelper;
import kd.scmc.im.business.helper.InvoiceBizHelper;
import kd.scmc.im.business.helper.SupplierHelper;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class OmInBillEditPlugin
extends ImBillEditPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final Long DEFAULT_INVOICE_BIZ = 1533341968170710016L;
    private static final Long PROFORMA_INVOICE_BIZ = 1571047306646894592L;
    private TaxAlgorithmForForm algo = null;

    protected TaxAlgorithmForForm getAlgorithm() {
        if (this.algo == null) {
            this.algo = new TaxAlgorithmForForm(this.getView());
        }
        return this.algo;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"providersupplier", "receivesupplier", "invoicesupplier", "providerlinkman", "bizoperatorgroup", "bizoperator", "bizdept", "entrysettleorg", "owner", "outowner", "keeper", "outkeeper", "supplier", "taxrateid", "invoicebiztype"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        this.setOutWareHouse();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("audit".equals(operateKey)) {
            this.checkMaterial(args, "B");
        }
    }

    private void checkMaterial(BeforeDoOperationEventArgs e, String allowedBillStatus) {
        ArrayList<String> allowedMsgList = new ArrayList<String>();
        StringBuilder infoMsg = new StringBuilder();
        IDataModel bill = this.getModel();
        DynamicObject obj = bill.getDataEntity();
        StringBuilder compeletPk = new StringBuilder();
        DynamicObjectCollection entry = bill.getEntryEntity("billentry");
        String billstatus = obj.getString("billstatus");
        DynamicObject transObj = obj.getDynamicObject("invscheme").getDynamicObject("transceivertype");
        if (transObj == null) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", transObj.getPkValue());
        DataSet transObjSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)transObj.getDataEntityType().getName(), (String)"bizdirection", (QFilter[])qFilter.toArray(), null);
        while (transObjSet.hasNext()) {
            Row row = transObjSet.next();
            String bizdirection = row.getString("bizdirection");
            if (!"1".equals(bizdirection)) continue;
            return;
        }
        transObjSet.close();
        if (!allowedBillStatus.equals(billstatus)) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)entry)) {
            for (DynamicObject omInEntry : entry) {
                Map<String, Map<String, Object>> map;
                if (omInEntry.getBoolean("ispresent") || MapUtils.isEmpty(map = this.getOmOrderData(omInEntry.getLong("mainbillid"))) || !this.judgeOrderClosed(omInEntry, map)) continue;
                allowedMsgList.add(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u5206\u5f55\uff0c", (String)"OmInBillEditPlugin_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), obj.getString("billno"), omInEntry.get("mainbillentryseq")));
                compeletPk.append(omInEntry.getPkValue());
                compeletPk.append(",");
            }
        }
        if (CollectionUtils.isNotEmpty(allowedMsgList)) {
            StringBuilder sb = new StringBuilder();
            allowedMsgList.stream().forEach(x -> sb.append((String)x));
            infoMsg.append(String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5165\u5e93\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u59d4\u5916\u8ba2\u5355\u884c\u5df2\u5b8c\u5168\u5165\u5e93\uff0c\u662f\u5426\u5b8c\u5168\u6838\u9500\uff1f", (String)"OmInBillEditPlugin_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), sb));
            FormOperate source = (FormOperate)e.getSource();
            RefObject afterConfirm = new RefObject();
            if (!source.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener("completeWriteOff", (IFormPlugin)this);
                this.getView().showConfirm(infoMsg.toString(), MessageBoxOptions.YesNo, listener);
                this.getPageCache().put("compeletPk", compeletPk.toString());
                e.setCancel(true);
                return;
            }
        }
    }

    private Map<String, Map<String, Object>> getOmOrderData(long pkValue) {
        QFilter qFilter = new QFilter("id", "=", (Object)pkValue);
        DataSet omOrderDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_om_purorderbill", (String)"closestatus,billentry.id,billentry.invbaseqty,billentry.returnbaseqty,billentry.receivebaseqtydown,billentry.rowclosestatus", (QFilter[])qFilter.toArray(), null);
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(256);
        while (omOrderDataSet.hasNext()) {
            Row row = omOrderDataSet.next();
            HashMap<String, Object> map1 = new HashMap<String, Object>(32);
            String closeStatus = row.getString("closestatus");
            String rowclosestatus = row.getString("billentry.rowclosestatus");
            BigDecimal invbaseqty = row.getBigDecimal("billentry.invbaseqty");
            BigDecimal returnbaseqty = row.getBigDecimal("billentry.returnbaseqty");
            BigDecimal receivebaseqtydown = row.getBigDecimal("billentry.receivebaseqtydown");
            map1.put("closeStatus", closeStatus);
            map1.put("billentry.invbaseqty", invbaseqty);
            map1.put("billentry.returnbaseqty", returnbaseqty);
            map1.put("billentry.receivebaseqtydown", receivebaseqtydown);
            map1.put("billentry.rowclosestatus", rowclosestatus);
            map.put(row.getString("billentry.id"), map1);
        }
        omOrderDataSet.close();
        return map;
    }

    private boolean judgeOrderClosed(DynamicObject omInEntry, Map<String, Map<String, Object>> map) {
        Map<String, Object> omOrderEntryMap = map.get(omInEntry.get("mainbillentryid").toString());
        BigDecimal baseQty = omInEntry.getBigDecimal("baseqty");
        if ("B".equals(omOrderEntryMap.get("billentry.rowclosestatus"))) {
            return true;
        }
        BigDecimal invbaseqty = (BigDecimal)omOrderEntryMap.get("billentry.invbaseqty");
        BigDecimal returnbaseqty = (BigDecimal)omOrderEntryMap.get("billentry.returnbaseqty");
        BigDecimal receivebaseqtydown = (BigDecimal)omOrderEntryMap.get("billentry.receivebaseqtydown");
        return invbaseqty.subtract(returnbaseqty).add(baseQty).compareTo(receivebaseqtydown) >= 0;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("completeWriteOff".equals(callBackId)) {
            String compeletPk;
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            boolean isComplete = false;
            if (MessageBoxResult.Yes.equals((Object)result)) {
                isComplete = true;
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(compeletPk = this.getPageCache().get("compeletPk")))) {
                String[] completePkArray = compeletPk.split(",");
                for (int i = 0; i < completePkArray.length; ++i) {
                    QFilter qfilter = new QFilter("billentry.id", "=", (Object)Long.valueOf(completePkArray[i]));
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"im_mdc_ominbill", (String)"billentry.completewriteoff", (QFilter[])new QFilter[]{qfilter});
                    DynamicObjectCollection entry = obj.getDynamicObjectCollection("billentry");
                    for (DynamicObject dyn : entry) {
                        if (!dyn.getPkValue().equals(Long.valueOf(completePkArray[i]))) continue;
                        dyn.set("completewriteoff", (Object)isComplete);
                    }
                    SaveServiceHelper.update((DynamicObject)obj);
                }
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("audit", operateOption);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel bill = this.getModel();
        DynamicObject bizOrg = (DynamicObject)bill.getValue("bizorg");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        switch (key) {
            case "supplier": {
                this.supplierSelect(e);
                break;
            }
            case "providersupplier": 
            case "invoicesupplier": 
            case "receivesupplier": {
                this.supplierInfoSelect(e);
                break;
            }
            case "providerlinkman": {
                this.providerLinkmanSelect(e, rowIndex, showParameter);
                break;
            }
            case "bizoperatorgroup": {
                this.bizOperatorGroupSelect(e, bizOrg, showParameter);
                break;
            }
            case "bizoperator": {
                this.bizOperatorSelect(e, bizOrg, showParameter);
                break;
            }
            case "bizdept": {
                this.bizDeptSelect(e, bizOrg, showParameter);
                break;
            }
            case "owner": {
                this.ownerSelect(e);
                break;
            }
            case "taxrateid": {
                this.taxrateSelect(e, showParameter);
                break;
            }
            case "invoicebiztype": {
                InvoiceBizHelper.invoiceBizSelect((IFormView)this.getView(), (ListShowParameter)showParameter);
                break;
            }
        }
    }

    private void supplierSelect(BeforeF7SelectEvent e) {
        this.addVMISelect(e);
    }

    private void addVMISelect(BeforeF7SelectEvent e) {
        Object bizTypeId;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && ((bizTypeId = bizType.getPkValue()).equals(BizTypeConsts.BIZTYPE_PURIN_VMI) || bizTypeId.equals(BizTypeConsts.BIZTYPE_PURINRETURN_VMI))) {
            QFilter q = new QFilter("enablevmi", "=", (Object)"1");
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)q);
        }
    }

    private void supplierInfoSelect(BeforeF7SelectEvent e) {
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
        if (supplier == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_SUPPLIER(), (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void providerLinkmanSelect(BeforeF7SelectEvent e, int rowIndex, ListShowParameter showParameter) {
        DynamicObject providerSupplier = (DynamicObject)this.getModel().getValue("providersupplier", rowIndex);
        if (providerSupplier == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_PROVIDERSUPPLIER(), (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("supplierid", "=", providerSupplier.getPkValue()).and("invalid", "=", (Object)false)));
        }
    }

    private void bizOperatorGroupSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\u3002", (String)"OmInBillEditPlugin_13", (String)"scmc-mm-mdc", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        DynamicObject bizoperator = (DynamicObject)this.getModel().getValue("bizoperator");
        if (bizoperator == null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0));
        } else {
            bizoperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizoperator.getPkValue(), (String)"bd_operator");
            QFilter qFilter01 = new QFilter("operatorid", "=", bizoperator.getDynamicObject("operatorid").getPkValue());
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter01});
            if (map.size() != 0) {
                ArrayList list = new ArrayList(map.values());
                ArrayList<Long> groupList = new ArrayList<Long>();
                for (int i = 0; i < list.size(); ++i) {
                    groupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", groupList));
            }
        }
    }

    private void bizOperatorSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
        QFilter enableFilter;
        long bizOrgId;
        QFilter operatorGroupIdFilter;
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"OmInBillEditPlugin_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        BasedataEdit control = (BasedataEdit)this.getControl("bizoperatorgroup");
        BasedataProp property = (BasedataProp)control.getProperty();
        FilterBuilder buildCoreFilter = property.buildCoreFilter(this.getModel());
        QFilter filterGridFilter = buildCoreFilter.getQFilter();
        Map currentBizOrgBizOperatorGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{filterGridFilter, operatorGroupIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)(bizOrgId = Long.parseLong(bizOrg.getPkValue().toString()))), enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (currentBizOrgBizOperatorGroup != null && !currentBizOrgBizOperatorGroup.isEmpty()) {
            HashSet keySet = new HashSet(currentBizOrgBizOperatorGroup.keySet());
            QFilter qFilter = new QFilter("operatorgrpid", "in", new ArrayList(keySet));
            QFilter qFilter1 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter, qFilter1));
        } else if (currentBizOrgBizOperatorGroup == null || currentBizOrgBizOperatorGroup.isEmpty()) {
            showParameter.getListFilterParameter().setFilter(new QFilter("operatorgrpid", "in", null));
        }
    }

    private void bizDeptSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
    }

    private void ownerSelect(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        String type = (String)this.getModel().getValue("ownertype", rowIndex);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        switch (type) {
            case "bos_org": 
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                this.addVMISelect(e);
                break;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    protected void taxrateSelect(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        IDataModel dataModel = this.getModel();
        Object bizTime = dataModel.getValue("biztime");
        if (bizTime == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_BIZTIME()));
            e.setCancel(true);
            return;
        }
        QFilter f = new QFilter("activedate", "<=", bizTime);
        QFilter fExpdate = new QFilter("expdate", ">=", bizTime);
        fExpdate.or(new QFilter("expdate", "is null", null));
        f.and(fExpdate);
        showParameter.getListFilterParameter().setFilter(f);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("billno")) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            if ("currency".equals(propName)) {
                this.changeExchangeRate();
            } else if ("settlecurrency".equals(propName)) {
                this.changeSettleCurrency();
            } else if ("exratetable".equals(propName)) {
                this.changeExchangeRate();
            } else if ("exratedate".equals(propName)) {
                this.changeExchangeRate();
            } else if ("supplier".equals(propName)) {
                this.changeSupplier(newValue);
            } else if ("providersupplier".equals(propName)) {
                this.changeProviderSupplier((DynamicObject)newValue, rowIndex);
            } else if ("istax".equals(propName)) {
                this.changeIsTax(newValue);
            } else if ("ispresent".equals(propName)) {
                this.changeIsPresent(newValue, rowIndex);
            } else if ("priceandtax".equals(propName)) {
                this.changePriceAndTax(rowIndex, newValue, oldValue);
            } else if ("actualprice".equals(propName)) {
                this.changeActualPrice(rowIndex, newValue, oldValue);
            } else if ("actualtaxprice".equals(propName)) {
                this.changeActualTaxPrice(oldValue, newValue, rowIndex);
            } else if ("discounttype".equals(propName) || "discountrate".equals(propName)) {
                this.changeDiscountType(propName, oldValue, newValue, rowIndex);
            } else if ("discountamount".equals(propName)) {
                this.changeDiscountAmount(propName, oldValue, (BigDecimal)newValue, rowIndex);
            } else if ("taxamount".equals(propName)) {
                this.changeTaxMount(propName, oldValue, newValue, rowIndex);
            } else if ("taxrateid".equals(propName)) {
                this.changeTaxRateID((DynamicObject)newValue, rowIndex);
            } else if ("exchangerate".equals(propName)) {
                this.changeExChangeRate(propName, oldValue, newValue);
            } else if ("bizoperator".equals(propName)) {
                this.changeBizOperator((DynamicObject)newValue);
            } else if ("bizoperatorgroup".equals(propName)) {
                this.changeBizOperatorGroup((DynamicObject)newValue);
            } else if ("bizorg".equals(propName)) {
                this.changeBizOrg(newValue);
                this.change4BizOrg((DynamicObject)newValue);
            } else if ("entryreqorg".equals(propName)) {
                this.changeEntryReqOrg((DynamicObject)newValue, rowIndex);
            } else if ("entrysettleorg".equals(propName)) {
                this.changeEntrySettleOrg((DynamicObject)newValue, rowIndex);
            } else if ("biztime".equals(propName)) {
                this.changeBizTime(this.getModel());
            } else if ("invscheme".equals(propName)) {
                this.changeInvScheme((DynamicObject)newValue);
            } else if ("warehouse".equals(propName)) {
                this.changeWarehouse((DynamicObject)newValue, rowIndex);
            } else if ("location".equals(propName)) {
                this.changeLocation((DynamicObject)newValue, rowIndex);
            } else if ("outwarehouse".equals(propName)) {
                this.changeOutWarehouse((DynamicObject)newValue, rowIndex);
            } else if ("invoicebiztype".equals(propName)) {
                InvoiceBizHelper.invoiceBizChange((IDataModel)this.getModel(), (DynamicObject)((DynamicObject)newValue));
            } else if ("owner".equals(propName)) {
                this.changeOwner((DynamicObject)newValue, rowIndex);
            } else if ("invtype".equals(propName)) {
                this.changeInvType(rowIndex);
            } else if ("taxpayertype".equals(propName)) {
                InvoiceBizHelper.taxPayerChange((IDataModel)this.getModel(), (int)rowIndex);
            }
            this.getAlgorithm().calByChange(e);
            if (!"taxamount".equals(propName) && !"taxrate".equals(propName)) continue;
            this.changeTaxMountOrTax(rowIndex);
        }
    }

    private void changeLocation(DynamicObject newValue, int rowIndex) {
        DynamicObject invscheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (invscheme == null) {
            return;
        }
        boolean isoutupdate = invscheme.getBoolean("isoutupdate");
        if (isoutupdate) {
            DynamicObject outlocation = (DynamicObject)this.getModel().getValue("outlocation", rowIndex);
            DynamicObject location = (DynamicObject)this.getModel().getValue("location", rowIndex);
            if (outlocation == null && location != null) {
                Long warehouseId = (Long)this.getModel().getValue("warehouse_id", rowIndex);
                Long outwarehouseId = (Long)this.getModel().getValue("outwarehouse_id", rowIndex);
                if (Long.compare(warehouseId, outwarehouseId) == 0) {
                    this.getModel().setValue("outlocation", (Object)location, rowIndex);
                }
            }
        }
    }

    private void changeOutWarehouse(DynamicObject outWareHouse, int rowIndex) {
        if (outWareHouse != null) {
            DynamicObject outlocation = (DynamicObject)this.getModel().getValue("outlocation");
            boolean isopenlocation = outWareHouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowIndex, new String[]{"outlocation"});
            if (outlocation == null) {
                Long wareHouseId = (Long)this.getModel().getValue("warehouse_id", rowIndex);
                Long outWareHouseId = outWareHouse.getLong("id");
                if (Long.compare(wareHouseId, outWareHouseId) == 0) {
                    this.getModel().setValue("outlocation", this.getModel().getValue("location", rowIndex), rowIndex);
                }
            }
            if (!isopenlocation) {
                this.getModel().setValue("outlocation", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"outlocation"});
            }
        } else {
            this.getModel().setValue("outlocation", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"outlocation"});
        }
    }

    private void changeWarehouse(DynamicObject warehouse, int rowIndex) {
        DynamicObject outwarehouse = (DynamicObject)this.getModel().getValue("outwarehouse", rowIndex);
        boolean isoutupdate = ((DynamicObject)this.getModel().getValue("invscheme")).getBoolean("isoutupdate");
        if (outwarehouse == null && isoutupdate) {
            this.getModel().setValue("outwarehouse", (Object)warehouse, rowIndex);
        }
    }

    private void changeInvScheme(DynamicObject invscheme) {
        if (invscheme != null) {
            boolean isoutupdate = invscheme.getBoolean("isoutupdate");
            this.getView().setVisible(Boolean.valueOf(isoutupdate), new String[]{"outwarehouse", "outlocation"});
            if (isoutupdate) {
                int count = this.getModel().getEntryRowCount("billentry");
                for (int i = 0; i < count; ++i) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"outlocation"});
                }
            }
        }
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject owner = (DynamicObject)this.getModel().getValue("owner", i);
            this.changeOwner(owner, i);
        }
    }

    private void changeBizTime(IDataModel model) {
        int rowCount = model.getEntryRowCount("billentry");
        Date bizTime = (Date)model.getValue("biztime");
        if (rowCount > 0) {
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("billentry");
            for (int i = 0; i < rowCount; ++i) {
                boolean needClear;
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                DynamicObject taxrate = dynamicObject.getDynamicObject("taxrateid");
                if (taxrate == null) continue;
                Date activedate = taxrate.getDate("activedate");
                Date expdate = taxrate.getDate("expdate");
                boolean bl = needClear = bizTime == null || bizTime.before(activedate) || expdate != null && bizTime.after(expdate);
                if (!needClear) continue;
                this.setValue("taxrateid", null, i, false);
                this.changeTaxRateID(null, i);
            }
        }
    }

    private void changeSupplier(Object newValue) {
        DynamicObject supplier = (DynamicObject)newValue;
        Object supplierId = null;
        DynamicObject invoiceSupplier = null;
        DynamicObject receivingSupplier = null;
        DynamicObject deliverSupplier = null;
        DynamicObject settlementCy = null;
        DynamicObject settlementType = null;
        DynamicObject payCond = null;
        IDataModel bill = this.getModel();
        int size = bill.getEntryEntity("billentry").size();
        if (supplier == null) {
            bill.setValue("paycondition", null);
            bill.setValue("settletype", null);
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                bill.setValue("invoicesupplier", null, rowIndex);
                bill.setValue("receivesupplier", null, rowIndex);
                bill.setValue("providersupplier", null, rowIndex);
            }
            return;
        }
        invoiceSupplier = supplier.getDynamicObject("invoicesupplierid");
        receivingSupplier = supplier.getDynamicObject("receivingsupplierid");
        deliverSupplier = supplier.getDynamicObject("deliversupplierid");
        settlementCy = supplier.getDynamicObject("settlementcyid");
        settlementType = supplier.getDynamicObject("settlementtypeid");
        payCond = supplier.getDynamicObject("paycond");
        supplierId = supplier.getPkValue();
        bill.setValue("paycondition", payCond == null ? null : payCond.getPkValue());
        bill.setValue("settletype", settlementType == null ? null : settlementType.getPkValue());
        if (settlementCy != null) {
            bill.setValue("settlecurrency", settlementCy.getPkValue());
        } else {
            DynamicObject currency = (DynamicObject)bill.getValue("currency");
            bill.setValue("settlecurrency", currency == null ? null : currency.getPkValue());
        }
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            String outKeeperType;
            String keeperType;
            String outOwnerType;
            bill.setValue("invoicesupplier", invoiceSupplier == null ? supplier.getPkValue() : invoiceSupplier.getPkValue(), rowIndex);
            bill.setValue("receivesupplier", receivingSupplier == null ? supplier.getPkValue() : receivingSupplier.getPkValue(), rowIndex);
            bill.setValue("providersupplier", deliverSupplier == null ? supplier.getPkValue() : deliverSupplier.getPkValue(), rowIndex);
            String type = (String)bill.getValue("ownertype", rowIndex);
            if ("bd_supplier".equals(type)) {
                bill.setValue("owner", supplierId, rowIndex);
            }
            if ("bd_supplier".equals(outOwnerType = (String)bill.getValue("outownertype", rowIndex))) {
                bill.setValue("outowner", supplierId, rowIndex);
            }
            if ("bd_supplier".equals(keeperType = (String)bill.getValue("keepertype", rowIndex))) {
                bill.setValue("keeper", supplierId, rowIndex);
            }
            if (!"bd_supplier".equals(outKeeperType = (String)bill.getValue("outkeepertype", rowIndex))) continue;
            bill.setValue("outkeeper", supplierId, rowIndex);
        }
        DynamicObject invoiceType = (DynamicObject)supplier.get("invoicecategory");
        String appId = this.getView().getFormShowParameter().getAppId();
        if (invoiceType != null && appId != null) {
            Long invoiceTypeId = invoiceType.getLong("id");
            DynamicObject invoiceBizType = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"CommonHelperService", (String)"getInvoiceBizType", (Object[])new Object[]{invoiceTypeId, appId});
            if (invoiceBizType != null) {
                bill.setValue("invoicebiztype", (Object)invoiceBizType);
            } else {
                bill.setValue("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
            }
        } else {
            bill.setValue("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
        }
    }

    private void changeProviderSupplier(DynamicObject providerSupplier, int rowIndex) {
        IDataModel bill = this.getModel();
        ILocaleString providerAddress = null;
        DynamicObjectCollection linkmans = null;
        if (providerSupplier != null) {
            providerAddress = SupplierHelper.getValidDefaultMultilingualAddress((DynamicObject)providerSupplier);
            linkmans = providerSupplier.getDynamicObjectCollection("entry_linkman");
        }
        Long supplierLinkmanId = null;
        if (linkmans != null) {
            for (DynamicObject linkman : linkmans) {
                boolean isDefault = linkman.getBoolean("isdefault_linkman");
                boolean isInvalid = linkman.getBoolean("invalid");
                if (!isDefault || isInvalid) continue;
                supplierLinkmanId = Long.valueOf(String.valueOf(linkman.getPkValue()));
            }
        }
        if (supplierLinkmanId == null && linkmans != null && linkmans.size() > 0) {
            for (DynamicObject linkman : linkmans) {
                boolean isInvalid = linkman.getBoolean("invalid");
                if (isInvalid) continue;
                supplierLinkmanId = (Long)linkman.getPkValue();
                break;
            }
        }
        bill.setValue("provideraddress", (Object)providerAddress, rowIndex);
        bill.setValue("providerlinkman", supplierLinkmanId, rowIndex);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if ("billentry".equals(entryName)) {
            DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
            DynamicObject invoiceSupplier = null;
            DynamicObject receivingSupplier = null;
            DynamicObject deliverSupplier = null;
            if (supplier != null) {
                invoiceSupplier = supplier.getDynamicObject("invoicesupplierid");
                receivingSupplier = supplier.getDynamicObject("receivingsupplierid");
                deliverSupplier = supplier.getDynamicObject("deliversupplierid");
            }
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.initPriceField(isTax, rowIndex);
                this.initNewEntry(rowIndex, invoiceSupplier, receivingSupplier, deliverSupplier);
            }
        }
    }

    private void changeTaxRateID(DynamicObject taxRateID, int rowIndex) {
        DynamicObject bill = this.getBill();
        boolean purInBillType = InvoiceBizHelper.isPurInBillType((DynamicObject)bill);
        if (taxRateID == null) {
            this.getModel().setValue("taxrate", (Object)0, rowIndex);
            if (purInBillType) {
                this.getModel().setValue("deductiblerate", (Object)BigDecimal.ZERO, rowIndex);
            }
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
        if (purInBillType) {
            DynamicObject invoiceBiz = bill.getDynamicObject("invoicebiztype");
            if (invoiceBiz != null) {
                Long invoiceBizId = invoiceBiz.getLong("id");
                Object taxPayerType = model.getValue("taxpayertype", rowIndex);
                if ("1".equals(taxPayerType) && (DEFAULT_INVOICE_BIZ.equals(invoiceBizId) || PROFORMA_INVOICE_BIZ.equals(invoiceBizId))) {
                    model.setValue("deductiblerate", taxRateID.get("taxrate"), rowIndex);
                } else {
                    model.setValue("deductiblerate", (Object)BigDecimal.ZERO, rowIndex);
                }
            } else {
                model.setValue("deductiblerate", (Object)BigDecimal.ZERO, rowIndex);
            }
        }
    }

    private void changeExChangeRate(String propName, Object oldValue, Object newValue) {
    }

    private void changeDiscountType(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int discountRateScale = 4;
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate == null) {
            discountRate = BigDecimal.ZERO;
        }
        if (discountRate != null && DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            discountRate = discountRate.setScale(discountRateScale, 4);
            model.setValue("discountrate", (Object)discountRate, rowIndex);
            if (discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) > 0) {
                model.setValue(fieldName, oldValue, rowIndex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u5e94\u5c0f\u4e8e\u7b49\u4e8e100%\u3002", (String)"OmInBillEditPlugin_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return;
            }
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountamount"});
        } else if (discountRate != null && DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            if (settleCurrency != null) {
                discountRateScale = this.getPrecision("settlecurrency", "priceprecision");
            }
            discountRate = discountRate.setScale(discountRateScale, 4);
            boolean isTax = (Boolean)model.getValue("istax");
            BigDecimal amount = discountRate;
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                if (amount.compareTo(priceAndTax) > 0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"OmInBillEditPlugin_4", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    return;
                }
            } else {
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                if (amount.compareTo(price) > 0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5355\u4ef7\u3002", (String)"OmInBillEditPlugin_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    return;
                }
            }
            model.setValue("discountrate", (Object)discountRate, rowIndex);
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountamount"});
        } else {
            model.setValue("discountrate", null, rowIndex);
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
            model.setValue("discountamount", null, rowIndex);
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountamount"});
        }
    }

    private void changeIsTax(Object newValue) {
        if (newValue instanceof Boolean) {
            boolean isTax = (Boolean)newValue;
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.initPriceField(isTax, i);
            }
        }
    }

    private void initPriceField(boolean isTax, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)model.getValue("ispresent", rowIndex);
        view.setEnable(Boolean.valueOf(!isPresent), rowIndex, new String[]{"taxrateid"});
        view.setEnable(Boolean.valueOf(!isPresent), rowIndex, new String[]{"discounttype"});
        boolean isDiscount = DiscountTypeEnum.NULL.getValue().equals(model.getValue("discounttype", rowIndex));
        view.setEnable(Boolean.valueOf(!isDiscount), rowIndex, new String[]{"discountrate"});
        view.setEnable(Boolean.valueOf(!isDiscount), rowIndex, new String[]{"discountamount"});
        boolean isEnable = !isPresent && !isTax;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"price"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"actualprice"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amount"});
        isEnable = !isPresent && isTax;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"priceandtax"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"actualtaxprice"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amountandtax"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"taxamount"});
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)newValue;
        boolean isTax = (Boolean)model.getValue("istax");
        this.initPriceField(isTax, rowIndex);
        if (isPresent) {
            model.setValue("price", (Object)Constants.ZERO, rowIndex);
            model.setValue("priceandtax", (Object)Constants.ZERO, rowIndex);
            model.setValue("actualprice", (Object)Constants.ZERO, rowIndex);
            model.setValue("actualtaxprice", (Object)Constants.ZERO, rowIndex);
            model.setValue("taxrate", (Object)Constants.ZERO, rowIndex);
            model.setValue("taxrateid", null, rowIndex);
            model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            model.setValue("discountrate", (Object)Constants.ZERO, rowIndex);
        }
    }

    private String getBizOrgDisplayName() {
        BasedataEdit bizOrgEdit = (BasedataEdit)this.getControl("bizorg");
        IDataEntityProperty orgProp = bizOrgEdit.getProperty();
        LocaleString displayName = orgProp.getDisplayName();
        return displayName.toString();
    }

    private void changeBizOrg(Object newValue) {
        DynamicObject bizOrg = (DynamicObject)newValue;
        if (bizOrg != null) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            this.changeBizDept(bizOrgId);
            this.getModel().setValue("bizoperator", null);
            this.getModel().setValue("bizoperatorgroup", null);
            return;
        }
    }

    private void changeBizDept(Long orgId) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && deptIds.size() > 0) {
            this.getModel().setValue("bizdept", deptIds.get(0));
            return;
        }
        deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptIds != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
            this.getModel().setValue("bizdept", (Object)orgId);
        } else {
            this.getModel().setValue("bizdept", null);
        }
    }

    private void changeBizOperatorGroup(DynamicObject bizGrp) {
        if (bizGrp == null) {
            this.getModel().setValue("bizoperator", null);
        }
    }

    private void changeBizOperator(DynamicObject bizOperator) {
        if (bizOperator != null) {
            bizOperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizOperator.getPkValue(), (String)"bd_operator");
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", bizOperator.get("operatorgrpid"));
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
            if (bizOrg == null) {
                return;
            }
            List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)((Long)bizOrg.getPkValue()), (boolean)true);
            if (deptids != null && deptids.size() > 0) {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    for (Long deptId : userdeptIds) {
                        if (!deptids.contains(deptId)) continue;
                        this.getModel().beginInit();
                        this.getModel().setValue("bizdept", (Object)deptId);
                        this.getModel().endInit();
                        this.getView().updateView("bizdept");
                        break;
                    }
                }
            } else {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    this.getModel().beginInit();
                    this.getModel().setValue("bizdept", userdeptIds.get(0));
                    this.getModel().endInit();
                    this.getView().updateView("bizdept");
                }
            }
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", null);
            this.getModel().setValue("bizdept", null);
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            this.getView().updateView("bizdept");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("billentry");
        boolean falg = false;
        for (int i = 0; i < entrys.size(); ++i) {
            String srcbillno = ((DynamicObject)entrys.get(i)).getString("srcbillnumber");
            if (StringUtils.isEmpty((Object)srcbillno)) continue;
            falg = true;
        }
        if (falg) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"paymode"});
        }
        this.setOutWareHouse();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
        if (org != null) {
            this.initCurrencyAndExrateTable((Long)org.getPkValue());
        }
        Date bizDate = (Date)this.getModel().getValue("biztime");
        this.getModel().setValue("exratedate", (Object)bizDate);
        if (bizOrg != null) {
            Long settleOrgId = this.getCompanyByOrg((Long)bizOrg.getPkValue());
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.initSettleOrgDefaultValue(settleOrgId, i);
            }
        }
        DynamicObject bizOrgDynamicObject = (DynamicObject)this.getModel().getValue("bizorg");
        this.changeBizOrg(bizOrgDynamicObject);
        this.setOutWareHouse();
        this.initSettleType();
        this.initTaxPayerType();
        boolean fromWebApi = ((BillModel)this.getModel()).isFromWebApi();
        if (!fromWebApi) {
            this.getModel().setValue("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
        }
    }

    private void setOutWareHouse() {
        DynamicObject invscheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (invscheme != null) {
            boolean isoutupdate = invscheme.getBoolean("isoutupdate");
            this.getView().setVisible(Boolean.valueOf(isoutupdate), new String[]{"outwarehouse", "outlocation"});
            if (isoutupdate) {
                int count = this.getModel().getEntryRowCount("billentry");
                for (int i = 0; i < count; ++i) {
                    DynamicObject outwarehouse = (DynamicObject)this.getModel().getValue("outwarehouse", i);
                    if (outwarehouse != null && outwarehouse.getBoolean("isopenlocation")) continue;
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"outlocation"});
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"outwarehouse", "outlocation"});
        }
    }

    private void initSettleType() {
        this.getModel().setValue("settletype", null);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            this.initCurrencyAndExrateTable((Long)org.getPkValue());
        }
        Date bizDate = (Date)this.getModel().getValue("biztime");
        model.setValue("exratedate", (Object)bizDate);
        this.changeExchangeRate();
        this.getAlgorithm().calByChange("exchangerate");
        String appId = this.getView().getFormShowParameter().getAppId();
        DynamicObject bill = model.getDataEntity();
        InvoiceBizHelper.handleInvoiceBizNull((DynamicObject)bill, (String)appId);
        this.initTaxPayerType();
    }

    private void initSettleOrgDefaultValue(Object settleOrgId, int rowIndex) {
        this.getModel().setValue("entrysettleorg", settleOrgId, rowIndex);
    }

    private void changeExchangeRate() {
        Long exrateTableId;
        IDataModel model = this.getModel();
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        Date exrateDate = (Date)model.getValue("exratedate");
        DynamicObject exratetable = (DynamicObject)this.getModel().getValue("exratetable");
        Long l = exrateTableId = exratetable == null ? null : Long.valueOf(exratetable.getLong("id"));
        if (currency != null && settleCurrency != null && exrateTableId != null) {
            if (currency.getPkValue().equals(settleCurrency.getPkValue())) {
                model.setValue("exchangerate", (Object)new BigDecimal(1));
                this.getView().setEnable(Boolean.FALSE, new String[]{"exchangerate"});
            } else {
                BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)settleCurrency.getLong("id"), (Long)currency.getLong("id"), (Date)exrateDate);
                if (exchangeRate == null) {
                    model.setValue("exchangerate", null);
                    ErrorCodeHelper.showErrorCode((String)ResManager.loadKDString((String)"\u8bf7\u5728\u5f53\u524d\u6c47\u7387\u8868\u4e2d\u914d\u7f6e\u201c\u672c\u4f4d\u5e01\u201d\u548c\u201c\u7ed3\u7b97\u5e01\u201d\u7684\u6c47\u7387\u3002", (String)"OmInBillEditPlugin_6", (String)"scmc-mm-mdc", (Object[])new Object[0]), (String)"n", (String)"tip", null, null, (int)3, null, null, null, (AbstractFormPlugin)this);
                } else {
                    model.setValue("exchangerate", (Object)exchangeRate);
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"exchangerate"});
            }
        }
    }

    private void changeSettleCurrency() {
        this.changeExchangeRate();
    }

    private void change4BizOrg(DynamicObject bizOrg) {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        if (bizOrg == null) {
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("entrysettleorg", null, i);
            }
        } else {
            Long settleOrgId = this.getCompanyByOrg((Long)bizOrg.getPkValue());
            for (int i = 0; i < entryRowCount; ++i) {
                this.initSettleOrgDefaultValue(settleOrgId, i);
            }
        }
    }

    private void changeEntryReqOrg(DynamicObject newValue, int rowIndex) {
        IDataModel model = this.getModel();
        String type = (String)model.getValue("ownertype", rowIndex);
        if ("bos_org".equals(type)) {
            Object defalutOwner = this.getInvSchemeService().getDefalutOwner(type, rowIndex);
            model.setValue("owner", defalutOwner, rowIndex);
        }
    }

    private void changeEntrySettleOrg(DynamicObject newValue, int rowIndex) {
    }

    private void changeDiscountAmount(String fieldName, Object oldValue, BigDecimal discountAmount, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal priceAndPrice = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        BigDecimal amoutAndTax = BigDecimal.ZERO;
        amoutAndTax = isTax ? qty.multiply(priceAndPrice) : qty.multiply(price).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimalConstants.ONEHUNDRED)));
        if (discountAmount.compareTo(amoutAndTax) > 0 || discountAmount.compareTo(BigDecimal.ZERO) < 0) {
            model.setValue("discountamount", oldValue, rowIndex);
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_UNITDISAMOUNT()));
            return;
        }
    }

    private void changeTaxMount(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        boolean taxAmountCheck;
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal amountAndTax = (BigDecimal)model.getValue("amountandtax", rowIndex);
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
        boolean bl = taxAmountCheck = isTax && (taxAmount.compareTo(amountAndTax) > 0 || taxAmount.compareTo(BigDecimal.ZERO) < 0);
        if (taxAmountCheck) {
            model.setValue("taxamount", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u989d\u5e94\u9700\u6ee1\u8db3\u6761\u4ef6\uff1a0\u2264\u7a0e\u989d\u2264\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"OmInBillEditPlugin_7", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
    }

    private void initCurrencyAndExrateTable(Long orgId) {
        IDataModel model = this.getModel();
        if (orgId == null) {
            model.setValue("currency", null);
            model.setValue("exratetable", null);
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (map == null) {
            model.setValue("currency", null);
            model.setValue("exratetable", null);
            return;
        }
        model.setValue("currency", map.get("baseCurrencyID"));
        Object exRateTableId = map.get("exchangeRateTableID");
        model.setValue("exratetable", exRateTableId);
    }

    private void initNewEntry(int rowIndex, DynamicObject invoiceSupplier, DynamicObject receivingSupplier, DynamicObject deliverSupplier) {
        this.setSettleOrg(rowIndex);
        this.setDefaultSupplierInfo(invoiceSupplier, receivingSupplier, deliverSupplier, rowIndex);
        this.setDefaultQty(rowIndex);
        this.setDefaultTaxPayerType(rowIndex);
    }

    private void setSettleOrg(int rowIndex) {
        Long settleOrgId;
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
        if (bizOrg != null && (settleOrgId = this.getCompanyByOrg((Long)bizOrg.getPkValue())) != null) {
            this.getModel().setValue("bizorg", (Object)bizOrg, rowIndex);
            this.initSettleOrgDefaultValue(settleOrgId, rowIndex);
        }
    }

    private void setDefaultQty(int rowIndex) {
        IDataModel bill = this.getModel();
        bill.setValue("returnbaseqty", null, rowIndex);
        bill.setValue("returnqty", null, rowIndex);
        bill.setValue("remainreturnqty", null, rowIndex);
        bill.setValue("remainreturnbaseqty", null, rowIndex);
        bill.setValue("joinpriceqty", null, rowIndex);
        bill.setValue("remainjoinpriceqty", null, rowIndex);
    }

    private void setDefaultSupplierInfo(DynamicObject invoiceSupplier, DynamicObject receivingSupplier, DynamicObject deliverSupplier, int rowIndex) {
        this.getModel().setValue("providersupplier", deliverSupplier == null ? null : deliverSupplier.getPkValue(), rowIndex);
        this.getModel().setValue("invoicesupplier", invoiceSupplier == null ? null : invoiceSupplier.getPkValue(), rowIndex);
        this.getModel().setValue("receivesupplier", receivingSupplier == null ? null : receivingSupplier.getPkValue(), rowIndex);
    }

    protected void changePriceAndTax(int rowIndex, Object newValue, Object oldValue) {
        BigDecimal priceAndTax;
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate != null && DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && (priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex)) != null && discountRate != null && priceAndTax.compareTo(discountRate) < 0) {
            model.setValue("priceandtax", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\u5e94\u5927\u4e8e\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"OmInBillEditPlugin_8", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
    }

    protected void changeActualPrice(int rowIndex, Object newValue, Object oldValue) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal actualPrice = (BigDecimal)newValue;
        if (price != null && actualPrice != null && price.compareTo(actualPrice) < 0) {
            model.setValue("actualprice", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5355\u4ef7\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5355\u4ef7\u3002", (String)"OmInBillEditPlugin_9", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
        this.setDefaultDiscountType(rowIndex);
    }

    protected void changeActualTaxPrice(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal actualPrice = (BigDecimal)newValue;
        if (price != null && actualPrice != null && price.compareTo(actualPrice) < 0) {
            model.setValue("actualtaxprice", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"OmInBillEditPlugin_10", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
        this.setDefaultDiscountType(rowIndex);
    }

    private void setDefaultDiscountType(int i) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String discountType = (String)model.getValue("discounttype", i);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)discountType) || DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            model.beginInit();
            model.setValue("discounttype", (Object)DiscountTypeEnum.UNITDIS.getValue(), i);
            model.endInit();
            BillViewHelper.updateViewField((IFormView)this.getView(), (int)i, (String)"discounttype", (String[])new String[0]);
            view.setEnable(Boolean.TRUE, i, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, i, new String[]{"discountamount"});
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel bill = this.getModel();
        BillModel billModel = (BillModel)bill;
        boolean isFromWebApi = billModel.isFromWebApi();
        if (!isFromWebApi) {
            return;
        }
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
        if (bizOrg == null) {
            return;
        }
        Map sourceData = e.getSourceData();
        Map bizDept = (Map)sourceData.get("bizdept");
        if (bizDept == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)bizDept.get("number")))) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            this.changeBizDept(bizOrgId);
        }
        JSONArray entry = (JSONArray)sourceData.get("billentry");
        for (Object obj : entry) {
            Object outInvType;
            Object invType;
            Object outKeeper;
            Object outOwner;
            Object keeper;
            Object owner;
            Object settleOrg;
            Map map = (Map)obj;
            Object reqOrg = map.get("entryreqorg");
            if (reqOrg == null) {
                this.getModel().setValue("entryreqorg", null);
            }
            if ((settleOrg = map.get("entrysettleorg")) == null) {
                this.getModel().setValue("entrysettleorg", null);
            }
            if ((owner = map.get("owner")) == null) {
                this.getModel().setValue("owner", null);
            }
            if ((keeper = map.get("keeper")) == null) {
                this.getModel().setValue("keeper", null);
            }
            if ((outOwner = map.get("outowner")) == null) {
                this.getModel().setValue("outowner", null);
            }
            if ((outKeeper = map.get("outkeeper")) == null) {
                this.getModel().setValue("outkeeper", null);
            }
            if ((invType = map.get("invtype")) == null) {
                this.getModel().setValue("invtype", null);
            }
            if ((outInvType = map.get("outinvtype")) != null) continue;
            this.getModel().setValue("outinvtype", null);
        }
        this.initTaxPayerType();
    }

    private boolean isInitBill(Object isInitBill) {
        if (isInitBill == null) {
            return false;
        }
        if (isInitBill instanceof Boolean) {
            return (Boolean)isInitBill;
        }
        return "true".equals(isInitBill.toString().trim()) || "1".equals(isInitBill.toString().trim());
    }

    protected void setHeadEnable() {
        super.setHeadEnable();
        IFormView view = this.getView();
        DynamicObject bill = this.getBill();
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        boolean isEnable = currency == null || settleCurrency == null || !currency.getPkValue().equals(settleCurrency.getPkValue());
        view.setEnable(Boolean.valueOf(isEnable), new String[]{"exchangerate"});
    }

    protected void setEnable4IsDraw(boolean isDraw) {
        super.setEnable4IsDraw(isDraw);
        IFormView view = this.getView();
        if (isDraw) {
            view.setEnable(Boolean.FALSE, new String[]{"billtype", "settlecurrency", "bizorg", "supplier", "exchangerate", "exratetable", "transactepath"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"supplier"});
        }
    }

    protected void setBillEntryEnable(RowDataEntity entry) {
        String outKeeperType;
        String keeperType;
        super.setBillEntryEnable(entry);
        DynamicObject bill = this.getBill();
        IFormView view = this.getView();
        int index = entry.getRowIndex();
        boolean isTax = bill.getBoolean("istax");
        this.initPriceField(isTax, index);
        DynamicObject dynamicObject = entry.getDataEntity();
        Boolean isPresent = dynamicObject.getBoolean("ispresent");
        this.changeIsPresent(isPresent, index);
        String discountType = (String)this.getModel().getValue("discounttype", index);
        if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            view.setEnable(Boolean.FALSE, index, new String[]{"discountrate"});
            view.setEnable(Boolean.FALSE, index, new String[]{"discountamount"});
        }
        if ((keeperType = entry.getDataEntity().getString("keepertype")) != null) {
            boolean isAccountOrg = "bd_supplier".equalsIgnoreCase(keeperType) || "bd_customer".equalsIgnoreCase(keeperType);
            view.setEnable(Boolean.valueOf(isAccountOrg), new String[]{"keeper"});
        }
        if ((outKeeperType = entry.getDataEntity().getString("outkeepertype")) != null) {
            boolean isAccountOrg = "bd_supplier".equalsIgnoreCase(outKeeperType) || "bd_customer".equalsIgnoreCase(outKeeperType);
            view.setEnable(Boolean.valueOf(isAccountOrg), new String[]{"outkeeper"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if ("entryrowsplitop".equals(operateKey) || "newentry".equals(operateKey) || "unaudit".equals(operateKey)) {
            this.setOutWareHouse();
        }
    }

    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        if (isDraw) {
            IFormView view = this.getView();
            int index = row.getRowIndex();
            view.setEnable(Boolean.FALSE, index, new String[]{"ispresent", "model", "unit", "ownertype", "owner", "entrysettleorg", "taxrate", "discounttype", "discountrate"});
            IDataModel dataModel = view.getModel();
            Object srcbillentity = dataModel.getValue("srcbillentity");
            if ("im_purinbill".equals(srcbillentity)) {
                view.setEnable(Boolean.FALSE, index, new String[]{"lotnumber", "producedate", "expirydate"});
            }
        }
    }

    private void changeOwner(DynamicObject owner, int rowIndex) {
        Object ownerType = this.getModel().getValue("ownertype", rowIndex);
        if ("bos_org".equals(ownerType)) {
            if (owner != null) {
                Map cacheOwners = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"taxpayertype", (QFilter[])new QFilter("id", "=", owner.getPkValue()).toArray());
                this.setTaxPayerType(rowIndex, owner, cacheOwners);
            } else {
                this.getModel().setValue("taxpayertype", null, rowIndex);
            }
        } else {
            this.getModel().setValue("taxpayertype", null, rowIndex);
        }
    }

    private void setTaxPayerType(int rowIndex, DynamicObject owner, Map<Object, DynamicObject> cacheOwners) {
        DynamicObject cacheOwner;
        if (owner != null && (cacheOwner = cacheOwners.get(owner.getPkValue())) != null) {
            this.getModel().setValue("taxpayertype", cacheOwner.get("taxpayertype"), rowIndex);
        }
    }

    private void changeInvType(int rowIndex) {
        DynamicObject owner = (DynamicObject)this.getModel().getValue("owner", rowIndex);
        this.changeOwner(owner, rowIndex);
    }

    private void initTaxPayerType() {
        DynamicObject bill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        HashSet<Object> ownerIds = new HashSet<Object>(16);
        for (DynamicObject entry : entrys) {
            Object ownerId;
            String ownerType = entry.getString("ownertype");
            if (!"bos_org".equals(ownerType)) continue;
            DynamicObject owner = entry.getDynamicObject("owner");
            if (owner == null && (ownerId = entry.get("owner_id")) != null) {
                owner = BusinessDataServiceHelper.newDynamicObject((String)ownerType);
                owner.set("id", ownerId);
                entry.set("owner", (Object)owner);
            }
            if (owner == null) continue;
            ownerIds.add(owner.getPkValue());
        }
        Map cacheOwners = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"taxpayertype", (QFilter[])new QFilter("id", "in", ownerIds).toArray());
        int rowCount = entrys.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object ownerType = this.getModel().getValue("ownertype", i);
            if (!"bos_org".equals(ownerType)) continue;
            DynamicObject owner = (DynamicObject)this.getModel().getValue("owner", i);
            this.setTaxPayerType(i, owner, cacheOwners);
        }
    }

    private void setDefaultTaxPayerType(int rowIndex) {
        DynamicObject owner;
        Object ownerType = this.getModel().getValue("ownertype", rowIndex);
        if ("bos_org".equals(ownerType) && (owner = (DynamicObject)this.getModel().getValue("owner", rowIndex)) != null) {
            Map cacheOwners = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"taxpayertype", (QFilter[])new QFilter("id", "=", owner.getPkValue()).toArray());
            this.setTaxPayerType(rowIndex, owner, cacheOwners);
        }
    }

    private void changeTaxMountOrTax(int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal deductibleRate = (BigDecimal)model.getValue("deductiblerate", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        if (deductibleRate != null && taxRate != null && deductibleRate.compareTo(taxRate) == 0) {
            model.setValue("curdeductibleamt", model.getValue("curtaxamount", rowIndex), rowIndex);
            model.setValue("intercostamt", model.getValue("curamount", rowIndex), rowIndex);
            this.getView().updateView("curdeductibleamt", rowIndex);
            this.getView().updateView("intercostamt", rowIndex);
        }
    }
}

