/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.ominbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.formplugin.ImBillListPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class OmInBillListPlugin
extends ImBillListPlugin {
    private static final String TPLBATIN = "tplbatin";

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "tplbatin": {
                this.doReceive();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("writeoff".equals(operateKey)) {
            this.checkMaterial(args, "C", operateKey);
        }
        if ("audit".equals(operateKey)) {
            this.checkMaterial(args, "B", operateKey);
        }
    }

    private void checkMaterial(BeforeDoOperationEventArgs e, String allowedBillStatus, String operateKey) {
        int i;
        ArrayList<String> allowedMsgList = new ArrayList<String>();
        StringBuilder infoMsg = new StringBuilder();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String entityName = billList.getEntityId();
        StringBuilder compeletPk = new StringBuilder();
        ListSelectedRowCollection selectsOld = billList.getSelectedRows();
        ListSelectedRowCollection selects = new ListSelectedRowCollection();
        for (i = 0; i < selectsOld.size(); ++i) {
            boolean numLabel = false;
            for (int j = 0; j < selects.size(); ++j) {
                if (!selects.get(j).getPrimaryKeyValue().equals(selectsOld.get(i).getPrimaryKeyValue())) continue;
                numLabel = true;
            }
            if (numLabel) continue;
            selects.add((Object)selectsOld.get(i));
        }
        for (i = 0; i < selects.size(); ++i) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)selects.get(i).getPrimaryKeyValue(), (String)entityName);
            DynamicObject transObj = obj.getDynamicObject("invscheme").getDynamicObject("transceivertype");
            if (transObj == null) {
                return;
            }
            QFilter qFilter = new QFilter("id", "=", transObj.getPkValue());
            DataSet transObjSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)transObj.getDataEntityType().getName(), (String)"bizdirection", (QFilter[])qFilter.toArray(), null);
            while (transObjSet.hasNext()) {
                Row row = transObjSet.next();
                String bizdirection = row.getString("bizdirection");
                if (!"1".equals(bizdirection)) continue;
                return;
            }
            transObjSet.close();
            DynamicObjectCollection entry = obj.getDynamicObjectCollection("billentry");
            String billstatus = obj.getString("billstatus");
            if (!allowedBillStatus.equals(billstatus) || !CollectionUtils.isNotEmpty((Collection)entry)) continue;
            for (DynamicObject omInEntry : entry) {
                Map<String, Map<String, Object>> map;
                if (omInEntry.getBoolean("ispresent") || MapUtils.isEmpty(map = this.getOmOrderData(omInEntry.getLong("mainbillid"))) || !this.judgeOrderClosed(omInEntry, map, allowedBillStatus)) continue;
                allowedMsgList.add(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u5206\u5f55\uff0c", (String)"OmInBillListPlugin_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), obj.getString("billno"), omInEntry.get("mainbillentryseq")));
                compeletPk.append(omInEntry.getPkValue());
                compeletPk.append(",");
            }
        }
        if (CollectionUtils.isNotEmpty(allowedMsgList)) {
            StringBuilder sb = new StringBuilder();
            allowedMsgList.stream().forEach(x -> sb.append((String)x));
            infoMsg.append(String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5165\u5e93\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u59d4\u5916\u8ba2\u5355\u884c\u5df2\u5b8c\u5168\u5165\u5e93\uff0c\u662f\u5426\u5b8c\u5168\u6838\u9500\uff1f", (String)"OmInBillListPlugin_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), sb.toString()));
            FormOperate source = (FormOperate)e.getSource();
            RefObject afterConfirm = new RefObject();
            if (!source.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
                this.getView().showConfirm(infoMsg.toString(), MessageBoxOptions.YesNo, listener);
                this.getPageCache().put("compeletPk", compeletPk.toString());
                e.setCancel(true);
                return;
            }
        }
    }

    private boolean judgeOrderClosed(DynamicObject omInEntry, Map<String, Map<String, Object>> map, String allowedBillStatus) {
        Map<String, Object> omOrderEntryMap = map.get(omInEntry.get("mainbillentryid").toString());
        BigDecimal baseQty = omInEntry.getBigDecimal("baseqty");
        if ("B".equals(omOrderEntryMap.get("billentry.rowclosestatus"))) {
            return true;
        }
        BigDecimal invbaseqty = (BigDecimal)omOrderEntryMap.get("billentry.invbaseqty");
        BigDecimal returnbaseqty = (BigDecimal)omOrderEntryMap.get("billentry.returnbaseqty");
        BigDecimal receivebaseqtydown = (BigDecimal)omOrderEntryMap.get("billentry.receivebaseqtydown");
        return !("C".equals(allowedBillStatus) ? invbaseqty.subtract(returnbaseqty).compareTo(receivebaseqtydown) < 0 : invbaseqty.subtract(returnbaseqty).add(baseQty).compareTo(receivebaseqtydown) < 0);
    }

    private Map<String, Map<String, Object>> getOmOrderData(long pkValue) {
        QFilter qFilter = new QFilter("id", "=", (Object)pkValue);
        DataSet omOrderDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_om_purorderbill", (String)"closestatus,billentry.id,billentry.invbaseqty,billentry.returnbaseqty,billentry.receivebaseqtydown,billentry.rowclosestatus", (QFilter[])qFilter.toArray(), null);
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(256);
        while (omOrderDataSet.hasNext()) {
            Row row = omOrderDataSet.next();
            HashMap<String, Object> map1 = new HashMap<String, Object>(32);
            String closeStatus = row.getString("closestatus");
            String rowclosestatus = row.getString("billentry.rowclosestatus");
            BigDecimal invbaseqty = row.getBigDecimal("billentry.invbaseqty");
            BigDecimal returnbaseqty = row.getBigDecimal("billentry.returnbaseqty");
            BigDecimal receivebaseqtydown = row.getBigDecimal("billentry.receivebaseqtydown");
            map1.put("closeStatus", closeStatus);
            map1.put("billentry.invbaseqty", invbaseqty);
            map1.put("billentry.returnbaseqty", returnbaseqty);
            map1.put("billentry.receivebaseqtydown", receivebaseqtydown);
            map1.put("billentry.rowclosestatus", rowclosestatus);
            map.put(row.getString("billentry.id"), map1);
        }
        omOrderDataSet.close();
        return map;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("writeoff".equals(callBackId) || "audit".equals(callBackId)) {
            String compeletPk;
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            boolean isComplete = false;
            if (MessageBoxResult.Yes.equals((Object)result)) {
                isComplete = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)(compeletPk = this.getPageCache().get("compeletPk")))) {
                String[] completePkArray = compeletPk.split(",");
                for (int i = 0; i < completePkArray.length; ++i) {
                    QFilter qfilter = new QFilter("billentry.id", "=", (Object)Long.valueOf(completePkArray[i]));
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"im_mdc_ominbill", (String)"billentry,billentry.completewriteoff", (QFilter[])new QFilter[]{qfilter});
                    DynamicObjectCollection entry = obj.getDynamicObjectCollection("billentry");
                    for (DynamicObject dyn : entry) {
                        if (!dyn.getPkValue().equals(Long.valueOf(completePkArray[i]))) continue;
                        dyn.set("completewriteoff", (Object)isComplete);
                    }
                    SaveServiceHelper.update((DynamicObject)obj);
                }
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation(callBackId, operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if ("audit".equals(e.getOperateKey()) && e.getOperationResult() != null && e.getOperationResult().getValidateResult() != null && e.getOperationResult().getValidateResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void doReceive() {
        boolean isReceiveEnable = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        if (!isReceiveEnable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u4f9b\u5e94\u5546\u534f\u540c\uff0c\u65e0\u6cd5\u534f\u540c\u5165\u5e93\u3002", (String)"OmInBillListPlugin_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pur_batreceive");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }
}

