/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.xmftreqbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;
import kd.scmc.im.formplugin.mdc.xmftreqbill.XMftReqUtils;

public class XMftReqAuditNewEntryOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(XMftReqAuditNewEntryOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.addAll(XMftReqUtils.getChangeEntryFields());
        keys.add("billno");
        keys.add("org");
        keys.add("reqbillno");
        keys.add("reqbillid");
        keys.add("entrychangetype");
        keys.add("srcbillentryid");
        keys.add("creator");
        keys.add("createtime");
        keys.add("srcbaseqty");
        keys.add("baseqty");
        keys.add("materialtype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        HashMap<Long, Set<Long>> idEntryIdMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject obj : objs) {
            Long pkValue = (Long)obj.getPkValue();
            if (!"B".equals(obj.getString("materialtype"))) continue;
            HashSet<Long> entryIdSet = new HashSet<Long>(16);
            DynamicObjectCollection billentrys = obj.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                String entrychangetype = billentry.getString("entrychangetype");
                BigDecimal baseqty = billentry.getBigDecimal("baseqty");
                BigDecimal srcbaseqty = billentry.getBigDecimal("srcbaseqty");
                if (!"A".equals(entrychangetype) && (!"B".equals(entrychangetype) || baseqty.compareTo(srcbaseqty) <= 0)) continue;
                entryIdSet.add((Long)billentry.getPkValue());
            }
            if (entryIdSet.isEmpty()) continue;
            idEntryIdMap.put(pkValue, entryIdSet);
        }
        if (!idEntryIdMap.isEmpty()) {
            this.pushMftSeqBill(idEntryIdMap);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pushMftSeqBill(Map<Long, Set<Long>> idEntryIdMap) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber("im_mdc_mftreqbill");
        pushArgs.setHasRight(true);
        pushArgs.setRuleId("1473770776111888384");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSourceEntityNumber("im_mdc_xmftreqbill");
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (Map.Entry<Long, Set<Long>> m : idEntryIdMap.entrySet()) {
            Set<Long> value = m.getValue();
            for (Long l : value) {
                ListSelectedRow srcBill = new ListSelectedRow((Object)m.getKey());
                srcBill.setEntryEntityKey("billentry");
                srcBill.setEntryPrimaryKeyValue((Object)l);
                needPushRows.add(srcBill);
            }
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"im_mdc_mftreqbill");
        if (!pushResult.isSuccess()) {
            logger.info(XMftReqAuditNewEntryOp.getErrByRes(pushResult));
            throw new KDBizException(new ErrorCode("XMftReqAuditNewEntryOpPush", String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u751f\u4ea7\u9886\u6599\u7533\u8bf7\u5355\u5931\u8d25\uff1a%s", (String)"XMftReqAuditNewEntryOp_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), XMftReqAuditNewEntryOp.getErrByRes(pushResult))), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject obj : targetBillObjs) {
            idSet.add((Long)obj.getPkValue());
        }
        OperateOption operateOption = StockBackFlushUtils.getOperateOption();
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"im_mdc_mftreqbill", (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        if (!saveResult.isSuccess()) throw new KDBizException(new ErrorCode("XMftReqAuditNewEntryOpSave", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u751f\u4ea7\u9886\u6599\u7533\u8bf7\u5355\u5931\u8d25\uff1a%s", (String)"XMftReqAuditNewEntryOp_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), XMftReqAuditNewEntryOp.getErrDetail(saveResult))), new Object[0]);
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"im_mdc_mftreqbill", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)operateOption);
        if (submitResult.isSuccess()) {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"im_mdc_mftreqbill", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)operateOption);
            if (auditResult.isSuccess()) return;
            throw new KDBizException(new ErrorCode("XMftReqAuditNewEntryOpAudit", String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u751f\u4ea7\u9886\u6599\u7533\u8bf7\u5355\u5931\u8d25\uff1a%s", (String)"XMftReqAuditNewEntryOp_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), XMftReqAuditNewEntryOp.getErrDetail(auditResult))), new Object[0]);
        }
        OperationServiceHelper.executeOperate((String)"delete", (String)"im_mdc_mftreqbill", (Object[])idSet.toArray(), (OperateOption)operateOption);
        throw new KDBizException(new ErrorCode("XMftReqAuditNewEntryOpSubmit", String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u751f\u4ea7\u9886\u6599\u7533\u8bf7\u5355\u5931\u8d25\uff1a%s", (String)"XMftReqAuditNewEntryOp_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), XMftReqAuditNewEntryOp.getErrDetail(submitResult))), new Object[0]);
    }

    public static String getErrByRes(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isFullSuccess()) continue;
            errMessage.append(billReport.getFailMessage());
        }
        return errMessage.toString();
    }

    private static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage().replaceAll("</br>", ""));
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage().replaceAll("</br>", ""));
        }
        return errDetail.toString();
    }
}

