/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.mdc;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.mservice.api.mdc.MdcOmCmplinToPurReceiveAndQueryUnVerifyQtyService;

public class MdcOmCmplinToPurReceiveAndQueryUnVerifyQtyServiceImpl
implements MdcOmCmplinToPurReceiveAndQueryUnVerifyQtyService {
    private static Log log = LogFactory.getLog(MdcOmCmplinToPurReceiveAndQueryUnVerifyQtyServiceImpl.class);

    @Override
    public Map<String, Map<String, String>> getUnVerifyQty(Map<String, String> paramMap) throws KDBizException {
        if (paramMap == null || paramMap.isEmpty()) {
            return new HashMap<String, Map<String, String>>(1);
        }
        String entity = paramMap.get("entity");
        String entryIdListStr = paramMap.get("entryIdList");
        if (kd.bos.util.StringUtils.isEmpty((String)entity) || kd.bos.util.StringUtils.isEmpty((String)entryIdListStr)) {
            return new HashMap<String, Map<String, String>>(1);
        }
        List entryIdList = (List)SerializationUtils.fromJsonString((String)entryIdListStr, List.class);
        if (entryIdList.isEmpty()) {
            return new HashMap<String, Map<String, String>>(1);
        }
        HashMap<String, Map<String, String>> verifyQtyResultMap = new HashMap<String, Map<String, String>>(entryIdList.size());
        if ("im_mdc_omcmplinbill".equals(entity)) {
            QFilter verifyBillIdQ;
            QFilter verifyFormQ;
            boolean hadVerify;
            QFilter qFilter = new QFilter("billentry.id", "in", (Object)entryIdList);
            HashSet<Long> billIdSet = new HashSet<Long>();
            String selectFields = "id, modeltype,billentry.id entryId, billentry.remainjoinpriceqty remainjoinpriceqty, billentry.remainjoinpricebaseqty remainjoinpricebaseqty,billentry.unverifyqty unverifyqty, billentry.unverifybaseqty unverifybaseqty";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getUnVerifyQty", (String)entity, (String)selectFields, (QFilter[])qFilter.toArray(), null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String modeltype = row.getString("modeltype");
                    Long entryId = row.getLong("entryId");
                    BigDecimal remainjoinpriceqty = row.getBigDecimal("remainjoinpriceqty");
                    BigDecimal remainjoinpricebaseqty = row.getBigDecimal("remainjoinpricebaseqty");
                    BigDecimal unverifyqty = row.getBigDecimal("unverifyqty");
                    BigDecimal unverifybaseqty = row.getBigDecimal("unverifybaseqty");
                    HashMap<String, String> verifyQty = new HashMap<String, String>(2);
                    if ("B".equals(modeltype)) {
                        verifyQty.put("unverifyqty", remainjoinpriceqty.toPlainString());
                        verifyQty.put("unverifybaseqty", remainjoinpricebaseqty.toPlainString());
                    } else {
                        if (remainjoinpriceqty.compareTo(unverifyqty) > 0) {
                            verifyQty.put("unverifyqty", unverifyqty.toPlainString());
                        } else {
                            verifyQty.put("unverifyqty", remainjoinpriceqty.toPlainString());
                        }
                        if (remainjoinpricebaseqty.compareTo(unverifybaseqty) > 0) {
                            verifyQty.put("unverifybaseqty", unverifybaseqty.toPlainString());
                        } else {
                            verifyQty.put("unverifybaseqty", remainjoinpricebaseqty.toPlainString());
                        }
                    }
                    verifyQtyResultMap.put(String.valueOf(entryId), verifyQty);
                    billIdSet.add(row.getLong("id"));
                }
            }
            if (!billIdSet.isEmpty() && (hadVerify = QueryServiceHelper.exists((String)"msmod_wf_sp", (QFilter[])(verifyFormQ = new QFilter("verifyform", "=", (Object)entity)).and(verifyBillIdQ = new QFilter("verifybillid", "in", billIdSet)).toArray()))) {
                String msg = ResManager.loadKDString((String)"\u5355\u636e\u6b63\u5728\u6838\u9500", (String)"MdcOmCmplinQueryUnVertiyQtyServiceImpl_0", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
        }
        return verifyQtyResultMap;
    }

    @Override
    public Map<String, Object> omPurOrderBillPush(Map<String, Object> paramMap) {
        String sourceEntity = paramMap.get("sourceEntity").toString();
        String targetEntity = paramMap.get("targetEntity").toString();
        Object botpNumberObj = paramMap.get("botpNumber");
        String ruleId = null;
        if (botpNumberObj != null) {
            ruleId = botpNumberObj.toString();
        }
        Map pushOrderData = (Map)paramMap.get("pushOrderData");
        LinkedHashMap rowSalOutInfoMap = (LinkedHashMap)paramMap.get("rowSalOutInfoMap");
        ConvertRuleElement convertRuleElementParam = this.getBotpRule(sourceEntity, targetEntity, ruleId);
        if (convertRuleElementParam == null) {
            String errorMessage = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"MdcOmCmplinQueryUnVertiyQtyServiceImpl_1", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            throw new KDException(new ErrorCode("SRMERRORCODE005", errorMessage), new Object[]{errorMessage});
        }
        PushArgs pushArgs = new PushArgs();
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        pushArgs.setSourceEntityNumber(convertRuleElementParam.getSourceEntityNumber());
        pushArgs.setTargetEntityNumber(convertRuleElementParam.getTargetEntityNumber());
        pushArgs.setBuildConvReport(true);
        pushArgs.setRuleId(convertRuleElementParam.getId());
        for (Map.Entry entry : pushOrderData.entrySet()) {
            Long entryKey = (Long)entry.getKey();
            for (Long next : (Collection)entry.getValue()) {
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue((Object)entryKey);
                listSelectedRow.setEntryEntityKey("billentry");
                listSelectedRow.setEntryPrimaryKeyValue((Object)next);
                selectedRowList.add(listSelectedRow);
            }
        }
        pushArgs.setSelectedRows(selectedRowList);
        return this.doPushStockBill(pushArgs, rowSalOutInfoMap);
    }

    private ConvertRuleElement getBotpRule(String sourceEntity, String targetEntity, String ruleId) {
        ConvertRuleElement convertRuleElementParam = null;
        if (!StringUtils.isEmpty((Object)ruleId)) {
            convertRuleElementParam = ConvertMetaServiceHelper.loadRule((String)ruleId);
        } else {
            List ruleList = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
            if (ruleList != null && !ruleList.isEmpty()) {
                for (ConvertRuleElement convertRuleElement : ruleList) {
                    if (convertRuleElement.isEnabled() && convertRuleElement.isDefRule()) {
                        convertRuleElementParam = convertRuleElement;
                        break;
                    }
                    if (!convertRuleElement.isEnabled()) continue;
                    convertRuleElementParam = convertRuleElement;
                }
            }
        }
        return convertRuleElementParam;
    }

    private Map<String, Object> doPushStockBill(PushArgs pushArgs, Map<String, List<Map<String, String>>> rowSalOutInfoMap) {
        HashMap<String, Object> returnMap;
        block8: {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss");
            returnMap = new HashMap<String, Object>(2);
            returnMap.put("succed", Boolean.FALSE);
            returnMap.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u6d88\u606f", (String)"MdcOmCmplinQueryUnVertiyQtyServiceImpl_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            pushArgs.setBuildConvReport(true);
            pushArgs.addCustomParam("botp_outformula", String.valueOf(Boolean.TRUE));
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
                IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                        BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                    }
                };
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                for (DynamicObject bill : targetData) {
                    DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("materialentry");
                    DynamicObjectCollection splitBillEntrys = new DynamicObjectCollection();
                    long seq = 1L;
                    for (DynamicObject billentry : billentrys) {
                        String mainBillEntryId = billentry.getString("srcentryid");
                        if (!rowSalOutInfoMap.containsKey(mainBillEntryId)) continue;
                        List<Map<String, String>> entryParamList = rowSalOutInfoMap.get(mainBillEntryId);
                        for (Map<String, String> entryParamsMap : entryParamList) {
                            DynamicObject splitEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)billentry, (boolean)false, (boolean)true);
                            splitEntry.setParent(billentry.getParent());
                            this.setEntryProp(entryParamsMap, splitEntry, sf);
                            splitEntry.set("seq", (Object)seq);
                            splitBillEntrys.add((Object)splitEntry);
                            ++seq;
                        }
                    }
                    if (splitBillEntrys.isEmpty()) continue;
                    bill.set("materialentry", (Object)splitBillEntrys);
                }
                result.release(refDataProvider, mainType);
                ArrayList pkIds = new ArrayList(targetData.size());
                try {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                    OperationResult operationResult = SaveServiceHelper.saveOperate((String)pushArgs.getTargetEntityNumber(), (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)operateOption);
                    if (operationResult == null) break block8;
                    if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                        pkIds.addAll(operationResult.getSuccessPkIds());
                        returnMap.put("data", pkIds);
                        returnMap.put("message", "ok");
                        returnMap.put("succed", Boolean.TRUE);
                        break block8;
                    }
                    returnMap.put("succed", Boolean.FALSE);
                    StringBuilder messageError = new StringBuilder();
                    messageError.append(operationResult.getMessage()).append(System.lineSeparator());
                    operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append(System.lineSeparator()));
                    returnMap.put("message", messageError.toString());
                }
                catch (Throwable throwable) {
                    log.error(throwable);
                    returnMap.put("succed", Boolean.FALSE);
                    returnMap.put("message", throwable.getMessage());
                }
            } else {
                returnMap.put("succed", Boolean.FALSE);
                String loadKDString = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5e8f\u63a5\u6536\u4e0b\u63a8\u5355\u636e\u5f02\u5e38\uff1a", (String)"MdcOmCmplinQueryUnVertiyQtyServiceImpl_3", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                StringBuilder message = new StringBuilder();
                message.append(loadKDString).append(System.lineSeparator());
                message.append(result.getMessage());
                result.getBillReports().forEach(row -> message.append(row.getFailMessage()));
                returnMap.put("message", message.toString());
                log.info("@@@\u59d4\u5916\u5de5\u5e8f\u63a5\u6536\u4e0b\u63a8\u4e0b\u6e38\u5355\u636e\u5f02\u5e38\uff1a" + result.getMessage());
            }
        }
        return returnMap;
    }

    private void setEntryProp(Map<String, String> paramMap, DynamicObject entry, SimpleDateFormat sf) {
        String mainBillEntryId = entry.getString("srcentryid");
        String qtystr = paramMap.get("qty_" + mainBillEntryId);
        String suplot = paramMap.get("suplot_" + mainBillEntryId);
        String proddate = paramMap.get("proddate_" + mainBillEntryId);
        String duedate = paramMap.get("duedate_" + mainBillEntryId);
        if (!StringUtils.isEmpty((Object)qtystr)) {
            BigDecimal qty = new BigDecimal(qtystr);
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject baseUnit = entry.getDynamicObject("basicunit");
            DynamicObject auxptyUnit = entry.getDynamicObject("asstunit");
            DynamicObject unit = entry.getDynamicObject("unit");
            BigDecimal baseqty = this.getDesQtyConv(material, unit, qty, baseUnit);
            BigDecimal auxQty = this.getDesQtyConv(material, baseUnit, baseqty, auxptyUnit);
            entry.set("qty", (Object)qty);
            entry.set("basicqty", (Object)baseqty);
            entry.set("asstqty", (Object)auxQty);
        }
        if (!StringUtils.isEmpty((Object)suplot)) {
            entry.set("suplot", (Object)suplot);
        }
        try {
            if (!StringUtils.isEmpty((Object)proddate)) {
                entry.set("proddate", (Object)sf.parse(proddate));
            }
            if (!StringUtils.isEmpty((Object)duedate)) {
                entry.set("duedate", (Object)sf.parse(duedate));
            }
        }
        catch (Exception ex) {
            log.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal qty = BigDecimal.ZERO;
        if (material == null || srcUnit == null || desUnit == null || srcQty == null) {
            qty = BigDecimal.ZERO;
        } else if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            qty = srcQty;
        } else {
            BigDecimal unitRate;
            Long materialId = material.getLong("masterid.id");
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0 && (unitRate = new BigDecimal(muConv.getInt("denominator")).divide(new BigDecimal(muConv.getInt("numerator")), 10, 4)) != null && unitRate.compareTo(BigDecimal.ZERO) != 0) {
                int unitPrecision = desUnit.getInt("precision");
                if (!StringUtils.isEmpty((Object)desUnit.getString("precisionaccount"))) {
                    int account = desUnit.getInt("precisionaccount");
                    int unitPrecisionType = 4;
                    if (account == 2) {
                        unitPrecisionType = 1;
                    } else if (account == 3) {
                        unitPrecisionType = 0;
                    }
                    qty = srcQty.divide(unitRate, unitPrecision, unitPrecisionType);
                }
            }
        }
        return qty;
    }
}

