/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.mdc.event;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.formplugin.mdc.mftouttpl.MftOrderCalMaterialUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CalMaterialServiceOp {
    private static final Log logger = LogFactory.getLog(CalMaterialServiceOp.class);
    private Set<String> manuEntryidSet = new HashSet<String>(20);
    private Set<String> manuidSet = new HashSet<String>(20);
    private String modetype = "";
    private Boolean autoflag = Boolean.TRUE;

    public CalMaterialServiceOp(Set<String> manuid, Set<String> manuEntryid, String typeNumber, String isautoflag) {
        this.manuEntryidSet = manuEntryid;
        this.manuidSet = manuid;
        this.modetype = typeNumber;
        this.autoflag = Boolean.TRUE;
        if ("0".equals(isautoflag)) {
            this.autoflag = Boolean.FALSE;
        }
    }

    public void invoke() {
        HashSet<String> basunitList = new HashSet(20);
        Map<String, String> entityMap = this.getMftModeEntity();
        HashMap srcMap = Maps.newHashMap();
        HashSet<Long> transactiontypeList = new HashSet<Long>(20);
        Map<Object, Object> measureunitData = Maps.newHashMap();
        HashMap<String, DynamicObject> transactiontypeMap = Maps.newHashMap();
        if (!this.manuidSet.isEmpty() && this.manuidSet.size() > 0) {
            DynamicObject[] loadList;
            basunitList = this.getMaterialUnitData(this.manuidSet, entityMap.get("tableName"));
            measureunitData = CalMaterialServiceOp.getMeasureunitData(basunitList);
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", this.manuidSet.stream().map(NumberUtils::toLong).collect(Collectors.toList()))};
            for (DynamicObject morder : loadList = BusinessDataServiceHelper.load((String)entityMap.get("orderEntity"), (String)this.selectMftOrderColumn(), (QFilter[])filters)) {
                srcMap.put(morder.getString("billno"), morder);
                DynamicObject transactiontype = morder.getDynamicObject("transactiontype");
                if (transactiontype == null) continue;
                Long transactiontypeId = (Long)transactiontype.getPkValue();
                transactiontypeList.add(transactiontypeId);
            }
            if (!transactiontypeList.isEmpty() && transactiontypeList.size() > 0) {
                QFilter[] filters1 = new QFilter[]{new QFilter("id", "in", transactiontypeList)};
                DynamicObject[] transList = BusinessDataServiceHelper.load((String)"mpdm_transactproduct", (String)"id,isvolcal,controlscope,isautoclose", (QFilter[])filters1);
                transactiontypeMap = new HashMap<String, DynamicObject>(16);
                for (DynamicObject trans : transList) {
                    transactiontypeMap.put(trans.getPkValue().toString(), trans);
                }
            }
        }
        String targetName = "im_mdc_mftproorder";
        MftOrderCalMaterialUtils.calMaterial(measureunitData, (Map<String, DynamicObject>)transactiontypeMap, this.manuidSet, this.manuEntryidSet, srcMap, this.autoflag, targetName, entityMap);
    }

    private Map<String, String> getMftModeEntity() {
        HashMap<String, String> entityMap = new HashMap<String, String>(20);
        switch (this.modetype) {
            case "1": {
                entityMap.put("transactEntity", "mpdm_transactproduct");
                entityMap.put("tableName", "t_pom_mftorderentry");
                entityMap.put("reqoutEntity", "im_mdc_mftproorder");
                entityMap.put("orderEntity", "pom_mftorder");
                entityMap.put("stockEntity", "pom_mftstock");
                break;
            }
            case "2": {
                entityMap.put("transactEntity", "mpdm_transactproduct");
                entityMap.put("tableName", "t_om_mftorderentry");
                entityMap.put("reqoutEntity", "im_mdc_omoutbill");
                entityMap.put("orderEntity", "om_mftorder");
                entityMap.put("stockEntity", "om_mftstock");
                break;
            }
            case "7": {
                entityMap.put("transactEntity", "mpdm_transactproduct");
                entityMap.put("tableName", "t_pom_mroorderentry");
                entityMap.put("reqoutEntity", "im_mdc_mftproorder");
                entityMap.put("orderEntity", "pom_mroorder");
                entityMap.put("stockEntity", "pom_mrostock");
                break;
            }
            case "9": {
                entityMap.put("transactEntity", "mpdm_transactproduct");
                entityMap.put("tableName", "t_prop_mftorderentry");
                entityMap.put("reqoutEntity", "im_mdc_mftproorder");
                entityMap.put("orderEntity", "prop_mftorder");
                entityMap.put("stockEntity", "prop_mftstock");
                break;
            }
            default: {
                entityMap.put("transactEntity", "mpdm_transactproduct");
                entityMap.put("tableName", "t_pom_mftorderentry");
                entityMap.put("reqoutEntity", "im_mdc_mftproorder");
                entityMap.put("orderEntity", "pom_mftorder");
                entityMap.put("stockEntity", "pom_mftstock");
            }
        }
        return entityMap;
    }

    private Set<String> getMaterialUnitData(Set<String> orderList, String tableName) {
        HashSet<String> unitList = new HashSet<String>();
        StringBuilder msb = new StringBuilder();
        int index = 0;
        for (String materialId : orderList) {
            if (++index == orderList.size()) {
                msb.append(materialId);
                continue;
            }
            msb.append(materialId);
            msb.append(",");
        }
        String queryMainSql = "select fid,funit,fbaseunit from " + tableName + " where fid in (" + msb + ") ";
        try (DataSet queryMainData = DB.queryDataSet((String)"queryunitData", (DBRoute)new DBRoute("scm"), (String)queryMainSql);){
            for (Row row : queryMainData) {
                String fid = row.getString("fid");
                String baseunit = row.getString("fbaseunit");
                String unit = row.getString("funit");
                unitList.add(unit);
            }
        }
        return unitList;
    }

    public static Map<String, String> getMeasureunitData(Set<String> unitList) {
        HashMap<String, String> map = new HashMap<String, String>();
        int index = 0;
        StringBuilder msb = new StringBuilder();
        for (String unitId : unitList) {
            if (++index == unitList.size()) {
                msb.append(unitId);
                continue;
            }
            msb.append(unitId);
            msb.append(",");
        }
        String queryMainSql = "select fid,fprecision,fprecisiontype from T_bd_Measureunit where  fid in (" + msb + ") ";
        try (DataSet queryMainData = DB.queryDataSet((String)"queryMeasureunitData", (DBRoute)DBRoute.base, (String)queryMainSql);){
            for (Row row : queryMainData) {
                String fid = row.getString("fid");
                String precision = row.getString("fprecision");
                String precisiontype = row.getString("fprecisiontype");
                map.put(fid, precision + "@@" + precisiontype);
            }
        }
        return map;
    }

    private String selectMftOrderColumn() {
        return "billno,transactiontype,treeentryentity.producttype,treeentryentity.qty,treeentryentity.pid,treeentryentity.baseqty,treeentryentity.unit,treeentryentity.baseunit,treeentryentity.pickstatus,treeentryentity.pickingpairs";
    }
}

