/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.common.mdc.utils.AutoBackFlushUtils;
import kd.scmc.im.common.mdc.utils.OMStockBackFlushUtils;
import kd.scmc.im.common.mdc.utils.OmAutoBackFlushUtils;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;
import kd.scmc.im.opplugin.mdc.AutoBackFlushOpValidator;
import org.apache.commons.lang.StringUtils;

public class AutoBackFlushOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(AutoBackFlushOp.class);
    private static final Set<String> billTypes = Sets.newHashSet((Object[])new String[]{"im_mdc_mftmanuinbill", "im_mdc_mftreturnbill", "im_mdc_omcmplinbil"});

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("producttype");
        e.getFieldKeys().add("qualitystatus");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("receivalqty");
        e.getFieldKeys().add("receivedqty");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("srcbillnumber");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("mainbillnumber");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryseq");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("productionorg");
        e.getFieldKeys().add("backflushstatus");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("biztime");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("billentry.manubillid");
        e.getFieldKeys().add("billentry.manuentryid");
        e.getFieldKeys().add("billentry.returnbackflush");
        e.getFieldKeys().add("productiondomain");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AutoBackFlushOpValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String value;
        Long key;
        List validExtDataEntities = e.getValidExtDataEntities();
        ArrayList passedDataEntitys = new ArrayList(16);
        ArrayList<ExtendedDataEntity> successDataEntitys = new ArrayList<ExtendedDataEntity>(16);
        ArrayList<DynamicObject> bfObj = new ArrayList<DynamicObject>();
        HashMap<Object, ExtendedDataEntity> dataEntityMap = new HashMap<Object, ExtendedDataEntity>(16);
        if ("backflush".equals(e.getOperationKey())) {
            for (ExtendedDataEntity dataEntity : validExtDataEntities) {
                DynamicObject obj = dataEntity.getDataEntity();
                if (obj.getBoolean("ischargeoff")) continue;
                bfObj.add(obj);
                dataEntityMap.put(obj.getPkValue(), dataEntity);
            }
        } else {
            logger.info("start backflush.");
            DynamicObject[] dataArray = e.getDataEntities();
            Map<Long, DynamicObject> transMap = StockBackFlushUtils.getTransMap(dataArray, "backflusherr");
            for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
                boolean returnbackflush;
                DynamicObject obj = extendedDataEntity.getDataEntity();
                if (obj.getBoolean("ischargeoff")) continue;
                DynamicObject tran = null;
                if ("im_mdc_omcmplinbill".equals(obj.getDataEntityType().getName())) {
                    if ("B".equals(obj.getString("modeltype"))) continue;
                    tran = transMap.get(((DynamicObject)obj.getDynamicObjectCollection("billentry").get(0)).getLong("manubillid"));
                    if ("1".equals(StockBackFlushUtils.getBizDirection(obj.getDynamicObject("invscheme")))) {
                        returnbackflush = tran.getBoolean("returnbackflush");
                        if (!returnbackflush) continue;
                        this.getOption().setVariableValue("botpID", "1513122267733721088");
                        this.getOption().setVariableValue("targetname", "im_mdc_omreturnbill");
                    }
                } else if ("im_mdc_ominbill".equals(obj.getDataEntityType().getName())) {
                    tran = transMap.get(((DynamicObject)obj.getDynamicObjectCollection("billentry").get(0)).getLong("mainbillid"));
                    if ("1".equals(StockBackFlushUtils.getBizDirection(obj.getDynamicObject("invscheme")))) {
                        continue;
                    }
                } else if ("im_mdc_mftreturnbill".equals(obj.getDataEntityType().getName())) {
                    logger.info("\u5b8c\u5de5\u9000\u5e93\u5f00\u59cb\u5012\u51b2\u3002");
                    tran = transMap.get(((DynamicObject)obj.getDynamicObjectCollection("billentry").get(0)).getLong("mainbillid"));
                    if (tran == null || !(returnbackflush = tran.getBoolean("returnbackflush"))) {
                        continue;
                    }
                } else {
                    tran = transMap.get(((DynamicObject)obj.getDynamicObjectCollection("billentry").get(0)).getLong("mainbillid"));
                }
                if (tran != null && !tran.getBoolean("backflusherr")) continue;
                bfObj.add(obj);
                dataEntityMap.put(obj.getPkValue(), extendedDataEntity);
            }
            if (bfObj.isEmpty()) {
                return;
            }
        }
        List<Map<String, Object>> bfParam = this.getBFParam(bfObj);
        Map<Long, String> bfRes = this.backFlush(bfParam);
        if ("backflush".equals(e.getOperationKey())) {
            for (Map.Entry entry : bfRes.entrySet()) {
                key = (Long)entry.getKey();
                value = (String)entry.getValue();
                if ("".equals(value)) continue;
                passedDataEntitys.add(dataEntityMap.get(key));
                OperateErrorInfo errorInfo = new OperateErrorInfo("AutoBackFlushOp", ErrorLevel.Error, (Object)key);
                errorInfo.setMessage(StringUtils.strip((String)value, (String)"[]"));
                errorInfo.setTitle(ResManager.loadKDString((String)"\u5012\u51b2", (String)"AutoBackFlushOp_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                this.getOperationResult().getAllErrorInfo().add(errorInfo);
            }
        } else {
            for (Map.Entry entry : bfRes.entrySet()) {
                key = (Long)entry.getKey();
                value = (String)entry.getValue();
                if (value.indexOf(ResManager.loadKDString((String)"\u5012\u51b2\u5931\u8d25", (String)"AutoBackFlushOp_2", (String)"scmc-mm-mdc", (Object[])new Object[0])) == -1) continue;
                passedDataEntitys.add(dataEntityMap.get(key));
                OperateErrorInfo errorInfo = new OperateErrorInfo("AutoBackFlushOp", ErrorLevel.Error, (Object)key);
                errorInfo.setMessage(StringUtils.strip((String)value, (String)"[]"));
                errorInfo.setTitle(ResManager.loadKDString((String)"\u5012\u51b2", (String)"AutoBackFlushOp_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                this.getOperationResult().getAllErrorInfo().add(errorInfo);
            }
        }
        validExtDataEntities.removeAll(passedDataEntitys);
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            successDataEntitys.add(extendedDataEntity);
        }
        if (validExtDataEntities.isEmpty()) {
            e.cancel = true;
        } else {
            e.getValidExtDataEntities().clear();
            e.getValidExtDataEntities().addAll(successDataEntitys);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if ("backflush".equals(e.getOperationKey())) {
            return;
        }
        DynamicObject[] dataArray = e.getDataEntities();
        ArrayList<DynamicObject> bfObj = new ArrayList<DynamicObject>();
        Map<Long, DynamicObject> transMap = StockBackFlushUtils.getTransMap(dataArray, "backflusherr");
        for (DynamicObject obj : e.getDataEntities()) {
            boolean returnbackflush;
            if (obj.getBoolean("ischargeoff")) continue;
            DynamicObject tran = null;
            if ("im_mdc_omcmplinbill".equals(obj.getDataEntityType().getName())) {
                if ("B".equals(obj.getString("modeltype"))) continue;
                tran = transMap.get(((DynamicObject)obj.getDynamicObjectCollection("billentry").get(0)).getLong("manubillid"));
                if ("1".equals(StockBackFlushUtils.getBizDirection(obj.getDynamicObject("invscheme")))) {
                    returnbackflush = tran.getBoolean("returnbackflush");
                    if (!returnbackflush) continue;
                    this.getOption().setVariableValue("botpID", "1513122267733721088");
                    this.getOption().setVariableValue("targetname", "im_mdc_omreturnbill");
                }
            } else if ("im_mdc_ominbill".equals(obj.getDataEntityType().getName())) {
                tran = transMap.get(((DynamicObject)obj.getDynamicObjectCollection("billentry").get(0)).getLong("mainbillid"));
                if ("1".equals(StockBackFlushUtils.getBizDirection(obj.getDynamicObject("invscheme")))) {
                    continue;
                }
            } else if ("im_mdc_mftreturnbill".equals(obj.getDataEntityType().getName())) {
                logger.info("\u5b8c\u5de5\u9000\u5e93\u5f00\u59cb\u5012\u51b21\u3002");
                tran = transMap.get(((DynamicObject)obj.getDynamicObjectCollection("billentry").get(0)).getLong("mainbillid"));
                returnbackflush = tran.getBoolean("returnbackflush");
                if (!returnbackflush) {
                    continue;
                }
            } else {
                tran = transMap.get(((DynamicObject)obj.getDynamicObjectCollection("billentry").get(0)).getLong("mainbillid"));
            }
            if (tran != null && tran.getBoolean("backflusherr")) continue;
            bfObj.add(obj);
        }
        if (bfObj.isEmpty()) {
            return;
        }
        List<Map<String, Object>> bfParam = this.getBFParam(bfObj);
        Map<Long, String> bfRes = this.backFlush(bfParam);
        for (Map.Entry<Long, String> entry : bfRes.entrySet()) {
            Long key = entry.getKey();
            String value = entry.getValue();
            if ("".equals(value)) continue;
            if (bfRes.size() > 1) {
                OperateErrorInfo errorInfo = new OperateErrorInfo("AutoBackFlushOp", ErrorLevel.Error, (Object)key);
                errorInfo.setMessage(StringUtils.strip((String)value, (String)"[]"));
                errorInfo.setTitle(ResManager.loadKDString((String)"\u81ea\u52a8\u5012\u51b2", (String)"AutoBackFlushOp_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                this.operationResult.addErrorInfo(errorInfo);
                this.addSuccessId(key);
                continue;
            }
            if (bfRes.size() != 1) continue;
            this.operateOption.setVariableValue("afterFailbillIds", key.toString());
            this.operateOption.setVariableValue("backflushInfo", StringUtils.strip((String)value, (String)"[]"));
        }
        this.updateBFStatus(e.getDataEntities());
    }

    private void updateBFStatus(DynamicObject[] dataEntities) {
        ArrayList<Object> orderReportBillEntryIds = new ArrayList<Object>(16);
        for (DynamicObject manuInBill : dataEntities) {
            DynamicObjectCollection coll = manuInBill.getDynamicObjectCollection("billentry");
            coll.forEach(a -> orderReportBillEntryIds.add(a.getLong("id")));
        }
        if (!orderReportBillEntryIds.isEmpty()) {
            if ("im_mdc_omcmplinbill".equals(dataEntities[0].getDataEntityType().getName())) {
                OMStockBackFlushUtils.updateBFStatusByEntryId(orderReportBillEntryIds, this.billEntityType.getName());
            } else {
                AutoBackFlushUtils.updateBFStatusByEntryId(orderReportBillEntryIds, this.billEntityType.getName());
            }
        }
    }

    private void addSuccessId(Long key) {
        if (!this.operationResult.getSuccessPkIds().contains(key)) {
            this.operationResult.addSuccessPkId((Object)key);
        }
    }

    private List<Map<String, Object>> getBFParam(List<DynamicObject> bfObj) {
        ArrayList<Map<String, Object>> bfParam = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject obj : bfObj) {
            String name = obj.getDataEntityType().getName();
            if (billTypes.contains(name) && obj.getBoolean("isvirtualbill")) continue;
            String ordername = this.getOption().getVariableValue("ordername");
            String stockname = this.getOption().getVariableValue("stockname");
            String botpid = this.getOption().getVariableValue("botpID");
            if (("im_mdc_mftmanuinbill".equals(name) || "im_mdc_mftreturnbill".equals(name)) && "E".equals(obj.getString("productiondomain"))) {
                ordername = "prop_mftorder";
                stockname = "prop_mftstock";
                botpid = "1999940382770658304";
                if ("im_mdc_mftreturnbill".equals(name)) {
                    botpid = "1999940076393528320";
                }
            }
            HashMap<String, Object> bfParamMap = new HashMap<String, Object>(16);
            bfParamMap.put("billdym", obj);
            bfParamMap.put("id", obj.getPkValue());
            bfParamMap.put("billentity", obj.getDataEntityType().getName());
            bfParamMap.put("billno", obj.get("billno"));
            bfParamMap.put("operationkey", this.getOption().getVariableValue("opKey"));
            bfParamMap.put("biztime", obj.get("biztime"));
            bfParamMap.put("ordername", ordername);
            bfParamMap.put("orderentry", this.getOption().getVariableValue("orderentry"));
            bfParamMap.put("stockname", stockname);
            bfParamMap.put("targetname", this.getOption().getVariableValue("targetname"));
            bfParamMap.put("botpid", botpid);
            bfParamMap.put("billentry", this.getBillEntryBFParam(obj));
            bfParamMap.put("billentity", this.getOption().getVariableValue("srcname"));
            bfParam.add(bfParamMap);
        }
        return bfParam;
    }

    private Map<Object, Map<String, Object>> getBillEntryBFParam(DynamicObject obj) {
        HashMap<Object, Map<String, Object>> billEntryBFParam = new HashMap<Object, Map<String, Object>>(16);
        String name = obj.getDataEntityType().getName();
        DynamicObjectCollection dymCol = obj.getDynamicObjectCollection("billentry");
        for (int i = 0; i < dymCol.size(); ++i) {
            DynamicObject billEntry = (DynamicObject)dymCol.get(i);
            HashMap<String, Object> billEntryBFParamMap = new HashMap<String, Object>(16);
            billEntryBFParamMap.put("entryid", billEntry.getPkValue());
            billEntryBFParamMap.put("seq", i + 1);
            if ("im_mdc_omcmplinbill".equals(name)) {
                billEntryBFParamMap.put("orderid", billEntry.get("manubillid"));
                billEntryBFParamMap.put("orderentryid", billEntry.getLong("manuentryid"));
            } else {
                billEntryBFParamMap.put("orderid", billEntry.get("mainbillid"));
                billEntryBFParamMap.put("orderentryid", billEntry.getLong("mainbillentryid"));
            }
            String targetname = this.getOption().getVariableValue("targetname");
            if ("im_mdc_omreturnbill".equals(targetname) || "im_mdc_mftreturnorder".equals(targetname)) {
                billEntryBFParamMap.put("baseqty", billEntry.getBigDecimal("baseqty").abs());
            } else {
                billEntryBFParamMap.put("baseqty", billEntry.getBigDecimal("baseqty"));
            }
            billEntryBFParam.put(billEntry.getPkValue(), billEntryBFParamMap);
        }
        return billEntryBFParam;
    }

    private Map<Long, String> backFlush(List<Map<String, Object>> bfParam) {
        if ("pom_mftorder".equals(this.getOption().getVariableValue("ordername"))) {
            logger.info("bfParam: " + bfParam.toString());
            return AutoBackFlushUtils.backFlushbatch(bfParam);
        }
        return OmAutoBackFlushUtils.omBackFlushbatch(bfParam);
    }
}

