/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;

public class AutoBackFlushOpValidator
extends AbstractValidator {
    private static final String KEY_BILLENTRY = "billentry";

    public void validate() {
        String operationKey = this.getOption().getVariableValue("opKey");
        if ("backflush".equals(operationKey)) {
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                boolean isOminbill = false;
                if (("im_mdc_omcmplinbill".equals(this.getEntityKey()) || "im_mdc_ominbill".equals(this.getEntityKey())) && "1".equals(StockBackFlushUtils.getBizDirection(obj.getDynamicObject("invscheme")))) {
                    isOminbill = true;
                }
                if (isOminbill) {
                    this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u666e\u901a\u59d4\u5916\u9000\u8d27,\u4e0d\u5141\u8bb8\u5012\u51b2\u3002", (String)"AutoBackFlushOpValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    continue;
                }
                if (!"C".equals(obj.getString("billstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838\u3002", (String)"AutoBackFlushOpValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    continue;
                }
                this.checkBill(this.dataEntities[i]);
            }
        }
    }

    private void checkBill(ExtendedDataEntity extendedDataEntity) {
        DynamicObject obj = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(KEY_BILLENTRY);
        boolean isbackflush = true;
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            if ("C".equals(entryObj.get("backflushstatus"))) continue;
            isbackflush = false;
        }
        if (("im_mdc_omcmplinbill".equals(this.getEntityKey()) || "im_mdc_ominbill".equals(this.getEntityKey())) && isbackflush) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u5168\u90e8\u5012\u51b2\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5012\u51b2\u3002", (String)"AutoBackFlushOpValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
        }
    }
}

