/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.Collection;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class MFTProcessrptBillFixLinkOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MFTProcessrptBillFixLinkOp.class);
    private static final String IM_MDC_MFTMANUINBILL = "im_mdc_mftmanuinbill";
    private static final String SFC_PROCESSREPORTBILL = "sfc_processreportbill";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)this.billEntityType.getName(), (String)"billentry");
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        for (int i = 0; i < dataEntities.length; ++i) {
            dataEntities[i] = BusinessDataServiceHelper.loadSingle((Object)dataEntities[i].getPkValue(), (String)dataEntities[i].getDataEntityType().getName());
            if (dataEntities[i].getBoolean("ischargeoff")) continue;
            DynamicObjectCollection targetRows = dataEntities[i].getDynamicObjectCollection(targetTableDefine.getEntityKey());
            for (DynamicObject targetRow : targetRows) {
                String mainBillEntity = targetRow.getString("mainbillentity");
                String srcBillEntity = targetRow.getString("srcbillentity");
                String entityNumber = "";
                String entityKey = "";
                if (IM_MDC_MFTMANUINBILL.equals(this.billEntityType.getName())) {
                    entityKey = "billentry";
                    entityNumber = srcBillEntity;
                    if (SFC_PROCESSREPORTBILL.equals(srcBillEntity)) {
                        entityKey = "subentryentity1";
                    }
                }
                TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)entityNumber, (String)entityKey);
                Long srcTableId = srcTableDefine.getTableId();
                DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
                if (!CollectionUtils.isEmpty((Collection)linkRows)) continue;
                DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
                linkRow.set(lkEntryKey + "_sbillid", targetRow.get("srcbillid"));
                linkRow.set(lkEntryKey + "_sid", targetRow.get("srcbillentryid"));
                linkRows.add((Object)linkRow);
            }
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)this.billEntityType.getName(), (DynamicObject[])dataEntities, (OperateOption)this.createOperateOption());
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        operateOption.setVariableValue("WF", "false");
        return operateOption;
    }
}

