/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import kd.scmc.im.common.mdc.helper.OmOrderBookDateHelper;
import kd.scmc.im.opplugin.mdc.MFTDiffshareValidator;

public class MFTReqOutBillAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MFTReqOutBillAuditOp.class);
    private static final String KEY_AUDIT = "audit";
    private static final String KEY_UNAUDIT = "unaudit";
    private static final String KEY_BILLENTRY = "billentry";
    public static final String KEY_TRANSACTPRODUCT = "mpdm_transactproduct";
    public static final String KEY_TRANSACTIONTYPE = "transactiontype";
    private static final String KEY_MANUENTRYID = "manuentryid";
    private static final String KEY_MANUBILLID = "manubillid";
    private static final String ORDER = "pom_mftorder";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("needtime");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("srcbillnumber");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("mainbillnumber");
        e.getFieldKeys().add("mainbillentryseq");
        e.getFieldKeys().add(KEY_BILLENTRY);
        e.getFieldKeys().add("manubill");
        e.getFieldKeys().add(KEY_MANUBILLID);
        e.getFieldKeys().add("manuentry");
        e.getFieldKeys().add(KEY_MANUENTRYID);
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("isbackflush");
        e.getFieldKeys().add("isvirtualbill");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("bizorg");
        e.getFieldKeys().add("billcretype");
        e.getFieldKeys().add("reqtype");
        e.getFieldKeys().add("billentry.stockentryid");
        e.getFieldKeys().add("billentry.stockno");
        e.getFieldKeys().add("billentry.stockentry");
        e.getFieldKeys().add("billentry.stockid");
        e.getFieldKeys().add("billentry.material");
        e.getFieldKeys().add("billentry.configuredcode");
        e.getFieldKeys().add("billentry.lotnumber");
        e.getFieldKeys().add("billentry.baseunit");
        e.getFieldKeys().add("billentry.auxpty");
        e.getFieldKeys().add("billentry.outownertype");
        e.getFieldKeys().add("billentry.outowner");
        e.getFieldKeys().add("billentry.warehouse");
        e.getFieldKeys().add("billentry.location");
        e.getFieldKeys().add("billentry.oprno");
        e.getFieldKeys().add("billentry.processseq");
        e.getFieldKeys().add("billentry.isadd");
        e.getFieldKeys().add("billentry.workprocedureid");
        e.getFieldKeys().add("billentry.operationdesc");
        e.getFieldKeys().add("billentry.oprworkcenter");
        e.getFieldKeys().add("billentry.workstation");
        e.getFieldKeys().add("billentry.workstation");
        e.getFieldKeys().add("billentry.billentry_lk");
        e.getFieldKeys().add("billentry.billentry_lk_stableid");
        e.getFieldKeys().add("billentry.billentry_lk_sbillid");
        e.getFieldKeys().add("billentry.billentry_lk_sid");
        e.getFieldKeys().add("billentry.linetype");
        e.getFieldKeys().add("billentry.materialname");
        e.getFieldKeys().add("billentry.isrework");
        e.getFieldKeys().add("billentry.feedreason");
        e.getFieldKeys().add("billentry.lot");
        e.getFieldKeys().add("billentry.isrework");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("productiondomain");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dObjects = e.getDataEntities();
        boolean isPropOrder = false;
        if (KEY_AUDIT.equals(operationKey) || KEY_UNAUDIT.equals(operationKey)) {
            HashSet<String> manuIdSet = new HashSet<String>(16);
            HashSet<String> manuEntryIdSet = new HashSet<String>(16);
            HashSet<Long> billIdSet = new HashSet<Long>(16);
            for (DynamicObject repOut : dObjects) {
                if (repOut.getBoolean("ischargeoff")) {
                    return;
                }
                billIdSet.add(repOut.getLong("id"));
                DynamicObjectCollection entryCol = repOut.getDynamicObjectCollection(KEY_BILLENTRY);
                for (DynamicObject billEntry : entryCol) {
                    Object manuBillId = billEntry.get(KEY_MANUBILLID);
                    Object billEntityId = billEntry.get(KEY_MANUENTRYID);
                    manuIdSet.add(manuBillId.toString());
                    manuEntryIdSet.add(billEntityId.toString());
                }
                if (!"E".equals(repOut.getString("productiondomain"))) continue;
                isPropOrder = true;
            }
            if (!manuEntryIdSet.isEmpty() && !manuIdSet.isEmpty()) {
                Long tableId;
                List sourceNodes;
                Long[] billIds;
                Map upNodeMap;
                BFRowLinkUpNode bfRowLinkUpNode;
                HashMap<String, Object> calparam = new HashMap<String, Object>();
                calparam.put("orderentryids", manuEntryIdSet);
                calparam.put("orderids", manuIdSet);
                calparam.put("operate", operationKey);
                String entityTypeName = this.billEntityType.getName();
                calparam.put("iscloseorder", "1");
                boolean isMroOrder = false;
                if (!billIdSet.isEmpty() && null != (bfRowLinkUpNode = (BFRowLinkUpNode)(upNodeMap = BFTrackerServiceHelper.loadBillLinkUpNodes((String)entityTypeName, (Long[])(billIds = billIdSet.toArray(new Long[billIdSet.size()])), (boolean)false)).get(billIds[0])) && (sourceNodes = bfRowLinkUpNode.findSourceNodes(tableId = EntityMetadataCache.loadMainTableDefine((String)"pom_mroorder").getTableId())) != null && !sourceNodes.isEmpty()) {
                    isMroOrder = true;
                }
                if (isMroOrder) {
                    calparam.put("modetype", "7");
                } else if (isPropOrder) {
                    calparam.put("modetype", "9");
                } else {
                    calparam.put("modetype", "1");
                }
                calparam.put("isautocal", "0");
                calparam.put("isautoflag", "0");
                calparam.put("appId", "im");
                String jsonString = JSON.toJSONString(calparam);
                EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
            }
            if (KEY_AUDIT.equals(operationKey)) {
                String entityTypeName = this.billEntityType.getName();
                if (StringUtils.equals((CharSequence)BillTypeEnum.PRO_ORDER.getName(), (CharSequence)entityTypeName) || StringUtils.equals((CharSequence)BillTypeEnum.FEED_ORDER.getName(), (CharSequence)entityTypeName) || StringUtils.equals((CharSequence)BillTypeEnum.RETURN_ORDER.getName(), (CharSequence)entityTypeName)) {
                    String order = ORDER;
                    if (isPropOrder) {
                        order = "prop_mftorder";
                    }
                    OmOrderBookDateHelper helper = new OmOrderBookDateHelper(dObjects, order, KEY_BILLENTRY, KEY_MANUBILLID, KEY_MANUENTRYID);
                    helper.updateOrderBookDateByBizBill();
                }
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MFTDiffshareValidator());
    }
}

