/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MFTReqOutBillBackflushQtyValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(MFTReqOutBillBackflushQtyValidator.class);
    private static final Set<String> billNames = Sets.newHashSet((Object[])new String[]{"im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_mdc_omoutbill", "im_mdc_omreturnbill"});
    private static final Set<String> mainBillType = Sets.newHashSet((Object[])new String[]{"pom_mftstock", "om_mftstock"});

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MFTReqOutBillBackflushQtyValidator", (String)"validate");){
            if (!"save".equals(this.getOperateKey()) || !billNames.contains(this.entityKey)) {
                return;
            }
            OperateOption option = this.getOption();
            if (!option.containsVariable("billCanbfqtyStr") || option.getVariableValue("billCanbfqtyStr") == null || "".equals(option.getVariableValue("billCanbfqtyStr"))) {
                return;
            }
            String billCanbfqtyStr = option.getVariableValue("billCanbfqtyStr");
            Map optionCanbfqty = (Map)JSON.parseObject((String)billCanbfqtyStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            if (optionCanbfqty.isEmpty()) {
                return;
            }
            HashMap billCanbfqty = new HashMap(16);
            HashMap<String, BigDecimal> billAlreadyqty = new HashMap<String, BigDecimal>(16);
            for (Map.Entry billQty : optionCanbfqty.entrySet()) {
                ExtendedDataEntity[] canbfqty = BigDecimal.ZERO;
                if (!"".equals(billQty.getValue())) {
                    canbfqty = new BigDecimal(String.valueOf(billQty.getValue()));
                }
                billCanbfqty.put(billQty.getKey(), canbfqty);
            }
            logger.info("------MFTReqOutBillBackflushQtyValidator------\u5e94\u5012\u51b2\u6570\u91cfMap\uff1a" + ((Object)billCanbfqty).toString());
            HashSet<Long> srcbillentryidList = new HashSet<Long>(16);
            HashSet<Long> mainbillentryidList = new HashSet<Long>(16);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject obj = dataEntity.getDataEntity();
                for (DynamicObject billentry : obj.getDynamicObjectCollection("billentry")) {
                    if (!"pom_mftstock".equals(billentry.getString("mainbillentity"))) continue;
                    srcbillentryidList.add(billentry.getLong("srcbillentryid"));
                    mainbillentryidList.add(billentry.getLong("mainbillentryid"));
                }
            }
            QFilter qFilter = new QFilter("billentry.srcbillentryid", "in", srcbillentryidList);
            qFilter.and("billentry.mainbillentryid", "in", mainbillentryidList);
            qFilter.and("isvirtualbill", "=", (Object)Boolean.FALSE);
            qFilter.and("ischargeoff", "=", (Object)Boolean.FALSE);
            qFilter.and("ischargeoffed", "=", (Object)Boolean.FALSE);
            String fields = "billentry.srcbillentryid, billentry.mainbillentryid, billentry.qty";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.entityKey, (String)fields, (QFilter[])new QFilter[]{qFilter}, null);){
                for (Row row : dataSet) {
                    String billKey = row.getString("billentry.srcbillentryid") + "@" + row.getString("billentry.mainbillentryid");
                    logger.info("------MFTReqOutBillBackflushQtyValidator------\u5355\u636e\u6620\u5c04billKey\uff1a" + billKey + "\uff1b\u672c\u5355\u5012\u51b2\u6570\u91cfalreadyQty\uff1a" + row.getBigDecimal("billentry.qty").toString());
                    if (billAlreadyqty.get(billKey) != null) {
                        billAlreadyqty.put(billKey, ((BigDecimal)billAlreadyqty.get(billKey)).add(row.getBigDecimal("billentry.qty")));
                        continue;
                    }
                    billAlreadyqty.put(billKey, row.getBigDecimal("billentry.qty"));
                }
            }
            logger.info("------MFTReqOutBillBackflushQtyValidator------\u5df2\u5012\u51b2\u6570\u91cfMap\uff1a" + ((Object)billAlreadyqty).toString());
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject obj = dataEntity.getDataEntity();
                for (DynamicObject billentry : obj.getDynamicObjectCollection("billentry")) {
                    BigDecimal canbfqty;
                    if (!mainBillType.contains(billentry.getString("mainbillentity"))) continue;
                    String billKey = billentry.getString("srcbillentryid") + "@" + billentry.getString("mainbillentryid");
                    BigDecimal alreadyqty = billAlreadyqty.get(billKey) == null ? BigDecimal.ZERO : (BigDecimal)billAlreadyqty.get(billKey);
                    BigDecimal bigDecimal = canbfqty = billCanbfqty.get(billKey) == null ? BigDecimal.ZERO : (BigDecimal)billCanbfqty.get(billKey);
                    if (alreadyqty.add(billentry.getBigDecimal("qty")).compareTo(canbfqty) <= 0) continue;
                    logger.info("------MFTReqOutBillBackflushQtyValidator------\u9886\u6599\u5355[" + obj.getString("billno") + "]\u5355\u636e\u6620\u5c04billKey[" + billKey + "]\u6570\u91cf:" + billentry.getBigDecimal("qty") + " \u5df2\u5012\u51b2\u6570\u91cf:" + alreadyqty + " \u5e94\u5012\u51b2\u6570\u91cf:" + canbfqty);
                    String format = String.format(ResManager.loadKDString((String)"\u9886\u6599\u5355[%1$s]\u6570\u91cf%2$s\u5df2\u5927\u4e8e\u5269\u4f59\u5e94\u5012\u51b2\u6570\u91cf%3$s\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MFTReqOutBillBackflushQtyValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), obj.getString("billno"), billentry.getBigDecimal("qty"), canbfqty.subtract(alreadyqty));
                    this.addErrorMessage(dataEntity, format);
                }
            }
        }
    }

    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("billno");
        fields.add("isvirtualbill");
        fields.add("ischargeoff");
        fields.add("ischargeoffed");
        fields.add("billentry");
        fields.add("billentry.srcbillentryid");
        fields.add("billentry.mainbillentity");
        fields.add("billentry.qty");
        return fields;
    }
}

