/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.utils.OrderBookDateService;

public class MFTReqOutBillBookDateValidator
extends AbstractValidator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MFTReqOutBillBookDateValidator", (String)"validate");){
            String operate = this.getOperateKey();
            HashSet<Long> manuEntryId = new HashSet<Long>(16);
            HashSet<Long> mroManuEntryId = new HashSet<Long>(16);
            int i = 0;
            while (true) {
                DynamicObject obj;
                if (i < this.dataEntities.length) {
                    obj = this.dataEntities[i].getDataEntity();
                } else {
                    Map<String, Map<String, String>> mftOrder = this.getMftOrder(manuEntryId, "pom_mftorder");
                    mftOrder.putAll(this.getMftOrder(mroManuEntryId, "pom_mroorder"));
                    switch (operate) {
                        case "audit": 
                        case "unaudit": {
                            this.checkBookDate(mftOrder, operate);
                            return;
                        }
                    }
                    return;
                }
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    if (entryObj.getLong("mainbillentryid") <= 0L && !entryObj.getBoolean("isadd")) continue;
                    if ("pom_mftstock".equals(entryObj.getString("mainbillentity"))) {
                        manuEntryId.add(entryObj.getLong("manuentryid"));
                        continue;
                    }
                    if (!"pom_mrostock".equals(entryObj.getString("mainbillentity"))) continue;
                    mroManuEntryId.add(entryObj.getLong("manuentryid"));
                }
                ++i;
            }
        }
    }

    private void checkBookDate(Map<String, Map<String, String>> mftOrder, String operate) {
        HashSet invOrgs = new HashSet(16);
        mftOrder.values().forEach(t -> invOrgs.add(Long.parseLong((String)t.get("inwardept"))));
        Map acctOrgCloseDateMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCloseService", (String)"getAcctOrgCloseDate", (Object[])new Object[]{invOrgs});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                String closeBookDate;
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                Map<String, String> manuObj = mftOrder.get(entryObj.getString("manuentryid"));
                if (manuObj == null || StringUtils.equals((CharSequence)"A", (CharSequence)manuObj.get("bizstatus"))) continue;
                String string = closeBookDate = StringUtils.isNotEmpty((CharSequence)manuObj.get("closebookdate")) ? manuObj.get("closebookdate") : manuObj.get("closetime");
                if (StringUtils.isEmpty((CharSequence)closeBookDate)) {
                    String format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u7b2c%2$s\u884c\u5206\u5f55\u201c\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\u201d\u53ca\u201c\u5173\u95ed\u65e5\u671f\u201d\u5747\u4e3a\u7a7a\uff0c\u8de8\u671f\u6821\u9a8c\u5931\u8d25\u3002", (String)"MFTReqOutBillBookDateValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), manuObj.get("billno"), manuObj.get("seq"));
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                Date maxBookDate = OrderBookDateService.queryMaxBookDate(Long.parseLong(manuObj.get("org")), Long.parseLong(manuObj.get("inwardept")), new HashMap<Long, Date>(), acctOrgCloseDateMap);
                try {
                    String format;
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date compareBookDate = sf.parse(closeBookDate);
                    if (!OrderBookDateService.isIntertemporal(compareBookDate, maxBookDate)) continue;
                    SimpleDateFormat sfDay = new SimpleDateFormat("yyyy-MM-dd");
                    if ("audit".equals(operate) && !obj.getBoolean("isvirtualbill")) {
                        format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u7b2c%2$s\u884c\u5206\u5f55\u7684\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\uff08%3$s\uff09\u5c0f\u4e8e\u7b49\u4e8e\u6838\u7b97\u7ec4\u7ec7\u5173\u8d26\u65e5\u671f\uff08%4$s\uff09\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"MFTReqOutBillBookDateValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), manuObj.get("billno"), manuObj.get("seq"), sfDay.format(compareBookDate), sfDay.format(maxBookDate));
                        this.addErrorMessage(this.dataEntities[i], format);
                        continue;
                    }
                    if (!"unaudit".equals(operate)) continue;
                    format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u7b2c%2$s\u884c\u5206\u5f55\u7684\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\uff08%3$s\uff09\u5c0f\u4e8e\u7b49\u4e8e\u6838\u7b97\u7ec4\u7ec7\u5173\u8d26\u65e5\u671f\uff08%4$s\uff09\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MFTReqOutBillBookDateValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), manuObj.get("billno"), manuObj.get("seq"), sfDay.format(compareBookDate), sfDay.format(maxBookDate));
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                catch (ParseException e) {
                    String format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u7b2c%2$s\u884c\u5206\u5f55\u201c\u5de5\u5355\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\u201d\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a%3$s\u3002", (String)"MFTReqOutBillBookDateValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), manuObj.get("billno"), manuObj.get("seq"), e.getMessage());
                    this.addErrorMessage(this.dataEntities[i], format);
                }
            }
        }
    }

    private Map<String, Map<String, String>> getMftOrder(Set<Long> manuEntryId, String entity) {
        String algoKey = "queryMftOrder";
        String selectFields = "id,billno,org,treeentryentity.id,treeentryentity.bizstatus,treeentryentity.seq,treeentryentity.inwardept,treeentryentity.closebookdate,treeentryentity.closetime";
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(256);
        QFilter qFilter = new QFilter("treeentryentity.id", "in", manuEntryId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> map1 = new HashMap<String, String>(16);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("org", row.getString("org"));
                map1.put("treeentryentity.id", row.getString("treeentryentity.id"));
                map1.put("bizstatus", row.getString("treeentryentity.bizstatus"));
                map1.put("seq", row.getString("treeentryentity.seq"));
                map1.put("inwardept", row.getString("treeentryentity.inwardept"));
                map1.put("closebookdate", row.getString("treeentryentity.closebookdate"));
                map1.put("closetime", row.getString("treeentryentity.closetime"));
                map.put(row.getString("treeentryentity.id"), map1);
            }
        }
        return map;
    }
}

