/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class MFTReqOutBillSaveAndSubmitAndDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MFTReqOutBillSaveAndSubmitAndDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("srcbillnumber");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("mainbillnumber");
        e.getFieldKeys().add("mainbillentryseq");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("manubill");
        e.getFieldKeys().add("manubillid");
        e.getFieldKeys().add("manuentry");
        e.getFieldKeys().add("manuentryid");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("bizorg");
        e.getFieldKeys().add("billcretype");
        e.getFieldKeys().add("reqtype");
        e.getFieldKeys().add("billentry.stockentryid");
        e.getFieldKeys().add("billentry.stockno");
        e.getFieldKeys().add("billentry.stockentry");
        e.getFieldKeys().add("billentry.stockid");
        e.getFieldKeys().add("billentry.material");
        e.getFieldKeys().add("billentry.configuredcode");
        e.getFieldKeys().add("billentry.lotnumber");
        e.getFieldKeys().add("billentry.baseunit");
        e.getFieldKeys().add("billentry.auxpty");
        e.getFieldKeys().add("billentry.outownertype");
        e.getFieldKeys().add("billentry.outowner");
        e.getFieldKeys().add("billentry.warehouse");
        e.getFieldKeys().add("billentry.location");
        e.getFieldKeys().add("billentry.oprno");
        e.getFieldKeys().add("billentry.processseq");
        e.getFieldKeys().add("billentry.isadd");
        e.getFieldKeys().add("billentry.workprocedureid");
        e.getFieldKeys().add("billentry.operationdesc");
        e.getFieldKeys().add("billentry.oprworkcenter");
        e.getFieldKeys().add("billentry.workstation");
        e.getFieldKeys().add("billentry.workstation");
        e.getFieldKeys().add("billentry.billentry_lk");
        e.getFieldKeys().add("billentry.billentry_lk_stableid");
        e.getFieldKeys().add("billentry.billentry_lk_sbillid");
        e.getFieldKeys().add("billentry.billentry_lk_sid");
        e.getFieldKeys().add("billentry.linetype");
        e.getFieldKeys().add("billentry.materialname");
        e.getFieldKeys().add("billentry.isrework");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("save".equals(operationKey)) {
            dataEntities = e.getDataEntities();
            Set invSchemeIds = Arrays.stream(dataEntities).filter(x -> x.getDynamicObject("invscheme") != null).map(x -> x.getDynamicObject("invscheme").getPkValue()).collect(Collectors.toSet());
            Map invSchemeMap = BusinessDataServiceHelper.loadFromCache((String)"im_invscheme", (QFilter[])new QFilter[]{new QFilter("id", "in", invSchemeIds)});
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject dataEntity = dataEntities[i];
                if (dataEntity.getDynamicObject("invscheme") == null) continue;
                DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
                this.initEntryValue(billEntry);
                this.setInvSchemeValue(dataEntity, billEntry, (DynamicObject)invSchemeMap.get(dataEntity.getDynamicObject("invscheme").getPkValue()));
            }
        }
        if (this.isSave(operationKey)) {
            dataEntities = e.getDataEntities();
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject dataEntity = dataEntities[i];
                String entityName = dataEntity.getDataEntityType().getName();
                boolean ischargeoff = dataEntity.getBoolean("ischargeoff");
                if (!ischargeoff) continue;
                TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)entityName, (String)"billentry");
                String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
                DynamicObjectCollection billEntrys = dataEntity.getDynamicObjectCollection("billentry");
                for (DynamicObject billEntry : billEntrys) {
                    DynamicObjectCollection linkRows;
                    if (billEntry.get("mainbillentity") == null || !"pom_mftstock".equals(billEntry.getString("mainbillentity")) && !"prop_mftstock".equals(billEntry.getString("mainbillentity"))) continue;
                    TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)billEntry.getString("mainbillentity"), (String)"stockentry");
                    Long mftStockEntryId = billEntry.getLong("mainbillentryid");
                    long mainbillid = billEntry.getLong("mainbillid");
                    if (mftStockEntryId == null || mftStockEntryId.equals(0L) || !(linkRows = billEntry.getDynamicObjectCollection(lkEntryKey)).isEmpty() || linkRows.getDynamicObjectType() == null) continue;
                    DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                    linkRows.add((Object)linkRow);
                    linkRow.set(lkEntryKey + "_stableid", (Object)srcTableDefine.getTableId());
                    linkRow.set(lkEntryKey + "_sbillid", (Object)mainbillid);
                    linkRow.set(lkEntryKey + "_sid", (Object)mftStockEntryId);
                }
            }
        }
    }

    private boolean isSave(String operationKey) {
        return "save".equalsIgnoreCase(operationKey) || "submit".equalsIgnoreCase(operationKey);
    }

    private void setInvSchemeValue(DynamicObject dataEntity, DynamicObjectCollection billEntry, DynamicObject invScheme) {
        DynamicObjectCollection outInvTypeEntry = invScheme.getDynamicObjectCollection("outinvtypeentry");
        List outinvtypeisdefault = outInvTypeEntry.stream().filter(var -> var.getBoolean("outinvtypeisdefault")).collect(Collectors.toList());
        DynamicObjectCollection outInvStatusEntry = invScheme.getDynamicObjectCollection("outinvstatusentry");
        List outinvstatusisdefault = outInvStatusEntry.stream().filter(var -> var.getBoolean("outinvstatusisdefault")).collect(Collectors.toList());
        for (DynamicObject dynamicObject : billEntry) {
            if (dynamicObject.get("outownertype") == null) {
                dynamicObject.set("outownertype", dataEntity.get("supplyownertype"));
            }
            if (CollectionUtils.isNotEmpty(outinvtypeisdefault) && dynamicObject.get("outinvtype") == null) {
                dynamicObject.set("outinvtype", ((DynamicObject)outinvtypeisdefault.get(0)).get("outinvtype"));
            }
            if (CollectionUtils.isNotEmpty(outinvstatusisdefault) && dynamicObject.get("outinvstatus") == null) {
                dynamicObject.set("outinvstatus", ((DynamicObject)outinvstatusisdefault.get(0)).get("outinvstatus"));
            }
            if (dynamicObject.get("outowner") != null) continue;
            dynamicObject.set("outowner", dataEntity.get("supplyowner"));
        }
    }

    private void initEntryValue(DynamicObjectCollection billEntry) {
        for (DynamicObject dynamicObject : billEntry) {
            DynamicObject material = dynamicObject.getDynamicObject("material");
            if (material == null) {
                return;
            }
            DynamicObject masterId = material.getDynamicObject("masterid");
            if (dynamicObject.get("materialmasterid") != null || masterId == null) continue;
            dynamicObject.set("materialmasterid", masterId.getPkValue());
        }
    }
}

