/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import org.apache.commons.lang3.StringUtils;

public class MFTReqOutBillValidator
extends AbstractValidator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MFTReqOutBillValidator", (String)"validate");){
            String operate = this.getOperateKey();
            HashSet<Long> manuEntryId = new HashSet<Long>(16);
            HashSet<Long> mroManuEntryId = new HashSet<Long>(16);
            HashSet<Long> propManuEntryId = new HashSet<Long>(16);
            HashSet<Long> mainBillEntryId = new HashSet<Long>(16);
            HashSet<Long> mroMainBillEntryId = new HashSet<Long>(16);
            HashSet<Long> propMainBillEntryId = new HashSet<Long>(16);
            int i = 0;
            while (true) {
                DynamicObject obj;
                if (i < this.dataEntities.length) {
                    obj = this.dataEntities[i].getDataEntity();
                } else {
                    Map<String, Map<String, String>> mftOrder = this.getMftOrder(manuEntryId, "pom_mftorder");
                    mftOrder.putAll(this.getMftOrder(mroManuEntryId, "pom_mroorder"));
                    mftOrder.putAll(this.getMftOrder(propManuEntryId, "prop_mftorder"));
                    mftOrder.putAll(this.getMftOrder(manuEntryId, "prop_mftorder"));
                    switch (operate) {
                        case "audit": {
                            this.checkAudit(mainBillEntryId, mroMainBillEntryId, propMainBillEntryId, mftOrder);
                            return;
                        }
                        case "unaudit": {
                            this.checkPomMftOrder(mftOrder);
                            return;
                        }
                    }
                    return;
                }
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    if (entryObj.getLong("mainbillentryid") <= 0L && !entryObj.getBoolean("isadd")) continue;
                    if ("pom_mftstock".equals(entryObj.getString("mainbillentity"))) {
                        mainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                        manuEntryId.add(entryObj.getLong("manuentryid"));
                        continue;
                    }
                    if ("pom_mrostock".equals(entryObj.getString("mainbillentity"))) {
                        mroMainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                        mroManuEntryId.add(entryObj.getLong("manuentryid"));
                        continue;
                    }
                    if (!"prop_mftstock".equals(entryObj.getString("mainbillentity"))) continue;
                    propMainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                    propManuEntryId.add(entryObj.getLong("manuentryid"));
                }
                ++i;
            }
        }
    }

    private void checkAudit(Set<Long> mainBillEntryId, Set<Long> mroMainBillEntryId, Set<Long> propMainBillEntryId, Map<String, Map<String, String>> mftOrder) {
        Map<String, Map<String, Object>> mftStock = MftReqOutBillUtil.getMftStockByMainBillEntryIds(mainBillEntryId, "pom_mftstock");
        mftStock.putAll(MftReqOutBillUtil.getMftStockByMainBillEntryIds(mroMainBillEntryId, "pom_mrostock"));
        mftStock.putAll(MftReqOutBillUtil.getMftStockByMainBillEntryIds(propMainBillEntryId, "prop_mftstock"));
        mftStock.putAll(MftReqOutBillUtil.getMftStockByMainBillEntryIds(mainBillEntryId, "prop_mftstock"));
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                if (0L == entryObj.getLong("manubillid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u751f\u4ea7\u5de5\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"MFTReqOutBillValidator_14", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                    continue;
                }
                Map<String, String> manuObj = mftOrder.get(entryObj.getString("manuentryid"));
                if (manuObj == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u751f\u4ea7\u5de5\u5355\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillValidator_15", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                    continue;
                }
                if (!"C".equals(manuObj.get("billstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u751f\u4ea7\u5de5\u5355\u975e\u5ba1\u6838\u72b6\u6001\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillValidator_16", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                    continue;
                }
                DynamicObject transObj = obj.getDynamicObject("invscheme").getDynamicObject("transceivertype");
                if (transObj == null) continue;
                transObj = BusinessDataServiceHelper.loadSingleFromCache((Object)transObj.getPkValue(), (String)transObj.getDataEntityType().getName());
                if (null == entryObj.getString("mainbillentity") || "".equals(entryObj.getString("mainbillentity"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"MFTReqOutBillValidator_18", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                    continue;
                }
                Map<String, Object> stockObj = mftStock.get(entryObj.getString("mainbillentryid"));
                if (null == stockObj) continue;
                if (propMainBillEntryId.contains(Long.parseLong(entryObj.getString("mainbillentryid"))) && !"C".equals(stockObj.get("billstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u6d41\u7a0b\u7528\u6599\u6e05\u5355\u672a\u5ba1\u6838\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillValidator_25", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                BigDecimal actQty = (BigDecimal)stockObj.get("stockentry.actissueqty");
                BigDecimal rejQty = (BigDecimal)stockObj.get("stockentry.rejectedqty");
                BigDecimal feedQty = (BigDecimal)stockObj.get("stockentry.feedingqty");
                if ("B".equals(stockObj.get("stockentry.overissuecontrl")) && "0".equals(transObj.getString("bizdirection")) && "1".equals(transObj.getString("transceiver")) || !Boolean.FALSE.equals(stockObj.get("stockentry.iscannegative")) || !"1".equals(transObj.getString("bizdirection")) || !"0".equals(transObj.getString("transceiver")) || entryObj.getBigDecimal("baseqty").add(rejQty).subtract(feedQty).compareTo(actQty) <= 0) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u9000\u6599\u6570\u91cf\u201c%2$s\u201d\u51cf\u53bb\u7ec4\u4ef6\u6e05\u5355\u8865\u6599\u6570\u91cf\u201c%3$s\u201d\u8d85\u8fc7\u7ec4\u4ef6\u6e05\u5355\u5b9e\u53d1\u6570\u91cf\u201c%4$s\u201d\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillValidator_19", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, entryObj.getBigDecimal("baseqty").stripTrailingZeros().toPlainString(), rejQty.stripTrailingZeros().toPlainString(), feedQty.stripTrailingZeros().toPlainString(), actQty.stripTrailingZeros().toPlainString()));
            }
        }
    }

    private void checkPomMftOrder(Map<String, Map<String, String>> mftOrder) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                if (0L == entryObj.getLong("manubillid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u751f\u4ea7\u5de5\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"MFTReqOutBillValidator_20", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                    continue;
                }
                Map<String, String> manuObj = mftOrder.get(entryObj.getString("manuentryid"));
                if (manuObj == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u751f\u4ea7\u5de5\u5355\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillValidator_15", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                    continue;
                }
                if (!"C".equals(manuObj.get("billstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u751f\u4ea7\u5de5\u5355\u975e\u5ba1\u6838\u72b6\u6001\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillValidator_21", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"C", (CharSequence)manuObj.get("planstatus"))) continue;
                String format = String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355%2$s\u7b2c%3$s\u884c\u7684\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u4e0b\u8fbe\uff0c%4$s\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillValidator_22", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), manuObj.get("billno"), manuObj.get("seq"), BillTypeEnum.getValue(this.entityKey));
                this.addErrorMessage(this.dataEntities[i], format);
            }
        }
    }

    private Map<String, Map<String, String>> getMftOrder(Set<Long> manuEntryId, String entity) {
        String algoKey = "queryMftOrder";
        String selectFields = "id,billno,billstatus,treeentryentity.id,treeentryentity.seq,treeentryentity.producttype,treeentryentity.material,treeentryentity.iscontrolqty,treeentryentity.inwarmax,treeentryentity.inwarmin,treeentryentity.quainwaqty,treeentryentity.waitcheckqty,treeentryentity.unquainwaqty,treeentryentity.scrinwaqty,treeentryentity.bizstatus,treeentryentity.planstatus";
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(256);
        QFilter qFilter = new QFilter("treeentryentity.id", "in", manuEntryId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> map1 = new HashMap<String, String>(16);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("treeentryentity.id", row.getString("treeentryentity.id"));
                map1.put("bizstatus", row.getString("treeentryentity.bizstatus"));
                map1.put("planstatus", row.getString("treeentryentity.planstatus"));
                map1.put("seq", row.getString("treeentryentity.seq"));
                map.put(row.getString("treeentryentity.id"), map1);
            }
        }
        return map;
    }
}

