/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import kd.scmc.im.common.mdc.enums.OperateEnum;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import kd.scmc.im.opplugin.mdc.utils.MPDMMftGenStocksUtils;
import org.apache.commons.lang3.StringUtils;

public class MFTReqOutStockBillValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(MFTReqOutStockBillValidator.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MFTReqOutStockBillValidator", (String)"validate");){
            String operate = this.getOperateKey();
            if ("delete".equals(operate)) {
                return;
            }
            HashSet<Long> mainBillIds = new HashSet<Long>(16);
            HashSet<Long> morMainBillIds = new HashSet<Long>(16);
            HashSet<Long> propMainBillIds = new HashSet<Long>(16);
            HashSet<String> manuEntryIds = new HashSet<String>(16);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    if (entryObj.getLong("mainbillid") <= 0L && !entryObj.getBoolean("isadd")) continue;
                    if ("pom_mftstock".equals(entryObj.getString("mainbillentity"))) {
                        mainBillIds.add(entryObj.getLong("mainbillid"));
                        manuEntryIds.add(entryObj.getString("manuentryid"));
                        continue;
                    }
                    if ("pom_mrostock".equals(entryObj.getString("mainbillentity"))) {
                        morMainBillIds.add(entryObj.getLong("mainbillid"));
                        continue;
                    }
                    if (!"prop_mftstock".equals(entryObj.getString("mainbillentity"))) continue;
                    propMainBillIds.add(entryObj.getLong("mainbillid"));
                }
            }
            Map<String, Map<String, String>> mftStock = MftReqOutBillUtil.getMftStockByIds(mainBillIds, "pom_mftstock");
            mftStock.putAll(MftReqOutBillUtil.getMftStockByIds(morMainBillIds, "pom_mrostock"));
            mftStock.putAll(MftReqOutBillUtil.getMftStockByIds(propMainBillIds, "prop_mftstock"));
            Map<Object, Object> xmftStock = new HashMap(16);
            Map<Object, Object> xmftOrder = new HashMap(16);
            boolean isFirstLoad1 = true;
            boolean isFirstLoad2 = true;
            this.doValidate(operate, mftStock);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    boolean isUpdateStock;
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    if ((StringUtils.isBlank((CharSequence)entryObj.getString("manubill")) || StringUtils.isBlank((CharSequence)entryObj.getString("manuentry"))) && entryObj.getLong("mainbillid") == 0L && entryObj.getBoolean("isadd")) continue;
                    String mainBillId = entryObj.getString("mainbillid");
                    String manuEntryId = entryObj.getString("manuentryid");
                    Map<String, String> map = mftStock.get(mainBillId);
                    if (map == null) {
                        String format = String.format(ResManager.loadKDString((String)"%s\uff1a\u6ca1\u6709\u5bf9\u5e94\u7684\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"MFTReqOutStockBillValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey));
                        if ("prop_mftstock".equals(entryObj.getString("mainbillentity"))) {
                            format = String.format(ResManager.loadKDString((String)"%s\uff1a\u6ca1\u6709\u5bf9\u5e94\u7684\u6d41\u7a0b\u7528\u6599\u6e05\u5355\u3002", (String)"MFTReqOutStockBillValidator_15", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey));
                        }
                        this.addErrorMessage(this.dataEntities[i], format);
                        continue;
                    }
                    boolean bl = isUpdateStock = null == map.get("transactiontypeisupdatestock") ? false : Boolean.parseBoolean(map.get("transactiontypeisupdatestock"));
                    if (isUpdateStock && StringUtils.equals((CharSequence)mainBillId, (CharSequence)map.get("id")) && !StringUtils.equals((CharSequence)"C", (CharSequence)map.get("billstatus"))) {
                        String format = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5bf9\u5e94\u7684\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355%2$s\u672a\u5ba1\u6838\uff0c%3$s\u5931\u8d25\u3002", (String)"MFTReqOutStockBillValidator_8", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), map.get("billno"), OperateEnum.getValue(operate));
                        if ("prop_mftstock".equals(entryObj.getString("mainbillentity"))) {
                            format = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5bf9\u5e94\u7684\u6d41\u7a0b\u7528\u6599\u6e05\u5355%2$s\u672a\u5ba1\u6838\uff0c%3$s\u5931\u8d25\u3002", (String)"MFTReqOutStockBillValidator_16", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), map.get("billno"), OperateEnum.getValue(operate));
                        }
                        this.addErrorMessage(this.dataEntities[i], format);
                        continue;
                    }
                    if (isFirstLoad1) {
                        xmftStock = MftReqOutBillUtil.getXmftStockByStockId(mainBillIds, "pom_xmftstock");
                        isFirstLoad1 = false;
                    }
                    Map<String, Object> pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)obj.getDynamicObject("bizorg").getPkValue(), "im_mdc_mftproorder");
                    Boolean isMftStockCtrlBusExe = (Boolean)pmAppParameterMap.get("ismftstockctrlbusexe");
                    Map stringMap = (Map)xmftStock.get(mainBillId);
                    if (isMftStockCtrlBusExe.booleanValue() && !obj.getBoolean("isvirtualbill") && stringMap != null && StringUtils.equals((CharSequence)mainBillId, (CharSequence)((CharSequence)stringMap.get("stockentry.stockid")))) {
                        String format = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5bf9\u5e94\u7684\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355%2$s\u672a\u5ba1\u6838\uff0c%3$s\u5931\u8d25\u3002", (String)"MFTReqOutStockBillValidator_9", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), stringMap.get("billno"), OperateEnum.getValue(operate));
                        this.addErrorMessage(this.dataEntities[i], format);
                        continue;
                    }
                    if (isFirstLoad2) {
                        xmftOrder = MftReqOutBillUtil.getXmftOrderByManuEntryId(manuEntryIds, "pom_xmftorder");
                        isFirstLoad2 = false;
                    }
                    Boolean isMftOrderCtrlBusExe = (Boolean)pmAppParameterMap.get("ismftorderctrlbusexe");
                    Map xmftOrderMap = (Map)xmftOrder.get(manuEntryId);
                    if (!isMftOrderCtrlBusExe.booleanValue() || obj.getBoolean("isvirtualbill") || xmftOrderMap == null || !StringUtils.equals((CharSequence)manuEntryId, (CharSequence)((CharSequence)xmftOrderMap.get("treeentryentity.srcbillentryid")))) continue;
                    String format = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355\u53d8\u66f4\u5355%2$s\u672a\u5ba1\u6838\uff0c%3$s\u5931\u8d25\u3002", (String)"MFTReqOutStockBillValidator_10", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), xmftOrderMap.get("billno"), OperateEnum.getValue(operate));
                    this.addErrorMessage(this.dataEntities[i], format);
                }
            }
        }
    }

    private void doValidate(String operate, Map<String, Map<String, String>> mftStock) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObject bizorg = obj.getDynamicObject("bizorg");
            HashSet<Long> seqSet = new HashSet<Long>(16);
            String billEntityName = obj.getDataEntityType().getName();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                Object mainbillid = entryObj.get("mainbillid");
                if (!(entryObj.getBoolean("isadd") || entryObj.getLong("mainbillentryid") <= 0L || mainbillid != null && 0L != entryObj.getLong("mainbillid"))) {
                    String format = String.format(ResManager.loadKDString((String)"%s\uff1a\u6ca1\u6709\u5bf9\u5e94\u7684\u6838\u5fc3\u5355\u636eid\u3002", (String)"MFTReqOutStockBillValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey));
                    this.addErrorMessage(this.dataEntities[i], format);
                }
                Map<String, String> map = mftStock.get(null == mainbillid ? "0" : mainbillid.toString());
                boolean isUpdateStock = null == map || null == map.get("transactiontypeisupdatestock") ? false : Boolean.parseBoolean(map.get("transactiontypeisupdatestock"));
                DynamicObject bdmaterial = entryObj.getDynamicObject("material");
                if (!"submit".equals(operate) && !"audit".equals(operate) || !isUpdateStock || !entryObj.getBoolean("isadd")) continue;
                if (null != bdmaterial && entryObj.getLong("mainbillentryid") == 0L) {
                    QFilter mftmaterialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)Long.parseLong(bizorg.getPkValue().toString()));
                    mftmaterialFilter.and(new QFilter("masterid", "=", bdmaterial.getDynamicObject("masterid").get("id")));
                    mftmaterialFilter.and(new QFilter("enable", "=", (Object)"1"));
                    mftmaterialFilter.and(new QFilter("status", "=", (Object)"C"));
                    DynamicObject mftmaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{mftmaterialFilter});
                    if (null == mftmaterial) {
                        String format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u672a\u521b\u5efa\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6%2$s\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"MFTReqOutStockBillValidator_13", (String)"scmc-mm-mdc", (Object[])new Object[0]), entryObj.getInt("seq"), entryObj.getString("materialname"));
                        this.addErrorMessage(this.dataEntities[i], format);
                    }
                }
                String reqtype = obj.getString("reqtype");
                if (!StringUtils.equals((CharSequence)BillTypeEnum.FEED_ORDER.getName(), (CharSequence)billEntityName) || !StringUtils.equals((CharSequence)"A", (CharSequence)reqtype)) continue;
                seqSet.add(entryObj.getLong("seq"));
            }
            if (CollectionUtils.isEmpty(seqSet)) continue;
            String info = ResManager.loadKDString((String)"\u9886\u6599\u7c7b\u578b\u4e3a\u5b9a\u989d\u9886\u6599\uff0c\u4e0d\u5141\u8bb8\u7ec4\u4ef6\u5916\u9886\u6599\u3002", (String)"MFTReqOutStockBillValidator_14", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            this.addErrorMessage(this.dataEntities[i], info);
        }
    }
}

