/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MFTReqOutUnitValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(MFTReqOutUnitValidator.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MFTReqOutUnitValidator", (String)"validate");){
            String operate = this.getOperateKey();
            if ("delete".equals(operate)) {
                return;
            }
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
                DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
                for (int j = 0; j < billEntry.size(); ++j) {
                    DynamicObject material = ((DynamicObject)billEntry.get(j)).getDynamicObject("material");
                    if (material == null) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u5206\u5f55\u7269\u6599\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"MFTReqOutUnitValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                        continue;
                    }
                    DynamicObject inventoryUnit = material.getDynamicObject("inventoryunit");
                    DynamicObject unit = ((DynamicObject)billEntry.get(j)).getDynamicObject("unit");
                    if (inventoryUnit != null && unit != null && !Objects.equals(inventoryUnit.getPkValue(), unit.getPkValue())) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u548c\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u5355\u4f4d\u4e0d\u5339\u914d\u3002", (String)"MFTReqOutUnitValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                        continue;
                    }
                    DynamicObject baseUnit = ((DynamicObject)billEntry.get(j)).getDynamicObject("baseunit");
                    DynamicObject masterId = material.getDynamicObject("masterid");
                    DynamicObject dynamicObject = masterId.getDynamicObject("baseunit");
                    if (baseUnit == null || dynamicObject == null || Objects.equals(baseUnit.getPkValue(), dynamicObject.getPkValue())) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u57fa\u672c\u5355\u4f4d\u201d\u548c\u7269\u6599\u4fe1\u606f\u57fa\u672c\u5355\u4f4d\u4e0d\u5339\u914d\u3002", (String)"MFTReqOutUnitValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                }
            }
        }
    }
}

