/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.enums.OperateEnum;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;

public class MFTReqProBillValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(MFTReqProBillValidator.class);
    private static String KEY_UNAUDIT = "unaudit";
    private static String KEY_CHARGEAGAINST = "chargeagainst";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        HashSet<Long> propMroMainBillEntryId;
        HashSet<Long> propMainBillEntryId;
        HashSet<Long> mroMainBillEntryId;
        HashSet<Long> mainBillEntryId;
        String operate;
        TraceSpan span = Tracer.create((String)"MFTReqProBillValidator", (String)"validate");
        Throwable throwable = null;
        try {
            operate = this.getOperateKey();
            mainBillEntryId = new HashSet<Long>(16);
            mroMainBillEntryId = new HashSet<Long>(16);
            propMainBillEntryId = new HashSet<Long>(16);
            propMroMainBillEntryId = new HashSet<Long>(16);
            if (StringUtils.equals((CharSequence)KEY_UNAUDIT, (CharSequence)operate) || StringUtils.equals((CharSequence)KEY_CHARGEAGAINST, (CharSequence)operate)) {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    DynamicObject obj = this.dataEntities[i].getDataEntity();
                    for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                        DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                        if (entryObj.getLong("mainbillentryid") <= 0L) continue;
                        if ("pom_mftstock".equals(entryObj.getString("mainbillentity"))) {
                            mainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                            continue;
                        }
                        if ("pom_mrostock".equals(entryObj.getString("mainbillentity"))) {
                            mroMainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                            continue;
                        }
                        if ("prop_mftstock".equals(entryObj.getString("mainbillentity"))) {
                            propMainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                            continue;
                        }
                        if (!"prop_mrostock".equals(entryObj.getString("mainbillentity"))) continue;
                        propMroMainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        Map<String, Map<String, Object>> mftStock = MftReqOutBillUtil.getMftStockByMainBillEntryIds(mainBillEntryId, "pom_mftstock");
        mftStock.putAll(MftReqOutBillUtil.getMftStockByMainBillEntryIds(mroMainBillEntryId, "pom_mrostock"));
        Map<String, Map<String, Object>> propMftStock = MftReqOutBillUtil.getMftStockByMainBillEntryIds(propMainBillEntryId, "prop_mftstock");
        propMftStock.putAll(MftReqOutBillUtil.getMftStockByMainBillEntryIds(propMroMainBillEntryId, "prop_mrostock"));
        switch (operate) {
            case "unaudit": {
                this.qtyValidator(operate, mftStock, "pom");
                this.qtyValidator(operate, propMftStock, "prop");
                return;
            }
            case "chargeagainst": {
                logger.error("\u51b2\u9500\u5f00\u59cb");
                this.beginChargeAgainst(operate, mftStock, "pom");
                this.beginChargeAgainst(operate, propMftStock, "prop");
                return;
            }
        }
        return;
        finally {
            if (span != null) {
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    span.close();
                }
            }
        }
    }

    private void qtyValidator(String operate, Map<String, Map<String, Object>> mftStock, String appId) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            if (mftStock.size() == 0) {
                return;
            }
            this.validateinvsheme(this.dataEntities[i]);
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                String format;
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                BigDecimal qty = entryObj.getBigDecimal("baseqty").abs();
                Map<String, Object> manuObj = mftStock.get(entryObj.getString("mainbillentryid"));
                if (manuObj == null) {
                    return;
                }
                BigDecimal actissueQty = (BigDecimal)manuObj.get("stockentry.actissueqty");
                BigDecimal rejectedQty = (BigDecimal)manuObj.get("stockentry.rejectedqty");
                BigDecimal feedingQty = (BigDecimal)manuObj.get("stockentry.feedingqty");
                BigDecimal useQty = (BigDecimal)manuObj.get("stockentry.useqty");
                BigDecimal bigDecimal = actissueQty.subtract(rejectedQty).subtract(useQty).add(feedingQty).subtract(qty);
                if (bigDecimal.compareTo(BigDecimal.ZERO) >= 0 || !((Boolean)manuObj.get("transactiontypeid.isreturn")).booleanValue()) continue;
                if ("prop".equals(appId)) {
                    if ("A".equals(manuObj.get("transactiontypeid.returncontrol"))) {
                        format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u6d41\u7a0b\u7528\u6599\u6e05\u5355 %2$s\u7b2c%3$s\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u662f\u5426\u7ee7\u7eed%4$s\uff1f", (String)"MFTReqProBillValidator_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                        this.addWarningMessage(this.dataEntities[i], format);
                        continue;
                    }
                    if (!"B".equals(manuObj.get("transactiontypeid.returncontrol"))) continue;
                    format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u6d41\u7a0b\u7528\u6599\u6e05\u5355 %2$s\u7b2c%3$s\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"MFTReqProBillValidator_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                if ("A".equals(manuObj.get("transactiontypeid.returncontrol"))) {
                    format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355%2$s\u7b2c%3$s\u884c\u5206\u5f55\u201c\u5728\u5236\u6570\u91cf\u201d\u4e3a\u8d1f\uff0c\u662f\u5426\u7ee7\u7eed%4$s\uff1f", (String)"MFTReqProBillValidator_7", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                    this.addWarningMessage(this.dataEntities[i], format);
                    continue;
                }
                if (!"B".equals(manuObj.get("transactiontypeid.returncontrol"))) continue;
                format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355%2$s\u7b2c%3$s\u884c\u5206\u5f55\u201c\u5728\u5236\u6570\u91cf\u201d\u4e3a\u8d1f\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"MFTReqProBillValidator_8", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                this.addErrorMessage(this.dataEntities[i], format);
            }
        }
    }

    private void beginChargeAgainst(String operate, Map<String, Map<String, Object>> mftStock, String appId) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                String format;
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                BigDecimal qty = entryObj.getBigDecimal("baseqty");
                Map<String, Object> manuObj = mftStock.get(entryObj.getString("mainbillentryid"));
                if (manuObj == null) {
                    return;
                }
                BigDecimal actissueQty = (BigDecimal)manuObj.get("stockentry.actissueqty");
                BigDecimal rejectedQty = (BigDecimal)manuObj.get("stockentry.rejectedqty");
                BigDecimal feedingQty = (BigDecimal)manuObj.get("stockentry.feedingqty");
                BigDecimal useQty = (BigDecimal)manuObj.get("stockentry.useqty");
                BigDecimal bigDecimal = (actissueQty = actissueQty.subtract(qty)).subtract(rejectedQty).subtract(useQty).add(feedingQty);
                if (bigDecimal.compareTo(BigDecimal.ZERO) >= 0 || !((Boolean)manuObj.get("transactiontypeid.isreturn")).booleanValue()) continue;
                if ("prop".equals(appId)) {
                    if ("A".equals(manuObj.get("transactiontypeid.returncontrol"))) {
                        format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u6d41\u7a0b\u7528\u6599\u6e05\u5355 %2$s\u7b2c%3$s\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u662f\u5426\u7ee7\u7eed%4$s\uff1f", (String)"MFTReqProBillValidator_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                        this.addWarningMessage(this.dataEntities[i], format);
                        continue;
                    }
                    if (!"B".equals(manuObj.get("transactiontypeid.returncontrol"))) continue;
                    format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u6d41\u7a0b\u7528\u6599\u6e05\u5355 %2$s\u7b2c%3$s\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"MFTReqProBillValidator_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                if ("A".equals(manuObj.get("transactiontypeid.returncontrol"))) {
                    format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355%2$s\u7b2c%3$s\u884c\u5206\u5f55\u201c\u5728\u5236\u6570\u91cf\u201d\u4e3a\u8d1f\uff0c\u662f\u5426\u7ee7\u7eed%4$s\uff1f", (String)"MFTReqProBillValidator_7", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                    this.addWarningMessage(this.dataEntities[i], format);
                    continue;
                }
                if (!"B".equals(manuObj.get("transactiontypeid.returncontrol"))) continue;
                format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355%2$s\u7b2c%3$s\u884c\u5206\u5f55\u201c\u5728\u5236\u6570\u91cf\u201d\u4e3a\u8d1f\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"MFTReqProBillValidator_8", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                this.addErrorMessage(this.dataEntities[i], format);
            }
        }
    }

    private void validateinvsheme(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        if (this.getOption().containsVariable("ismanual") && dataEntity.getBoolean("isbackflush")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5012\u51b2\u9886\u6599\u5355\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u53cd\u5ba1\u6838\u3002", (String)"MFTReqProBillValidator_10", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        }
    }
}

