/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.enums.OperateEnum;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;

public class MFTReqReturnBillValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(MFTReqReturnBillValidator.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MFTReqReturnBillValidator", (String)"validate");){
            String operate = this.getOperateKey();
            HashSet<Long> mainBillEntryId = new HashSet<Long>(16);
            HashSet<Long> mroMainBillEntryId = new HashSet<Long>(16);
            HashSet<Long> propMainBillEntryId = new HashSet<Long>(16);
            HashSet<Long> propMroMainBillEntryId = new HashSet<Long>(16);
            int i = 0;
            while (true) {
                DynamicObject obj;
                if (i < this.dataEntities.length) {
                    obj = this.dataEntities[i].getDataEntity();
                } else {
                    switch (operate) {
                        case "audit": {
                            this.calcPickingNum(operate, mainBillEntryId, mroMainBillEntryId, "pom");
                            this.calcPickingNum(operate, propMainBillEntryId, propMroMainBillEntryId, "prop");
                            return;
                        }
                        case "submit": {
                            this.calcPickingNum(operate, mainBillEntryId, mroMainBillEntryId, "pom");
                            this.calcPickingNum(operate, propMainBillEntryId, propMroMainBillEntryId, "prop");
                            return;
                        }
                        case "chargeagainst": {
                            logger.error("\u51b2\u9500\u5f00\u59cb");
                            this.calcPickingNum(operate, mainBillEntryId, mroMainBillEntryId, "pom");
                            this.calcPickingNum(operate, propMainBillEntryId, propMroMainBillEntryId, "prop");
                            return;
                        }
                    }
                    return;
                }
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    if (entryObj.getLong("mainbillentryid") <= 0L) continue;
                    if ("pom_mftstock".equals(entryObj.getString("mainbillentity"))) {
                        mainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                        continue;
                    }
                    if ("pom_mrostock".equals(entryObj.getString("mainbillentity"))) {
                        mroMainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                        continue;
                    }
                    if ("prop_mftstock".equals(entryObj.getString("mainbillentity"))) {
                        propMainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                        continue;
                    }
                    if (!"prop_mrostock".equals(entryObj.getString("mainbillentity"))) continue;
                    propMroMainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                }
                ++i;
            }
        }
    }

    private void calcPickingNum(String operate, Set<Long> mainBillEntryId, Set<Long> mroMainBillEntryId, String appId) {
        Map<String, Map<String, Object>> mftStock;
        if ("prop".equals(appId)) {
            mftStock = MftReqOutBillUtil.getMftStockByMainBillEntryIds(mainBillEntryId, "prop_mftstock");
            mftStock.putAll(MftReqOutBillUtil.getMftStockByMainBillEntryIds(mroMainBillEntryId, "prop_mrostock"));
        } else {
            mftStock = MftReqOutBillUtil.getMftStockByMainBillEntryIds(mainBillEntryId, "pom_mftstock");
            mftStock.putAll(MftReqOutBillUtil.getMftStockByMainBillEntryIds(mroMainBillEntryId, "pom_mrostock"));
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                String format;
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                BigDecimal qty = entryObj.getBigDecimal("baseqty").abs();
                Map<String, Object> manuObj = mftStock.get(entryObj.getString("mainbillentryid"));
                if (manuObj == null) {
                    return;
                }
                BigDecimal actissueQty = (BigDecimal)manuObj.get("stockentry.actissueqty");
                BigDecimal rejectedQty = (BigDecimal)manuObj.get("stockentry.rejectedqty");
                BigDecimal feedingQty = (BigDecimal)manuObj.get("stockentry.feedingqty");
                BigDecimal useQty = (BigDecimal)manuObj.get("stockentry.useqty");
                BigDecimal wipQty = actissueQty.subtract(rejectedQty.subtract(qty)).add(feedingQty).subtract(useQty);
                if (!obj.getBoolean("ischargeoff")) {
                    wipQty = actissueQty.subtract(rejectedQty.add(qty)).add(feedingQty).subtract(useQty);
                }
                if (wipQty.compareTo(BigDecimal.ZERO) >= 0 || !((Boolean)manuObj.get("transactiontypeid.isreturn")).booleanValue()) continue;
                if ("prop".equals(appId)) {
                    if ("A".equals(manuObj.get("transactiontypeid.returncontrol"))) {
                        format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u6d41\u7a0b\u7528\u6599\u6e05\u5355%2$s\u7b2c%3$d\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u662f\u5426\u7ee7\u7eed%4$s\uff1f", (String)"MFTReqReturnBillValidator_6", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                        this.addWarningMessage(this.dataEntities[i], format);
                        continue;
                    }
                    if (!"B".equals(manuObj.get("transactiontypeid.returncontrol"))) continue;
                    format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u6d41\u7a0b\u7528\u6599\u6e05\u5355%2$s\u7b2c%3$d\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"MFTReqReturnBillValidator_7", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                if ("A".equals(manuObj.get("transactiontypeid.returncontrol"))) {
                    format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355%2$s\u7b2c%3$d\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u662f\u5426\u7ee7\u7eed%4$s\uff1f", (String)"MFTReqReturnBillValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                    this.addWarningMessage(this.dataEntities[i], format);
                    continue;
                }
                if (!"B".equals(manuObj.get("transactiontypeid.returncontrol"))) continue;
                format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355%2$s\u7b2c%3$d\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"MFTReqReturnBillValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                this.addErrorMessage(this.dataEntities[i], format);
            }
        }
    }
}

