/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scmc.im.opplugin.mdc.OmInBillAuditOrUnauditOpValidator;

public class OmInBillAuditOrUnauditOp
extends AbstractOperationServicePlugIn {
    private static final String KEY_BILLENTRY = "billentry";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(KEY_BILLENTRY);
        e.getFieldKeys().add("backflushstatus");
        e.getFieldKeys().add("biztype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OmInBillAuditOrUnauditOpValidator());
    }

    /*
     * WARNING - void declaration
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        List selectedRows = e.getSelectedRows();
        if (!"audit".equals(operationKey) && !"unaudit".equals(operationKey)) {
            return;
        }
        HashSet<Object> billPkIds = new HashSet<Object>(16);
        for (int i = 0; i < selectedRows.size(); ++i) {
            ExtendedDataEntity objEntity = (ExtendedDataEntity)selectedRows.get(i);
            billPkIds.add(objEntity.getBillPkId());
        }
        HashMap<Object, DynamicObject> pk_billMap = new HashMap<Object, DynamicObject>(16);
        HashSet<Object> mainBillIds = new HashSet<Object>(16);
        HashSet<Object> mainBillEntryIds = new HashSet<Object>(16);
        if (!billPkIds.isEmpty()) {
            void var13_25;
            QFilter stockQf;
            String string;
            DynamicObject[] components;
            QFilter qfilter;
            DynamicObject[] orders;
            DynamicObject[] bills;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"im_mdc_ominbill");
            for (DynamicObject dynamicObject : bills = BusinessDataServiceHelper.load((Object[])billPkIds.toArray(), (DynamicObjectType)dataEntityType)) {
                pk_billMap.put(dynamicObject.getPkValue(), dynamicObject);
                DynamicObjectCollection billEntry = dynamicObject.getDynamicObjectCollection(KEY_BILLENTRY);
                for (DynamicObject entryObj : billEntry) {
                    Object orderId = entryObj.get("mainbillid");
                    mainBillIds.add(orderId);
                    Object orderEntryId = entryObj.get("mainbillentryid");
                    mainBillEntryIds.add(orderEntryId);
                }
            }
            HashMap<String, DynamicObject> id_mainbillid = new HashMap<String, DynamicObject>(16);
            if (!mainBillIds.isEmpty() && (orders = BusinessDataServiceHelper.load((String)"pm_om_purorderbill", (String)"billentry.invqty,billentry.baseqty", (QFilter[])new QFilter[]{qfilter = new QFilter("id", "in", mainBillIds)})) != null) {
                for (DynamicObject order : orders) {
                    id_mainbillid.put(order.getString("id"), order);
                }
            }
            HashMap<String, DynamicObject> mainbillEntryId_stockMap = new HashMap<String, DynamicObject>(16);
            if (!mainBillEntryIds.isEmpty() && (components = BusinessDataServiceHelper.load((String)"om_componentlist", (String)(string = "orderentryid,transactiontypeid,baseqty,transactiontypeid.deduction,stockentry,stockentry.demandqty,stockentry.wipqty,stockentry.useqty,stockentry.iscannegative,stockentry.qtytype,stockentry.actissueqty,stockentry.feedingqty,stockentry.rejectedqty"), (QFilter[])new QFilter[]{stockQf = new QFilter("orderentryid", "in", mainBillEntryIds)})) != null) {
                for (DynamicObject component : components) {
                    String keyString = "";
                    Object orderentry = component.get("orderentryid");
                    if (orderentry instanceof DynamicObject) {
                        keyString = ((DynamicObject)orderentry).getString("id");
                    } else if (orderentry != null) {
                        keyString = orderentry.toString();
                    }
                    mainbillEntryId_stockMap.put(keyString, component);
                }
            }
            ArrayList<DynamicObject> entryObjs = new ArrayList<DynamicObject>(16);
            boolean bl = false;
            while (var13_25 < selectedRows.size()) {
                ExtendedDataEntity objEntity = (ExtendedDataEntity)selectedRows.get((int)var13_25);
                DynamicObject bill = (DynamicObject)pk_billMap.get(objEntity.getBillPkId());
                if (bill != null) {
                    DynamicObjectCollection billentry = bill.getDynamicObjectCollection(KEY_BILLENTRY);
                    for (DynamicObject entryObj : billentry) {
                        this.setCompletedWriteOff(entryObj, operationKey);
                        this.changeStockWipqty(entryObj, id_mainbillid, mainbillEntryId_stockMap);
                        if ((bill.getBoolean("ischargeoff") || !"audit".equals(operationKey)) && !"chargeagainst".equals(operationKey)) continue;
                        if (!this.getbillParam()) {
                            this.autoCloseOmOrder(entryObj);
                            continue;
                        }
                        entryObjs.add(entryObj);
                    }
                }
                ++var13_25;
            }
            if (this.getbillParam()) {
                this.autoCloseOmOrder(entryObjs);
            }
            SaveServiceHelper.update((DynamicObject[])mainbillEntryId_stockMap.values().toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])bills);
        }
    }

    private boolean getbillParam() {
        Object billParameter = SystemParamServiceHelper.getBillParameter((String)"im_mdc_ominbill", (String)"orderclose");
        if (billParameter instanceof Boolean) {
            return (Boolean)billParameter;
        }
        return false;
    }

    private void setCompletedWriteOff(DynamicObject entryObj, String operationKey) {
        if (!"unaudit".equals(operationKey)) {
            return;
        }
        entryObj.set("completewriteoff", (Object)false);
    }

    private void changeStockWipqty(DynamicObject entryObj, Map<String, DynamicObject> id_mainbillid, Map<String, DynamicObject> mainbillEntryId_stockMap) {
        String orderEntryId = entryObj.getString("mainbillentryid");
        if (orderEntryId == null) {
            return;
        }
        DynamicObject orderDym = id_mainbillid.get(entryObj.getString("mainbillid"));
        if (orderDym == null) {
            return;
        }
        DynamicObjectCollection orderEntryDym = orderDym.getDynamicObjectCollection(KEY_BILLENTRY);
        if (orderEntryDym == null) {
            return;
        }
        DynamicObject stockDym = mainbillEntryId_stockMap.get(orderEntryId);
        if (stockDym == null) {
            return;
        }
        String deduction = stockDym.getString("transactiontypeid.deduction");
        if (!"A".equals(deduction)) {
            return;
        }
        DynamicObjectCollection stockEntryDym = stockDym.getDynamicObjectCollection("stockentry");
        if (stockEntryDym == null) {
            return;
        }
        for (int i = 0; i < stockEntryDym.size(); ++i) {
            DynamicObject stockEntry = (DynamicObject)stockEntryDym.get(i);
            if (stockEntry == null) {
                return;
            }
            BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
            BigDecimal feedingQty = stockEntry.getBigDecimal("feedingqty");
            BigDecimal rejectedQty = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal outsQty = actissueQty.add(feedingQty).subtract(rejectedQty);
            try {
                BigDecimal useQty = this.getUseQty(orderEntryId, stockDym, stockEntry);
                BigDecimal newWipQty = outsQty.subtract(useQty);
                stockEntry.set("wipqty", (Object)newWipQty);
                stockEntry.set("useqty", (Object)useQty);
                continue;
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, new ErrorCode("MmcServiceOrderCloseOpAction", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
            }
        }
    }

    private BigDecimal getUseQty(Object orderEntryId, DynamicObject stockDym, DynamicObject stockEntry) {
        BigDecimal useQty = (BigDecimal)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMPDMOldMftGenStocksUtils", (String)"aculOMUseQty", (Object[])new Object[]{stockEntry, orderEntryId, stockDym.getDynamicObject("transactiontypeid")});
        return useQty;
    }

    private void autoCloseOmOrder(DynamicObject entryObj) {
        Long orderEntryid = entryObj.getLong("mainbillentryid");
        Long orderid = entryObj.getLong("mainbillid");
        if (null != orderid && 0L != orderid && null != orderEntryid && 0L != orderEntryid) {
            try {
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"om", (String)"IOmPmOrderCloseService", (String)"closeOrder", (Object[])new Object[]{orderEntryid, orderid});
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, new ErrorCode("IOmPmOrderCloseService", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
            }
        }
    }

    private void autoCloseOmOrder(List<DynamicObject> entryObjs) {
        if (entryObjs.isEmpty()) {
            return;
        }
        ArrayList mapList = new ArrayList(16);
        for (DynamicObject entryObj : entryObjs) {
            Long orderEntryid = entryObj.getLong("mainbillentryid");
            Long orderid = entryObj.getLong("mainbillid");
            HashMap<String, Long> map = new HashMap<String, Long>(2);
            map.put("orderid", orderid);
            map.put("orderentryid", orderEntryid);
            mapList.add(map);
        }
        try {
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"om", (String)"IOmPmOrderCloseService", (String)"closeOrder", (Object[])new Object[]{mapList});
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, new ErrorCode("IOmPmOrderCloseService", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
        }
    }
}

