/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.apache.commons.collections4.MapUtils;

public class OmInBillAuditOrUnauditOpValidator
extends AbstractValidator {
    private static final String KEY_BILLENTRY = "billentry";

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"OmInBillAuditOrUnauditOpValidator", (String)"validate");){
            String operationKey = this.getOperateKey();
            if ("unaudit".equals(operationKey) || "delete".equals(operationKey)) {
                HashSet<Long> srcBillEntryId = new HashSet<Long>(16);
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    DynamicObjectCollection entryCol = this.dataEntities[i].getDataEntity().getDynamicObjectCollection(KEY_BILLENTRY);
                    for (DynamicObject object : entryCol) {
                        srcBillEntryId.add(object.getLong("id"));
                    }
                }
                Map<Long, Map<String, Object>> mftProOrderByIds = this.getMftProOrderByIds(srcBillEntryId);
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.checkBill(this.dataEntities[i], mftProOrderByIds);
                }
            }
        }
    }

    private void checkBill(ExtendedDataEntity extendedDataEntity, Map<Long, Map<String, Object>> data) {
        ArrayList<Integer> unExistList = new ArrayList<Integer>(10);
        DynamicObject obj = extendedDataEntity.getDataEntity();
        if ("im_mdc_ominbill".equals(this.getEntityKey()) || "im_mdc_omcmplinbill".equals(this.getEntityKey())) {
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(KEY_BILLENTRY);
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(i);
                Map<String, Object> map = data.get(entryObj.getLong("id"));
                if (!MapUtils.isNotEmpty(map)) continue;
                unExistList.add(i + 1);
            }
            if (!unExistList.isEmpty()) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5df2\u7ecf\u5012\u51b2\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"OmInBillAuditOrUnauditOpValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), ((Object)unExistList).toString());
                this.addErrorMessage(extendedDataEntity, errMsg);
            }
        } else if ("im_mdc_mftmanuinbill".equals(this.getEntityKey()) || "im_mdc_mftreturnbill".equals(this.getEntityKey())) {
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(KEY_BILLENTRY);
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject entryObj = (DynamicObject)entryCol.get(i);
                Map<String, Object> map = data.get(entryObj.getLong("id"));
                if (!MapUtils.isNotEmpty(map)) continue;
                unExistList.add(i + 1);
            }
            if (!unExistList.isEmpty()) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5df2\u7ecf\u5012\u51b2\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"OmInBillAuditOrUnauditOpValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), ((Object)unExistList).toString());
                this.addErrorMessage(extendedDataEntity, errMsg);
            }
        }
    }

    private Map<Long, Map<String, Object>> getMftProOrderByIds(Set<Long> srcBillEntryId) {
        HashMap<Long, Map<String, Object>> map = new HashMap<Long, Map<String, Object>>(16);
        String llDEntityKey = this.getLLDEntityKey();
        if (StringUtils.isEmpty((CharSequence)llDEntityKey)) {
            return map;
        }
        String algoKey = "getMftProOrderByIds";
        QFilter filter = new QFilter("billentry.srcbillentryid", "in", srcBillEntryId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)llDEntityKey, (String)"id,billentry.srcbillentryid", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map1 = new HashMap<String, Object>(8);
                map1.put("id", row.getString("id"));
                map1.put("billentry.srcbillentryid", row.getLong("billentry.srcbillentryid"));
                map.put(row.getLong("billentry.srcbillentryid"), map1);
            }
        }
        return map;
    }

    private String getLLDEntityKey() {
        if ("im_mdc_mftmanuinbill".equals(this.getEntityKey())) {
            return "im_mdc_mftproorder";
        }
        if ("im_mdc_mftreturnbill".equals(this.getEntityKey())) {
            return "im_mdc_mftreturnorder";
        }
        if ("im_mdc_ominbill".equals(this.getEntityKey())) {
            return "im_mdc_omproorder";
        }
        if ("im_mdc_omcmplinbill".equals(this.getEntityKey())) {
            return "im_mdc_omoutbill";
        }
        return "";
    }
}

