/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;

public class OmInBillSaveOrSubmitOpValidator
extends AbstractValidator {
    private static final String KEY_BILLENTRY = "billentry";

    public void validate() {
        String operationKey = this.getOperateKey();
        if ("submit".equals(operationKey) || "save".equals(operationKey)) {
            for (int i = 0; i < this.dataEntities.length; ++i) {
                this.checkBill(this.dataEntities[i]);
            }
            this.dealWarehouseAndLocation(this.dataEntities);
            if ("submit".equals(operationKey)) {
                this.submitValid();
            }
        }
    }

    private void submitValid() {
        HashSet<Long> orgIds = new HashSet<Long>(10);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObject org = obj.getDynamicObject("org");
            if (org == null) continue;
            orgIds.add(org.getLong("id"));
        }
        Map<Long, Long[]> warehouseMap = this.getWarehouse(this.entityKey, orgIds);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Long[] longs = warehouseMap.get(obj.getDynamicObject("org").getLong("id"));
            boolean isoutupdate = obj.getDynamicObject("invscheme") == null ? false : obj.getDynamicObject("invscheme").getBoolean("isoutupdate");
            for (int j = 0; j < obj.getDynamicObjectCollection(KEY_BILLENTRY).size(); ++j) {
                String format;
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection(KEY_BILLENTRY).get(j);
                if (!isoutupdate) continue;
                DynamicObject outwarehouse = entryObj.getDynamicObject("outwarehouse");
                DynamicObject outlocation = entryObj.getDynamicObject("outlocation");
                if (outwarehouse == null) continue;
                if (longs == null || longs.length == 0) {
                    String format2 = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u6240\u9009\u7684\u51fa\u5e93\u4ed3\u5e93\u6ca1\u6709\u6743\u9650\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInBillSaveOrSubmitOpValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                    this.addErrorMessage(this.dataEntities[i], format2);
                    continue;
                }
                List<Long> list = Arrays.asList(longs);
                if (!list.contains(outwarehouse.getPkValue())) {
                    format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u6240\u9009\u7684\u51fa\u5e93\u4ed3\u5e93\u6ca1\u6709\u6743\u9650\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInBillSaveOrSubmitOpValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                if (outwarehouse.getBoolean("isopenlocation")) {
                    if (outlocation == null) {
                        format = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$d\u884c\u51fa\u5e93\u4ed3\u5e93\u5df2\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406\uff0c\u8bf7\u586b\u5199\u5206\u5f55\u201c\u51fa\u5e93\u4ed3\u4f4d\u201d\u3002", (String)"OmInBillSaveOrSubmitOpValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                        this.addErrorMessage(this.dataEntities[i], format);
                        continue;
                    }
                    DynamicObjectCollection entryEntity = outwarehouse.getDynamicObjectCollection("entryentity");
                    List collect = entryEntity.stream().map(var -> var.getDynamicObject("location").getLong("id")).collect(Collectors.toList());
                    if (outlocation == null || collect.contains(outlocation.getLong("id"))) continue;
                    String format3 = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u7684\u51fa\u5e93\u4ed3\u5e93\u542f\u7528\u4ed3\u4f4d\u4f46\u662f\u4ed3\u4f4d\u4e0e\u4ed3\u5e93\u4e0d\u7b26\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInBillSaveOrSubmitOpValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                    this.addErrorMessage(this.dataEntities[i], format3);
                    continue;
                }
                if (outlocation == null) continue;
                format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u7684\u51fa\u5e93\u4ed3\u5e93\u672a\u542f\u7528\u4ed3\u4f4d\u4f46\u662f\u4ed3\u4f4d\u6709\u503c\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInBillSaveOrSubmitOpValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                this.addErrorMessage(this.dataEntities[i], format);
            }
        }
    }

    private Map<Long, Long[]> getWarehouse(String formId, Set<Long> ids) {
        HashMap<Long, Long[]> resultMap = new HashMap<Long, Long[]>(16);
        if (CollectionUtils.isEmpty(ids)) {
            return resultMap;
        }
        for (Long orgId : ids) {
            List<Long> result = this.setWareHouseIsolate(formId, orgId);
            if (result == null) {
                Long[] allWarehouseIDs = WarehouseHelper.getAllWarehouseIDs((Long)orgId);
                resultMap.put(orgId, allWarehouseIDs);
                continue;
            }
            resultMap.put(orgId, result.toArray(new Long[result.size()]));
        }
        return resultMap;
    }

    private List<Long> setWareHouseIsolate(String formId, Long id) {
        long userId = UserServiceHelper.getCurrentUserId();
        Object wareHouseIsolate = AppParameterHelper.getAppParameterByFormId((String)formId, (Long)id, (String)"fwarehouseisolate");
        if (wareHouseIsolate instanceof Boolean && !((Boolean)wareHouseIsolate).booleanValue()) {
            return null;
        }
        List wareHouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId((Long)userId, Collections.singletonList(id));
        if (CollectionUtils.isEmpty((Collection)wareHouses)) {
            return null;
        }
        ArrayList<Long> wareHouseIds = new ArrayList<Long>(16);
        for (DynamicObject wareHose : wareHouses) {
            Long wareHosePkValue = (Long)wareHose.getPkValue();
            wareHouseIds.add(wareHosePkValue);
        }
        return wareHouseIds;
    }

    private void dealWarehouseAndLocation(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            if (!obj.getDynamicObject("invscheme").getBoolean("isoutupdate")) continue;
            DynamicObjectCollection cols = obj.getDynamicObjectCollection(KEY_BILLENTRY);
            for (DynamicObject col : cols) {
                DynamicObject outWareHouse = col.getDynamicObject("outwarehouse");
                if (outWareHouse == null) {
                    col.set("outwarehouse", (Object)col.getDynamicObject("warehouse"));
                }
                DynamicObject outlocation = col.getDynamicObject("outlocation");
                if (col.getDynamicObject("outwarehouse") == null || !col.getDynamicObject("outwarehouse").getBoolean("isopenlocation") || outlocation != null) continue;
                col.set("outlocation", (Object)col.getDynamicObject("location"));
            }
        }
    }

    private void checkBill(ExtendedDataEntity extendedDataEntity) {
        DynamicObject obj = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(KEY_BILLENTRY);
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            if (0L != entryObj.getLong("mainbillid") || entryObj.getBoolean("ispresent")) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u901a\u8fc7\u62c9\u5f0f\u751f\u6210\u9009\u5355\u6216\u52fe\u9009\u201c\u8d60\u54c1\u201d\u540e\u4fdd\u5b58\u6216\u63d0\u4ea4\u3002", (String)"OmInBillSaveOrSubmitOpValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
        }
    }
}

