/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.im.opplugin.mdc.OMReqFeedBillValidator;
import kd.scmc.im.opplugin.mdc.OMReqProBillValidator;
import kd.scmc.im.opplugin.mdc.OMReqReturnBillValidator;
import kd.scmc.im.opplugin.mdc.OmReqOutBillValidator;

public class OmReqOutBillAuditOp
extends AbstractOperationServicePlugIn {
    private static final String KEY_AUDIT = "audit";
    private static final String KEY_UNAUDIT = "unaudit";
    private static final String KEY_BILLENTRY = "billentry";
    private static final String KEY_MANUBILL = "manubillid";
    private static final String KEY_MANUENTRYID = "manuentryid";
    private static final String IM_MDC_OM_RETURN_ORDER = "im_mdc_omreturnorder";
    private static final String IM_MDC_OM_PRO_ORDER = "im_mdc_omproorder";
    private static final String IM_MDC_OM_FEED_ORDER = "im_mdc_omfeedorder";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("srcbillnumber");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("mainbillnumber");
        e.getFieldKeys().add("mainbillentryseq");
        e.getFieldKeys().add(KEY_BILLENTRY);
        e.getFieldKeys().add("manubill");
        e.getFieldKeys().add(KEY_MANUBILL);
        e.getFieldKeys().add("manuentry");
        e.getFieldKeys().add(KEY_MANUENTRYID);
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("isbackflush");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OmReqOutBillValidator());
        String name = this.billEntityType.getName();
        if (IM_MDC_OM_RETURN_ORDER.equals(name)) {
            e.addValidator((AbstractValidator)new OMReqReturnBillValidator());
        }
        if (IM_MDC_OM_FEED_ORDER.equals(name)) {
            e.addValidator((AbstractValidator)new OMReqFeedBillValidator());
        }
        if (IM_MDC_OM_FEED_ORDER.equals(name) || IM_MDC_OM_PRO_ORDER.equals(name)) {
            e.addValidator((AbstractValidator)new OMReqProBillValidator());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dObjects = e.getDataEntities();
        if (KEY_AUDIT.equals(operationKey) || KEY_UNAUDIT.equals(operationKey)) {
            for (DynamicObject repOut : dObjects) {
                if (repOut.getBoolean("ischargeoff")) {
                    return;
                }
                DynamicObjectCollection entryCol = repOut.getDynamicObjectCollection(KEY_BILLENTRY);
                ArrayList<Map<String, Long>> mapList = new ArrayList<Map<String, Long>>(entryCol.size());
                for (DynamicObject billEntry : entryCol) {
                    long manuBillId = billEntry.getLong(KEY_MANUBILL);
                    long billEntityId = billEntry.getLong(KEY_MANUENTRYID);
                    HashMap<String, Long> map = new HashMap<String, Long>(2);
                    map.put("orderid", manuBillId);
                    map.put("orderentryid", billEntityId);
                    mapList.add(map);
                }
                try {
                    this.doInvokeBizService(mapList);
                }
                catch (Exception ex) {
                    throw new KDException((Throwable)ex, new ErrorCode("IOmPmOrderCloseService", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
                }
            }
        }
    }

    private void doInvokeBizService(List<Map<String, Long>> mapList) {
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"om", (String)"IOmPmOrderCloseService", (String)"closeOrder", (Object[])new Object[]{mapList});
    }

    private void autoCloseOrder(long manuBillId, long billEntityId) {
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"om", (String)"IOmPmOrderCloseService", (String)"closeOrder", (Object[])new Object[]{billEntityId, manuBillId});
    }
}

