/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.applybill;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.opplugin.mdc.applybill.validate.MdcReturnApplyBillCloseOnAddVal;

public class MdcReturnApplyBillCloseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billentry");
        keys.add("material");
        keys.add("baseqty");
        keys.add("qty");
        keys.add("auditqty");
        keys.add("rowstatus");
        keys.add("billstatus");
        keys.add("closer");
        keys.add("closedate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new MdcReturnApplyBillCloseOnAddVal());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        String entryids = this.getOption().getVariableValue("entryids", "1");
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"id");
        Date now = TimeServiceHelper.now();
        if ("1".equals(entryids)) {
            for (DynamicObject bill : bills) {
                bill.set("billstatus", (Object)"D");
                bill.set("closer", (Object)currentUser);
                bill.set("closedate", (Object)now);
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    entry.set("rowstatus", (Object)"D");
                }
            }
        } else {
            String[] split;
            HashSet<Long> ids = new HashSet<Long>(16);
            for (String string : split = entryids.split("@")) {
                ids.add(Long.parseLong(string));
            }
            for (String string : bills) {
                int label = 1;
                DynamicObjectCollection entrys = string.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    if (ids.contains(entry.getPkValue())) {
                        entry.set("rowstatus", (Object)"D");
                    }
                    if (entry.getString("rowstatus").equals("D")) continue;
                    label = 2;
                }
                if (label != true) continue;
                string.set("billstatus", (Object)"D");
                string.set("closer", (Object)currentUser);
                string.set("closedate", (Object)now);
            }
        }
        SaveServiceHelper.save((DynamicObject[])bills);
    }
}

