/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.applybill.validate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;

public class MdcApplyBillValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MFTReqOutBillValidator", (String)"validate");){
            HashSet<Long> propMainBillEntryId = new HashSet<Long>(16);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    if (!"prop_mftstock".equals(entryObj.getString("mainbillentity"))) continue;
                    propMainBillEntryId.add(entryObj.getLong("mainbillentryid"));
                }
            }
            Map<String, Map<String, Object>> mftStock = MftReqOutBillUtil.getMftStockByMainBillEntryIds(propMainBillEntryId, "prop_mftstock");
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    Map<String, Object> stockObj = mftStock.get(entryObj.getString("mainbillentryid"));
                    if (null == stockObj || !propMainBillEntryId.contains(Long.parseLong(entryObj.getString("mainbillentryid"))) || "C".equals(stockObj.get("billstatus"))) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u6d41\u7a0b\u7528\u6599\u6e05\u5355\u672a\u5ba1\u6838\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillValidator_25", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
                }
            }
        }
    }

    private void checkAudit(Set<Long> propMainBillEntryId, Map<String, Map<String, String>> mftOrder) {
        Map<String, Map<String, Object>> mftStock = MftReqOutBillUtil.getMftStockByMainBillEntryIds(propMainBillEntryId, "prop_mftstock");
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                Map<String, Object> stockObj = mftStock.get(entryObj.getString("mainbillentryid"));
                if (null == stockObj || !propMainBillEntryId.contains(Long.parseLong(entryObj.getString("mainbillentryid"))) || "C".equals(stockObj.get("billstatus"))) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u6d41\u7a0b\u7528\u6599\u6e05\u5355\u672a\u5ba1\u6838\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillValidator_25", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
            }
        }
    }

    private Map<String, Map<String, String>> getMftOrder(Set<Long> manuEntryId, String entity) {
        String algoKey = "queryMftOrder";
        String selectFields = "id,billno,billstatus,treeentryentity.id,treeentryentity.seq,treeentryentity.producttype,treeentryentity.material,treeentryentity.iscontrolqty,treeentryentity.inwarmax,treeentryentity.inwarmin,treeentryentity.quainwaqty,treeentryentity.waitcheckqty,treeentryentity.unquainwaqty,treeentryentity.scrinwaqty,treeentryentity.bizstatus,treeentryentity.planstatus";
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(256);
        QFilter qFilter = new QFilter("treeentryentity.id", "in", manuEntryId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> map1 = new HashMap<String, String>(16);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("treeentryentity.id", row.getString("treeentryentity.id"));
                map1.put("bizstatus", row.getString("treeentryentity.bizstatus"));
                map1.put("planstatus", row.getString("treeentryentity.planstatus"));
                map1.put("seq", row.getString("treeentryentity.seq"));
                map.put(row.getString("treeentryentity.id"), map1);
            }
        }
        return map;
    }
}

