/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.backflush;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;

public class MyTaskBackFlush
implements Runnable {
    private static Log logger = LogFactory.getLog(MyTaskBackFlush.class);
    private static String targetName = "im_mdc_mftproorder";
    private RequestContext rc;
    private String pageId;
    private String operateKey;
    private List<DynamicObject> selectDym;
    private String pagecachebfinvqty;
    private DynamicObject backFlushLog;
    private AtomicInteger finishActomicInteger;
    private Map<String, BigDecimal> billCanbfqty = new HashMap<String, BigDecimal>(16);

    public MyTaskBackFlush(RequestContext rc, String pageId, List<DynamicObject> selectDym, String operateKey, DynamicObject backFlushLog, AtomicInteger finishActomicInteger) {
        this.rc = rc;
        this.pageId = pageId;
        this.selectDym = selectDym;
        this.operateKey = operateKey;
        this.backFlushLog = backFlushLog;
        this.finishActomicInteger = finishActomicInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        try {
            this.doTask();
        }
        catch (Exception e) {
            PageCache pageCache = new PageCache(this.pageId);
            pageCache.put("bfexception", e.toString());
            logger.error((Throwable)e);
        }
        finally {
            DistributeSessionlessCache backflush = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("backflush");
            for (DynamicObject sdym : this.selectDym) {
                Object sourcebillid = sdym.get("sourcebillid");
                Object sourcebillentryid = sdym.get("sourcebillentryid");
                Object stockentryid = sdym.get("stockentryid");
                String key = "backflush_" + sourcebillid + "_" + sourcebillentryid + "_" + stockentryid;
                if (backflush == null || !backflush.contains(key)) continue;
                backflush.remove(key);
            }
        }
    }

    private void doTask() {
        List<DynamicObject> selectDyms = this.selectDym;
        HashMap<DynamicObject, String> res = new HashMap<DynamicObject, String>(selectDyms.size());
        ArrayList<DynamicObject> billEntryList = new ArrayList<DynamicObject>(selectDyms.size());
        String billType = this.getBizBillType(selectDyms);
        HashSet<Object> sourceBillIds = new HashSet<Object>(selectDyms.size());
        for (DynamicObject select : selectDyms) {
            billEntryList.add(select);
            res.put(select, "");
            sourceBillIds.add(select.get("sourcebillid"));
        }
        Map<String, Boolean> resMap = this.getSourceBillDataMap(billType, sourceBillIds);
        HashMap<String, List<Long>> inBill = new HashMap<String, List<Long>>(billEntryList.size());
        HashMap<String, DynamicObject> billEntryId = new HashMap<String, DynamicObject>(billEntryList.size());
        for (DynamicObject billEntry : billEntryList) {
            String sourceBillId = billEntry.getString("sourcebillid");
            if (!resMap.isEmpty() && resMap.get(sourceBillId).booleanValue()) continue;
            String sourceBillIdEntryId = billEntry.getString("sourcebillentryid");
            String key = sourceBillId + "," + sourceBillIdEntryId;
            List stockEntry = inBill.get(key) == null ? new ArrayList() : (List)inBill.get(key);
            stockEntry.add((Long)billEntry.get("stockentryid"));
            inBill.put(key, stockEntry);
            String qtyKey = key + "," + billEntry.getString("stockentryid");
            billEntryId.put(qtyKey, billEntry);
            String billKey = billEntry.getString("sourcebillentryid") + "@" + billEntry.getString("stockentryid");
            this.billCanbfqty.put(billKey, billEntry.getBigDecimal("canbfqty"));
        }
        if ("backflush".equals(this.operateKey)) {
            long start = System.currentTimeMillis();
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6279\u91cf\u751f\u6210\u9886\u6599\u5355\u5f00\u59cb\uff1a");
            this.autoBackFlush(inBill, billEntryId, res, this.pageId);
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6279\u91cf\u751f\u6210\u9886\u6599\u5355\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        } else if ("unbackflush".equals(this.operateKey)) {
            this.unBackFlushByBillType(billEntryList, res, this.pageId, billType);
        }
        PageCache pageCache = new PageCache(this.pageId);
        long start1 = System.currentTimeMillis();
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6279\u91cf\u751f\u6210\u65e5\u5fd7\u5f00\u59cb\uff1a");
        StockBackFlushUtils.delResLog(res, this.operateKey, this.backFlushLog);
        int indexNum = Integer.parseInt(pageCache.get("backflushfinishnum"));
        int numInt = Integer.parseInt(pageCache.get("backflushnum"));
        int pushNum = Integer.parseInt(pageCache.get("batchbfqty"));
        if (pushNum == 1 && indexNum == numInt || pushNum != 1) {
            pageCache.put("backflushlog", this.backFlushLog.getPkValue().toString());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.backFlushLog});
            if (pushNum != 1) {
                pageCache.put("opProgressPro", "100");
            }
        }
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6279\u91cf\u751f\u6210\u65e5\u5fd7\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start1));
    }

    private Map<String, Boolean> getSourceBillDataMap(String billType, Set<Object> sourceBillIds) {
        HashMap resMap = Maps.newHashMap();
        if (!StringUtils.equals((CharSequence)"", (CharSequence)billType)) {
            QFilter qFilter = new QFilter("id", "in", sourceBillIds);
            DataSet rows = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)billType, (String)"id,isvirtualbill", (QFilter[])new QFilter[]{qFilter}, null);
            for (Row row : rows) {
                resMap.put(row.getString("id"), row.getBoolean("isvirtualbill"));
            }
        }
        return resMap;
    }

    private String getBizBillType(List<DynamicObject> selectDyms) {
        if (!selectDyms.isEmpty()) {
            DynamicObject obj = selectDyms.get(0);
            String sourceBill = obj.getString("sourcebillentry");
            if (StringUtils.equals((CharSequence)"A", (CharSequence)sourceBill)) {
                return "im_mdc_mftmanuinbill";
            }
            if (StringUtils.equals((CharSequence)"G", (CharSequence)sourceBill)) {
                return "im_mdc_mftreturnbill";
            }
        }
        return "";
    }

    private void unBackFlushByBillType(List<DynamicObject> billEntryList, Map<DynamicObject, String> res, String pageCacheOption, String billType) {
        if ("im_mdc_mftreturnbill".equalsIgnoreCase(billType)) {
            this.unBackFlushByTarget(billEntryList, res, pageCacheOption, "im_mdc_mftreturnorder");
        } else {
            this.unBackFlushByTarget(billEntryList, res, pageCacheOption, "im_mdc_mftproorder");
        }
    }

    private void unBackFlushByTarget(List<DynamicObject> billEntryList, Map<DynamicObject, String> res, String pageCacheOption, String targetName) {
        HashSet<Long> sourceBillEntryidSet = new HashSet<Long>(16);
        HashSet<Long> stockEntryIdSet = new HashSet<Long>(16);
        for (DynamicObject billEntry : billEntryList) {
            sourceBillEntryidSet.add(billEntry.getLong("sourcebillentryid"));
            stockEntryIdSet.add(billEntry.getLong("stockentryid"));
        }
        QFilter filter = new QFilter("billentry.srcbillentryid", "in", sourceBillEntryidSet);
        filter.and(new QFilter("billentry.mainbillentryid", "in", stockEntryIdSet));
        filter.and("billtype.billformid", "=", (Object)targetName);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)targetName, (String)"id,billno,billentry.srcbillid,billentry.srcbillentryid,billentry.mainbillentryid", (QFilter[])new QFilter[]{filter});
        if (bills == null || bills.length == 0) {
            for (Map.Entry<DynamicObject, String> entry : res.entrySet()) {
                DynamicObject key = entry.getKey();
                res.put(key, ResManager.loadKDString((String)"\u6ca1\u6709\u5012\u51b2\u9886\u6599\u5355\u3002", (String)"MyTaskBackFlush_12", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                int numInt = res.size();
                int dealSize = this.getResSize(res);
                PageCache pageCache = new PageCache(pageCacheOption);
                pageCache.put("opProgressPro", String.valueOf(dealSize * 100 / numInt));
                pageCache.put("backflushfinishnum", Integer.toString(dealSize));
            }
        } else {
            Set<String> idSet = this.getIdSet(bills);
            Map<String, Set<String>> billIdMap = this.getIdMap(bills);
            for (Map.Entry<DynamicObject, String> entry : res.entrySet()) {
                DynamicObject key = entry.getKey();
                String sourceBillIdEntryId = key.getString("sourcebillentryid");
                String stockEntryId = key.getString("stockentryid");
                if (idSet.contains(sourceBillIdEntryId + "," + stockEntryId)) continue;
                res.put(key, ResManager.loadKDString((String)"\u6ca1\u6709\u5012\u51b2\u9886\u6599\u5355\u3002", (String)"MyTaskBackFlush_12", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            int numInt = res.size();
            int dealSize = this.getResSize(res);
            PageCache pageCache = new PageCache(pageCacheOption);
            pageCache.put("opProgressPro", String.valueOf(dealSize * 100 / numInt));
            pageCache.put("backflushfinishnum", Integer.toString(dealSize));
            if (this.isStop(pageCacheOption)) {
                return;
            }
            this.delBackFlush(bills, res, billIdMap, pageCacheOption, targetName);
        }
    }

    private void autoBackFlush(Map<String, List<Long>> inBill, Map<String, DynamicObject> billEntryId, Map<DynamicObject, String> res, String pageCacheOption) {
        PageCache pageCache = new PageCache(pageCacheOption);
        int numInt = Integer.parseInt(pageCache.get("backflushnum"));
        int pushNum = Integer.parseInt(pageCache.get("batchbfqty"));
        if (pushNum == 1) {
            this.pagecachebfinvqty = pageCache.get("pagecachebfinvqty");
            ArrayList<DynamicObject> needPushList = new ArrayList<DynamicObject>();
            for (Map.Entry<String, List<Long>> enrty : inBill.entrySet()) {
                List<Long> stockEntry = enrty.getValue();
                for (Long stockEntryId : stockEntry) {
                    String qtyKey = enrty.getKey() + "," + stockEntryId.toString();
                    DynamicObject billEntryDym = billEntryId.get(qtyKey);
                    if (this.backFlushVal(billEntryDym, res)) {
                        needPushList.add(billEntryDym);
                        continue;
                    }
                    this.finishActomicInteger.getAndAdd(1);
                    int indexInt = this.finishActomicInteger.get();
                    pageCache.put("backflushfinishnum", Integer.toString(indexInt));
                    pageCache.put("opProgressPro", String.valueOf(indexInt * 100 / numInt));
                    if (!this.isStop(pageCacheOption)) continue;
                    return;
                }
            }
            this.batchBackFlush(needPushList, res, pageCache, pageCacheOption, numInt);
            for (int i = 0; i < 50; ++i) {
                List<DynamicObject> resUn = this.getResUn(res);
                this.batchBackFlush(resUn, res, pageCache, pageCacheOption, numInt);
            }
        } else {
            this.pagecachebfinvqty = pageCache.get("pagecachebfinvqty");
            ArrayList<DynamicObject> needPushList = new ArrayList<DynamicObject>();
            for (Map.Entry<String, List<Long>> enrty : inBill.entrySet()) {
                List<Long> stockEntry = enrty.getValue();
                for (Long stockEntryId : stockEntry) {
                    String qtyKey = enrty.getKey() + "," + stockEntryId.toString();
                    DynamicObject billEntryDym = billEntryId.get(qtyKey);
                    if (this.backFlushVal(billEntryDym, res)) {
                        needPushList.add(billEntryDym);
                        continue;
                    }
                    int indexInt = Integer.parseInt(pageCache.get("backflushfinishnum"));
                    pageCache.put("backflushfinishnum", Integer.toString(++indexInt));
                    pageCache.put("opProgressPro", String.valueOf((indexInt - 1) * 100 / numInt));
                    if (!this.isStop(pageCacheOption)) continue;
                    return;
                }
            }
            this.batchBackFlush(needPushList, res, pageCache, pageCacheOption, numInt);
            for (int i = 0; i < 50; ++i) {
                List<DynamicObject> resUn = this.getResUn(res);
                this.batchBackFlush(resUn, res, pageCache, pageCacheOption, numInt);
            }
        }
    }

    private void batchBackFlush(List<DynamicObject> needPushList, Map<DynamicObject, String> res, PageCache pageCache, String pageCacheOption, int numInt) {
        if (!needPushList.isEmpty()) {
            int pushNum = Integer.parseInt(pageCache.get("batchbfqty"));
            List<List<DynamicObject>> batchNeedPushList = StockBackFlushUtils.subList(needPushList, pushNum);
            int size = batchNeedPushList.size();
            ArrayList<DynamicObject> needPushTkList = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> needPushRKList = new ArrayList<DynamicObject>(16);
            String mftstockentity = pageCache.get("mftstockentity");
            String proorderrule = "932404158450050048";
            String returnorderrule = "1847731519599195136";
            if ("prop_mftstock".equals(mftstockentity)) {
                proorderrule = "1999940382770658304";
                returnorderrule = "1999940076393528320";
            }
            for (int i = 0; i < size; ++i) {
                List<DynamicObject> needPush = batchNeedPushList.get(i);
                for (DynamicObject needPushDyn : needPush) {
                    String sourcebillType = needPushDyn.getString("sourcebillentry");
                    if (StringUtils.equals((CharSequence)"G", (CharSequence)sourcebillType)) {
                        needPushTkList.add(needPushDyn);
                        continue;
                    }
                    needPushRKList.add(needPushDyn);
                }
                long start = System.currentTimeMillis();
                int currentSize = this.getResSize(res);
                if (!needPushRKList.isEmpty()) {
                    this.autoBackFlushStock(needPushRKList, res, proorderrule, targetName, pageCache);
                }
                if (!needPushTkList.isEmpty()) {
                    this.autoBackFlushStock(needPushTkList, res, returnorderrule, "im_mdc_mftreturnorder", pageCache);
                }
                if (pushNum == 1) {
                    int dealSize = this.getResSize(res);
                    this.finishActomicInteger.getAndAdd(dealSize - currentSize);
                    int indexInt = this.finishActomicInteger.get();
                    pageCache.put("backflushfinishnum", Integer.toString(indexInt));
                    pageCache.put("opProgressPro", String.valueOf(indexInt * 100 / numInt));
                } else {
                    int indexInt = Integer.parseInt(pageCache.get("backflushfinishnum"));
                    int dealSize = this.getResSize(res);
                    indexInt = indexInt + dealSize - currentSize;
                    pageCache.put("backflushfinishnum", Integer.toString(indexInt));
                    pageCache.put("opProgressPro", String.valueOf(indexInt * 100 / numInt));
                }
                if (this.isStop(pageCacheOption)) {
                    return;
                }
                String format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u751f\u6210\u5012\u51b2\u9886\u6599\u5355\uff0c\u5171%1$s\u6279\uff0c\u7b2c%2$s\u6279\uff0c\u8017\u65f6%3$s\u3002", (String)"MyTaskBackFlush_14", (String)"scmc-mm-mdc", (Object[])new Object[0]), size, i + 1, System.currentTimeMillis() - start);
                logger.info(format);
            }
        }
    }

    private int getResSize(Map<DynamicObject, String> res) {
        int i = 0;
        for (Map.Entry<DynamicObject, String> entry : res.entrySet()) {
            if ("".equals(entry.getValue())) continue;
            ++i;
        }
        return i;
    }

    private List<DynamicObject> getResUn(Map<DynamicObject, String> res) {
        ArrayList<DynamicObject> unRes = new ArrayList<DynamicObject>(16);
        for (Map.Entry<DynamicObject, String> entry : res.entrySet()) {
            if (!"".equals(entry.getValue())) continue;
            DynamicObject key = entry.getKey();
            key.set("isuselog", (Object)"");
            unRes.add(key);
        }
        return unRes;
    }

    private boolean isStop(String pageCacheOption) {
        PageCache pageCache = new PageCache(pageCacheOption);
        String startProgress = pageCache.get("opProgressStop");
        return "1".equals(startProgress);
    }

    private void autoBackFlushStock(List<DynamicObject> needPushList, Map<DynamicObject, String> res, String ruleId, String targetName, PageCache pageCache) {
        HashMap<Object, List<DynamicObject>> stockBFMap = new HashMap<Object, List<DynamicObject>>(16);
        String mftstockentity = pageCache.get("mftstockentity");
        logger.info("\u5012\u51b2\u5e73\u53f0\u4e0b\u63a8\u6e90\u5355\u6807\u8bc6---mftstockentity--" + mftstockentity + "---ruleId---" + ruleId);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(mftstockentity);
        pushArgs.setTargetEntityNumber(targetName);
        pushArgs.setHasRight(false);
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject needPush : needPushList) {
            List<DynamicObject> stockBFList;
            Object stockEntryId = needPush.get("stockentryid");
            if (stockBFMap.get(stockEntryId) == null) {
                stockBFList = new ArrayList(1);
                ListSelectedRow srcBill1 = new ListSelectedRow(needPush.get("stockid"));
                srcBill1.setEntryEntityKey("stockentry");
                srcBill1.setEntryPrimaryKeyValue(stockEntryId);
                needPushRows.add(srcBill1);
            } else {
                stockBFList = (List)stockBFMap.get(stockEntryId);
            }
            stockBFList.add(needPush);
            stockBFMap.put(stockEntryId, stockBFList);
        }
        pushArgs.setSelectedRows(needPushRows);
        long start1 = System.currentTimeMillis();
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u8c03\u7528\u4e0b\u63a8\u5f15\u64ce,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start1));
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder().append(ResManager.loadKDString((String)"\u4e0b\u63a8\u9886\u6599\u5355\u5931\u8d25\uff1a", (String)"MyTaskBackFlush_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            errMessage.append(pushResult.getMessage());
            for (DynamicObject needPush : needPushList) {
                res.put(needPush, errMessage.toString());
            }
        }
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            List linkEntityRowReports = billReport.getLinkEntityRowReports();
            for (SourceRowReport sr : linkEntityRowReports) {
                Object entryId = sr.getEntryId();
                String resStr = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u9886\u6599\u5355\u5931\u8d25\uff1a%1$s", (String)"MyTaskBackFlush_15", (String)"scmc-mm-mdc", (Object[])new Object[0]), sr.getFailMessage());
                List list = (List)stockBFMap.get(entryId);
                for (DynamicObject entry : list) {
                    res.put(entry, resStr);
                }
            }
        }
        this.delPushRes(pushResult, stockBFMap, res, targetName);
    }

    private void delPushRes(ConvertOperationResult pushResult, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res, String targetName) {
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)targetName);
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (targetBillObjs.isEmpty()) {
            return;
        }
        this.handleTarget(targetBillObjs, stockBFMap);
        long start1 = System.currentTimeMillis();
        int size1 = targetBillObjs.size();
        ArrayList<DynamicObject> needBackFlushTargetBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject targetBillObj : targetBillObjs) {
            boolean isAutoMatch = targetBillObj.getBoolean("isautomatch");
            if (!isAutoMatch) continue;
            needBackFlushTargetBills.add(targetBillObj);
        }
        if (needBackFlushTargetBills != null && needBackFlushTargetBills.size() > 0) {
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6279\u6b21\u5012\u51b2,\u5171" + needBackFlushTargetBills.size() + "\u6761\uff0c");
            targetBillObjs.removeAll(needBackFlushTargetBills);
            StockBackFlushUtils.handleMatchingRule(needBackFlushTargetBills, this.pagecachebfinvqty, stockBFMap, res);
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6279\u6b21\u5012\u51b2,\u5171\u6210\u529f" + needBackFlushTargetBills.size() + "\u6761\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start1));
            targetBillObjs.addAll(needBackFlushTargetBills);
        }
        if (targetBillObjs.isEmpty()) {
            return;
        }
        long start2 = System.currentTimeMillis();
        int size2 = targetBillObjs.size();
        StockBackFlushUtils.handleInvQty(targetBillObjs, this.pagecachebfinvqty, stockBFMap, res);
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6309\u7167\u5e93\u5b58\u6570\u91cf,\u5171" + size2 + "\u6761\uff0c,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start2));
        for (int j = 0; j < targetBillObjs.size(); ++j) {
            DynamicObject targetBillObj = (DynamicObject)targetBillObjs.get(j);
            for (DynamicObject mftorderEntryObj : targetBillObj.getDynamicObjectCollection("billentry")) {
                Object parent = mftorderEntryObj.getParent();
                if (parent != null) continue;
                logger.info("error \u7236\u5b9e\u4f53\u8d4b\u503c");
                mftorderEntryObj.setParent((Object)targetBillObj);
            }
        }
        long start22 = System.currentTimeMillis();
        ArrayList<Object> saveSuccessList = new ArrayList<Object>(targetBillObjs.size());
        StockBackFlushUtils.dealInvRealbalance2(targetBillObjs, stockBFMap, res);
        long start3 = System.currentTimeMillis();
        int size3 = targetBillObjs.size();
        if (size3 == 0) {
            return;
        }
        String billCanbfqtyStr = JSON.toJSONString(this.billCanbfqty);
        OperateOption saveOption = StockBackFlushUtils.getOperateOption();
        saveOption.setVariableValue("billCanbfqtyStr", billCanbfqtyStr);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)targetName, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)saveOption);
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u4fdd\u5b58\u9886\u6599\u5355,\u5171" + size3 + "\u6761\uff0c,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start3));
        StockBackFlushUtils.setErrlog(saveResult, targetBillObjs, stockBFMap, res, "save");
        List successPkIds = saveResult.getSuccessPkIds();
        ArrayList<DynamicObject> failList = new ArrayList<DynamicObject>(targetBillObjs.size());
        if (successPkIds.size() < targetBillObjs.size()) {
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u4fdd\u5b58\u9886\u6599\u5355" + StockBackFlushUtils.getMesMap(saveResult));
            long start33 = System.currentTimeMillis();
            for (int j = 0; j < targetBillObjs.size(); ++j) {
                DynamicObject targetBillObj = (DynamicObject)targetBillObjs.get(j);
                OperationResult singleResult = OperationServiceHelper.executeOperate((String)"save", (String)targetName, (DynamicObject[])new DynamicObject[]{targetBillObj}, (OperateOption)saveOption);
                if (singleResult.isSuccess()) {
                    saveSuccessList.addAll(singleResult.getSuccessPkIds());
                    continue;
                }
                StockBackFlushUtils.setSaveErrlog(singleResult, targetBillObj, stockBFMap, res, "save");
                failList.add(targetBillObj);
            }
            logger.info("\u4fdd\u5b58\u9884\u7559\u5931\u8d25\u7684\u6761\u6570:" + failList.size());
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u4fdd\u5b58\u9886\u6599\u535533,\u5171" + size3 + "\u6761\uff0c,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start33));
            targetBillObjs.removeAll(failList);
        } else {
            saveSuccessList.addAll(successPkIds);
        }
        if (saveSuccessList.size() <= 0) {
            return;
        }
        if (targetBillObjs.isEmpty()) {
            return;
        }
        long start4 = System.currentTimeMillis();
        int size4 = targetBillObjs.size();
        OperateOption submitOption = StockBackFlushUtils.getOperateOption();
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetName, (Object[])saveSuccessList.toArray(), (OperateOption)submitOption);
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u63d0\u4ea4\u9886\u6599\u5355,\u5171" + size4 + "\u6761\uff0c,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start4));
        StockBackFlushUtils.setErrlog(submitResult, targetBillObjs, stockBFMap, res, "submit");
        StockBackFlushUtils.deleteRes(saveSuccessList, submitResult, targetName);
        if (targetBillObjs.isEmpty()) {
            return;
        }
        long start5 = System.currentTimeMillis();
        int size5 = targetBillObjs.size();
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetName, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)submitOption);
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u5ba1\u6838\u9886\u6599\u5355,\u5171" + size5 + "\u6761\uff0c,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start5));
        StockBackFlushUtils.setErrlog(auditResult, targetBillObjs, stockBFMap, res, "audit");
        StockBackFlushUtils.deleteRes(submitResult.getSuccessPkIds(), auditResult, targetName);
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObjectCollection tbillEntrys = targetBillObj.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : tbillEntrys) {
                StockBackFlushUtils.setErr(entry, res, stockBFMap, "success");
            }
        }
    }

    private void handleTarget(List<DynamicObject> targetBillObjs, Map<Object, List<DynamicObject>> stockBFMap) {
        for (int j = 0; j < targetBillObjs.size(); ++j) {
            DynamicObject targetBillObj = targetBillObjs.get(j);
            for (DynamicObject mftorderEntryObj : targetBillObj.getDynamicObjectCollection("billentry")) {
                targetBillObj.set("biztime", this.delTarget(mftorderEntryObj, stockBFMap));
            }
        }
        StockBackFlushUtils.initBookDate(targetBillObjs);
    }

    private Object delTarget(DynamicObject mftorderEntryObj, Map<Object, List<DynamicObject>> stockBFMap) {
        Object bizName = null;
        DynamicObject masterid = mftorderEntryObj.getDynamicObject("material").getDynamicObject("masterid");
        DynamicObject unit = mftorderEntryObj.getDynamicObject("unit");
        DynamicObject baseunit = mftorderEntryObj.getDynamicObject("baseunit");
        Object stockEntryId = mftorderEntryObj.get("mainbillentryid");
        List<DynamicObject> list = stockBFMap.get(stockEntryId);
        for (DynamicObject stockBFDym : list) {
            if (!"handleTarget".equals(stockBFDym.getString("isuselog"))) {
                BigDecimal qtyByUnit = this.getQtyByUnit(masterid, baseunit, unit, stockBFDym.getBigDecimal("nowbfqty"));
                logger.info("delTarget---qtyByUnit---" + qtyByUnit);
                mftorderEntryObj.set("qty", (Object)qtyByUnit);
                mftorderEntryObj.set("baseqty", (Object)this.processPrecision(stockBFDym.getBigDecimal("nowbfqty"), baseunit));
                mftorderEntryObj.set("qtyunit2nd", (Object)stockBFDym.getBigDecimal("qtyunit2nd"));
                mftorderEntryObj.set("srcbillnumber", stockBFDym.get("sourcebillno"));
                mftorderEntryObj.set("srcbillid", stockBFDym.get("sourcebillid"));
                mftorderEntryObj.set("srcbillentryid", stockBFDym.get("sourcebillentryid"));
                mftorderEntryObj.set("srcbillentity", (Object)StockBackFlushUtils.getEntity(stockBFDym.getString("sourcebillentry")));
                mftorderEntryObj.set("lotnumber", stockBFDym.get("batchno"));
                bizName = stockBFDym.get("backflushtime");
                stockBFDym.set("isuselog", (Object)"handleTarget");
                continue;
            }
            bizName = null;
        }
        return bizName;
    }

    private boolean backFlushVal(DynamicObject billEntryDym, Map<DynamicObject, String> res) {
        boolean isReturnBill = false;
        String sourcebillentry = billEntryDym.getString("sourcebillentry");
        if ("G".equals(sourcebillentry)) {
            isReturnBill = true;
        }
        DynamicObject transactionType = billEntryDym.getDynamicObject("transactiontypeid");
        boolean backflushmore = transactionType.getBoolean("backflushmore");
        BigDecimal nowbfQty = billEntryDym.getBigDecimal("nowbfqty");
        BigDecimal cansendqty = billEntryDym.getBigDecimal("cansendqty");
        boolean bfclose = billEntryDym.getBoolean("bfclose");
        String bfflag = billEntryDym.getString("bfflag");
        if (bfclose || "C".equals(bfflag)) {
            res.put(billEntryDym, ResManager.loadKDString((String)"\u5df2\u5012\u51b2\u5b8c\u6210\u6216\u5012\u51b2\u5173\u95ed,\u5012\u51b2\u5931\u8d25\u3002", (String)"MyTaskBackFlush_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return false;
        }
        if (nowbfQty.compareTo(BigDecimal.ZERO) == 0) {
            res.put(billEntryDym, ResManager.loadKDString((String)"\u672c\u6b21\u5012\u51b2\u6570\u91cf\u4e3a\u96f6,\u5012\u51b2\u5931\u8d25\u3002", (String)"MyTaskBackFlush_6", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return false;
        }
        if (!isReturnBill && !backflushmore) {
            if (nowbfQty.compareTo(cansendqty) > 0) {
                res.put(billEntryDym, ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\uff1a\u5012\u51b2\u6570\u91cf\u5e94\u5c0f\u4e8e\u9700\u6c42\u6570\u91cf\uff0c\u5012\u51b2\u5931\u8d25\u3002", (String)"MyTaskBackFlush_7", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return false;
            }
        } else {
            String overissuecontrl = billEntryDym.getString("overissuecontrl");
            if ("B".equals(overissuecontrl) && nowbfQty.compareTo(cansendqty) > 0) {
                res.put(billEntryDym, ResManager.loadKDString((String)"\u8d85\u53d1\u63a7\u5236\uff1a\u4e0d\u53ef\u8d85\u53d1\uff0c\u5012\u51b2\u5931\u8d25\u3002", (String)"MyTaskBackFlush_8", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private BigDecimal processPrecision(BigDecimal qty, DynamicObject unit) {
        int precision = unit.getInt("precision");
        return qty.setScale(precision, this.getRoundType(unit));
    }

    private BigDecimal getQtyByUnit(DynamicObject masterid, DynamicObject baseunit, DynamicObject unit, BigDecimal baseqty) {
        if (unit == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)masterid.getPkValue()), (Long)((Long)baseunit.getPkValue()), (Long)((Long)unit.getPkValue()));
        if (muConv == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal numerator = muConv.getBigDecimal("numerator");
        BigDecimal denominator = muConv.getBigDecimal("denominator");
        int precision = unit.getInt("precision");
        return baseqty.multiply(numerator).divide(denominator, precision, this.getRoundType(unit));
    }

    private int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    private Set<String> getIdSet(DynamicObject[] bills) {
        HashSet<String> idSet = new HashSet<String>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject billEntry : billEntrys) {
                String srcbillentryid = billEntry.getString("srcbillentryid");
                String mainbillentryid = billEntry.getString("mainbillentryid");
                idSet.add(srcbillentryid + "," + mainbillentryid);
            }
        }
        return idSet;
    }

    private Map<String, Set<String>> getIdMap(DynamicObject[] bills) {
        HashMap<String, Set<String>> billIdMap = new HashMap<String, Set<String>>(bills.length);
        for (DynamicObject bill : bills) {
            HashSet<String> idSet = new HashSet<String>(bills.length);
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject billEntry : billEntrys) {
                String srcbillentryid = billEntry.getString("srcbillentryid");
                String mainbillentryid = billEntry.getString("mainbillentryid");
                idSet.add(srcbillentryid + "," + mainbillentryid);
            }
            billIdMap.put(bill.getPkValue().toString(), idSet);
        }
        return billIdMap;
    }

    private void delBackFlush(DynamicObject[] bills, Map<DynamicObject, String> res, Map<String, Set<String>> billIdMap, String pageCacheOption, String targetName) {
        int numInt = res.size();
        PageCache pageCache = new PageCache(pageCacheOption);
        ArrayList<Long> mftProOrderPKList = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            mftProOrderPKList.add((Long)bill.getPkValue());
        }
        int pushNum = Integer.parseInt(pageCache.get("batchbfqty"));
        if (pushNum < 100) {
            pushNum = 100;
        }
        List batchNeedPushList = StockBackFlushUtils.subList(mftProOrderPKList, pushNum);
        int size = batchNeedPushList.size();
        for (int i = 0; i < size; ++i) {
            List needPush = batchNeedPushList.get(i);
            long start = System.currentTimeMillis();
            OperateOption option = StockBackFlushUtils.getOperateOption();
            OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)targetName, (Object[])needPush.toArray(), (OperateOption)option);
            if (unAuditResult != null) {
                List errorInfos = unAuditResult.getAllErrorOrValidateInfo();
                List successPkIds = unAuditResult.getSuccessPkIds();
                if (successPkIds.size() < needPush.size()) {
                    for (Long needPushId : needPush) {
                        Set<String> set;
                        if (successPkIds.contains(needPush) || (set = billIdMap.get(needPushId.toString())) == null) continue;
                        this.delErrMes(StockBackFlushUtils.getErrDetail(unAuditResult), set, res);
                    }
                }
                this.fillErrMes(res, errorInfos, billIdMap);
                if (!successPkIds.isEmpty()) {
                    OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)targetName, (Object[])successPkIds.toArray(), (OperateOption)option);
                    List delErrorInfos = delResult.getAllErrorOrValidateInfo();
                    this.fillErrMes(res, delErrorInfos, billIdMap);
                    for (Object successPkId : successPkIds) {
                        Set<String> set = billIdMap.get(successPkId.toString());
                        if (set == null) continue;
                        this.delErrMes("success", set, res);
                    }
                }
            }
            int dealSize = this.getResSize(res);
            pageCache.put("opProgressPro", String.valueOf(dealSize * 100 / numInt));
            pageCache.put("backflushfinishnum", Integer.toString(dealSize));
            if (this.isStop(pageCacheOption)) {
                return;
            }
            String format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u751f\u6210\u5012\u51b2\u9886\u6599\u5355\uff0c\u5171%1$s\u6279\uff0c\u7b2c%2$s\u6279\uff0c\u8017\u65f6%3$s\u3002", (String)"MyTaskBackFlush_14", (String)"scmc-mm-mdc", (Object[])new Object[0]), size, i + 1, System.currentTimeMillis() - start);
            logger.info(format);
        }
    }

    private void fillErrMes(Map<DynamicObject, String> res, List<IOperateInfo> errorInfos, Map<String, Set<String>> billIdMap) {
        for (IOperateInfo errorInfo : errorInfos) {
            String pkValue = errorInfo.getPkValue() == null ? "0" : errorInfo.getPkValue().toString();
            Set<String> set = billIdMap.get(pkValue);
            if (set == null) continue;
            this.delErrMes(errorInfo.getTitle() + "," + errorInfo.getMessage(), set, res);
        }
    }

    private void delErrMes(String errorInfoStr, Set<String> set, Map<DynamicObject, String> res) {
        for (Map.Entry<DynamicObject, String> entry : res.entrySet()) {
            DynamicObject key = entry.getKey();
            String sourceBillIdEntryId = key.getString("sourcebillentryid");
            String stockEntryId = key.getString("stockentryid");
            if (!set.contains(sourceBillIdEntryId + "," + stockEntryId)) continue;
            res.put(key, errorInfoStr);
        }
    }
}

