/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.backflush;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.im.common.mdc.utils.OMStockBackFlushUtils;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;

public class OMTaskBackFlush
implements Runnable {
    private static Log logger = LogFactory.getLog(OMTaskBackFlush.class);
    private String targetName = "im_mdc_omoutbill";
    private String botpId = "1236978371423038464";
    private RequestContext rc;
    private String pageId;
    private String operateKey;
    private List<DynamicObject> selectDym;
    private String pagecachebfinvqty;
    private Map<String, BigDecimal> billCanbfqty = new HashMap<String, BigDecimal>(16);

    public OMTaskBackFlush(RequestContext rc, String pageId, List<DynamicObject> selectDym, String operateKey) {
        this.rc = rc;
        this.pageId = pageId;
        this.selectDym = selectDym;
        this.operateKey = operateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        try {
            this.doTask();
        }
        catch (Exception e) {
            PageCache pageCache = new PageCache(this.pageId);
            pageCache.put("bfexception", e.toString());
            logger.error((Throwable)e);
        }
        finally {
            DistributeSessionlessCache backflush = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("backflush");
            for (DynamicObject sdym : this.selectDym) {
                Object sourcebillid = sdym.get("sourcebillid");
                Object sourcebillentryid = sdym.get("sourcebillentryid");
                Object stockentryid = sdym.get("stockentryid");
                String key = "backflush_" + sourcebillid + "_" + sourcebillentryid + "_" + stockentryid;
                if (backflush == null || !backflush.contains(key)) continue;
                logger.info("\u91ca\u653eredis---" + key);
                backflush.remove(key);
            }
        }
    }

    private void doTask() {
        List<DynamicObject> selectDyms = this.selectDym;
        HashMap<DynamicObject, String> res = new HashMap<DynamicObject, String>(selectDyms.size());
        ArrayList<DynamicObject> billEntryList = new ArrayList<DynamicObject>(selectDyms.size());
        HashSet<Object> sourceBillIds = new HashSet<Object>(selectDyms.size());
        for (DynamicObject select : selectDyms) {
            billEntryList.add(select);
            res.put(select, "");
            sourceBillIds.add(select.get("sourcebillid"));
        }
        Map<String, Boolean> resMap = this.getSourceBillDataMap("im_mdc_omcmplinbill", sourceBillIds);
        HashMap<String, List<Long>> inBill = new HashMap<String, List<Long>>(billEntryList.size());
        HashMap<String, DynamicObject> billEntryId = new HashMap<String, DynamicObject>(billEntryList.size());
        for (DynamicObject billEntry : billEntryList) {
            String sourceBillId = billEntry.getString("sourcebillid");
            if (!resMap.isEmpty() && resMap.get(sourceBillId).booleanValue()) continue;
            String sourceBillIdEntryId = billEntry.getString("sourcebillentryid");
            String key = sourceBillId + "," + sourceBillIdEntryId;
            List stockEntry = inBill.get(key) == null ? new ArrayList() : (List)inBill.get(key);
            stockEntry.add((Long)billEntry.get("stockentryid"));
            inBill.put(key, stockEntry);
            String qtyKey = key + "," + billEntry.getString("stockentryid");
            billEntryId.put(qtyKey, billEntry);
            String billKey = billEntry.getString("sourcebillentryid") + "@" + billEntry.getString("stockentryid");
            this.billCanbfqty.put(billKey, billEntry.getBigDecimal("canbfqty"));
        }
        if ("backflush".equals(this.operateKey)) {
            long start = System.currentTimeMillis();
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6279\u91cf\u751f\u6210\u9886\u6599\u5355\u5f00\u59cb\uff1a");
            this.autoBackFlush(inBill, billEntryId, res, this.pageId);
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6279\u91cf\u751f\u6210\u9886\u6599\u5355\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        } else if ("unbackflush".equals(this.operateKey)) {
            this.unBackFlush(billEntryList, res, this.pageId);
        }
        PageCache pageCache = new PageCache(this.pageId);
        pageCache.put("backflushlog", OMStockBackFlushUtils.delResLog(res, this.operateKey));
        pageCache.put("opProgressPro", "100");
    }

    private Map<String, Boolean> getSourceBillDataMap(String billType, Set<Object> sourceBillIds) {
        HashMap resMap = Maps.newHashMap();
        if (!StringUtils.equals((CharSequence)"", (CharSequence)billType)) {
            QFilter qFilter = new QFilter("id", "in", sourceBillIds);
            DataSet rows = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)billType, (String)"id,isvirtualbill", (QFilter[])new QFilter[]{qFilter}, null);
            for (Row row : rows) {
                resMap.put(row.getString("id"), row.getBoolean("isvirtualbill"));
            }
        }
        return resMap;
    }

    private void unBackFlush(List<DynamicObject> billEntryList, Map<DynamicObject, String> res, String pageCacheOption) {
        long sourcebillid;
        String sourcebillType;
        ArrayList<DynamicObject> tkList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> rKList = new ArrayList<DynamicObject>(16);
        HashMap<Long, Boolean> inBIllID_bizdirection = new HashMap<Long, Boolean>(16);
        for (DynamicObject needPush : billEntryList) {
            sourcebillType = needPush.getString("sourcebillentry");
            if (!"A".equals(sourcebillType)) continue;
            sourcebillid = needPush.getLong("sourcebillid");
            inBIllID_bizdirection.put(sourcebillid, Boolean.TRUE);
        }
        if (!inBIllID_bizdirection.isEmpty()) {
            String algoKey = "query-ominbill";
            String selects = "id,invscheme.bizdirection";
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", inBIllID_bizdirection.keySet())};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_omcmplinbill", (String)selects, (QFilter[])qFilters, null);){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    Long id = next.getLong("id");
                    String bizdirection = next.getString("invscheme.bizdirection");
                    if ("1".equals(bizdirection)) {
                        inBIllID_bizdirection.put(id, Boolean.FALSE);
                        continue;
                    }
                    inBIllID_bizdirection.put(id, Boolean.TRUE);
                }
            }
        }
        for (DynamicObject needPush : billEntryList) {
            sourcebillType = needPush.getString("sourcebillentry");
            if ("A".equals(sourcebillType)) {
                sourcebillid = needPush.getLong("sourcebillid");
                if (((Boolean)inBIllID_bizdirection.get(sourcebillid)).booleanValue()) {
                    rKList.add(needPush);
                    continue;
                }
                tkList.add(needPush);
                continue;
            }
            rKList.add(needPush);
        }
        if (!rKList.isEmpty()) {
            this.targetName = "im_mdc_omoutbill";
            HashMap<DynamicObject, String> rkres = new HashMap<DynamicObject, String>(rKList.size());
            for (DynamicObject rkObj : rKList) {
                rkres.put(rkObj, "");
            }
            this.doUnBackFlush(rKList, rkres, pageCacheOption);
            res.putAll(rkres);
        }
        if (!tkList.isEmpty()) {
            this.targetName = "im_mdc_omreturnbill";
            HashMap<DynamicObject, String> tkres = new HashMap<DynamicObject, String>(tkList.size());
            for (DynamicObject tkObj : tkList) {
                tkres.put(tkObj, "");
            }
            this.doUnBackFlush(tkList, tkres, pageCacheOption);
            res.putAll(tkres);
        }
    }

    private void doUnBackFlush(List<DynamicObject> billEntryList, Map<DynamicObject, String> res, String pageCacheOption) {
        HashSet<Long> sourceBillEntryidSet = new HashSet<Long>(16);
        HashSet<Long> stockEntryIdSet = new HashSet<Long>(16);
        for (DynamicObject billEntry : billEntryList) {
            sourceBillEntryidSet.add(billEntry.getLong("sourcebillentryid"));
            stockEntryIdSet.add(billEntry.getLong("stockentryid"));
        }
        QFilter filter = new QFilter("billentry.srcbillentryid", "in", sourceBillEntryidSet);
        filter.and(new QFilter("billentry.mainbillentryid", "in", stockEntryIdSet));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)this.targetName, (String)"id,billno,billentry.srcbillid,billentry.srcbillentryid,billentry.mainbillentryid", (QFilter[])new QFilter[]{filter});
        if (bills == null || bills.length == 0) {
            for (Map.Entry<DynamicObject, String> entry : res.entrySet()) {
                DynamicObject key = entry.getKey();
                res.put(key, ResManager.loadKDString((String)"\u6ca1\u6709\u5012\u51b2\u9886\u6599\u5355\u3002", (String)"OMTaskBackFlush_12", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
        } else {
            Set<String> idSet = this.getIdSet(bills);
            Map<String, Set<String>> billIdMap = this.getIdMap(bills);
            for (Map.Entry<DynamicObject, String> entry : res.entrySet()) {
                DynamicObject key = entry.getKey();
                String sourceBillIdEntryId = key.getString("sourcebillentryid");
                String stockEntryId = key.getString("stockentryid");
                if (idSet.contains(sourceBillIdEntryId + "," + stockEntryId)) continue;
                res.put(key, ResManager.loadKDString((String)"\u6ca1\u6709\u5012\u51b2\u9886\u6599\u5355\u3002", (String)"OMTaskBackFlush_12", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            int numInt = res.size();
            int dealSize = this.getResSize(res);
            PageCache pageCache = new PageCache(pageCacheOption);
            pageCache.put("opProgressPro", String.valueOf((dealSize - 1) * 100 / numInt));
            if (this.isStop(pageCacheOption)) {
                return;
            }
            this.delBackFlush(bills, res, billIdMap, pageCacheOption);
        }
    }

    private void autoBackFlush(Map<String, List<Long>> inBill, Map<String, DynamicObject> billEntryId, Map<DynamicObject, String> res, String pageCacheOption) {
        int numInt = 0;
        int indexInt = 0;
        for (Map.Entry<String, List<Long>> enrty : inBill.entrySet()) {
            List<Long> stockEntry = enrty.getValue();
            numInt += stockEntry.size();
        }
        PageCache pageCache = new PageCache(pageCacheOption);
        this.pagecachebfinvqty = pageCache.get("pagecachebfinvqty");
        ArrayList<DynamicObject> needPushList = new ArrayList<DynamicObject>();
        for (Map.Entry entry : inBill.entrySet()) {
            List stockEntry = (List)entry.getValue();
            for (Long stockEntryId : stockEntry) {
                String qtyKey = (String)entry.getKey() + "," + stockEntryId.toString();
                DynamicObject billEntryDym = billEntryId.get(qtyKey);
                if (this.backFlushVal(billEntryDym, res)) {
                    needPushList.add(billEntryDym);
                    continue;
                }
                pageCache.put("opProgressPro", String.valueOf((++indexInt - 1) * 100 / numInt));
                if (!this.isStop(pageCacheOption)) continue;
                return;
            }
        }
        this.batchBackFlush(needPushList, res, pageCache, pageCacheOption, numInt);
        for (int i = 0; i < 8; ++i) {
            List<DynamicObject> list = this.getResUn(res);
            this.batchBackFlush(list, res, pageCache, pageCacheOption, numInt);
        }
    }

    private void batchBackFlush(List<DynamicObject> needPushList, Map<DynamicObject, String> res, PageCache pageCache, String pageCacheOption, int numInt) {
        if (!needPushList.isEmpty()) {
            long sourcebillid;
            String sourcebillType;
            ArrayList<DynamicObject> needPushTkList = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> needPushRKList = new ArrayList<DynamicObject>(16);
            HashMap<Long, Boolean> inBIllID_bizdirection = new HashMap<Long, Boolean>(16);
            for (DynamicObject needPush : needPushList) {
                sourcebillType = needPush.getString("sourcebillentry");
                if (!"A".equals(sourcebillType)) continue;
                sourcebillid = needPush.getLong("sourcebillid");
                inBIllID_bizdirection.put(sourcebillid, Boolean.TRUE);
            }
            if (!inBIllID_bizdirection.isEmpty()) {
                String algoKey = "query-ominbill";
                String selects = "id,invscheme.bizdirection";
                QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", inBIllID_bizdirection.keySet())};
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_omcmplinbill", (String)selects, (QFilter[])qFilters, null);){
                    while (dataSet.hasNext()) {
                        Row next = dataSet.next();
                        Long id = next.getLong("id");
                        String bizdirection = next.getString("invscheme.bizdirection");
                        if ("1".equals(bizdirection)) {
                            inBIllID_bizdirection.put(id, Boolean.FALSE);
                            continue;
                        }
                        inBIllID_bizdirection.put(id, Boolean.TRUE);
                    }
                }
            }
            for (DynamicObject needPush : needPushList) {
                sourcebillType = needPush.getString("sourcebillentry");
                if ("A".equals(sourcebillType)) {
                    sourcebillid = needPush.getLong("sourcebillid");
                    if (((Boolean)inBIllID_bizdirection.get(sourcebillid)).booleanValue()) {
                        needPushRKList.add(needPush);
                        continue;
                    }
                    needPushTkList.add(needPush);
                    continue;
                }
                needPushRKList.add(needPush);
            }
            if (!needPushRKList.isEmpty()) {
                this.botpId = "1236978371423038464";
                this.targetName = "im_mdc_omoutbill";
                if (this.doBatchBackFlush(res, pageCache, pageCacheOption, numInt, needPushRKList)) {
                    return;
                }
            }
            if (!needPushTkList.isEmpty()) {
                this.botpId = "1513122267733721088";
                this.targetName = "im_mdc_omreturnbill";
                if (this.doBatchBackFlush(res, pageCache, pageCacheOption, numInt, needPushTkList)) {
                    return;
                }
            }
        }
    }

    private boolean doBatchBackFlush(Map<DynamicObject, String> res, PageCache pageCache, String pageCacheOption, int numInt, List<DynamicObject> needPushRKList) {
        int pushNum = Integer.parseInt(pageCache.get("batchbfqty"));
        List<List<DynamicObject>> batchNeedPushList = StockBackFlushUtils.subList(needPushRKList, pushNum);
        int size = batchNeedPushList.size();
        for (int i = 0; i < size; ++i) {
            List<DynamicObject> needPush = batchNeedPushList.get(i);
            long start = System.currentTimeMillis();
            this.autoBackFlushStock(needPush, res);
            int dealSize = this.getResSize(res);
            pageCache.put("opProgressPro", String.valueOf((dealSize - 1) * 100 / numInt));
            if (this.isStop(pageCacheOption)) {
                return true;
            }
            String format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u751f\u6210\u5012\u51b2\u9886\u6599\u5355\uff1a\u5171%1$s\u6279\uff0c\u7b2c%2$s\u6279\uff0c\u8017\u65f6%3$s\u3002", (String)"OMTaskBackFlush_14", (String)"scmc-mm-mdc", (Object[])new Object[0]), size, i + 1, System.currentTimeMillis() - start);
            logger.info(format);
        }
        return false;
    }

    private int getResSize(Map<DynamicObject, String> res) {
        int i = 0;
        for (Map.Entry<DynamicObject, String> entry : res.entrySet()) {
            if ("".equals(entry.getValue())) continue;
            ++i;
        }
        return i;
    }

    private List<DynamicObject> getResUn(Map<DynamicObject, String> res) {
        ArrayList<DynamicObject> unRes = new ArrayList<DynamicObject>(16);
        for (Map.Entry<DynamicObject, String> entry : res.entrySet()) {
            if (!"".equals(entry.getValue())) continue;
            DynamicObject key = entry.getKey();
            key.set("isuselog", (Object)"");
            unRes.add(key);
        }
        return unRes;
    }

    private boolean isStop(String pageCacheOption) {
        PageCache pageCache = new PageCache(pageCacheOption);
        String startProgress = pageCache.get("opProgressStop");
        return "1".equals(startProgress);
    }

    private void autoBackFlushStock(List<DynamicObject> needPushList, Map<DynamicObject, String> res) {
        HashMap<Object, List<DynamicObject>> stockBFMap = new HashMap<Object, List<DynamicObject>>(16);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("om_mftstock");
        pushArgs.setTargetEntityNumber(this.targetName);
        pushArgs.setHasRight(false);
        pushArgs.setRuleId(this.botpId);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject needPush : needPushList) {
            Iterator<DynamicObject> stockEntryId = needPush.get("stockentryid");
            ListSelectedRow srcBill1 = new ListSelectedRow(needPush.get("stockid"));
            srcBill1.setEntryEntityKey("stockentry");
            srcBill1.setEntryPrimaryKeyValue((Object)stockEntryId);
            needPushRows.add(srcBill1);
            List stockBFList = stockBFMap.get(stockEntryId) == null ? new ArrayList(1) : (List)stockBFMap.get(stockEntryId);
            stockBFList.add(needPush);
            stockBFMap.put(stockEntryId, stockBFList);
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder().append(ResManager.loadKDString((String)"\u4e0b\u63a8\u9886\u6599\u5355\u5931\u8d25\uff1a", (String)"OMTaskBackFlush_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            errMessage.append(pushResult.getMessage());
            for (DynamicObject needPush : needPushList) {
                res.put(needPush, errMessage.toString());
            }
        }
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            List linkEntityRowReports = billReport.getLinkEntityRowReports();
            for (SourceRowReport sr : linkEntityRowReports) {
                Object entryId = sr.getEntryId();
                String resStr = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u9886\u6599\u5355\u5931\u8d25\uff1a%1$s", (String)"OMTaskBackFlush_15", (String)"scmc-mm-mdc", (Object[])new Object[0]), sr.getFailMessage());
                List list = (List)stockBFMap.get(entryId);
                for (DynamicObject entry : list) {
                    res.put(entry, resStr);
                }
            }
        }
        this.delPushRes(pushResult, stockBFMap, res);
    }

    private void delPushRes(ConvertOperationResult pushResult, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res) {
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)this.targetName);
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (targetBillObjs.isEmpty()) {
            return;
        }
        this.handleTarget(targetBillObjs, stockBFMap);
        ArrayList<DynamicObject> needBackFlushTargetBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject targetBillObj : targetBillObjs) {
            boolean isAutoMatch = targetBillObj.getBoolean("isautomatch");
            if (!isAutoMatch) continue;
            needBackFlushTargetBills.add(targetBillObj);
        }
        if (needBackFlushTargetBills != null && needBackFlushTargetBills.size() > 0) {
            StockBackFlushUtils.handleMatchingRule(needBackFlushTargetBills, this.pagecachebfinvqty, stockBFMap, res);
        }
        if (targetBillObjs.isEmpty()) {
            return;
        }
        StockBackFlushUtils.handleInvQty(targetBillObjs, this.pagecachebfinvqty, stockBFMap, res);
        if (targetBillObjs.isEmpty()) {
            return;
        }
        String billCanbfqtyStr = JSON.toJSONString(this.billCanbfqty);
        OperateOption saveOption = StockBackFlushUtils.getOperateOption();
        saveOption.setVariableValue("billCanbfqtyStr", billCanbfqtyStr);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.targetName, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)saveOption);
        StockBackFlushUtils.setErrlog(saveResult, targetBillObjs, stockBFMap, res, "save");
        if (targetBillObjs.isEmpty()) {
            return;
        }
        OperateOption submitOption = StockBackFlushUtils.getOperateOption();
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)this.targetName, (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)submitOption);
        StockBackFlushUtils.setErrlog(submitResult, targetBillObjs, stockBFMap, res, "submit");
        StockBackFlushUtils.deleteRes(saveResult, submitResult, this.targetName);
        if (targetBillObjs.isEmpty()) {
            return;
        }
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)this.targetName, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)submitOption);
        StockBackFlushUtils.setErrlog(auditResult, targetBillObjs, stockBFMap, res, "audit");
        StockBackFlushUtils.deleteRes(submitResult, auditResult, this.targetName);
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObjectCollection tbillEntrys = targetBillObj.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : tbillEntrys) {
                StockBackFlushUtils.setErr(entry, res, stockBFMap, "success");
            }
        }
    }

    private void handleTarget(List<DynamicObject> targetBillObjs, Map<Object, List<DynamicObject>> stockBFMap) {
        for (int j = 0; j < targetBillObjs.size(); ++j) {
            DynamicObject targetBillObj = targetBillObjs.get(j);
            for (DynamicObject mftorderEntryObj : targetBillObj.getDynamicObjectCollection("billentry")) {
                targetBillObj.set("biztime", this.delTarget(mftorderEntryObj, stockBFMap));
            }
        }
        StockBackFlushUtils.initBookDate(targetBillObjs);
    }

    private Object delTarget(DynamicObject mftorderEntryObj, Map<Object, List<DynamicObject>> stockBFMap) {
        Object bizName = null;
        DynamicObject masterid = mftorderEntryObj.getDynamicObject("material").getDynamicObject("masterid");
        DynamicObject unit = mftorderEntryObj.getDynamicObject("unit");
        DynamicObject baseunit = mftorderEntryObj.getDynamicObject("baseunit");
        Object stockEntryId = mftorderEntryObj.get("mainbillentryid");
        List<DynamicObject> list = stockBFMap.get(stockEntryId);
        for (DynamicObject stockBFDym : list) {
            if ("handleTarget".equals(stockBFDym.getString("isuselog"))) continue;
            mftorderEntryObj.set("qty", (Object)this.getQtyByUnit(masterid, baseunit, unit, stockBFDym.getBigDecimal("nowbfqty")));
            mftorderEntryObj.set("baseqty", (Object)this.processPrecision(stockBFDym.getBigDecimal("nowbfqty"), baseunit));
            mftorderEntryObj.set("qtyunit2nd", (Object)stockBFDym.getBigDecimal("qtyunit2nd"));
            mftorderEntryObj.set("srcbillnumber", stockBFDym.get("sourcebillno"));
            mftorderEntryObj.set("srcbillid", stockBFDym.get("sourcebillid"));
            mftorderEntryObj.set("srcbillentryid", stockBFDym.get("sourcebillentryid"));
            mftorderEntryObj.set("srcbillentity", (Object)StockBackFlushUtils.getEntity(stockBFDym.getString("sourcebillentry")));
            mftorderEntryObj.set("lotnumber", stockBFDym.get("batchno"));
            bizName = stockBFDym.get("backflushtime");
            stockBFDym.set("isuselog", (Object)"handleTarget");
        }
        return bizName;
    }

    private boolean backFlushVal(DynamicObject billEntryDym, Map<DynamicObject, String> res) {
        boolean isReturnBill = false;
        String sourcebillentry = billEntryDym.getString("sourcebillentry");
        if ("A".equals(sourcebillentry)) {
            long sourcebillid = billEntryDym.getLong("sourcebillid");
            String algoKey = "query-im_mdc_omcmplinbill";
            String selects = "invscheme.bizdirection";
            QFilter[] qfs = new QFilter[]{new QFilter("id", "=", (Object)sourcebillid)};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_omcmplinbill", (String)selects, (QFilter[])qfs, null);){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    String bizdirection = next.getString("invscheme.bizdirection");
                    if (!"1".equals(bizdirection)) continue;
                    isReturnBill = true;
                }
            }
        }
        DynamicObject transactionType = billEntryDym.getDynamicObject("transactiontypeid");
        boolean backflushmore = transactionType.getBoolean("backflushmore");
        BigDecimal nowbfQty = billEntryDym.getBigDecimal("nowbfqty");
        long stockEntryId = billEntryDym.getLong("stockentryid");
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"om_mftstock", (String)"stockentry.cansendqty", (QFilter[])new QFilter[]{new QFilter("stockentry.id", "=", (Object)stockEntryId)});
        BigDecimal cansendqty = billEntryDym.getBigDecimal("cansendqty");
        if (queryOne != null) {
            cansendqty = queryOne.getBigDecimal("stockentry.cansendqty");
        }
        boolean bfclose = billEntryDym.getBoolean("bfclose");
        String bfflag = billEntryDym.getString("bfflag");
        if (bfclose || "C".equals(bfflag)) {
            res.put(billEntryDym, ResManager.loadKDString((String)"\u5df2\u5012\u51b2\u5b8c\u6210\u6216\u5012\u51b2\u5173\u95ed,\u5012\u51b2\u5931\u8d25\u3002", (String)"OMTaskBackFlush_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return false;
        }
        if (nowbfQty.compareTo(BigDecimal.ZERO) == 0) {
            res.put(billEntryDym, ResManager.loadKDString((String)"\u672c\u6b21\u5012\u51b2\u6570\u91cf\u4e3a\u96f6,\u5012\u51b2\u5931\u8d25\u3002", (String)"OMTaskBackFlush_6", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return false;
        }
        if (!isReturnBill && !backflushmore) {
            if (nowbfQty.compareTo(cansendqty) > 0) {
                res.put(billEntryDym, ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b:\u5012\u51b2\u6570\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u9700\u6c42\u6570\u91cf,\u5012\u51b2\u5931\u8d25\u3002", (String)"OMTaskBackFlush_7", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return false;
            }
        } else {
            String overissuecontrl = billEntryDym.getString("overissuecontrl");
            if ("B".equals(overissuecontrl) && nowbfQty.compareTo(cansendqty) > 0) {
                res.put(billEntryDym, ResManager.loadKDString((String)"\u8d85\u53d1\u63a7\u5236:\u4e0d\u53ef\u8d85\u53d1,\u5012\u51b2\u5931\u8d25\u3002", (String)"OMTaskBackFlush_8", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private BigDecimal processPrecision(BigDecimal qty, DynamicObject unit) {
        int precision = unit.getInt("precision");
        return qty.setScale(precision, this.getRoundType(unit));
    }

    private BigDecimal getQtyByUnit(DynamicObject masterid, DynamicObject baseunit, DynamicObject unit, BigDecimal baseqty) {
        if (unit == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)masterid.getPkValue()), (Long)((Long)baseunit.getPkValue()), (Long)((Long)unit.getPkValue()));
        if (muConv == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal numerator = muConv.getBigDecimal("numerator");
        BigDecimal denominator = muConv.getBigDecimal("denominator");
        int precision = unit.getInt("precision");
        return baseqty.multiply(numerator).divide(denominator, precision, this.getRoundType(unit));
    }

    private int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    private Set<String> getIdSet(DynamicObject[] bills) {
        HashSet<String> idSet = new HashSet<String>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject billEntry : billEntrys) {
                String srcbillentryid = billEntry.getString("srcbillentryid");
                String mainbillentryid = billEntry.getString("mainbillentryid");
                idSet.add(srcbillentryid + "," + mainbillentryid);
            }
        }
        return idSet;
    }

    private Map<String, Set<String>> getIdMap(DynamicObject[] bills) {
        HashMap<String, Set<String>> billIdMap = new HashMap<String, Set<String>>(bills.length);
        for (DynamicObject bill : bills) {
            HashSet<String> idSet = new HashSet<String>(bills.length);
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject billEntry : billEntrys) {
                String srcbillentryid = billEntry.getString("srcbillentryid");
                String mainbillentryid = billEntry.getString("mainbillentryid");
                idSet.add(srcbillentryid + "," + mainbillentryid);
            }
            billIdMap.put(bill.getPkValue().toString(), idSet);
        }
        return billIdMap;
    }

    private void delBackFlush(DynamicObject[] bills, Map<DynamicObject, String> res, Map<String, Set<String>> billIdMap, String pageCacheOption) {
        int numInt = res.size();
        PageCache pageCache = new PageCache(pageCacheOption);
        ArrayList<Long> mftProOrderPKList = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            mftProOrderPKList.add((Long)bill.getPkValue());
        }
        int pushNum = Integer.parseInt(pageCache.get("batchbfqty"));
        List batchNeedPushList = StockBackFlushUtils.subList(mftProOrderPKList, pushNum);
        int size = batchNeedPushList.size();
        for (int i = 0; i < size; ++i) {
            List needPush = batchNeedPushList.get(i);
            long start = System.currentTimeMillis();
            OperateOption option = StockBackFlushUtils.getOperateOption();
            OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)this.targetName, (Object[])needPush.toArray(), (OperateOption)option);
            if (unAuditResult != null) {
                List errorInfos = unAuditResult.getAllErrorOrValidateInfo();
                this.fillErrMes(res, errorInfos, billIdMap);
                List successPkIds = unAuditResult.getSuccessPkIds();
                if (!successPkIds.isEmpty()) {
                    OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.targetName, (Object[])successPkIds.toArray(), (OperateOption)option);
                    List delErrorInfos = delResult.getAllErrorOrValidateInfo();
                    this.fillErrMes(res, delErrorInfos, billIdMap);
                }
            }
            int dealSize = this.getResSize(res);
            pageCache.put("opProgressPro", String.valueOf((dealSize - 1) * 100 / numInt));
            if (this.isStop(pageCacheOption)) {
                return;
            }
            String format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u751f\u6210\u5012\u51b2\u9886\u6599\u5355\uff1a\u5171%1$s\u6279\uff0c\u7b2c%2$s\u6279\uff0c\u8017\u65f6%3$s\u3002", (String)"OMTaskBackFlush_14", (String)"scmc-mm-mdc", (Object[])new Object[0]), size, i + 1, System.currentTimeMillis() - start);
            logger.info(format);
        }
    }

    private void fillErrMes(Map<DynamicObject, String> res, List<IOperateInfo> errorInfos, Map<String, Set<String>> billIdMap) {
        for (IOperateInfo errorInfo : errorInfos) {
            String pkValue = errorInfo.getPkValue() == null ? "0" : errorInfo.getPkValue().toString();
            Set<String> set = billIdMap.get(pkValue);
            if (set == null) continue;
            this.delErrMes(errorInfo, set, res);
        }
    }

    private void delErrMes(IOperateInfo errorInfo, Set<String> set, Map<DynamicObject, String> res) {
        for (Map.Entry<DynamicObject, String> entry : res.entrySet()) {
            DynamicObject key = entry.getKey();
            String sourceBillIdEntryId = key.getString("sourcebillentryid");
            String stockEntryId = key.getString("stockentryid");
            if (!set.contains(sourceBillIdEntryId + "," + stockEntryId)) continue;
            res.put(key, errorInfo.getTitle() + "," + errorInfo.getMessage());
        }
    }
}

