/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.feed.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FeedorderExcessSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        String entityKey = this.getEntityKey();
        String stockEntityKey = "im_mdc_omfeedbill".equals(entityKey) ? "om_mftstock" : "pom_mftstock";
        HashSet<Long> stockEntryIds = new HashSet<Long>(16);
        HashSet<Long> stockPropEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject feedOrder = dataEntity.getDataEntity();
            if (!"B".equals(feedOrder.getString("reqtype")) || feedOrder.getBoolean("isvirtualbill")) continue;
            DynamicObjectCollection billentrys = feedOrder.getDynamicObjectCollection("billentry");
            boolean isProductionDomain = feedOrder.containsProperty("productiondomain");
            if (isProductionDomain && "E".equals(feedOrder.getString("productiondomain"))) {
                for (DynamicObject billentry : billentrys) {
                    stockPropEntryIds.add(billentry.getLong("mainbillentryid"));
                }
                continue;
            }
            for (DynamicObject billentry : billentrys) {
                stockEntryIds.add(billentry.getLong("mainbillentryid"));
            }
        }
        this.excessValidator(stockEntityKey, stockEntryIds, dataEntities);
        this.excessValidator("prop_mftstock", stockPropEntryIds, dataEntities);
    }

    private void excessValidator(String stockEntityKey, Set<Long> stockEntryIds, ExtendedDataEntity[] dataEntities) {
        if (!stockEntryIds.isEmpty()) {
            HashMap<Long, BigDecimal> entryId2unissueqty = new HashMap<Long, BigDecimal>(stockEntryIds.size());
            HashMap<Long, String> entryId2billno = new HashMap<Long, String>(stockEntryIds.size());
            HashMap<Long, Integer> entryId2seq = new HashMap<Long, Integer>(stockEntryIds.size());
            this.queryStock(stockEntryIds, stockEntityKey, entryId2unissueqty, entryId2billno, entryId2seq);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject feedOrder = dataEntity.getDataEntity();
                if (!"B".equals(feedOrder.getString("reqtype")) || feedOrder.getBoolean("isvirtualbill")) continue;
                int i = 0;
                DynamicObjectCollection billentrys = feedOrder.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentrys) {
                    ++i;
                    Long srcbillentryid = billentry.getLong("mainbillentryid");
                    if (entryId2unissueqty.get(srcbillentryid) == null || ((BigDecimal)entryId2unissueqty.get(srcbillentryid)).compareTo(BigDecimal.ZERO) <= 0) continue;
                    String entityKey2 = this.getEntityKey();
                    String content = String.format(ResManager.loadKDString((String)"[\u751f\u4ea7\u8865\u6599\u5355%1$s\uff0c\u7269\u6599\u660e\u7ec6\u7b2c%2$s\u884c] \u6821\u9a8c[\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355%3$s\uff0c\u7ec4\u4ef6\u660e\u7ec6\u7b2c%4$s\u884c]\uff1a\u9700\u6c42\u57fa\u672c\u6570\u91cf\u672a\u5b8c\u5168\u9886\u7528\uff0c\u4e0d\u5141\u8bb8\u8d85\u989d\u9886\u6599\u3002", (String)"FeedorderExcessSubmitValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), feedOrder.getString("billno"), i, entryId2billno.get(srcbillentryid), entryId2seq.get(srcbillentryid));
                    if ("im_mdc_omfeedbill".equals(entityKey2)) {
                        content = String.format(ResManager.loadKDString((String)"[\u59d4\u5916\u8865\u6599\u5355%1$s\uff0c\u7269\u6599\u660e\u7ec6\u7b2c%2$s\u884c] \u6821\u9a8c[\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355%3$s\uff0c\u7528\u6599\u660e\u7ec6\u7b2c%4$s\u884c]\uff1a\u9700\u6c42\u57fa\u672c\u6570\u91cf\u672a\u5b8c\u5168\u9886\u7528\uff0c\u4e0d\u5141\u8bb8\u8d85\u989d\u9886\u6599\u3002", (String)"FeedorderExcessSubmitValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), feedOrder.getString("billno"), i, entryId2billno.get(srcbillentryid), entryId2seq.get(srcbillentryid));
                    }
                    if ("prop_mftstock".equals(stockEntityKey)) {
                        content = String.format(ResManager.loadKDString((String)"[\u751f\u4ea7\u8865\u6599\u5355%1$s\uff0c\u7269\u6599\u660e\u7ec6\u7b2c%2$s\u884c] \u6821\u9a8c[\u6d41\u7a0b\u7528\u6599\u6e05\u5355%3$s\uff0c\u7528\u6599\u660e\u7ec6\u7b2c%4$s\u884c]\uff1a\u9700\u6c42\u57fa\u672c\u6570\u91cf\u672a\u5b8c\u5168\u9886\u7528\uff0c\u4e0d\u5141\u8bb8\u8d85\u989d\u9886\u6599\u3002", (String)"FeedorderExcessSubmitValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), feedOrder.getString("billno"), i, entryId2billno.get(srcbillentryid), entryId2seq.get(srcbillentryid));
                    }
                    this.addErrorMessage(dataEntity, content);
                }
            }
        }
    }

    private void queryStock(Set<Long> stockEntryIds, String stockEntityKey, Map<Long, BigDecimal> entryId2unissueqty, Map<Long, String> entryId2billno, Map<Long, Integer> entryId2seq) {
        String selectFields = "stockentry.id stockentryid,billno,stockentry.unissueqty unissueqty,stockentry.seq seq";
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"queryStock", (String)stockEntityKey, (String)selectFields, (QFilter[])new QFilter("stockentry.id", "in", stockEntryIds).toArray(), null);){
            for (Row row : dataset) {
                Long entryId = row.getLong("stockentryid");
                entryId2unissueqty.put(entryId, row.getBigDecimal("unissueqty"));
                entryId2billno.put(entryId, row.getString("billno"));
                entryId2seq.put(entryId, row.getInteger("seq"));
            }
        }
    }
}

