/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.importexcel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class OffReqAllowedImportOp
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        DynamicObject[] mftOrders = this.queryMftOrder(billdatas);
        HashMap entrySeqMap = new HashMap(16);
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (DynamicObject object : mftOrders) {
            Set collect = object.getDynamicObjectCollection("treeentryentity").stream().map(x -> x.getInt("seq")).collect(Collectors.toSet());
            orderEntryIds.addAll(object.getDynamicObjectCollection("treeentryentity").stream().map(x -> x.getLong("id")).collect(Collectors.toSet()));
            entrySeqMap.put(object.getString("billno"), collect);
        }
        DynamicObject[] mftStocks = this.queryMftStock(orderEntryIds);
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData next = iterator.next();
            JSONObject data = next.getData();
            int index = next.getStartIndex();
            JSONArray billEntry = data.getJSONArray("billentry");
            for (int i = 0; i < billEntry.size(); ++i) {
                JSONObject entry = billEntry.getJSONObject(i);
                String manubill = entry.getString("manubill");
                Integer manuentry = entry.getInteger("manuentry");
                String vin = entry.getString("vin");
                String innervehiclenumber = entry.getString("innervehiclenumber");
                if (!entrySeqMap.containsKey(manubill)) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355%s\u4e0d\u5b58\u5728\u3002", (String)"OffReqAllowedImportOp_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), manubill)).fail();
                    iterator.remove();
                    return;
                }
                if (manuentry <= 0) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u884c\u53f7\u4e0d\u5408\u6cd5\u3002", (String)"OffReqAllowedImportOp_1", (String)"scmc-mm-mdc", (Object[])new Object[0])).fail();
                    iterator.remove();
                    return;
                }
                if (!((Set)entrySeqMap.get(manubill)).contains(manuentry)) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355%1$s\u4e0d\u5b58\u5728%2$s\u7684\u884c\u53f7\u3002", (String)"OffReqAllowedImportOp_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), manubill, manuentry)).fail();
                    iterator.remove();
                    return;
                }
                boolean existStock = false;
                for (DynamicObject object : mftStocks) {
                    DynamicObject orderEntry = object.getDynamicObject("orderentryid");
                    if (!manubill.equals(orderEntry.getString("headbillno")) || manuentry.intValue() != orderEntry.getInt("entryseq")) continue;
                    existStock = true;
                    break;
                }
                if (!existStock) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355%s\u4e0d\u5b58\u5728\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"OffReqAllowedImportOp_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), manubill)).fail();
                    iterator.remove();
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)vin) && vin.length() > 255) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8f66\u8f86\u51fa\u5382\u7f16\u53f7\u8d85\u957f\u3002", (String)"OffReqAllowedImportOp_4", (String)"scmc-mm-mdc", (Object[])new Object[0])).fail();
                    iterator.remove();
                    return;
                }
                if (!StringUtils.isNotBlank((CharSequence)innervehiclenumber) || innervehiclenumber.length() <= 255) continue;
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5185\u90e8\u8f66\u8f86\u7f16\u53f7\u8d85\u957f\u3002", (String)"OffReqAllowedImportOp_5", (String)"scmc-mm-mdc", (Object[])new Object[0])).fail();
                iterator.remove();
                return;
            }
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (rowdatas == null || rowdatas.isEmpty()) {
            return null;
        }
        DynamicObject[] mftOrders = this.queryMftOrder(rowdatas);
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (DynamicObject object : mftOrders) {
            orderEntryIds.addAll(object.getDynamicObjectCollection("treeentryentity").stream().map(x -> x.getLong("id")).collect(Collectors.toSet()));
        }
        DynamicObject[] mftStocks = this.queryMftStock(orderEntryIds);
        for (ImportBillData next : rowdatas) {
            JSONObject data = next.getData();
            this.initHeadData(data);
            JSONArray billEntry = data.getJSONArray("billentry");
            for (int i = 0; i < billEntry.size(); ++i) {
                JSONObject entry = billEntry.getJSONObject(i);
                String manubill = entry.getString("manubill");
                Integer manuentry = entry.getInteger("manuentry");
                this.initEntryData(entry);
                for (DynamicObject object : mftOrders) {
                    if (!manubill.equals(object.getString("billno"))) continue;
                    DynamicObjectCollection entryEntity = object.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject e : entryEntity) {
                        if (manuentry.intValue() != e.getInt("seq")) continue;
                        this.initEntryData(entry, object, e);
                    }
                }
                for (DynamicObject object : mftStocks) {
                    DynamicObject orderEntry = object.getDynamicObject("orderentryid");
                    if (!manubill.equals(orderEntry.getString("headbillno")) || manuentry.intValue() != orderEntry.getInt("entryseq")) continue;
                    this.initEntryData(entry, object);
                }
            }
            data.put("billentry", (Object)billEntry);
        }
        return super.save(rowdatas, logger);
    }

    protected boolean isForceBatch() {
        return super.isForceBatch();
    }

    protected int getBatchImportSize() {
        return 5000;
    }

    public String getDefaultKeyFields() {
        return "radiofield";
    }

    public List<String> getDefaultLockUIs() {
        return Lists.newArrayList((Object[])new String[]{"radiofield1", "radiofield2"});
    }

    private void initHeadData(JSONObject data) {
        String supplierOwnerType;
        data.put("billstatus", (Object)"A");
        data.put("billcretype", (Object)"1");
        data.put("reqtype", (Object)"B");
        switch (supplierOwnerType = data.getString("supplyownertype")) {
            case "\u4e1a\u52a1\u5355\u5143": {
                data.put("supplyownertype", (Object)"bos_org");
                break;
            }
            case "\u5ba2\u6237": {
                data.put("supplyownertype", (Object)"bd_customer");
                break;
            }
            case "\u4f9b\u5e94\u5546": {
                data.put("supplyownertype", (Object)"bd_supplier");
            }
        }
    }

    private void initEntryData(JSONObject entry, DynamicObject order, DynamicObject orderEntry) {
        entry.put("manubillid", order.getPkValue());
        entry.put("manuentryid", orderEntry.getPkValue());
        entry.put("tracknumber", orderEntry.get("tracknumber"));
        entry.put("project", orderEntry.get("bdproject"));
    }

    private void initEntryData(JSONObject entry, DynamicObject stock) {
        entry.put("srcbillnumber", (Object)stock.getString("billno"));
        entry.put("mainbillnumber", (Object)stock.getString("billno"));
        entry.put("mainbillid", (Object)stock.getString("id"));
        entry.put("mainbillentity", (Object)"pom_mftstock");
    }

    private void initEntryData(JSONObject entry) {
        String outKeeperType;
        switch (outKeeperType = entry.getString("outkeepertype")) {
            case "\u5e93\u5b58\u7ec4\u7ec7": {
                entry.put("outkeepertype", (Object)"bos_org");
                break;
            }
            case "\u5ba2\u6237": {
                entry.put("outkeepertype", (Object)"bd_customer");
                break;
            }
            case "\u4f9b\u5e94\u5546": {
                entry.put("outkeepertype", (Object)"bd_supplier");
            }
        }
        entry.put("isadd", (Object)true);
    }

    private DynamicObject[] queryMftOrder(List<ImportBillData> billdatas) {
        HashSet<String> orderNos = new HashSet<String>(16);
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and(new QFilter("transactiontype.isoffreqallowed", "=", (Object)true));
        filter.and(new QFilter("treeentryentity.planstatus", "in", (Object)Sets.newHashSet((Object[])new String[]{"C"})));
        filter.and(new QFilter("treeentryentity.bizstatus", "=", (Object)"A"));
        filter.and(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
        for (ImportBillData importBillData : billdatas) {
            JSONArray billEntry = importBillData.getData().getJSONArray("billentry");
            for (int i = 0; i < billEntry.size(); ++i) {
                JSONObject entry = billEntry.getJSONObject(i);
                if (!StringUtils.isNotBlank((CharSequence)entry.getString("manubill"))) continue;
                orderNos.add(entry.getString("manubill"));
            }
        }
        filter.and(new QFilter("billno", "in", orderNos));
        return BusinessDataServiceHelper.load((String)"pom_mftorder", (String)"billno,treeentryentity.seq,treeentryentity.id,treeentryentity.producttype,treeentryentity.tracknumber,treeentryentity.bdproject", (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject[] queryMftStock(Set<Long> orderEntryIds) {
        QFilter qFilter = new QFilter("orderentryid.id", "in", orderEntryIds);
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        return BusinessDataServiceHelper.load((String)"pom_mftstock", (String)"billno,orderentryid,billstatus,stockentry,stockentry.id", (QFilter[])new QFilter[]{qFilter});
    }
}

