/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.utils.MDCDyObjUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ManuFactureorderInwarehsJoinProductValidator
extends AbstractValidator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"ManuFactureorderInwarehsJoinProductValidator", (String)"validate");){
            String operate;
            switch (operate = this.getOperateKey()) {
                case "submit": 
                case "submitandnew": 
                case "audit": {
                    HashSet<Long> materialMasterIds = new HashSet<Long>(16);
                    if (!"im_mdc_mftmanuinbill".equals(this.entityKey)) return;
                    DynamicObject productionorg = null;
                    ExtendedDataEntity[] extendedDataEntityArray = this.dataEntities;
                    int n = extendedDataEntityArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            if (productionorg == null) return;
                            Map<Long, Map<String, Object>> data = this.getMaterialMftInfo(materialMasterIds, productionorg);
                            this.validJointProduct(data);
                            return;
                        }
                        ExtendedDataEntity dataEntity = extendedDataEntityArray[n2];
                        DynamicObject obj = dataEntity.getDataEntity();
                        DynamicObjectCollection col = obj.getDynamicObjectCollection("billentry");
                        if (productionorg == null) {
                            productionorg = obj.getDynamicObject("productionorg");
                        }
                        for (DynamicObject eColRow : col) {
                            boolean isadd = eColRow.getBoolean("isadd");
                            String productType = eColRow.getString("producttype");
                            if (!isadd || "C".equals(productType)) continue;
                            materialMasterIds.add(MDCDyObjUtil.getDyObjId(eColRow.get("materialmasterid")));
                        }
                        ++n2;
                    }
                }
            }
            return;
        }
    }

    private Map<Long, Map<String, Object>> getMaterialMftInfo(Set<Long> materialMasterIds, DynamicObject productionorg) {
        String algoKey = "getMaterialMftInfo";
        HashMap<Long, Map<String, Object>> map = new HashMap<Long, Map<String, Object>>(materialMasterIds.size());
        if (CollectionUtils.isEmpty(materialMasterIds)) {
            return map;
        }
        QFilter qFilter = new QFilter("masterid", "in", materialMasterIds);
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)productionorg.getLong("id")));
        qFilter.and(new QFilter("isjointproduct", "=", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_materialmftinfo", (String)"id,masterid,isjointproduct", (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Constable> map1 = new HashMap<String, Constable>(8);
                map1.put("id", row.getLong("id"));
                map1.put("masterid", row.getLong("masterid"));
                map1.put("isjointproduct", row.getBoolean("isjointproduct"));
                map.put(row.getLong("masterid"), map1);
            }
        }
        return map;
    }

    private void validJointProduct(Map<Long, Map<String, Object>> data) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject manuInBill = dataEntity.getDataEntity();
            if (!"im_mdc_mftmanuinbill".equals(manuInBill.getDataEntityType().getName())) continue;
            DynamicObjectCollection entryCol = manuInBill.getDynamicObjectCollection("billentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                Map<String, Object> map;
                DynamicObject eColRow = (DynamicObject)entryCol.get(j);
                Boolean isadd = eColRow.getBoolean("isadd");
                Long materialmasterid = MDCDyObjUtil.getDyObjId(eColRow.get("materialmasterid"));
                String producttype = eColRow.getString("producttype");
                if (!isadd.booleanValue() || "C".equals(producttype) || !MapUtils.isEmpty(map = data.get(materialmasterid))) continue;
                String format = String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u201c%2$s\u201d\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u6216\u53ef\u8054\u526f\u4ea7\u54c1\u5c5e\u6027\u3002", (String)"ManuFactureorderInwarehsJoinProductValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, eColRow.getString("materialname"));
                this.addErrorMessage(dataEntity, format);
            }
        }
    }
}

