/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.common.mdc.helper.GetEntityNameHelper;
import kd.scmc.im.common.mdc.helper.OmOrderBookDateHelper;
import kd.scmc.im.opplugin.mdc.ext.MftInBillAuditAutoPushPurOrderExt;
import kd.scmc.im.opplugin.mdc.pojo.PropertiesPrepareBeforeArgs;

public class MftInBillAuditAutoPushPurOrderOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("billentry.baseqty");
        e.getFieldKeys().add("billentry.manubillid");
        e.getFieldKeys().add("billentry.manuentryid");
        e.getFieldKeys().add("billentry.producttype");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("audit".equals(operationKey)) {
            Object entryColl;
            DynamicObject[] dataEntities = e.getDataEntities();
            HashSet<Long> manubillids = new HashSet<Long>(16);
            for (DynamicObject dataEntity : dataEntities) {
                String name = dataEntity.getDynamicObjectType().getName();
                if ("im_mdc_mftreturnbill".equals(name)) continue;
                entryColl = dataEntity.getDynamicObjectCollection("billentry");
                Iterator iterator = entryColl.iterator();
                while (iterator.hasNext()) {
                    DynamicObject[] entry = (DynamicObject[])iterator.next();
                    long manubillid = entry.getLong("manubillid");
                    manubillids.add(manubillid);
                }
            }
            HashMap<Long, Boolean> mftOrderId_isinnerprocessMap = new HashMap<Long, Boolean>(16);
            if (!manubillids.isEmpty()) {
                String algoKey = "query-pom_mftorder";
                String selects = "id,transactiontype.isinnerprocess";
                QFilter[] qfs = new QFilter[]{new QFilter("id", "in", manubillids)};
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)GetEntityNameHelper.getOrderEntityName(e.getDataEntities()), (String)selects, (QFilter[])qfs, null);
                entryColl = null;
                try {
                    while (dataSet.hasNext()) {
                        Row next = dataSet.next();
                        mftOrderId_isinnerprocessMap.put(next.getLong("id"), next.getBoolean("transactiontype.isinnerprocess"));
                    }
                }
                catch (Throwable next) {
                    entryColl = next;
                    throw next;
                }
                finally {
                    if (dataSet != null) {
                        if (entryColl != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable next) {
                                ((Throwable)entryColl).addSuppressed(next);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            HashMap<Long, BigDecimal> manuentryid_baseQtyMap = new HashMap<Long, BigDecimal>(16);
            Map<String, String> propertiesMapping = new HashMap<String, String>();
            PropertiesPrepareBeforeArgs prepareBeforeArgs = new PropertiesPrepareBeforeArgs(propertiesMapping);
            PluginProxy mftInBillAuditAutoPushPurOrderExtPluginProxy = PluginProxy.create(null, MftInBillAuditAutoPushPurOrderExt.class, (String)"POM_MFTMANUINBILL_ADDPROPERTIES_EXT", null);
            List maps = mftInBillAuditAutoPushPurOrderExtPluginProxy.callReplace(t -> {
                if (t != null) {
                    return t.addPropertiesMapping(prepareBeforeArgs);
                }
                return new HashMap();
            });
            if (maps.size() > 0) {
                propertiesMapping = (Map)maps.get(0);
            }
            ArrayList<Long> entryids = new ArrayList<Long>();
            for (DynamicObject dataEntity : dataEntities) {
                String name = dataEntity.getDynamicObjectType().getName();
                if ("im_mdc_mftreturnbill".equals(name)) continue;
                DynamicObjectCollection entryColl2 = dataEntity.getDynamicObjectCollection("billentry");
                for (String[] entry : entryColl2) {
                    long manubillid = entry.getLong("manubillid");
                    Boolean isinnerprocess = (Boolean)mftOrderId_isinnerprocessMap.get(manubillid);
                    if (!isinnerprocess.booleanValue()) continue;
                    long manuentryid = entry.getLong("manuentryid");
                    BigDecimal baseQty = entry.getBigDecimal("baseqty");
                    BigDecimal baseSumQty = (BigDecimal)manuentryid_baseQtyMap.get(manuentryid);
                    entryids.add((Long)entry.getPkValue());
                    if (baseSumQty == null) {
                        manuentryid_baseQtyMap.put(manuentryid, baseQty);
                        continue;
                    }
                    manuentryid_baseQtyMap.put(manuentryid, baseSumQty.add(baseQty));
                }
            }
            Set ids = manuentryid_baseQtyMap.keySet();
            HashMap resMap = new HashMap();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query_dataset", (String)"im_mdc_mftmanuinbill", (String)this.getSelectField(propertiesMapping), (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", entryids)}, null);){
                String[] fieldNames = ds.getRowMeta().getFieldNames();
                while (ds.hasNext()) {
                    List<HashMap<String, Object>> value;
                    Row next = ds.next();
                    HashMap<String, Object> tempt = new HashMap<String, Object>(16);
                    for (String fieldName : fieldNames) {
                        tempt.put(fieldName, next.get(fieldName));
                    }
                    Long manuentryid = next.getLong("billentry.manuentryid") == null ? Long.valueOf(0L) : next.getLong("billentry.manuentryid");
                    if (!ids.contains(manuentryid)) continue;
                    if (resMap.get(manuentryid) == null) {
                        value = new ArrayList<HashMap<String, Object>>();
                        value.add(tempt);
                        resMap.put(manuentryid, value);
                        continue;
                    }
                    value = (List)resMap.get(manuentryid);
                    value.add(tempt);
                    resMap.put(manuentryid, value);
                }
            }
            if (!resMap.isEmpty()) {
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"MftOrderTechnicsService", (String)"createOmPurOrderBill", (Object[])new Object[]{resMap, propertiesMapping});
            }
            OmOrderBookDateHelper helper = new OmOrderBookDateHelper(dataEntities, GetEntityNameHelper.getOrderEntityName(e.getDataEntities()), "billentry", "manubillid", "manuentryid");
            helper.updateOrderBookDateByBizBill();
        }
    }

    private String getSelectField(Map<String, String> propertiesMapping) {
        StringJoiner sb = new StringJoiner(",");
        sb.add("billentry.manuentryid");
        sb.add("billentry.baseqty");
        Set<String> strings = propertiesMapping.keySet();
        for (String string : strings) {
            sb.add(string);
        }
        return sb.toString();
    }
}

