/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scmc.im.common.mdc.helper.GetEntityNameHelper;
import kd.scmc.im.common.mdc.utils.ProCalMaterialUtils;

public class MftOrderChargeAgainstUtils {
    private static final Log logger = LogFactory.getLog(MftOrderChargeAgainstUtils.class);
    private static final String ENTITYID_MANUFACTUREBILL = "pom_mftorder";
    private static final String ENTITYID_PROPMANUFACTUREBILL = "prop_mftorder";

    public static void changeStockWipqty(DynamicObject entryObj, List<Long> orderEntryIdList) {
        Long orderEntryId;
        if ((ENTITYID_MANUFACTUREBILL.equalsIgnoreCase(entryObj.getString("mainbillentity")) || ENTITYID_PROPMANUFACTUREBILL.equalsIgnoreCase(entryObj.getString("mainbillentity"))) && !"0".equals((orderEntryId = Long.valueOf(entryObj.getLong("mainbillentryid"))).toString())) {
            orderEntryIdList.add(orderEntryId);
        }
    }

    public static void calMftChargeAgainst(String operationKey, List<ExtendedDataEntity> selectedRows, String productiondomain) {
        ArrayList<Long> orderEntryIdList = new ArrayList<Long>();
        Map<Object, DynamicObject> objMap = MftOrderChargeAgainstUtils.getMftManuMap(selectedRows);
        for (int i = 0; i < selectedRows.size(); ++i) {
            ExtendedDataEntity objEntity = selectedRows.get(i);
            DynamicObject obj = objMap.get(objEntity.getBillPkId());
            if ((obj.getBoolean("ischargeoff") || !"audit".equals(operationKey) && !"unaudit".equals(operationKey)) && !"chargeagainst".equals(operationKey)) continue;
            DynamicObjectCollection billentry = obj.getDynamicObjectCollection("billentry");
            for (DynamicObject entryObj : billentry) {
                MftOrderChargeAgainstUtils.changeStockWipqty(entryObj, orderEntryIdList);
            }
        }
        if (!orderEntryIdList.isEmpty()) {
            try {
                DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMPDMMftGenStocksUtils", (String)"aculUseQtyByOrderEntryId", (Object[])new Object[]{orderEntryIdList, productiondomain});
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, new ErrorCode("MmcServiceOrderCloseOpAction", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
            }
        }
        HashSet<String> orderEntryidSet = new HashSet<String>(20);
        HashSet<String> orderidSet = new HashSet<String>(20);
        for (int i = 0; i < selectedRows.size(); ++i) {
            ExtendedDataEntity objEntity = selectedRows.get(i);
            DynamicObject obj = objMap.get(objEntity.getBillPkId());
            DynamicObjectCollection billentry = obj.getDynamicObjectCollection("billentry");
            if ((obj.getBoolean("ischargeoff") || !"audit".equals(operationKey) && !"unaudit".equals(operationKey)) && !"chargeagainst".equals(operationKey)) continue;
            for (int j = 0; j < billentry.size(); ++j) {
                orderEntryidSet.add(((DynamicObject)billentry.get(j)).getString("mainbillentryid"));
                orderidSet.add(((DynamicObject)billentry.get(j)).getString("mainbillid"));
            }
        }
        MftOrderChargeAgainstUtils.batchCloseOrderEvent(orderEntryidSet, orderidSet, operationKey, productiondomain);
    }

    public static void batchCloseOrderEvent(Set<String> orderEntryidSet, Set<String> orderidSet, String operationKey, String productiondomain) {
        if (!orderEntryidSet.isEmpty() && orderEntryidSet.size() > 0) {
            String orderNum = GetEntityNameHelper.getOrderEntityName(productiondomain);
            Set<String> resultEntryidSet = ProCalMaterialUtils.getMftOrderEntryids(orderidSet, orderEntryidSet, orderNum);
            HashMap<String, Object> calparam = new HashMap<String, Object>();
            calparam.put("orderentryids", resultEntryidSet);
            calparam.put("orderids", orderidSet);
            calparam.put("operate", operationKey);
            calparam.put("iscloseorder", "1");
            calparam.put("modetype", "1");
            if ("E".equalsIgnoreCase(productiondomain)) {
                calparam.put("modetype", "9");
            }
            calparam.put("isautocal", "0");
            calparam.put("isautoflag", "0");
            calparam.put("appId", "im");
            String jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
        }
    }

    public static Map<Object, DynamicObject> getMftManuMap(List<ExtendedDataEntity> selectedRows) {
        String entityName = "im_mdc_mftmanuinbill";
        ArrayList<Object> idList = new ArrayList<Object>(selectedRows.size());
        for (int i = 0; i < selectedRows.size(); ++i) {
            ExtendedDataEntity objEntity = selectedRows.get(i);
            idList.add(objEntity.getBillPkId());
            entityName = objEntity.getDataEntity().getDataEntityType().getName();
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)entityName, (String)"billentry,billentry.mainbillentity,billentry.mainbillentryid,billentry.mainbillid,billentry.manuentryid,billentry.manubillid,ischargeoff", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        HashMap<Object, DynamicObject> objMap = new HashMap<Object, DynamicObject>(load.length);
        for (DynamicObject dym : load) {
            objMap.put(dym.getPkValue(), dym);
        }
        return objMap;
    }
}

