/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class OmInBillValidator
extends AbstractValidator {
    private static final String ENTITYID_MANUFACTUREBILL = "pm_om_purorderbill";
    private static final String ENTITYID_STOCK = "om_componentlist";
    private static final String BIZ_TYPE = "990500657985463296";

    public void validate() {
        String operate;
        switch (operate = this.getOperateKey()) {
            case "audit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
                    if (BIZ_TYPE.equals(dataEntity.getDynamicObject("biztype").getPkValue() + "")) continue;
                    DynamicObject invscheme = dataEntity.getDynamicObject("invscheme");
                    if (invscheme == null) {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\uff0c\u4ee5\u786e\u4fdd\u5ba1\u6838\u901a\u8fc7\u3002", (String)"OmInBillValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                        this.addErrorMessage(this.dataEntities[i], msg);
                        continue;
                    }
                    String transceiver = invscheme.getString("transceiver");
                    String bizdirection = invscheme.getString("bizdirection");
                    if (StringUtils.equals((CharSequence)"0", (CharSequence)transceiver) && StringUtils.equals((CharSequence)"1", (CharSequence)bizdirection) || StringUtils.equals((CharSequence)"1", (CharSequence)transceiver) && StringUtils.equals((CharSequence)"0", (CharSequence)bizdirection)) continue;
                    boolean flag = "1191".equals(invscheme.getString("number"));
                    for (int j = 0; j < dataEntity.getDynamicObjectCollection("billentry").size(); ++j) {
                        String msg;
                        DynamicObject entryObj = (DynamicObject)dataEntity.getDynamicObjectCollection("billentry").get(j);
                        if (0L == entryObj.getLong("mainbillid")) {
                            if (entryObj.getBoolean("ispresent")) continue;
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u8ba2\u5355\u4e3a\u7a7a\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"OmInBillValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                            continue;
                        }
                        String selectFields = "id,billno,billstatus,billentry.id,billentry.seq,billentry.producttype,billentry.material,billentry.bizstatus,billentry.iscontrolqty,transactiontype,billentry.invbaseqty,billentry.returnbaseqty";
                        DynamicObject manuBill = BusinessDataServiceHelper.loadSingle((Object)entryObj.getLong("mainbillid"), (String)ENTITYID_MANUFACTUREBILL, (String)selectFields);
                        if (null == manuBill) {
                            msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"OmInBillValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                            this.addErrorMessage(this.dataEntities[i], msg);
                        }
                        if (manuBill != null && !"C".equals(manuBill.getString("billstatus"))) {
                            msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u8ba2\u5355\u975e\u5ba1\u6838\u72b6\u6001\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"OmInBillValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                            this.addErrorMessage(this.dataEntities[i], msg);
                        }
                        if (flag) {
                            if (BigDecimal.ZERO.compareTo(entryObj.getBigDecimal("qty")) <= 0) {
                                entryObj.set("qty", (Object)BigDecimal.ZERO.subtract(entryObj.getBigDecimal("qty")));
                            }
                        } else if (BigDecimal.ZERO.compareTo(entryObj.getBigDecimal("qty")) >= 0) {
                            entryObj.set("qty", (Object)BigDecimal.ZERO.subtract(entryObj.getBigDecimal("qty")));
                        }
                        if (null == manuBill || null != manuBill.getDynamicObjectCollection("billentry")) {
                            // empty if block
                        }
                        if (null == manuBill || !"B".equals(dataEntity.get("billstatus"))) continue;
                        this.completePickValid(this.dataEntities[i], entryObj, manuBill);
                    }
                }
                break;
            }
        }
    }

    private void completePickValid(ExtendedDataEntity edEntity, DynamicObject entryObj, DynamicObject manuBill) {
        if (manuBill == null || !this.needValid(manuBill)) {
            return;
        }
        Long id = manuBill.getLong("transactiontype");
        DynamicObject transactiontype = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mpdm_transactout");
        boolean isconsiderloss = transactiontype.getBoolean("isconsiderloss");
        BigDecimal curQTY = entryObj.getBigDecimal("baseqty");
        String materialNumber = entryObj.getDynamicObject("material").getDynamicObject("masterid").getString("number");
        String materialName = entryObj.getDynamicObject("material").getDynamicObject("masterid").getString("name");
        if (null != manuBill.getDynamicObjectCollection("billentry")) {
            for (int k = 0; k < manuBill.getDynamicObjectCollection("billentry").size(); ++k) {
                QFilter qfilter;
                boolean isExists;
                DynamicObject manuEntryObj = (DynamicObject)manuBill.getDynamicObjectCollection("billentry").get(k);
                Long manuEntryId = entryObj.getLong("mainbillentryid");
                if (!manuEntryId.equals(manuEntryObj.getPkValue()) || !(isExists = QueryServiceHelper.exists((String)ENTITYID_STOCK, (QFilter[])new QFilter[]{qfilter = new QFilter("orderentryid", "=", manuEntryObj.getPkValue())}))) continue;
                BigDecimal accQty = BigDecimal.ZERO;
                accQty = accQty.add(manuEntryObj.getBigDecimal("invbaseqty"));
                DynamicObject mftStock = BusinessDataServiceHelper.loadSingle((String)ENTITYID_STOCK, (String)"orderentryid,baseqty,materialunitid,stockentry,stockentry.materialid,stockentry.materialid.number,stockentry.materialid.name,stockentry.feedingqty,stockentry.qtytype,stockentry.overissuecontrl,stockentry.demandqty,stockentry.fixscrap,stockentry.qtynumerator,stockentry.qtydenominator,stockentry.lackraitioqty,stockentry.rejectedqty,stockentry.actissueqty,stockentry.issuemode,stockentry.isbackflush,stockentry.iskeypart,stockentry.isbulkmaterial,stockentry.fixscrap", (QFilter[])new QFilter[]{qfilter});
                BigDecimal baseQty = mftStock.getBigDecimal("baseqty");
                for (int j = 0; j < mftStock.getDynamicObjectCollection("stockentry").size(); ++j) {
                    DynamicObject mftstockEntryObj = (DynamicObject)mftStock.getDynamicObjectCollection("stockentry").get(j);
                    DynamicObject unitid = mftstockEntryObj.getDynamicObject("materialunitid");
                    int precision = unitid.getInt("precision");
                    String precisionaccount = unitid.getString("precisionaccount");
                    int deal = 4;
                    switch (precisionaccount) {
                        case "2": {
                            deal = 1;
                            break;
                        }
                        case "3": {
                            deal = 0;
                            break;
                        }
                        default: {
                            deal = 4;
                        }
                    }
                    if (!this.isInRange(mftstockEntryObj, transactiontype)) continue;
                    HashMap<String, Object> judgeParam = new HashMap<String, Object>();
                    judgeParam.put("mftstockEntryObj", mftstockEntryObj);
                    judgeParam.put("isconsiderloss", isconsiderloss);
                    judgeParam.put("curQTY", curQTY);
                    judgeParam.put("accQty", accQty);
                    judgeParam.put("baseQty", baseQty);
                    HashMap<String, Object> judgeResult = this.qualityJudge(judgeParam, precision, deal);
                    boolean isPass = (Boolean)judgeResult.get("isPass");
                    if (isPass) continue;
                    DynamicObject masterid = mftstockEntryObj.getDynamicObject("materialid").getDynamicObject("masterid");
                    String pNumber = masterid.getString("number");
                    String pName = masterid.getString("name");
                    BigDecimal qtyA = (BigDecimal)judgeResult.get("qualityA");
                    BigDecimal qtyB = (BigDecimal)judgeResult.get("qualityB");
                    BigDecimal qtyT = accQty.add(curQTY);
                    String message = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u5168\u9886\u6599\u7684\u7269\u6599\uff1a\u5165\u5e93\u4ea7\u54c1\u7f16\u7801\u201c%1$s\u201d \u4ea7\u54c1\u540d\u79f0\u201c%2$s\u201d \u5165\u5e93\u57fa\u672c\u6570\u91cf\u201c%3$s\u201d\uff0c\u7269\u6599\u7f16\u7801\u201c%4$s\u201d \u7269\u6599\u540d\u79f0\u201c%5$s\u201d\u5e94\u9886\u7528\u201c%6$s\u201d\uff0c\u5b9e\u9645\u9886\u7528\u201c%7$s\u201d\u3002", (String)"OmInBillValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), materialNumber, materialName, qtyT.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyT.intValue()) : qtyT.setScale(precision, deal), pNumber, pName, qtyB.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyB.intValue()) : qtyB.setScale(precision, deal), qtyA.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyA.intValue()) : qtyA.setScale(precision, deal));
                    if (this.isStrictControl(transactiontype)) {
                        this.addErrorMessage(edEntity, message);
                        continue;
                    }
                    this.addWarningMessage(edEntity, message);
                }
            }
        }
    }

    private boolean isInRange(DynamicObject mftstockEntryObj, DynamicObject transactiontype) {
        String warehousrang = transactiontype.getString("warehousrang");
        String issuemode = mftstockEntryObj.getString("issuemode");
        String isbackflush = mftstockEntryObj.getString("isbackflush");
        boolean isbulkmaterial = mftstockEntryObj.getBoolean("isbulkmaterial");
        boolean iskeypart = mftstockEntryObj.getBoolean("iskeypart");
        boolean inRangeFlag = false;
        switch (warehousrang) {
            case "A": {
                if (isbulkmaterial || !"A".equals(isbackflush) || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
            case "B": {
                if (!iskeypart || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
            case "C": {
                if (isbulkmaterial || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
        }
        return inRangeFlag;
    }

    private boolean needValid(DynamicObject manuBill) {
        Long id = manuBill.getLong("transactiontype");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject object = QueryServiceHelper.queryOne((String)"mpdm_transactout", (String)"iswarehousingpick", (QFilter[])new QFilter[]{qFilter});
        return object.getBoolean("iswarehousingpick");
    }

    private HashMap<String, Object> qualityJudge(HashMap<String, Object> judgeParam, int precision, int deal) {
        boolean isPass;
        BigDecimal qualityA = BigDecimal.ZERO;
        BigDecimal qualityB = BigDecimal.ZERO;
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObject mftstockEntryObj = (DynamicObject)judgeParam.get("mftstockEntryObj");
        boolean isconsiderloss = (Boolean)judgeParam.get("isconsiderloss");
        BigDecimal curQTY = (BigDecimal)judgeParam.get("curQTY");
        BigDecimal accQty = (BigDecimal)judgeParam.get("accQty");
        BigDecimal baseQty = (BigDecimal)judgeParam.get("baseQty");
        qualityA = qualityA.add(mftstockEntryObj.getBigDecimal("actissueqty")).subtract(mftstockEntryObj.getBigDecimal("rejectedqty")).add(mftstockEntryObj.getBigDecimal("feedingqty"));
        String qtytype = mftstockEntryObj.getString("qtytype");
        if ("A".equals(qtytype) || "C".equals(qtytype)) {
            String overissuecontrl = mftstockEntryObj.getString("overissuecontrl");
            qualityB = qualityB.add(accQty).add(curQTY);
            BigDecimal fixscrap = mftstockEntryObj.get("fixscrap") == null ? BigDecimal.ZERO : (BigDecimal)mftstockEntryObj.get("fixscrap");
            qualityB = isconsiderloss ? qualityB.multiply(mftstockEntryObj.getBigDecimal("demandqty").subtract(fixscrap)).divide(baseQty, precision, deal) : qualityB.multiply(mftstockEntryObj.getBigDecimal("qtynumerator")).divide(mftstockEntryObj.getBigDecimal("qtydenominator"), 8, 4);
            if ("B".equals(overissuecontrl) && qualityB.compareTo(mftstockEntryObj.getBigDecimal("lackraitioqty")) > 0) {
                qualityB = mftstockEntryObj.getBigDecimal("lackraitioqty");
            }
        } else {
            qualityB = mftstockEntryObj.getBigDecimal("demandqty");
        }
        if (qualityA.compareTo(qualityB) >= 0) {
            isPass = true;
        } else {
            isPass = false;
            result.put("qualityA", qualityA);
            result.put("qualityB", qualityB);
        }
        result.put("isPass", isPass);
        return result;
    }

    private boolean isStrictControl(DynamicObject transactiontype) {
        String warehouscontrol = transactiontype.getString("warehouscontrol");
        return "B".equals(warehouscontrol);
    }
}

