/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.old.ominbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.algorithm.TaxAlgorithmForBotp;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.InvBillConst;

public class OmInBillUpdateFields
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        InvBillConst.getSelectorListForAcc().forEach(field -> e.getFieldKeys().add(field));
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("stockindate");
        e.getFieldKeys().add("billcretype");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("materialmasterid");
        e.getFieldKeys().add("settlecurrency");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("istax");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("quotation");
        e.getFieldKeys().add("billentry.taxrate");
        e.getFieldKeys().add("billentry.price");
        e.getFieldKeys().add("billentry.priceandtax");
        e.getFieldKeys().add("billentry.discountrate");
        e.getFieldKeys().add("billentry.discounttype");
        e.getFieldKeys().add("billentry.discountamount");
        e.getFieldKeys().add("billentry.amountandtax");
        e.getFieldKeys().add("billentry.taxamount");
        e.getFieldKeys().add("billentry.amount");
        e.getFieldKeys().add("billentry.curamountandtax");
        e.getFieldKeys().add("billentry.curtaxamount");
        e.getFieldKeys().add("billentry.curamount");
        e.getFieldKeys().add("billentry.actualprice");
        e.getFieldKeys().add("billentry.actualtaxprice");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> importData = new ArrayList<DynamicObject>(16);
        DynamicObject[] dataEntities = e.getDataEntities();
        for (DynamicObject dataEntity : dataEntities) {
            importData.add(dataEntity);
        }
        for (DynamicObject bill : importData) {
            TaxAlgorithmForBotp algo = new TaxAlgorithmForBotp(bill);
            algo.reCalFields();
            DynamicObjectCollection enrtyList = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : enrtyList) {
                BigDecimal amount = entry.getBigDecimal("amount");
                boolean flag = this.checkBigDecimal(amount);
                if (flag) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u8d85\u8fc7\u7cfb\u7edf\u9884\u5236\u6700\u5927\u503c\u201c9999999999999\u201d\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u76f8\u5173\u6570\u636e\u3002", (String)"OmInBillUpdateFields_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
        }
        SaveServiceHelper.save((DynamicObject[])importData.toArray(new DynamicObject[0]));
    }

    private boolean checkBigDecimal(BigDecimal amount) {
        return amount.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) <= 0;
    }
}

