/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.opplugin.mdc.ommanuinbill.validate.OmCmplinChargeagainstValidator;
import kd.scmc.im.opplugin.mdc.ommanuinbill.validate.OmManuInChargeagainstValidator;

public class OMManuInChargeagainstOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OMManuInChargeagainstOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("ischargeoffed");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("manubill");
        e.getFieldKeys().add("manubillid");
        e.getFieldKeys().add("manuentry");
        e.getFieldKeys().add("manuentryid");
        e.getFieldKeys().add("producttype");
        e.getFieldKeys().add("qualitystatus");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("receivalqty");
        e.getFieldKeys().add("receivedqty");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("srcbillnumber");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("mainbillnumber");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryseq");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("productionorg");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("modeltype");
        e.getFieldKeys().add("billentry.manuentryid");
        e.getFieldKeys().add("billentry.manubillid");
        e.getFieldKeys().add("billentry.backflushstatus");
        e.getFieldKeys().add("invscheme.bizdirection");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OmCmplinChargeagainstValidator());
        e.addValidator((AbstractValidator)new OmManuInChargeagainstValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Object modeltype;
        super.endOperationTransaction(e);
        HashSet<String> entryIds = new HashSet<String>(16);
        for (DynamicObject bill : e.getDataEntities()) {
            String bizdirection;
            modeltype = bill.getString("modeltype");
            if (!"B".equals(modeltype) || !"0".equals(bizdirection = bill.getString("invscheme.bizdirection"))) continue;
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billentry) {
                entryIds.add(String.valueOf(entry.getPkValue()));
            }
        }
        if (CollectionUtils.isEmpty(entryIds)) {
            return;
        }
        QFilter qFilter = new QFilter("sumentry.manuinbillentryid", "in", entryIds);
        qFilter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        qFilter.and(new QFilter("sumentry.ischargeoffed", "=", (Object)Boolean.FALSE));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("sumentry.manufactureentryid.bizstatus", "!=", (Object)"C"));
        qFilter.and(new QFilter("sumentry.manufactureentryid.bizstatus", "!=", (Object)"B"));
        HashMap map = new HashMap();
        HashSet sumEntryIds = new HashSet();
        DataSet processReport = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryProgressReport"), (String)"sfc_processreportbill", (String)this.getSelectProperties(), (QFilter[])qFilter.toArray(), null);
        modeltype = null;
        try {
            processReport.forEach(t -> {
                Long id = t.getLong("id");
                Long sumEntryId = t.getLong("sumentry.id");
                sumEntryIds.add(sumEntryId);
                if (map.containsKey(id)) {
                    Set tempt = (Set)map.get(id);
                    tempt.add(sumEntryId);
                } else {
                    HashSet<Long> tempt = new HashSet<Long>();
                    tempt.add(sumEntryId);
                    map.put(id, tempt);
                }
            });
        }
        catch (Throwable bizdirection) {
            modeltype = bizdirection;
            throw bizdirection;
        }
        finally {
            if (processReport != null) {
                if (modeltype != null) {
                    try {
                        processReport.close();
                    }
                    catch (Throwable bizdirection) {
                        ((Throwable)modeltype).addSuppressed(bizdirection);
                    }
                } else {
                    processReport.close();
                }
            }
        }
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])map.keySet().toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sfc_processreportbill"));
        if (load == null || load.length == 0) {
            return;
        }
        HashMap loadMapping = new HashMap();
        for (int i = 0; i < load.length; ++i) {
            DynamicObject bill = load[i];
            DynamicObjectCollection sumentry = bill.getDynamicObjectCollection("sumentry");
            for (DynamicObject entry : sumentry) {
                String seq = entry.getString("seq");
                Long pkValue = (Long)entry.getPkValue();
                HashMap<DynamicObject, String> tempt = new HashMap<DynamicObject, String>();
                tempt.put(bill, seq);
                loadMapping.put(pkValue, tempt);
            }
        }
        try {
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"ProcessReportChargeAgainstService", (String)"chargeAgainstProcessReport", (Object[])new Object[]{map, loadMapping});
        }
        catch (Throwable throwable) {
            throw new KDBizException(new ErrorCode("chargeAgainst ProcessReport error", throwable.getMessage()), new Object[0]);
        }
    }

    private String getSelectProperties() {
        StringJoiner sj = new StringJoiner(",");
        sj.add("id");
        sj.add("sumentry.oprentryid");
        sj.add("sumentry.id");
        return sj.toString();
    }
}

