/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class OmCmPlinBillSaveOp
extends AbstractOperationServicePlugIn {
    private static final String DIRECT_QUTATION = "0";
    private static final String INDIRECT_QUTATION = "1";
    protected int curAmountPrecision = 2;
    protected int pricePrecision = 10;
    protected int amountPrecision = 2;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billcretype");
        fieldKeys.add("istax");
        fieldKeys.add("billentry.price");
        fieldKeys.add("billentry.priceandtax");
        fieldKeys.add("billentry.actualprice");
        fieldKeys.add("billentry.actualtaxprice");
        fieldKeys.add("billentry.discountamount");
        fieldKeys.add("billentry.amount");
        fieldKeys.add("billentry.curamount");
        fieldKeys.add("billentry.taxamount");
        fieldKeys.add("billentry.curtaxamount");
        fieldKeys.add("billentry.amountandtax");
        fieldKeys.add("billentry.curamountandtax");
        fieldKeys.add("billentry.taxrate");
        fieldKeys.add("billentry.qty");
        fieldKeys.add("billentry.discounttype");
        fieldKeys.add("billentry.discountrate");
        fieldKeys.add("billentry.discountamount");
        fieldKeys.add("quotation");
        fieldKeys.add("exchangerate");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        for (DynamicObject bill : dataEntities) {
            String billcretype = bill.getString("billcretype");
            if (DIRECT_QUTATION.equals(billcretype) || "2".equals(billcretype)) continue;
            boolean istax = bill.getBoolean("istax");
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            BigDecimal oneHundred = new BigDecimal("100.0");
            for (DynamicObject dynamicObject : billentry) {
                BigDecimal taxrate;
                if (istax) {
                    BigDecimal priceandtax = this.getNullToZero("priceandtax", dynamicObject);
                    taxrate = this.getNullToZero("taxrate", dynamicObject);
                    taxrate = taxrate.divide(oneHundred, taxrate.scale() + 2, 4);
                    BigDecimal price = priceandtax.divide(taxrate.add(BigDecimal.ONE), 10, 4);
                    dynamicObject.set("price", (Object)price);
                } else {
                    BigDecimal price = this.getNullToZero("price", dynamicObject);
                    taxrate = this.getNullToZero("taxrate", dynamicObject);
                    taxrate = taxrate.divide(oneHundred, taxrate.scale() + 2, 4);
                    BigDecimal priceandtax = price.multiply(taxrate.add(BigDecimal.ONE));
                    dynamicObject.set("priceandtax", (Object)priceandtax);
                }
                this.calDiscountAmount(istax, dynamicObject);
                this.calEntryAmountFileds(istax, dynamicObject);
                this.calEntryCurFileds(istax, bill, dynamicObject);
                this.calActualPrice(dynamicObject);
                this.calActualTaxPrice(dynamicObject);
            }
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    private void calActualTaxPrice(DynamicObject dynamicObject) {
        BigDecimal discountAmount = this.getNullToZero("discountamount", dynamicObject);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal taxPrice = this.getNullToZero("priceandtax", dynamicObject);
            dynamicObject.set("actualtaxprice", (Object)taxPrice);
        } else {
            BigDecimal amountAndTax = this.getNullToZero("amountandtax", dynamicObject);
            BigDecimal qty = this.getNullToZero("qty", dynamicObject);
            if (BigDecimal.ZERO.compareTo(amountAndTax) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                dynamicObject.set("actualtaxprice", (Object)BigDecimal.ZERO);
            } else {
                BigDecimal taxPrice = amountAndTax.divide(qty, this.pricePrecision, 4);
                dynamicObject.set("actualtaxprice", (Object)taxPrice);
            }
        }
    }

    private void calActualPrice(DynamicObject dynamicObject) {
        BigDecimal discountAmount = this.getNullToZero("discountamount", dynamicObject);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal price = this.getNullToZero("price", dynamicObject);
            dynamicObject.set("actualprice", (Object)price);
        } else {
            BigDecimal amount = this.getNullToZero("amount", dynamicObject);
            BigDecimal qty = this.getNullToZero("qty", dynamicObject);
            if (BigDecimal.ZERO.compareTo(amount) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                dynamicObject.set("actualprice", (Object)BigDecimal.ZERO);
            } else {
                BigDecimal price = amount.divide(qty, this.pricePrecision, 4);
                dynamicObject.set("actualprice", (Object)price);
            }
        }
    }

    protected void calEntryCurFileds(Boolean isTax, DynamicObject bill, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            this.calCurAmountAndTax(isTax, bill, dynamicObject);
            this.calCurTaxAmount(bill, dynamicObject);
            this.calCurAmount(isTax, bill, dynamicObject);
        } else {
            this.calCurAmount(isTax, bill, dynamicObject);
            this.calCurTaxAmount(bill, dynamicObject);
            this.calCurAmountAndTax(isTax, bill, dynamicObject);
        }
    }

    private void calCurAmount(Boolean istax, DynamicObject bill, DynamicObject dynamicObject) {
        if (istax.booleanValue()) {
            BigDecimal LocalTaxAmount = this.getNullToZero("curamountandtax", dynamicObject);
            BigDecimal LocalTax = this.getNullToZero("curtaxamount", dynamicObject);
            dynamicObject.set("curamount", (Object)LocalTaxAmount.subtract(LocalTax));
        } else {
            BigDecimal amount = this.getNullToZero("amount", dynamicObject);
            BigDecimal exchangerate = this.getNullToZero("exchangerate", bill);
            Object quotation = bill.get("quotation");
            BigDecimal localTaxAmount = BigDecimal.ZERO;
            if (DIRECT_QUTATION.equals(quotation)) {
                localTaxAmount = amount.multiply(exchangerate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
            } else if (INDIRECT_QUTATION.equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
                localTaxAmount = amount.divide(exchangerate, this.curAmountPrecision, RoundingMode.HALF_UP);
            }
            dynamicObject.set("curamount", (Object)localTaxAmount);
        }
    }

    private void calCurTaxAmount(DynamicObject bill, DynamicObject dynamicObject) {
        Object quotation = bill.get("quotation");
        BigDecimal tax = this.getNullToZero("taxamount", dynamicObject);
        BigDecimal exchangerate = this.getNullToZero("exchangerate", bill);
        BigDecimal localTax = BigDecimal.ZERO;
        if (DIRECT_QUTATION.equals(quotation)) {
            localTax = tax.multiply(exchangerate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
        } else if (INDIRECT_QUTATION.equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
            localTax = tax.divide(exchangerate, this.curAmountPrecision, RoundingMode.HALF_UP);
        }
        dynamicObject.set("curtaxamount", (Object)localTax);
    }

    private void calCurAmountAndTax(Boolean isTax, DynamicObject bill, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", dynamicObject);
            BigDecimal exchangerate = this.getNullToZero("exchangerate", bill);
            BigDecimal localTaxAmount = BigDecimal.ZERO;
            String quotation = bill.getString("quotation");
            if (DIRECT_QUTATION.equals(quotation)) {
                localTaxAmount = taxAmount.multiply(exchangerate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
            } else if (INDIRECT_QUTATION.equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
                localTaxAmount = taxAmount.divide(exchangerate, this.curAmountPrecision, RoundingMode.HALF_UP);
            }
            dynamicObject.set("curamountandtax", (Object)localTaxAmount);
        } else {
            BigDecimal localAmount = this.getNullToZero("curamount", dynamicObject);
            BigDecimal localTax = this.getNullToZero("curtaxamount", dynamicObject);
            dynamicObject.set("curamountandtax", (Object)localAmount.add(localTax));
        }
    }

    protected void calEntryAmountFileds(Boolean isTax, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            this.calAmountAndTax(isTax, dynamicObject);
            this.calTaxAmount(isTax, dynamicObject);
            this.calAmount(isTax, dynamicObject);
        } else {
            this.calAmount(isTax, dynamicObject);
            this.calTaxAmount(isTax, dynamicObject);
            this.calAmountAndTax(isTax, dynamicObject);
        }
    }

    private void calAmount(Boolean isTax, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", dynamicObject);
            BigDecimal tax = this.getNullToZero("taxamount", dynamicObject);
            BigDecimal amount = taxAmount.subtract(tax);
            dynamicObject.set("amount", (Object)amount);
        } else {
            BigDecimal price = this.getNullToZero("price", dynamicObject);
            BigDecimal qty = this.getNullToZero("qty", dynamicObject);
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal discountRate = this.getNullToZero("discountrate", dynamicObject);
            String discountType = dynamicObject.getString("discounttype");
            if (StringUtils.isNotEmpty((CharSequence)discountType)) {
                DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
                if (null == discountTypeEnum) {
                    return;
                }
                switch (discountTypeEnum) {
                    case DISRATE: {
                        BigDecimal reDiscountRate = discountRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4);
                        amount = price.multiply(qty).multiply(BigDecimal.ONE.subtract(reDiscountRate)).setScale(this.amountPrecision, 4);
                        break;
                    }
                    case UNITDIS: 
                    case DISAMT: {
                        amount = qty.multiply(price.subtract(discountRate)).setScale(this.amountPrecision, 4);
                        break;
                    }
                    case NULL: {
                        amount = qty.multiply(price).setScale(this.amountPrecision, 4);
                        break;
                    }
                }
            } else {
                amount = qty.multiply(price).setScale(this.amountPrecision, 4);
            }
            dynamicObject.set("amount", (Object)amount);
        }
    }

    private void calTaxAmount(Boolean isTax, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", dynamicObject);
            BigDecimal taxRate = this.getNullToZero("taxrate", dynamicObject);
            BigDecimal tax = BigDecimalConstants.ZERO;
            if (taxAmount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = taxAmount.multiply(taxRate).divide(taxRate.add(BigDecimalConstants.ONE), this.amountPrecision, 4);
            }
            dynamicObject.set("taxamount", (Object)tax);
        } else {
            BigDecimal amount = this.getNullToZero("amount", dynamicObject);
            BigDecimal taxRate = this.getNullToZero("taxrate", dynamicObject);
            BigDecimal tax = BigDecimalConstants.ZERO;
            if (amount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = amount.multiply(taxRate).setScale(this.amountPrecision, 4);
            }
            dynamicObject.set("taxamount", (Object)tax);
        }
    }

    private void calAmountAndTax(Boolean isTax, DynamicObject dynamicObject) {
        if (isTax.booleanValue()) {
            BigDecimal priceAndTax = this.getNullToZero("priceandtax", dynamicObject);
            BigDecimal qty = this.getNullToZero("qty", dynamicObject);
            BigDecimal taxAmount = BigDecimal.ZERO;
            BigDecimal discountAmount = this.getNullToZero("discountamount", dynamicObject);
            BigDecimal discountRate = this.getNullToZero("discountrate", dynamicObject);
            String discountType = dynamicObject.getString("discounttype");
            taxAmount = DiscountTypeEnum.DISRATE.getValue().equals(discountType) && discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) == 0 ? qty.multiply(priceAndTax).setScale(this.amountPrecision, 4).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(this.amountPrecision, 4);
            OmCmPlinBillSaveOp.setTaxAmountErrorTip(taxAmount);
            dynamicObject.set("amountandtax", (Object)taxAmount);
        } else {
            BigDecimal amount = this.getNullToZero("amount", dynamicObject);
            BigDecimal tax = this.getNullToZero("taxamount", dynamicObject);
            BigDecimal taxAmount = amount.add(tax);
            OmCmPlinBillSaveOp.setTaxAmountErrorTip(taxAmount);
            dynamicObject.set("amountandtax", (Object)taxAmount);
        }
    }

    public static void setTaxAmountErrorTip(BigDecimal taxAmount) {
        if (taxAmount.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_TAX_AMOUNT()));
        }
    }

    public void calDiscountAmount(Boolean isTax, DynamicObject dynamicObject) {
        BigDecimal price = this.getNullToZero("priceandtax", dynamicObject);
        BigDecimal qty = this.getNullToZero("qty", dynamicObject);
        BigDecimal discountRate = this.getNullToZero("discountrate", dynamicObject);
        String discountType = dynamicObject.getString("discounttype");
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)discountType)) {
            DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
            if (null == discountTypeEnum) {
                return;
            }
            switch (discountTypeEnum) {
                case DISRATE: {
                    discountAmount = price.multiply(qty).multiply(discountRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4)).setScale(this.amountPrecision, 4);
                    break;
                }
                case UNITDIS: 
                case DISAMT: {
                    if (discountRate.compareTo(price) > 0) {
                        discountRate = BigDecimal.ZERO;
                        dynamicObject.set("discountrate", (Object)discountRate);
                    }
                    if (isTax.booleanValue()) {
                        discountAmount = qty.multiply(discountRate).setScale(this.amountPrecision, 4);
                        break;
                    }
                    BigDecimal taxRate = this.getNullToZero("taxrate", dynamicObject);
                    taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4);
                    discountAmount = qty.multiply(discountRate).multiply(BigDecimal.ONE.add(taxRate)).setScale(this.amountPrecision, 4);
                    break;
                }
                case NULL: {
                    break;
                }
            }
        }
        dynamicObject.set("discountamount", (Object)discountAmount);
    }

    public BigDecimal getNullToZero(String key, DynamicObject dynamicObject) {
        BigDecimal value = dynamicObject.getBigDecimal(key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }
}

