/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.im.opplugin.mdc.ommanuinbill.validate.OmCmplInBillGenerateReportValidator;
import org.apache.commons.collections4.CollectionUtils;

public class OmCmplInBillGenerateReportOp
extends AbstractOperationServicePlugIn {
    Log logger = LogFactory.getLog(OmCmplInBillGenerateReportOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("billentry.baseqty");
        e.getFieldKeys().add("modeltype");
        e.getFieldKeys().add("techid");
        e.getFieldKeys().add("oprentryid");
        e.getFieldKeys().add("invscheme.bizdirection");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("billentry.id");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("ischargeoffed");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey;
        super.afterExecuteOperationTransaction(e);
        switch (operationKey = e.getOperationKey()) {
            case "generatereport": {
                this.generateReportOp(e);
                break;
            }
        }
    }

    private void generateReportOp(AfterOperationArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        ArrayList data = new ArrayList(10);
        String num = "";
        try {
            num = this.getOption().getVariableValue("num");
        }
        catch (Exception ex) {
            this.logger.info(ex.getMessage());
        }
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject dataEntity = bills[i];
            if (!"B".equals(dataEntity.getString("modeltype"))) continue;
            DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("baseqty", entry.getBigDecimal("baseqty"));
                map.put("techid", entry.getLong("techid"));
                map.put("oprentryid", entry.getLong("oprentryid"));
                map.put("billid", dataEntity.getPkValue());
                map.put("entryid", entry.getPkValue());
                map.put("billno", dataEntity.getString("billno"));
                map.put("seq", entry.getString("seq"));
                map.put("num", num);
                data.add(map);
            }
        }
        if (CollectionUtils.isNotEmpty(data)) {
            try {
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"ManuftechAutoPushProcessReportBillService", (String)"autoPushAndSubmit", (Object[])new Object[]{data});
            }
            catch (Throwable ex) {
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OmCmplInBillGenerateReportValidator());
    }
}

