/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.im.opplugin.mdc.ommanuinbill.validate.OMCmplInBillProcessReportExist;

public class OmCmplInBillUnAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OmCmplInBillUnAuditOp.class);
    private static final String KEY_BILLENTRY = "billentry";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add(KEY_BILLENTRY);
        e.getFieldKeys().add("manuentryid");
        e.getFieldKeys().add("manubillid");
        e.getFieldKeys().add("modeltype");
        e.getFieldKeys().add("producttype");
        e.getFieldKeys().add(KEY_BILLENTRY);
        e.getFieldKeys().add("billentry.id");
        e.getFieldKeys().add("billentry.backflushstatus");
        e.getFieldKeys().add("billentry.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OMCmplInBillProcessReportExist());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operateKey = e.getOperationKey();
        if ("unaudit".equals(operateKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities == null || dataEntities.length == 0) {
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject bill : dataEntities) {
                String number = bill.getString("modeltype");
                if ("A".equals(number)) continue;
                Long id = (Long)bill.getPkValue();
                ids.add(id);
            }
            Map ordersMap = BFTrackerServiceHelper.findTargetBills((String)"im_mdc_omcmplinbill", (Long[])ids.toArray(new Long[0]));
            logger.info("ordersMap:" + ordersMap);
            if (ordersMap == null || ordersMap.size() == 0) {
                return;
            }
            Set orders = (Set)ordersMap.get("pur_instock");
            if (orders == null || orders.size() == 0) {
                return;
            }
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("ids", new ArrayList(orders));
            param.put("entityName", "pur_instock");
            logger.info("param:" + param);
            try {
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"unAuditAndDeleteBill", (Object[])new Object[]{param});
                boolean success = (Boolean)result.get("success");
                String msg = (String)result.get("message");
                if (!success) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u534f\u540c\u8ba2\u5355\u63a5\u53e3\u5931\u8d25:", (String)"OmCmplInBillUnAuditOp_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), msg));
                }
            }
            catch (Exception ex) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u786e\u8ba4\u662f\u5426\u53cd\u5ba1\u6838\u63a5\u53e3\u5931\u8d25, \u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"OmCmplInBillUnAuditOp_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
        }
    }
}

