/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OmOrderCmplInWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final Log log = LogFactory.getLog(OmOrderCmplInWriteBackPlugin.class);
    private static final Long ADMINISTRATORID = 1L;
    private static final String CLOSESTATUS = "closestatus";
    private static final String CLOSER = "closer";
    private static final String CLOSEDATE = "closedate";

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        e.getFieldKeys().add("biztime");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("receivedate");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("isvirtualbill");
    }

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if ("pm_purorderbill".equals(e.getSrcMainType().getName()) || "pm_om_purorderbill".equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add("unitrate");
            e.getFieldKeys().add("invqty");
            e.getFieldKeys().add("planqty");
            e.getFieldKeys().add("planreceiveqty");
            e.getFieldKeys().add("planreceivedate");
            e.getFieldKeys().add(CLOSER);
            e.getFieldKeys().add(CLOSEDATE);
            e.getFieldKeys().add(CLOSESTATUS);
            e.getFieldKeys().add("receivedayup");
            e.getFieldKeys().add("receivedaydown");
            e.getFieldKeys().add("iscontrolday");
            e.getFieldKeys().add("deliverdate");
            e.getFieldKeys().add("supplier");
            e.getFieldKeys().add("qty");
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        ArrayList<Long> IDs = new ArrayList<Long>(16);
        String opType = this.getOpType();
        HashSet<String> billEntitys = new HashSet<String>(2);
        billEntitys.add("pm_purorderbill");
        billEntitys.add("pm_om_purorderbill");
        if (billEntitys.contains(srcSubMainType.getName()) && (opType.equalsIgnoreCase("audit") || opType.equalsIgnoreCase("unaudit") || "Cancel".equalsIgnoreCase(opType))) {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>();
            for (DynamicObject srcDataEntity : srcDataEntities) {
                Long billId = (Long)srcDataEntity.getPkValue();
                IDs.add(billId);
                if (srcDataEntity.get(CLOSESTATUS).equals("B")) {
                    if (srcDataEntity.get(CLOSER) != null || srcDataEntity.get(CLOSEDATE) != null) continue;
                    srcDataEntity.set(CLOSER, (Object)ADMINISTRATORID);
                    srcDataEntity.set(CLOSEDATE, (Object)TimeServiceHelper.now());
                    saveValue.add(srcDataEntity);
                    continue;
                }
                if (srcDataEntity.get(CLOSER) == null || srcDataEntity.get(CLOSEDATE) == null) continue;
                srcDataEntity.set(CLOSER, null);
                srcDataEntity.set(CLOSEDATE, null);
                saveValue.add(srcDataEntity);
            }
            this.updatePurCloseStatus(IDs, srcSubMainType.getName());
            DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
            SaveServiceHelper.save((DynamicObject[])saveValues);
        }
    }

    private void updatePurCloseStatus(List<Long> IDs, String srcName) {
        if (IDs != null && IDs.size() > 0) {
            Map pm_purorderbill = BFTrackerServiceHelper.findTargetBills((String)srcName, (Long[])IDs.toArray(new Long[0]));
            HashSet pur_orders = pm_purorderbill == null ? null : (HashSet)pm_purorderbill.get("pur_order");
            HashSet pm_purorderbillid = new HashSet();
            if (pur_orders != null && pur_orders.size() > 0) {
                Map purorderbill = BFTrackerServiceHelper.findSourceBills((String)"pur_order", (Long[])pur_orders.toArray(new Long[0]));
                pm_purorderbillid = purorderbill == null ? null : (HashSet)purorderbill.get(srcName);
            }
            QFilter orderFilter = new QFilter("id", "in", pm_purorderbillid);
            String selectFields = "id,closestatus,closer,closedate,billentry.id,billentry.rowclosestatus,billentry.rowterminatestatus";
            DynamicObject[] pm_purorderbills = BusinessDataServiceHelper.load((String)srcName, (String)selectFields, (QFilter[])new QFilter[]{orderFilter});
            HashMap purMap = new HashMap();
            if (pm_purorderbills != null && pm_purorderbills.length > 0) {
                for (DynamicObject order : pm_purorderbills) {
                    String closeStatus;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    String orderId = order.getPkValue().toString();
                    if (order.get(CLOSESTATUS).equals("B")) {
                        closeStatus = "0";
                        hashMap.put("closeStatus", closeStatus);
                        hashMap.put(CLOSER, ADMINISTRATORID);
                        Date now = TimeServiceHelper.now();
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String closeDate = format.format(now);
                        hashMap.put("alertDate", closeDate);
                    } else {
                        closeStatus = "1";
                        hashMap.put("closeStatus", closeStatus);
                        hashMap.put(CLOSER, null);
                        hashMap.put("alertDate", null);
                    }
                    DynamicObjectCollection billentry = order.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry : billentry) {
                        String entryId = entry.getPkValue().toString();
                        String rowCloseStatus = entry.getString("rowclosestatus");
                        String rowTerminateStatus = entry.getString("rowterminatestatus");
                        String purRowStatus = rowCloseStatus.equals("B") || rowTerminateStatus.equals("B") ? "0" : "1";
                        hashMap.put(entryId, purRowStatus);
                    }
                    purMap.put(orderId, hashMap);
                }
            }
            log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.updatePurCloseStatus \u53c2\u6570 --> " + purMap);
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"updatePurCloseStatus", (Object[])new Object[]{purMap});
            log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.updatePurCloseStatus \u7ed3\u679c --> " + result);
        }
    }
}

