/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill.validate;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.common.mdc.enums.OperateEnum;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import org.apache.commons.collections4.CollectionUtils;

public class OmCmplInBillGenerateReportValidator
extends AbstractValidator {
    public void validate() {
        this.getOption().setVariableValue("num", String.valueOf(this.dataEntities.length));
        String operate = this.getOperateKey();
        HashSet operates = Sets.newHashSet((Object[])new String[]{"generatereport", "unaudit"});
        if (operates.contains(operate)) {
            HashSet<Long> entryIds = new HashSet<Long>(16);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
                if (!"B".equals(dataEntity.getString("modeltype"))) continue;
                DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
                entryIds.addAll(billEntry.stream().map(x -> x.getLong("id")).collect(Collectors.toSet()));
            }
            Map<Long, Long> sfc_processreportbill = this.querySfcReportByEntryId(entryIds, "sfc_processreportbill");
            Map<Long, Long> sfc_reportresource_adjust = MftReqOutBillUtil.querySfcReportByEntryId(entryIds, "sfc_reportresource_adjust");
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
                String direction = dataEntity.getString("invscheme.bizdirection");
                if (!"B".equals(dataEntity.getString("modeltype"))) continue;
                if ("generatereport".equals(operate) && dataEntity.getBoolean("ischargeoff")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5df2\u51b2\u9500\u5355\u636e\u4e0d\u5141\u8bb8\u751f\u6210\u5de5\u5e8f\u6c47\u62a5\u3002", (String)"OmCmplInBillGenerateReportValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                if ("generatereport".equals(operate) && dataEntity.getBoolean("ischargeoffed")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5df2\u88ab\u51b2\u9500\u5355\u636e\u4e0d\u5141\u8bb8\u751f\u6210\u5de5\u5e8f\u6c47\u62a5\u3002", (String)"OmCmplInBillGenerateReportValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                if ("generatereport".equals(operate) && !"C".equals(dataEntity.getString("billstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u6267\u884c\u751f\u6210\u5de5\u5e8f\u6c47\u62a5\u3002", (String)"OmCmplInBillGenerateReportValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                if ("generatereport".equals(operate) && !"0".equals(direction)) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65b9\u5411\u5fc5\u987b\u4e3a\u6b63\u5411\u624d\u80fd\u6267\u884c\u751f\u6210\u5de5\u5e8f\u6c47\u62a5\u3002", (String)"OmCmplInBillGenerateReportValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
                for (int j = 0; j < billEntry.size(); ++j) {
                    if ("generatereport".equals(operate) && sfc_processreportbill.containsValue(((DynamicObject)billEntry.get(j)).getLong("id"))) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5df2\u751f\u6210\u6c47\u62a5\u5355\uff0c\u65e0\u9700\u751f\u6210\u3002", (String)"OmCmplInBillGenerateReportValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                        continue;
                    }
                    if (BigDecimal.ZERO.compareTo(((DynamicObject)billEntry.get(j)).getBigDecimal("baseqty")) <= 0 || !sfc_reportresource_adjust.containsValue(((DynamicObject)billEntry.get(j)).getLong("id"))) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5b58\u5728\u6c47\u62a5\u8d44\u6e90\u8c03\u6574\u5355\u4e0d\u5141\u8bb8%2$s\u3002", (String)"OmCmplInBillGenerateReportValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, OperateEnum.getValue(operate)));
                }
            }
        }
    }

    private Map<Long, Long> querySfcReportByEntryId(Set<Long> entryIds, String entity) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(256);
        if (CollectionUtils.isEmpty(entryIds)) {
            return map;
        }
        QFilter qFilter = new QFilter("sumentry.manuinbillentryid", "in", entryIds);
        String algoKey = "querySfcReportByEntryId";
        if ("sfc_processreportbill".equals(entity)) {
            qFilter = new QFilter("sumentry.manuinbillentryid", "in", entryIds.stream().map(String::valueOf).collect(Collectors.toSet()));
            qFilter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
            qFilter.and(new QFilter("sumentry.ischargeoffed", "=", (Object)Boolean.FALSE));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)"id,billno,billstatus,sumentry.id,sumentry.manuinbillentryid", (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.put(row.getLong("sumentry.id"), row.getLong("sumentry.manuinbillentryid"));
            }
        }
        return map;
    }
}

