/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class OmInBillDeleteOpValidator
extends AbstractValidator {
    public void validate() {
        String operationKey = this.getOperateKey();
        if (!"delete".equals(operationKey)) {
            return;
        }
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entryColl = dataEntity.getDataEntity().getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entryColl) {
                entryIds.add(entry.getLong("id"));
            }
        }
        Map<Long, Map<String, Object>> mftProOrderByIds = this.getMftProOrderByIds(entryIds);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            this.checkBill(this.dataEntities[i], mftProOrderByIds);
        }
    }

    private void checkBill(ExtendedDataEntity extendedDataEntity, Map<Long, Map<String, Object>> data) {
        ArrayList<Integer> seqLs = new ArrayList<Integer>(10);
        DynamicObject obj = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("billentry");
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            Map<String, Object> map = data.get(entryObj.getLong("id"));
            if (!MapUtils.isNotEmpty(map)) continue;
            seqLs.add(i + 1);
        }
        if (!seqLs.isEmpty()) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5df2\u7ecf\u5012\u51b2\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"OmInBillDeleteOpValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), ((Object)seqLs).toString());
            this.addErrorMessage(extendedDataEntity, errMsg);
        }
    }

    private Map<Long, Map<String, Object>> getMftProOrderByIds(Set<Long> srcBillEntryId) {
        HashMap<Long, Map<String, Object>> map = new HashMap<Long, Map<String, Object>>(16);
        String algoKey = "OmInBillDeleteOpValidator.getMftProOrderByIds";
        QFilter filter = new QFilter("billentry.srcbillentryid", "in", srcBillEntryId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_omoutbill", (String)"id,billentry.srcbillentryid", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> data = new HashMap<String, Object>(8);
                data.put("id", row.getString("id"));
                data.put("billentry.srcbillentryid", row.getLong("billentry.srcbillentryid"));
                map.put(row.getLong("billentry.srcbillentryid"), data);
            }
        }
        return map;
    }
}

