/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.ommanuinbill.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import kd.scmc.im.utils.DateUtils;

public class OmInCmplBillSaveOrSubmitOpValidator
extends AbstractValidator {
    public void validate() {
        String operationKey;
        switch (operationKey = this.getOperateKey()) {
            case "save": {
                this.validManubill();
                break;
            }
            case "submit": {
                this.validManubill();
                this.submitValid();
                break;
            }
        }
    }

    private void validManubill() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObjectCollection col = obj.getDynamicObjectCollection("billentry");
            for (int j = 0; j < col.size(); ++j) {
                if (!this.isNull(((DynamicObject)col.get(j)).getString("manubill"))) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u901a\u8fc7\u62c9\u5f0f\u751f\u6210\u9009\u5355\u540e\u201c\u4fdd\u5b58\u201d\u6216\u201c\u63d0\u4ea4\u201d\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
            }
        }
        this.dealWarehouseAndLocation(this.dataEntities);
    }

    private void dealWarehouseAndLocation(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            if (!obj.getDynamicObject("invscheme").getBoolean("isoutupdate")) continue;
            DynamicObjectCollection cols = obj.getDynamicObjectCollection("billentry");
            for (DynamicObject col : cols) {
                DynamicObject outWareHouse = col.getDynamicObject("outwarehouse");
                if (outWareHouse != null) continue;
                col.set("outwarehouse", (Object)col.getDynamicObject("warehouse"));
            }
        }
    }

    private void submitValid() {
        HashSet<Long> mftOrderIdList = new HashSet<Long>(10);
        HashSet<Long> orgIds = new HashSet<Long>(10);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObject org = obj.getDynamicObject("org");
            if (org == null) continue;
            orgIds.add(org.getLong("id"));
        }
        Map<Long, Long[]> warehouseMap = this.getWarehouse(this.entityKey, orgIds);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Long[] longs = warehouseMap.get(obj.getDynamicObject("org").getLong("id"));
            if (obj.getDynamicObject("invscheme") == null) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5e93\u5b58\u4e8b\u52a1\u201d\uff0c\u4ee5\u786e\u4fdd\u5ba1\u6838\u901a\u8fc7\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                this.addErrorMessage(this.dataEntities[i], msg);
            }
            boolean isoutupdate = obj.getDynamicObject("invscheme").getBoolean("isoutupdate");
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                String format;
                String format2;
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                mftOrderIdList.add(entryObj.getLong("manubillid"));
                DynamicObject warehouse = entryObj.getDynamicObject("warehouse");
                DynamicObject location = entryObj.getDynamicObject("location");
                if (warehouse != null) {
                    String format3;
                    if (longs == null || longs.length == 0) {
                        String format4 = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u6240\u9009\u7684\u4ed3\u5e93\u6ca1\u6709\u6743\u9650\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                        this.addErrorMessage(this.dataEntities[i], format4);
                        continue;
                    }
                    List<Long> list = Arrays.asList(longs);
                    if (!list.contains(warehouse.getPkValue())) {
                        format3 = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u6240\u9009\u7684\u4ed3\u5e93\u6ca1\u6709\u6743\u9650\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                        this.addErrorMessage(this.dataEntities[i], format3);
                        continue;
                    }
                    if (warehouse.getBoolean("isopenlocation")) {
                        List locationIds = WarehouseHelper.getLocationIds((Object)warehouse.getPkValue());
                        if (location != null && !locationIds.contains(location.getLong("id"))) {
                            format2 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$d\u884c\u5206\u5f55\u7684\u4ed3\u5e93\u542f\u7528\u4ed3\u4f4d\u4f46\u662f\u4ed3\u4f4d\u4e0e\u4ed3\u5e93\u4e0d\u7b26\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_13", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), j + 1);
                            this.addErrorMessage(this.dataEntities[i], format2);
                            continue;
                        }
                    } else if (location != null) {
                        format3 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$d\u884c\u5206\u5f55\u7684\u4ed3\u5e93\u672a\u542f\u7528\u4ed3\u4f4d\u4f46\u662f\u4ed3\u4f4d\u6709\u503c\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_14", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), j + 1);
                        this.addErrorMessage(this.dataEntities[i], format3);
                        continue;
                    }
                }
                if (!isoutupdate) continue;
                DynamicObject outwarehouse = entryObj.getDynamicObject("outwarehouse");
                DynamicObject outlocation = entryObj.getDynamicObject("outlocation");
                if (outwarehouse == null) continue;
                if (longs == null || longs.length == 0) {
                    format2 = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u6240\u9009\u7684\u51fa\u5e93\u4ed3\u5e93\u6ca1\u6709\u6743\u9650\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_17", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                    this.addErrorMessage(this.dataEntities[i], format2);
                    continue;
                }
                List<Long> list = Arrays.asList(longs);
                if (!list.contains(outwarehouse.getPkValue())) {
                    format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u6240\u9009\u7684\u51fa\u5e93\u4ed3\u5e93\u6ca1\u6709\u6743\u9650\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_17", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                if (outwarehouse.getBoolean("isopenlocation")) {
                    if (outlocation == null) {
                        format = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$d\u884c\u51fa\u5e93\u4ed3\u5e93\u5df2\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406\uff0c\u8bf7\u586b\u5199\u5206\u5f55\u51fa\u5e93\u4ed3\u4f4d\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_20", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                        this.addErrorMessage(this.dataEntities[i], format);
                        continue;
                    }
                    DynamicObjectCollection entryEntity = outwarehouse.getDynamicObjectCollection("entryentity");
                    List collect = entryEntity.stream().map(var -> var.getDynamicObject("location").getLong("id")).collect(Collectors.toList());
                    if (outlocation == null || collect.contains(outlocation.getLong("id"))) continue;
                    String format5 = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u7684\u51fa\u5e93\u4ed3\u5e93\u542f\u7528\u4ed3\u4f4d\u4f46\u662f\u4ed3\u4f4d\u4e0e\u4ed3\u5e93\u4e0d\u7b26\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_18", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                    this.addErrorMessage(this.dataEntities[i], format5);
                    continue;
                }
                if (outlocation == null) continue;
                format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u7684\u51fa\u5e93\u4ed3\u5e93\u672a\u542f\u7528\u4ed3\u4f4d\u4f46\u662f\u4ed3\u4f4d\u6709\u503c\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_19", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                this.addErrorMessage(this.dataEntities[i], format);
            }
            Map<Long, Map<String, Object>> orderById = MftReqOutBillUtil.getOrderById(mftOrderIdList, "om_mftorder");
            this.bizDateValid(this.dataEntities[i], orderById);
        }
    }

    private void bizDateValid(ExtendedDataEntity dataEntity, Map<Long, Map<String, Object>> orderById) {
        DynamicObject obj = dataEntity.getDataEntity();
        Date biztime = obj.getDate("biztime");
        if (biztime == null) {
            String format = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_9", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
            this.addErrorMessage(dataEntity, format);
            return;
        }
        Date dayEndTime = DateUtils.getDate((Date)biztime);
        for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
            String format;
            DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
            Long entryId = entryObj.getLong("manuentryid");
            if (!orderById.containsKey(entryId)) continue;
            Map<String, Object> map = orderById.get(entryId);
            Date transmitTime = (Date)map.get("treeentryentity.transmittime");
            if (transmitTime == null) {
                format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u5de5\u5355\u7684\u4e0b\u8fbe\u65e5\u671f\u4e3a\u7a7a\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_15", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                this.addErrorMessage(dataEntity, format);
                continue;
            }
            if ((transmitTime = DateUtils.getDate((Date)transmitTime)) == null || !dayEndTime.before(transmitTime)) continue;
            format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u5de5\u5355\u7684\u4e0b\u8fbe\u65e5\u671f\u5927\u4e8e\u5165\u5e93\u5355\u7684\u4e1a\u52a1\u65e5\u671f\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"OmInCmplBillSaveOrSubmitOpValidator_16", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
            this.addErrorMessage(dataEntity, format);
        }
    }

    private Map<Long, Long[]> getWarehouse(String formId, Set<Long> ids) {
        HashMap<Long, Long[]> resultMap = new HashMap<Long, Long[]>(16);
        if (CollectionUtils.isEmpty(ids)) {
            return resultMap;
        }
        for (Long orgId : ids) {
            List<Long> result = this.setWareHouseIsolate(formId, orgId);
            if (result == null) {
                Long[] allWarehouseIDs = WarehouseHelper.getAllWarehouseIDs((Long)orgId);
                resultMap.put(orgId, allWarehouseIDs);
                continue;
            }
            resultMap.put(orgId, result.toArray(new Long[result.size()]));
        }
        return resultMap;
    }

    private List<Long> setWareHouseIsolate(String formId, Long id) {
        long userId = UserServiceHelper.getCurrentUserId();
        Object wareHouseIsolate = AppParameterHelper.getAppParameterByFormId((String)formId, (Long)id, (String)"fwarehouseisolate");
        if (wareHouseIsolate instanceof Boolean && !((Boolean)wareHouseIsolate).booleanValue()) {
            return null;
        }
        List wareHouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId((Long)userId, Collections.singletonList(id));
        if (CollectionUtils.isEmpty((Collection)wareHouses)) {
            return null;
        }
        ArrayList<Long> wareHouseIds = new ArrayList<Long>(16);
        for (DynamicObject wareHose : wareHouses) {
            Long wareHosePkValue = (Long)wareHose.getPkValue();
            wareHouseIds.add(wareHosePkValue);
        }
        return wareHouseIds;
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj.toString().trim().length() == 0;
        }
        return obj == null;
    }
}

