/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.omoutbill;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import kd.scmc.im.common.mdc.enums.OperateEnum;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import org.apache.commons.lang3.StringUtils;

public class OMReqOutBillValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set strings = super.preparePropertys();
        strings.add("isvirtualbill");
        strings.add("billentry.manuentryid");
        strings.add("billentry.mainbillentryid");
        strings.add("billentry.baseqty");
        return strings;
    }

    public void validate() {
        String operate = this.getOperateKey();
        HashSet<Long> manuEntryId = new HashSet<Long>(10);
        HashSet<Long> mainBillEntryId = new HashSet<Long>(10);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                manuEntryId.add(entryObj.getLong("manuentryid"));
                mainBillEntryId.add(entryObj.getLong("mainbillentryid"));
            }
        }
        Map<String, Map<String, String>> mftOrder = this.getMftOrder(manuEntryId);
        Map<String, Map<String, Object>> mftStock = MftReqOutBillUtil.getMftStockByMainBillEntryIds(mainBillEntryId, "om_mftstock");
        HashSet orderBizStatus = Sets.newHashSet((Object[])new String[]{"B", "C", "D"});
        switch (operate) {
            case "audit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    DynamicObject obj = this.dataEntities[i].getDataEntity();
                    for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                        DynamicObject transObj;
                        DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                        if (0L == entryObj.getLong("manubillid")) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"OMReqOutBillValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                            continue;
                        }
                        Map<String, String> manuObj = mftOrder.get(entryObj.getString("manuentryid"));
                        if (manuObj == null) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"OMReqOutBillValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                            continue;
                        }
                        if (!"C".equals(manuObj.get("billstatus"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u975e\u5ba1\u6838\u72b6\u6001\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"OMReqOutBillValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                            continue;
                        }
                        String bizStatus = manuObj.get("bizstatus");
                        if (!obj.getBoolean("isvirtualbill") && orderBizStatus.contains(bizStatus)) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e3a\uff1a\u6302\u8d77/\u5173\u95ed/\u7ed3\u6848\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"OMReqOutBillValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                        }
                        if ((transObj = obj.getDynamicObject("invscheme").getDynamicObject("transceivertype")) == null) continue;
                        transObj = BusinessDataServiceHelper.loadSingleFromCache((Object)transObj.getPkValue(), (String)transObj.getDataEntityType().getName());
                        if (null == entryObj.getString("mainbillentity") || "".equals(entryObj.getString("mainbillentity"))) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"OMReqOutBillValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                            continue;
                        }
                        Map<String, Object> stockObj = mftStock.get(entryObj.getString("mainbillentryid"));
                        if (null == stockObj) {
                            return;
                        }
                        BigDecimal actQty = (BigDecimal)stockObj.get("stockentry.actissueqty");
                        BigDecimal rejQty = (BigDecimal)stockObj.get("stockentry.rejectedqty");
                        BigDecimal feedQty = (BigDecimal)stockObj.get("stockentry.feedingqty");
                        if ("B".equals(stockObj.get("stockentry.overissuecontrl")) && "0".equals(transObj.getString("bizdirection")) && "1".equals(transObj.getString("transceiver")) || !Boolean.FALSE.equals(stockObj.get("stockentry.iscannegative")) || !"1".equals(transObj.getString("bizdirection")) || !"0".equals(transObj.getString("transceiver")) || entryObj.getBigDecimal("baseqty").add(rejQty).subtract(feedQty).compareTo(actQty) <= 0) continue;
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u9000\u6599\u6570\u91cf\u201c%2$s\u201d\u51cf\u53bb\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u8865\u6599\u6570\u91cf\u201c%3$s\u201d\u8d85\u8fc7\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u5b9e\u53d1\u6570\u91cf\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"OMReqOutBillValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, entryObj.getBigDecimal("baseqty").stripTrailingZeros().toPlainString(), rejQty.stripTrailingZeros().toPlainString(), feedQty.stripTrailingZeros().toPlainString(), actQty.stripTrailingZeros().toPlainString()));
                    }
                }
                break;
            }
            case "unaudit": {
                this.checkPomMftOrder(mftOrder);
                break;
            }
            case "chargeagainst": {
                HashSet order = Sets.newHashSet((Object[])new String[]{"B", "C", "D"});
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    DynamicObject obj = this.dataEntities[i].getDataEntity();
                    this.validateOmOrder(obj, mftOrder, orderBizStatus, i);
                    for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                        String format;
                        DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                        BigDecimal qty = entryObj.getBigDecimal("baseqty");
                        Map<String, Object> manuObj = mftStock.get(entryObj.getString("mainbillentryid"));
                        if (manuObj == null) {
                            return;
                        }
                        BigDecimal actissueQty = (BigDecimal)manuObj.get("stockentry.actissueqty");
                        BigDecimal rejectedQty = (BigDecimal)manuObj.get("stockentry.rejectedqty");
                        BigDecimal feedingQty = (BigDecimal)manuObj.get("stockentry.feedingqty");
                        BigDecimal useQty = (BigDecimal)manuObj.get("stockentry.useqty");
                        BigDecimal bigDecimal = (actissueQty = actissueQty.subtract(qty)).subtract(rejectedQty).subtract(useQty).add(feedingQty);
                        if (bigDecimal.compareTo(BigDecimal.ZERO) >= 0 || !((Boolean)manuObj.get("transactiontypeid.isreturn")).booleanValue()) continue;
                        if ("A".equals(manuObj.get("transactiontypeid.returncontrol"))) {
                            format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355 %2$s\u7b2c%3$s\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u662f\u5426\u7ee7\u7eed%4$s\uff1f", (String)"OMReqOutBillValidator_9", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                            this.addWarningMessage(this.dataEntities[i], format);
                            continue;
                        }
                        if (!"B".equals(manuObj.get("transactiontypeid.returncontrol"))) continue;
                        format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355 %2$s\u7b2c%3$s\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"OMReqOutBillValidator_10", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                        this.addErrorMessage(this.dataEntities[i], format);
                    }
                }
                break;
            }
        }
    }

    private void validateOmOrder(DynamicObject obj, Map<String, Map<String, String>> mftOrder, Set<String> orderBizStatus, int i) {
        for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
            DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
            if (0L == entryObj.getLong("manubillid")) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"OMReqOutBillValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                continue;
            }
            Map<String, String> manuObj = mftOrder.get(entryObj.getString("manuentryid"));
            if (manuObj == null) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"OMReqOutBillValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                continue;
            }
            if (!"C".equals(manuObj.get("billstatus"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u975e\u5ba1\u6838\u72b6\u6001\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"OMReqOutBillValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                continue;
            }
            String bizStatus = manuObj.get("bizstatus");
            if (obj.getBoolean("isvirtualbill") || !orderBizStatus.contains(bizStatus)) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e3a\uff1a\u6302\u8d77/\u5173\u95ed/\u7ed3\u6848\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"OMReqOutBillValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
        }
    }

    private void checkPomMftOrder(Map<String, Map<String, String>> mftOrder) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                if (0L == entryObj.getLong("manubillid")) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"OMReqOutBillValidator_6", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                    continue;
                }
                Map<String, String> manuObj = mftOrder.get(entryObj.getString("manuentryid"));
                if (manuObj == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u4e0d\u5b58\u5728\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"OMReqOutBillValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                    continue;
                }
                if (!"C".equals(manuObj.get("billstatus"))) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u59d4\u5916\u5de5\u5355\u4e0d\u4e3a\u5ba1\u6838\u72b6\u6001\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"OMReqOutBillValidator_7", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"A", (CharSequence)manuObj.get("bizstatus")) && StringUtils.equals((CharSequence)"C", (CharSequence)manuObj.get("planstatus"))) continue;
                String format = String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u59d4\u5916\u5de5\u5355%2$s\u7b2c%3$s\u884c\u7684\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u4e0b\u8fbe\u4e14\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u6b63\u5e38\uff0c%4$s\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"OMReqOutBillValidator_8", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), manuObj.get("billno"), manuObj.get("seq"), BillTypeEnum.getValue(this.entityKey));
                this.addErrorMessage(this.dataEntities[i], format);
            }
        }
    }

    private Map<String, Map<String, String>> getMftOrder(Set<Long> manuEntryId) {
        String algoKey = "queryMftOrder";
        String selectFields = "id,billno,billstatus,treeentryentity.id,treeentryentity.seq,treeentryentity.producttype,treeentryentity.material,treeentryentity.iscontrolqty,treeentryentity.inwarmax,treeentryentity.inwarmin,treeentryentity.quainwaqty,treeentryentity.waitcheckqty,treeentryentity.unquainwaqty,treeentryentity.scrinwaqty,treeentryentity.bizstatus,treeentryentity.planstatus";
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(256);
        QFilter qFilter = new QFilter("treeentryentity.id", "in", manuEntryId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"om_mftorder", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> map1 = new HashMap<String, String>(16);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("treeentryentity.id", row.getString("treeentryentity.id"));
                map1.put("bizstatus", row.getString("treeentryentity.bizstatus"));
                map1.put("planstatus", row.getString("treeentryentity.planstatus"));
                map1.put("seq", row.getString("treeentryentity.seq"));
                map.put(row.getString("treeentryentity.id"), map1);
            }
        }
        return map;
    }
}

