/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.omoutbill;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.common.mdc.enums.OperateEnum;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;

public class OMReqProBillValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(OMReqProBillValidator.class);

    public void validate() {
        String operate = this.getOperateKey();
        HashSet<Long> mainBillEntryId = new HashSet<Long>(10);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                mainBillEntryId.add(entryObj.getLong("mainbillentryid"));
            }
        }
        switch (operate) {
            case "audit": 
            case "submit": {
                if (!"im_mdc_omreturnbill".equals(this.entityKey)) {
                    return;
                }
                this.calcPickingNum(operate, mainBillEntryId);
                break;
            }
            case "unaudit": {
                if ("im_mdc_omreturnbill".equals(this.entityKey)) {
                    for (int i = 0; i < this.dataEntities.length; ++i) {
                        ExtendedDataEntity extendedDataEntity = this.dataEntities[i];
                        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                        if (!this.getOption().containsVariable("ismanual") || !dataEntity.getBoolean("isbackflush")) continue;
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5012\u51b2\u59d4\u5916\u9000\u6599\u5355\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u53cd\u5ba1\u6838\u3002", (String)"OMReqProBillValidator_10", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    }
                    return;
                }
                this.calcPickingNum(operate, mainBillEntryId);
                break;
            }
            case "chargeagainst": {
                logger.debug("\u51b2\u9500\u5f00\u59cb");
                this.calcPickingNum(operate, mainBillEntryId);
                break;
            }
        }
    }

    private void validateinvsheme(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        if (this.getOption().containsVariable("ismanual") && dataEntity.getBoolean("isbackflush")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5012\u51b2\u59d4\u5916\u9886\u6599\u5355\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u53cd\u5ba1\u6838\u3002", (String)"OMReqProBillValidator_7", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        }
    }

    private void calcPickingNum(String operate, Set<Long> mainBillEntryId) {
        Map<String, Map<String, Object>> mftStock = MftReqOutBillUtil.getMftStockByMainBillEntryIds(mainBillEntryId, "om_mftstock");
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            if ("unaudit".equals(operate)) {
                this.validateinvsheme(this.dataEntities[i]);
            }
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                String format;
                DynamicObject transactionType;
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                BigDecimal qty = entryObj.getBigDecimal("baseqty");
                Map<String, Object> manuObj = mftStock.get(entryObj.getString("mainbillentryid"));
                if (manuObj == null) {
                    logger.error("\u7ec4\u4ef6\u6e05\u5355\u6ca1\u6709\u6570\u636e");
                    return;
                }
                BigDecimal actissueQty = (BigDecimal)manuObj.get("stockentry.actissueqty");
                BigDecimal rejectedQty = (BigDecimal)manuObj.get("stockentry.rejectedqty");
                BigDecimal feedingQty = (BigDecimal)manuObj.get("stockentry.feedingqty");
                BigDecimal useQty = (BigDecimal)manuObj.get("stockentry.useqty");
                BigDecimal bigDecimal = actissueQty.subtract(rejectedQty.subtract(qty)).add(feedingQty).subtract(useQty);
                if (!obj.getBoolean("ischargeoff")) {
                    bigDecimal = actissueQty.subtract(rejectedQty.add(qty)).add(feedingQty).subtract(useQty);
                }
                logger.debug("\u9886\u6599\u57fa\u672c\u6570\u91cf" + qty.toPlainString());
                logger.debug("\u5b9e\u53d1\u6570\u91cf" + actissueQty.toPlainString());
                logger.debug("\u9000\u6599\u6570\u91cf" + rejectedQty.toPlainString());
                logger.debug("\u8865\u6599\u6570\u91cf" + feedingQty.toPlainString());
                logger.debug("\u6d88\u8017\u6570\u91cf" + useQty.toPlainString());
                logger.debug("\u5728\u5236\u6570\u91cf" + bigDecimal.toPlainString());
                if (bigDecimal.compareTo(BigDecimal.ZERO) >= 0 || !(transactionType = BusinessDataServiceHelper.loadSingleFromCache((Object)manuObj.get("transactiontypeid"), (String)"mpdm_transactproduct")).getBoolean("isreturn")) continue;
                if ("A".equals(transactionType.get("returncontrol"))) {
                    format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355 %2$s\u7b2c%3$s\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u662f\u5426\u7ee7\u7eed%4$s\uff1f", (String)"OMReqProBillValidator_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                    this.addWarningMessage(this.dataEntities[i], format);
                    continue;
                }
                if (!"B".equals(transactionType.get("returncontrol"))) continue;
                format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u5bf9\u5e94\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355 %2$s\u7b2c%3$s\u884c\u5206\u5f55\u5728\u5236\u6570\u91cf\u4e3a\u8d1f\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"OMReqProBillValidator_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, manuObj.get("billno"), manuObj.get("stockentry.seq"), OperateEnum.getValue(operate));
                this.addErrorMessage(this.dataEntities[i], format);
            }
        }
    }
}

