/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.adjustbill;

import java.util.LinkedList;
import java.util.List;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.consts.InvBillConst;
import kd.scmc.im.helper.TriggerEventHelper;
import kd.scmc.im.validator.plugin.TransFormBillValidatorPlugin;

public class AdjustBillAuditOp
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(AdjustBillAuditOp.class);
    private static List<String> SubEntryList = new LinkedList<String>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        InvBillConst.getSelectorListForAcc().forEach(field -> e.getFieldKeys().add(field));
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("billentry.afterentity.seq");
        e.getFieldKeys().addAll(SubEntryList);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        TransFormBillValidatorPlugin tplValidator = new TransFormBillValidatorPlugin(e, "audit", this.billEntityType.getName());
        tplValidator.validate();
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operate = (String)this.operateMeta.get("type");
        String formId = this.billEntityType.getName();
        TriggerEventHelper triggerEventHelper = new TriggerEventHelper();
        triggerEventHelper.triggerEventByOp(e.getDataEntities(), operate, formId, this.getOption());
    }

    static {
        SubEntryList.add("ownertype1");
        SubEntryList.add("owner1");
        SubEntryList.add("keepertype1");
        SubEntryList.add("keeper1");
        SubEntryList.add("invstatus1");
        SubEntryList.add("invtype1");
        SubEntryList.add("material1");
        SubEntryList.add("auxpty1");
        SubEntryList.add("warehouse1");
        SubEntryList.add("location1");
        SubEntryList.add("lot1");
        SubEntryList.add("lotnumber1");
        SubEntryList.add("producedate1");
        SubEntryList.add("expirydate1");
        SubEntryList.add("project1");
        SubEntryList.add("baseunit1");
        SubEntryList.add("baseqty1");
        SubEntryList.add("qty1");
        SubEntryList.add("unit2nd1");
        SubEntryList.add("qtyunit2nd1");
        SubEntryList.add("entrycomment1");
    }
}

