/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.adjustbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.SerialNumberHelper;
import kd.scmc.im.consts.AdjustBillConst;
import org.apache.commons.collections4.CollectionUtils;

public class AdjustBillSaveOp
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(AdjustBillSaveOp.class);

    public static List<String> getSubEntryList() {
        List<String> selectors = Arrays.asList("configuredcode", "tracknumber", "project");
        selectors.forEach(field -> selectors.set(selectors.indexOf(field), field + "1"));
        return selectors;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        AdjustBillSaveOp.getSubEntryList().forEach(field -> e.getFieldKeys().add(field));
        e.getFieldKeys().add("billentry.afterentity.material");
        e.getFieldKeys().add("billentry.afterentity.srcbillid");
        e.getFieldKeys().add("billentry.afterentity.srcbillentryid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] bills;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection beforeRows;
            Long bizTypeId;
            DynamicObject bizType = bill.getDynamicObject("biztype");
            Long l = bizTypeId = bizType == null ? null : (Long)bizType.getPkValue();
            if (!this.isCarry(bizTypeId) || CollectionUtils.isEmpty((Collection)(beforeRows = bill.getDynamicObjectCollection("billentry")))) continue;
            for (DynamicObject beforeRow : beforeRows) {
                Object configureCode = beforeRow.get("configuredcode");
                Object trackNumber = beforeRow.get("tracknumber");
                Object project = beforeRow.get("project");
                DynamicObjectCollection afterRows = beforeRow.getDynamicObjectCollection("afterentity");
                if (CollectionUtils.isEmpty((Collection)afterRows)) continue;
                for (DynamicObject afterRow : afterRows) {
                    afterRow.set("configuredcode1", configureCode);
                    afterRow.set("tracknumber1", trackNumber);
                    afterRow.set("project1", project);
                }
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.endOperationTransaction(e);
        for (DynamicObject bill : bills = e.getDataEntities()) {
            AdjustBillSaveOp.isSerialNumber(bill);
        }
    }

    private boolean isCarry(Long bizTypeId) {
        if (null == bizTypeId) {
            return false;
        }
        return AdjustBillConst.BIZTYPE_LOTADJUST.equals(bizTypeId) || AdjustBillConst.BIZTYPE_STATUSADJUST.equals(bizTypeId) || AdjustBillConst.BIZTYPE_SNADJUST.equals(bizTypeId) || AdjustBillConst.BIZTYPE_UNITADJUST.equals(bizTypeId);
    }

    private static void isSerialNumber(DynamicObject bill) {
        boolean enableSerial = SerialNumberHelper.isInvBillEnableSerial((DynamicObject)bill);
        if (enableSerial) {
            AdjustBillSaveOp.copySerialNumber(bill);
        }
    }

    private static void copySerialNumber(DynamicObject adjustBill) {
        DynamicObjectCollection billEntries = adjustBill.getDynamicObjectCollection("billentry");
        for (DynamicObject billEntry : billEntries) {
            DynamicObject material = billEntry.getDynamicObject("material");
            if (!SerialNumberHelper.isEnableSerial((DynamicObject)material)) continue;
            Long srcBillId = billEntry.getLong("srcbillid");
            Long srcBillEntryId = billEntry.getLong("srcbillentryid");
            String srcBillEntity = billEntry.getString("srcbillentity");
            QFilter filter = new QFilter("billtype", "=", (Object)srcBillEntity).and("entrykey", "=", (Object)"billentry").and("billid", "=", (Object)srcBillId).and("entryid", "=", (Object)srcBillEntryId);
            DynamicObject srcBillSNRelation = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_billsnrelation", (QFilter[])filter.toArray());
            if (srcBillSNRelation == null) continue;
            DynamicObjectCollection srcBillSNRelationEntries = srcBillSNRelation.getDynamicObjectCollection("entryentity");
            if (billEntry.getBigDecimal("qty").intValue() != srcBillSNRelationEntries.size()) continue;
            ArrayList srcSNs = new ArrayList(srcBillSNRelationEntries.size());
            for (DynamicObject srcSNRelationEntry : srcBillSNRelationEntries) {
                HashMap<String, Object> srcSN = new HashMap<String, Object>(5);
                srcSN.put("snnumber", srcSNRelationEntry.get("snnumber"));
                srcSN.put("seq", srcSNRelationEntry.get("seq"));
                srcSN.put("invorg", srcSNRelationEntry.get("invorg"));
                srcSN.put("imei", srcSNRelationEntry.get("imei"));
                srcSN.put("meid", srcSNRelationEntry.get("meid"));
                srcSNs.add(srcSN);
            }
            DynamicObjectCollection afterBillEntries = billEntry.getDynamicObjectCollection("afterentity");
            SerialNumberHelper.quickBatchInputSerialNumber((String)"im_adjustbill", (Object)adjustBill.getPkValue(), (String)"billentry", (Object)billEntry.getPkValue(), (String)srcBillEntity, (Long)srcBillId, (String)"billentry", (Long)srcBillEntryId, (Object)material.get("id"), srcSNs);
            for (DynamicObject afterBillEntry : afterBillEntries) {
                SerialNumberHelper.quickBatchInputSerialNumber((String)"im_adjustbill", (Object)adjustBill.getPkValue(), (String)"afterentity", (Object)afterBillEntry.getPkValue(), (String)srcBillEntity, (Long)srcBillId, (String)"billentry", (Long)srcBillEntryId, (Object)material.get("id"), srcSNs);
            }
        }
    }
}

