/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.assembbill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.opplugin.assembbill.AbstractAssembBillOp;
import kd.scmc.im.validator.improt.TransFormImportHandle;
import kd.scmc.im.validator.plugin.TransFormBillValidatorPlugin;

public class AssembBillSaveOp
extends AbstractAssembBillOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        TransFormBillValidatorPlugin tplValidator = new TransFormBillValidatorPlugin(e, "save", this.billEntityType.getName());
        tplValidator.validate();
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"AssembBillSaveOp", (String)"beginOperationTransaction");){
            TransFormImportHandle importHandle;
            List<String> errorMsg;
            super.beginOperationTransaction(e);
            ArrayList<DynamicObject> importData = new ArrayList<DynamicObject>();
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities.length == 0) {
                return;
            }
            for (DynamicObject dataEntity : dataEntities) {
                String billCreType = dataEntity.getString("billcretype");
                if (!"1".equals(billCreType) && !"3".equals(billCreType)) continue;
                importData.add(dataEntity);
            }
            if (!importData.isEmpty() && !(errorMsg = (importHandle = new TransFormImportHandle(importData)).getErrorMsg()).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String err : errorMsg) {
                    sb.append(err).append("\r\n");
                }
                throw new KDBizException(sb.toString());
            }
        }
    }
}

