/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.assembbill;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.helper.TriggerEventHelper;
import kd.scmc.im.opplugin.assembbill.AbstractAssembBillOp;
import kd.scmc.im.validator.adjustbill.AdjustLocationMustInputValidator;
import kd.scmc.im.validator.general.LocationMustInputValidator;
import kd.scmc.im.validator.plugin.TransFormBillValidatorPlugin;

public class AssembBillSubmitOp
extends AbstractAssembBillOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new LocationMustInputValidator("warehouse", "location"));
        e.getValidators().add(new AdjustLocationMustInputValidator("warehouse1", "location1"));
        TransFormBillValidatorPlugin tplValidator = new TransFormBillValidatorPlugin(e, "submit", this.billEntityType.getName());
        tplValidator.validate();
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (LotMainFileHelper.isUseLotMainFile()) {
            LotMainFileHelper.matchBillLotId((DynamicObject[])e.getDataEntities(), (String)"submit");
        }
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] invBills;
        for (DynamicObject invBill : invBills = e.getDataEntities()) {
            invBill.set("lastupdateuser", (Object)UserServiceHelper.getCurrentUser((String)"id"));
            invBill.set("lastupdatetime", (Object)new Date());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operate = (String)this.operateMeta.get("type");
        String formId = this.billEntityType.getName();
        TriggerEventHelper triggerEventHelper = new TriggerEventHelper();
        triggerEventHelper.triggerEventByOp(e.getDataEntities(), operate, formId, this.getOption());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }
}

