/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.balanceinv;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.reserve.mservice.ReserveService;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.utils.InvAdviceReserveRelease;

public class BalanceAdviseReserveOp
extends AbstractOperationServicePlugIn {
    public static final String PM_REQUIRAPPLYBILL = "pm_requirapplybill";
    private static Log logger = LogFactory.getLog(BalanceAdviseReserveOp.class);
    private List<Long> modifiedMatIds = new ArrayList<Long>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("advicetype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        boolean needReserve = BalanceInvExecuteHelper.getNeedReserve();
        if (needReserve) {
            DynamicObject[] bills = e.getDataEntities();
            List<Long> qtyModifiedBillIds = this.getQtyModifiedBillIds(bills);
            List billList = Arrays.stream(bills).filter(bill -> qtyModifiedBillIds.contains(bill.getLong("id"))).collect(Collectors.toList());
            if (billList != null && !billList.isEmpty()) {
                InvAdviceReserveRelease.releaseReservation(billList);
                this.modifiedMatIds = billList.stream().filter(bill -> {
                    String adviceType = bill.getString("advicetype");
                    return !"A".equals(adviceType) && !"F".equals(adviceType);
                }).map(bill -> bill.getLong("id")).collect(Collectors.toList());
            }
        }
    }

    private List<Long> getQtyModifiedBillIds(DynamicObject[] bills) {
        Map<Long, DynamicObject> billMap = Arrays.stream(bills).filter(bill -> bill.getLong("id") != 0L).collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill));
        String selector = "id,entryentity.id,entryentity.baseqty";
        QFilter filter = new QFilter("id", "in", billMap.keySet());
        DynamicObjectCollection oldBills = QueryServiceHelper.query((String)"im_balanceinv_advice", (String)selector, (QFilter[])filter.toArray());
        ArrayList<Long> qtyModifiedBillIds = new ArrayList<Long>();
        if (oldBills == null) {
            return qtyModifiedBillIds;
        }
        Map<Long, BigDecimal> entryBaseQtyMap = oldBills.stream().collect(Collectors.toMap(bill -> bill.getLong("entryentity.id"), bill -> bill.getBigDecimal("entryentity.baseqty")));
        block0: for (DynamicObject bill2 : oldBills) {
            bill2 = billMap.get(bill2.getLong("id"));
            DynamicObjectCollection entries = bill2.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                BigDecimal newBaseQty = entry.getBigDecimal("baseqty");
                BigDecimal oldBaseQty = entryBaseQtyMap.get(entry.getLong("id"));
                if (oldBaseQty != null && oldBaseQty.compareTo(newBaseQty) == 0) continue;
                qtyModifiedBillIds.add(bill2.getLong("id"));
                continue block0;
            }
        }
        return qtyModifiedBillIds;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        boolean needReserve = BalanceInvExecuteHelper.getNeedReserve();
        if (needReserve) {
            DynamicObject[] dataEntities = e.getDataEntities();
            Set<Long> adviseIdSet = Arrays.stream(dataEntities).filter(data -> data.getString("advicetype").equals("A")).map(data -> data.getLong("id")).collect(Collectors.toSet());
            this.reservePreIn(adviseIdSet);
            if (this.modifiedMatIds != null && !this.modifiedMatIds.isEmpty()) {
                ArrayList<Long> adviceIds = new ArrayList<Long>();
                adviceIds.addAll(this.modifiedMatIds);
                OperationResult result = ReserveService.autoReserveByIds((String)"im_balanceinv_advice", adviceIds);
                if (!result.isSuccess()) {
                    throw new KDBizException(result.getMessage());
                }
                this.updateReservationRecord(dataEntities, this.modifiedMatIds);
            }
        }
    }

    private void updateReservationRecord(DynamicObject[] dataEntities, List<Long> modifiedIds) {
        ArrayList<Long> billIdList = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> entryIdList = new ArrayList<Long>(dataEntities.length);
        HashMap<Long, DynamicObject> adviceEntryMap = new HashMap<Long, DynamicObject>(dataEntities.length);
        for (DynamicObject adviseInfo : dataEntities) {
            long id = adviseInfo.getLong("id");
            if (!modifiedIds.contains(id)) continue;
            billIdList.add(id);
            DynamicObjectCollection entries = adviseInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                entryIdList.add(entry.getLong("id"));
                adviceEntryMap.put(entry.getLong("id"), entry);
            }
        }
        Map entrySourceInfo = BalanceInvExecuteHelper.getEntryBFRowIdMap((String)"im_balanceinv_advice", (String)"entryentity", billIdList, entryIdList);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(entrySourceInfo.size());
        if (!entrySourceInfo.isEmpty()) {
            HashSet sourceEntryIds = new HashSet(entrySourceInfo.size());
            for (Map sourceInfo : entrySourceInfo.values()) {
                sourceEntryIds.add(sourceInfo.get("entryid"));
            }
            String billType = PM_REQUIRAPPLYBILL;
            QFilter qFilter = new QFilter("billentry.id", "in", sourceEntryIds);
            DynamicObjectCollection sourceInfos = QueryServiceHelper.query((String)billType, (String)"billentry.id,billno,billentry.seq", (QFilter[])qFilter.toArray());
            Map<Long, DynamicObject> sourceObjMap = sourceInfos.stream().collect(Collectors.toMap(info -> info.getLong("billentry.id"), info -> info));
            for (Map.Entry entrySourceEntry : entrySourceInfo.entrySet()) {
                Object[] param = new Object[9];
                Long tarEntryId = (Long)entrySourceEntry.getKey();
                Map sourceInfoMap = (Map)entrySourceEntry.getValue();
                param[0] = billType;
                param[1] = sourceInfoMap.get("id");
                Long entryId = (Long)sourceInfoMap.get("entryid");
                param[2] = entryId;
                DynamicObject sourceEntry = sourceObjMap.get(entryId);
                param[3] = sourceEntry.get("billno");
                param[4] = sourceEntry.get("billentry.seq");
                DynamicObject adviceEntry = (DynamicObject)adviceEntryMap.get(tarEntryId);
                param[5] = adviceEntry.getDynamicObject("demandorg") == null ? Long.valueOf(0L) : adviceEntry.getDynamicObject("demandorg").getPkValue();
                param[6] = adviceEntry.getDynamicObject("invorg") == null ? Long.valueOf(0L) : adviceEntry.getDynamicObject("invorg").getPkValue();
                param[7] = sourceInfoMap.get("tarbillid");
                param[8] = tarEntryId;
                paramList.add(param);
            }
        }
        if (!paramList.isEmpty()) {
            StringBuilder sql = new StringBuilder(100);
            sql.append(" UPDATE T_MSMOD_RESERVERECORD SET F_BILL_OBJ_ID = ?, F_BILL_ID = ?, F_BILLENTRY_ID = ?, F_BILL_NO = ?, F_BILLENTRY_SEQ = ?, F_R_SALE_ORG = ?,F_R_INVORG = ? WHERE F_BILL_ID = ? AND F_BILLENTRY_ID = ?");
            String dbRouteKey = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getDBRouteKey();
            DB.executeBatch((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql.toString(), paramList);
        }
    }

    private void reservePreIn(Set<Long> adviseIdSet) {
        Map reserveResult;
        if (adviseIdSet == null || adviseIdSet.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("bal_id", "in", adviseIdSet);
        DynamicObjectCollection reservedAdvise = QueryServiceHelper.query((String)"msmod_reserve_record", (String)"bal_entryid", (QFilter[])filter.toArray());
        Set reservedEntryIds = reservedAdvise.stream().map(adviseInfo -> adviseInfo.getLong("bal_entryid")).collect(Collectors.toSet());
        filter = new QFilter("id", "in", adviseIdSet).and("advicetype", "=", (Object)"A");
        if (reservedEntryIds != null && !reservedEntryIds.isEmpty()) {
            filter = filter.and(new QFilter("entryentity.id", "not in", reservedEntryIds));
        }
        StringBuilder selectorBuilder = new StringBuilder();
        selectorBuilder.append("id,entryentity.id,entryentity.material,entryentity.baseqty");
        DynamicObjectCollection adviseCol = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"im_balanceinv_advice", (String)selectorBuilder.toString(), (QFilter[])filter.toArray(), (String)"");
        if (adviseCol == null || adviseCol.isEmpty()) {
            return;
        }
        HashMap<Long, DynamicObject> entry2ObjMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject adviseInfo2 : adviseCol) {
            entry2ObjMap.put(adviseInfo2.getLong("entryentity.id"), adviseInfo2);
        }
        ArrayList<Long> billIdList = new ArrayList<Long>(adviseCol.size());
        ArrayList<Long> entryIdList = new ArrayList<Long>(adviseCol.size());
        for (DynamicObject adviseInfo3 : adviseCol) {
            billIdList.add(adviseInfo3.getLong("id"));
            entryIdList.add(adviseInfo3.getLong("entryentity.id"));
        }
        Map entryIdSoueceMap = BalanceInvExecuteHelper.getEntryBFRowIdMap((String)"im_balanceinv_advice", (String)"entryentity", billIdList, entryIdList);
        ArrayList<Map<String, Object>> reserveParamList = new ArrayList<Map<String, Object>>(adviseCol.size());
        for (Map.Entry entryIdEntry : entryIdSoueceMap.entrySet()) {
            DynamicObject adviseInfo4 = (DynamicObject)entry2ObjMap.get(entryIdEntry.getKey());
            Map entryInfoMap = (Map)entryIdEntry.getValue();
            Map<String, Object> paramMap = this.getReserveParam(adviseInfo4, entryInfoMap);
            reserveParamList.add(paramMap);
        }
        if (!reserveParamList.isEmpty() && Boolean.FALSE.equals((reserveResult = this.invokeReserveService(PM_REQUIRAPPLYBILL, reserveParamList)).get("success"))) {
            StringBuilder stepErrorMsg = new StringBuilder();
            stepErrorMsg.append(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25\uff1a", (String)"BalanceAdviseSaveOp_0", (String)"scmc-im-business", (Object[])new Object[0]));
            stepErrorMsg.append(reserveResult.get("errMsg")).append("\n");
            throw new KDBizException(stepErrorMsg.toString());
        }
    }

    private Map invokeReserveService(String entityNum, List<Map<String, Object>> reserveParamList) {
        logger.info("\u4f20\u9012\u7ed9\u9884\u7559\u63a5\u53e3\u53c2\u6570\u4e3a\uff1a" + reserveParamList);
        String resultJson = (String)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"reserveBatchFree", (Object[])new Object[]{"im_balanceinv_advice", entityNum, false, reserveParamList});
        logger.info("\u7ed9\u9884\u7559\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + resultJson);
        Map reserveResult = (Map)SerializationUtils.fromJsonString((String)resultJson, Map.class);
        return reserveResult;
    }

    private Map<String, Object> getReserveParam(DynamicObject adviseInfo, Map<String, Object> sourceInfoMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(11);
        Object billId = sourceInfoMap.get("id");
        Object entryId = sourceInfoMap.get("entryid");
        Object seq = sourceInfoMap.get("seq");
        paramMap.put("billId", billId);
        paramMap.put("billEntryId", entryId);
        paramMap.put("billEntrySeq", seq);
        paramMap.put("invId", adviseInfo.get("id"));
        paramMap.put("invEntryId", adviseInfo.get("entryentity.id"));
        paramMap.put("baseQty", adviseInfo.get("entryentity.baseqty"));
        paramMap.put("qty", BigDecimal.ZERO);
        paramMap.put("qty2nd", BigDecimal.ZERO);
        paramMap.put("org", 0L);
        paramMap.put("material", adviseInfo.get("entryentity.material"));
        paramMap.put("isPredict", true);
        return paramMap;
    }
}

