/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.balanceinv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.opplugin.balanceinv.validator.BalanceInvCancelValidator;
import kd.scmc.im.utils.GetAdviceType;
import kd.scmc.im.utils.InvAdviceReserveRelease;

public class BalanceInvCancelOp
extends AbstractOperationServicePlugIn {
    private Map<Long, Long> purOrg2AccountOrgCache = new HashMap<Long, Long>();
    private Map<Long, Long> purOrg2InvOrgCache = new HashMap<Long, Long>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BalanceInvCancelValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] invAdviceBills = this.queryData(e.getDataEntities());
        String cancelEntryIdStr = this.getOption().getVariableValue("cancelentryids", "");
        Set selectEntryIds = null;
        if (StringUtils.isNotBlank((CharSequence)cancelEntryIdStr)) {
            selectEntryIds = (Set)SerializationUtils.fromJsonString((String)cancelEntryIdStr, Set.class);
        }
        ArrayList<DynamicObject> saveToDataBase = new ArrayList<DynamicObject>();
        Set purFocusEntityId = GetAdviceType.getCenterPurEntryIds((Set)selectEntryIds, (DynamicObject[])invAdviceBills);
        HashSet<Long> pushEntryId = new HashSet<Long>(16);
        Map<String, List<ListSelectedRow>> selectedRow = this.getBotpSelectedRow(purFocusEntityId, invAdviceBills, pushEntryId, selectEntryIds);
        for (Map.Entry<String, List<ListSelectedRow>> entry : selectedRow.entrySet()) {
            String adviceType = entry.getKey();
            List<ListSelectedRow> value = entry.getValue();
            if (value.isEmpty()) continue;
            List<DynamicObject> targetBills = this.doPush(value);
            this.handleFieldValue(adviceType, targetBills);
            saveToDataBase.addAll(targetBills);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult opResult = SaveServiceHelper.saveOperate((String)"im_balanceinv_advice", (DynamicObject[])saveToDataBase.toArray(new DynamicObject[saveToDataBase.size()]), (OperateOption)option);
        if (opResult.isSuccess()) {
            boolean needReserve = BalanceInvExecuteHelper.getNeedReserve();
            if (needReserve) {
                InvAdviceReserveRelease.releaseReservation(Arrays.stream(invAdviceBills).collect(Collectors.toList()));
            }
        } else {
            throw new KDBizException(opResult.getMessage());
        }
        InvAdviceReserveRelease.writeBackSourceBillQty((DynamicObject[])invAdviceBills);
        this.updateSourceBillFields(invAdviceBills, pushEntryId);
    }

    private DynamicObject[] queryData(DynamicObject[] dynamicObjects) {
        Object[] ids = new Object[dynamicObjects.length];
        for (int i = 0; i < dynamicObjects.length; ++i) {
            ids[i] = dynamicObjects[i].getPkValue();
        }
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"im_balanceinv_advice"));
    }

    private List<DynamicObject> doPush(List<ListSelectedRow> selectedRows) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setRuleId("1681247403891635200");
        pushArgs.setSourceEntityNumber("im_balanceinv_advice");
        pushArgs.setTargetEntityNumber("im_balanceinv_advice");
        pushArgs.setHasRight(false);
        pushArgs.setAppId("im");
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s\u3002", (String)"BalanceInvCancelOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), errMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"im_balanceinv_advice");
        List targetBillObjs = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType);
        return targetBillObjs;
    }

    private Map<String, List<ListSelectedRow>> getBotpSelectedRow(Set<Object> entryEntityId, DynamicObject[] invAdviceBills, Set<Long> pushEntryId, Set<String> selectEntryIds) {
        ArrayList<ListSelectedRow> purOutRows = new ArrayList<ListSelectedRow>();
        ArrayList<ListSelectedRow> purFocusRows = new ArrayList<ListSelectedRow>();
        for (DynamicObject invAdviceBill : invAdviceBills) {
            Object sourceBillId = invAdviceBill.getPkValue();
            DynamicObjectCollection entryBills = invAdviceBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryBill : entryBills) {
                Object entryBillId = entryBill.getPkValue();
                if (selectEntryIds != null && !selectEntryIds.contains(entryBillId.toString())) continue;
                String isClosed = entryBill.getString("isclosed");
                String isCencel = entryBill.getString("iscancel");
                if ("B".equals(isCencel) || "B".equals(isClosed)) continue;
                ListSelectedRow currentRow = new ListSelectedRow();
                currentRow.setPrimaryKeyValue(sourceBillId);
                currentRow.setEntryEntityKey("entryentity");
                currentRow.setEntryPrimaryKeyValue(entryBillId);
                pushEntryId.add((Long)entryBillId);
                if (entryEntityId.contains(entryBillId)) {
                    purFocusRows.add(currentRow);
                    continue;
                }
                purOutRows.add(currentRow);
            }
        }
        HashMap<String, List<ListSelectedRow>> result = new HashMap<String, List<ListSelectedRow>>(2);
        result.put("A", purOutRows);
        result.put("F", purFocusRows);
        return result;
    }

    private void handleFieldValue(String adviceType, List<DynamicObject> adviceBills) {
        for (DynamicObject bill : adviceBills) {
            bill.set("advicetype", (Object)adviceType);
            bill.set("supplyorg", (Object)0);
            Long balanceOrgId = bill.getDynamicObject("org").getLong("id");
            DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                BalanceInvExecuteHelper.handlePurAdvice((DynamicObject)entry, (Long)balanceOrgId, this.purOrg2AccountOrgCache, this.purOrg2InvOrgCache);
            }
        }
    }

    private void updateSourceBillFields(DynamicObject[] invAdviceBill, Set<Long> pushEntryId) {
        long currentUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject adviceBill : invAdviceBill) {
            boolean needUpdateHead = true;
            for (DynamicObject entry : adviceBill.getDynamicObjectCollection("entryentity")) {
                if (pushEntryId.contains(entry.getLong("id"))) {
                    entry.set("iscancel", (Object)"B");
                    entry.set("isclosed", (Object)"B");
                }
                if (!"A".equals(entry.getString("iscancel"))) continue;
                needUpdateHead = false;
            }
            if (!needUpdateHead) continue;
            adviceBill.set("repealuser", (Object)currentUserId);
            adviceBill.set("repealtime", (Object)new Date());
            adviceBill.set("billstatus", (Object)"D");
        }
        SaveServiceHelper.save((DynamicObject[])invAdviceBill);
    }
}

