/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.count;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.DymAccDSMappingBill;
import kd.scmc.im.business.helper.DymAccDataSourceHelper;
import kd.scmc.im.business.helper.InvcountSchemeHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.NoUpdateFieldsAnalysisHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.consts.InvCountSchemeConst;

public class DymAccDataSource {
    private static final String TRASCEIVER_RECEIVE = "0";
    private static final String TRASCEIVER_SEND = "1";
    private static final String TRASCEIVER_RECEIVE_AND_SEND = "2";
    private static String algoKey = DymAccDataSource.class.getClass().getName();
    protected static final List<String> invList = Arrays.asList("lotnumber", "qtyunit2nd", "creator", "auditor", "auditdate");
    private static String[] invFormIds = new String[]{"im_transinbill", "im_transoutbill", "im_transdirbill", "im_mdc_mftmanuinbill", "im_mdc_mftreturnorder", "im_saloutbill", "im_purreceivebill", "im_mdc_mftfeedorder", "im_purinbill", "im_productinbill", "im_otheroutbill", "im_disassemblebill", "im_otherinbill", "im_materialreqoutbill", "im_mdc_omcmplinbill", "im_locationtransfer", "im_mdc_omoutbill", "im_assembbill", "im_mdc_omreturnbill", "im_adjustbill", "im_mdc_omfeedbill", "im_mdc_mftproorder", "im_mdc_mftreturnbill"};
    private static final Set<String> invBillSet = new HashSet<String>(32);

    public static DataSet getBeforeEndDateUpdateBill(Set<QFilter> setQFilter) {
        List dymAccDSMappingBillList = DymAccDataSourceHelper.getUpdateBillFromDymAccDS((boolean)false);
        DataSet billSet = DymAccDataSource.getBillDataSet(dymAccDSMappingBillList, setQFilter);
        return DymAccDataSource.filterNoUpdateField(billSet);
    }

    private static DataSet getBillDataSet(List<DymAccDSMappingBill> listDymAccDSMappingBill, Set<QFilter> setQFilter) {
        DataSet billSet = null;
        DataSet schemeAddBillSet = null;
        DataSet schemeSubBillSet = null;
        Algo algo = Algo.create((String)algoKey);
        ArrayList<OrmInput> billAddIos = new ArrayList<OrmInput>(listDymAccDSMappingBill.size());
        ArrayList<OrmInput> billSubIos = new ArrayList<OrmInput>(listDymAccDSMappingBill.size());
        for (DymAccDSMappingBill dymAccDSMappingBill : listDymAccDSMappingBill) {
            String formId = dymAccDSMappingBill.getSrcbill();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            boolean isNeedInvScheme = true;
            if ("im_adjustbill".equals(formId) || "im_locationtransfer".equals(formId) || "im_assembbill".equals(formId) || "im_disassemblebill".equals(formId)) {
                isNeedInvScheme = false;
            } else {
                if (!MetaDataHelper.isExistField((IDataEntityType)mainEntityType, (String)"invscheme")) continue;
                isNeedInvScheme = true;
            }
            DymAccDataSource.setSelectedFiledsByFromId(dymAccDSMappingBill, isNeedInvScheme);
            if (isNeedInvScheme) {
                OrmInput billInput = DymAccDataSource.getBillInput(setQFilter, billSet, dymAccDSMappingBill, formId);
                if (billInput == null) continue;
                if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
                    billAddIos.add(billInput);
                    continue;
                }
                if (!"SUB".equals(dymAccDSMappingBill.getUpdateType())) continue;
                billSubIos.add(billInput);
                continue;
            }
            billSet = DymAccDataSource.handleUpdateBillNotSceme(setQFilter, billSet, dymAccDSMappingBill, formId);
        }
        if (!billAddIos.isEmpty()) {
            schemeAddBillSet = DymAccDataSource.handleBillDataSet(algo.createDataSet((Input[])billAddIos.toArray(new OrmInput[billAddIos.size()])), "ADD");
        }
        if (!billSubIos.isEmpty()) {
            schemeSubBillSet = DymAccDataSource.handleBillDataSet(algo.createDataSet((Input[])billSubIos.toArray(new OrmInput[billSubIos.size()])), "SUB");
        }
        if (billSet != null) {
            String[] fieldNames = null;
            if (schemeAddBillSet != null) {
                fieldNames = schemeAddBillSet.getRowMeta().getFieldNames();
            } else if (fieldNames == null && schemeSubBillSet != null) {
                fieldNames = schemeSubBillSet.getRowMeta().getFieldNames();
            } else if (fieldNames == null) {
                return billSet;
            }
            billSet = billSet.select(fieldNames);
            return billSet.union(schemeAddBillSet).union(schemeSubBillSet);
        }
        if (schemeAddBillSet != null) {
            return schemeAddBillSet.union(schemeSubBillSet);
        }
        return schemeSubBillSet;
    }

    private static DataSet filterNoUpdateField(DataSet billSet) {
        ArrayList<Object[]> lineData = new ArrayList<Object[]>(16);
        RowMeta rowMeta = billSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        for (Row row : billSet) {
            ArrayList<Object> tempData = new ArrayList<Object>(rowMeta.getFieldCount());
            String noUpdateInvFields = row.getString("noupdateinvfields");
            boolean updateField = null != noUpdateInvFields && !noUpdateInvFields.isEmpty();
            List noUpdateInvNumFieldList = NoUpdateFieldsAnalysisHelper.getNoUpdateFieldsList((String)noUpdateInvFields);
            for (String fieldName : fieldNames) {
                Object value = row.get(fieldName);
                if (updateField && noUpdateInvNumFieldList.contains(fieldName)) {
                    value = 0L;
                }
                tempData.add(value);
            }
            lineData.add(tempData.toArray());
        }
        CollectionInput inputs = new CollectionInput(rowMeta, lineData);
        return Algo.create((String)DymAccDataSource.getAlgoKeyAndMethodName()).createDataSet(new Input[]{inputs});
    }

    private static String getAlgoKeyAndMethodName() {
        return Thread.currentThread().getStackTrace()[2].toString();
    }

    private static DataSet handleUpdateBillRecByRecAndSendType(DymAccDSMappingBill dymAccDSMappingBill, Set<QFilter> listQFilter, boolean isNeedInvScheme) {
        ArrayList<QFilter> recListQFilter = new ArrayList<QFilter>(10);
        for (QFilter qFilter : listQFilter) {
            recListQFilter.add(qFilter.copy());
        }
        String formId = dymAccDSMappingBill.getSrcbill();
        recListQFilter.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        if (dymAccDSMappingBill.getqFilter() != null) {
            recListQFilter.add(dymAccDSMappingBill.getqFilter());
        }
        if (isNeedInvScheme) {
            recListQFilter.add(new QFilter("invscheme.isnotupdate", "=", (Object)Character.valueOf('0')));
            recListQFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_RECEIVE, TRASCEIVER_RECEIVE_AND_SEND}));
        }
        Map selectFiledMap = dymAccDSMappingBill.getMapping();
        for (QFilter qFilter : recListQFilter) {
            String property;
            String qFilterName = qFilter.getProperty();
            String[] propertyList = qFilterName.split("\\.");
            if (propertyList.length == 1) {
                property = (String)selectFiledMap.get(qFilterName);
                if (property == null) continue;
                qFilter.__setProperty(property);
                continue;
            }
            property = (String)selectFiledMap.get(propertyList[0]);
            if (property == null) continue;
            if ("material".equals(propertyList[0])) {
                property = DymAccDataSource.transferMaterialKey(property);
            }
            qFilter.__setProperty(property + "." + propertyList[1]);
        }
        DataSet billSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)formId, (String)dymAccDSMappingBill.getSelectedFileds(), (QFilter[])recListQFilter.toArray(new QFilter[recListQFilter.size()]), (String)"id asc");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outbaseqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty2nd");
        billSet = billSet.addField("qty", "inqty");
        billSet = billSet.addField("baseqty", "inbaseqty");
        billSet = billSet.addField("qtyunit2nd", "inqty2nd");
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"transnumber", String.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"configuredcode", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"tracknumber", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"producedate", Timestamp.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"expirydate", Timestamp.class);
        return billSet;
    }

    private static String transferMaterialKey(String property) {
        return property.replaceAll("materialmasterid1", "material1.masterid").replaceAll("materialmasterid", "material.masterid");
    }

    private static DataSet handleUpdateBillSendByRecAndSendType(DymAccDSMappingBill dymAccDSMappingBill, Set<QFilter> setQFilter, boolean isNeedInvScheme) {
        String formId = dymAccDSMappingBill.getSrcbill();
        ArrayList<QFilter> sendListQFilter = new ArrayList<QFilter>(10);
        for (QFilter qFilter : setQFilter) {
            sendListQFilter.add(qFilter.copy());
        }
        sendListQFilter.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        if (dymAccDSMappingBill.getqFilter() != null) {
            sendListQFilter.add(dymAccDSMappingBill.getqFilter());
        }
        if (isNeedInvScheme) {
            sendListQFilter.add(new QFilter("invscheme.isnotupdate", "=", (Object)Character.valueOf('0')));
            sendListQFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_SEND, TRASCEIVER_RECEIVE_AND_SEND}));
        }
        Map selectFiledMap = dymAccDSMappingBill.getMapping();
        for (QFilter qFilter : sendListQFilter) {
            String property;
            String qFilterName = qFilter.getProperty();
            String[] propertyList = qFilterName.split("\\.");
            if (propertyList.length == 1) {
                property = (String)selectFiledMap.get(qFilterName);
                if (property == null) continue;
                qFilter.__setProperty(property);
                continue;
            }
            property = (String)selectFiledMap.get(propertyList[0]);
            if (property == null) continue;
            if ("material".equals(propertyList[0])) {
                property = DymAccDataSource.transferMaterialKey(property);
            }
            qFilter.__setProperty(property + "." + propertyList[1]);
        }
        DataSet dataSet12 = QueryServiceHelper.queryDataSet((String)algoKey, (String)formId, (String)dymAccDSMappingBill.getSelectedFileds(), (QFilter[])sendListQFilter.toArray(new QFilter[sendListQFilter.size()]), (String)"id asc");
        dataSet12 = dataSet12.addField("qty", "outqty");
        dataSet12 = dataSet12.addField("baseqty", "outbaseqty");
        dataSet12 = dataSet12.addField("qtyunit2nd", "outqty2nd");
        dataSet12 = dataSet12.addField(TRASCEIVER_RECEIVE, "inqty");
        dataSet12 = dataSet12.addField(TRASCEIVER_RECEIVE, "inbaseqty");
        dataSet12 = dataSet12.addField(TRASCEIVER_RECEIVE, "inqty2nd");
        dataSet12 = InvcountSchemeHelper.changFiledDataType((DataSet)dataSet12, (String)"transnumber", String.class);
        dataSet12 = InvcountSchemeHelper.changFiledDataType((DataSet)dataSet12, (String)"configuredcode", Long.class);
        dataSet12 = InvcountSchemeHelper.changFiledDataType((DataSet)dataSet12, (String)"tracknumber", Long.class);
        dataSet12 = InvcountSchemeHelper.changFiledDataType((DataSet)dataSet12, (String)"producedate", Timestamp.class);
        dataSet12 = InvcountSchemeHelper.changFiledDataType((DataSet)dataSet12, (String)"expirydate", Timestamp.class);
        return dataSet12;
    }

    private static void setSelectedFiledsByFromId(DymAccDSMappingBill dymAccDSMappingBill, boolean isNeedInvScheme) {
        String formId = dymAccDSMappingBill.getSrcbill();
        String[] columnFileds = InvcountSchemeHelper.addFileds((String[])InvCountSchemeConst.getDymaccModelDimensionExcludeQty(), (String[])InvCountSchemeConst.getQtyfileds());
        Map mapping = dymAccDSMappingBill.getMapping();
        Set keySet = mapping.keySet();
        ArrayList<String> selectFiledFromDB = new ArrayList<String>(20);
        if (invBillSet.isEmpty()) {
            DymAccDataSource.initInvBillSet();
        }
        if (invBillSet.contains(formId)) {
            String materilaField = ((String)mapping.get("material")).replace("material.masterid", "materialmasterid").replace("material1.masterid", "materialmasterid1");
            mapping.put("material", materilaField);
        }
        for (String columnFiled : columnFileds) {
            if ("lotnumber".equals(columnFiled)) {
                selectFiledFromDB.add((String)mapping.get("lotnum") + " as lotnumber");
            }
            if ("qtyunit2nd".equals(columnFiled)) {
                selectFiledFromDB.add((String)mapping.get("qty2nd") + " as qtyunit2nd");
            }
            if (keySet.contains(columnFiled)) {
                selectFiledFromDB.add((String)mapping.get(columnFiled) + " as " + columnFiled);
                continue;
            }
            if (invList.contains(columnFiled)) continue;
            Object defaultValue = DymAccDataSource.getFieldDefaultValue(columnFiled);
            selectFiledFromDB.add(defaultValue + " as " + columnFiled);
        }
        selectFiledFromDB.add("id");
        selectFiledFromDB.add("billno");
        selectFiledFromDB.add("billstatus");
        selectFiledFromDB.add("biztime");
        selectFiledFromDB.add("biztype");
        selectFiledFromDB.add("creator");
        selectFiledFromDB.add("auditor");
        selectFiledFromDB.add("'" + formId + "' as billType");
        selectFiledFromDB.add("billentry.noupdateinvfields as noupdateinvfields");
        if (isNeedInvScheme) {
            selectFiledFromDB.add("invscheme");
            selectFiledFromDB.add("invscheme.transceivertype.id as transnumber");
        } else {
            selectFiledFromDB.add("0 as invscheme");
            if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
                switch (formId) {
                    case "im_adjustbill": {
                        selectFiledFromDB.add("'transrec' as transnumber");
                        break;
                    }
                    case "im_assembbill": {
                        selectFiledFromDB.add("'assembbillrec' as transnumber");
                        break;
                    }
                    case "im_disassemblebill": {
                        selectFiledFromDB.add("'disassemblebillrec' as transnumber");
                        break;
                    }
                    case "im_locationtransfer": {
                        selectFiledFromDB.add("'locationtransferbillrec' as transnumber");
                        break;
                    }
                }
            } else if ("SUB".equals(dymAccDSMappingBill.getUpdateType())) {
                switch (formId) {
                    case "im_adjustbill": {
                        selectFiledFromDB.add("'transsend' as transnumber");
                        break;
                    }
                    case "im_assembbill": {
                        selectFiledFromDB.add("'assembbillsend' as transnumber");
                        break;
                    }
                    case "im_disassemblebill": {
                        selectFiledFromDB.add("'disassemblebillsend' as transnumber");
                        break;
                    }
                    case "im_locationtransfer": {
                        selectFiledFromDB.add("'locationtransferbillsend' as transnumber");
                        break;
                    }
                }
            }
        }
        dymAccDSMappingBill.setSelectedFileds(String.join((CharSequence)",", selectFiledFromDB.toArray(new String[selectFiledFromDB.size()])));
    }

    private static Object getFieldDefaultValue(String columnFiled) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
        Map allFields = dt.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)allFields.get(columnFiled);
        if (property instanceof BasedataProp || property instanceof QtyProp) {
            return 0;
        }
        if (property instanceof TextProp || property instanceof ItemClassTypeProp) {
            return null;
        }
        if (property instanceof DateProp) {
            return null;
        }
        return null;
    }

    private static OrmInput getBillInput(Set<QFilter> listQFilter, DataSet billSet, DymAccDSMappingBill dymAccDSMappingBill, String formId) {
        ArrayList<QFilter> recListQFilter = new ArrayList<QFilter>(10);
        for (QFilter qFilter : listQFilter) {
            recListQFilter.add(qFilter.copy());
        }
        recListQFilter.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        if (dymAccDSMappingBill.getqFilter() != null) {
            recListQFilter.add(dymAccDSMappingBill.getqFilter());
        }
        recListQFilter.add(new QFilter("invscheme.isnotupdate", "=", (Object)Character.valueOf('0')));
        if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
            recListQFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_RECEIVE, TRASCEIVER_RECEIVE_AND_SEND}));
        } else {
            recListQFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_SEND, TRASCEIVER_RECEIVE_AND_SEND}));
        }
        Map selectFiledMap = dymAccDSMappingBill.getMapping();
        for (QFilter qFilter : recListQFilter) {
            String property;
            String qFilterName = qFilter.getProperty();
            String[] propertyList = qFilterName.split("\\.");
            if (propertyList.length == 1) {
                property = (String)selectFiledMap.get(qFilterName);
                if (property == null) continue;
                qFilter.__setProperty(property);
                continue;
            }
            property = (String)selectFiledMap.get(propertyList[0]);
            if (property == null) continue;
            if ("material".equals(propertyList[0])) {
                property = DymAccDataSource.transferMaterialKey(property);
            }
            qFilter.__setProperty(property + "." + propertyList[1]);
        }
        return new OrmInput(algoKey, formId, dymAccDSMappingBill.getSelectedFileds(), recListQFilter.toArray(new QFilter[recListQFilter.size()]));
    }

    protected static DataSet handleUpdateBillNotSceme(Set<QFilter> setQFilter, DataSet billSet, DymAccDSMappingBill dymAccDSMappingBill, String formId) {
        try {
            if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
                billSet = billSet != null ? billSet.union(DymAccDataSource.handleUpdateBillRecByRecAndSendType(dymAccDSMappingBill, setQFilter, false)) : DymAccDataSource.handleUpdateBillRecByRecAndSendType(dymAccDSMappingBill, setQFilter, false);
            } else if ("SUB".equals(dymAccDSMappingBill.getUpdateType())) {
                billSet = billSet != null ? billSet.union(DymAccDataSource.handleUpdateBillSendByRecAndSendType(dymAccDSMappingBill, setQFilter, false)) : DymAccDataSource.handleUpdateBillSendByRecAndSendType(dymAccDSMappingBill, setQFilter, false);
            }
        }
        catch (AlgoException algoException) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u95f4\u6570\u636eunion\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u201c%1s\u201d\u7684\u4f59\u989d\u89c4\u5219\u6620\u5c04\u914d\u7f6e\u201c%2s\u201d\u3002", (String)"DymAccDataSource_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), formId, algoException.getMessage()));
        }
        catch (Exception e) {
            throw e;
        }
        return billSet;
    }

    private static DataSet handleBillDataSet(DataSet billSet, String str) {
        if ("ADD".contentEquals(str)) {
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "outbaseqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty2nd");
            billSet = billSet.addField("qty", "inqty");
            billSet = billSet.addField("baseqty", "inbaseqty");
            billSet = billSet.addField("qtyunit2nd", "inqty2nd");
        } else {
            billSet = billSet.addField("qty", "outqty");
            billSet = billSet.addField("baseqty", "outbaseqty");
            billSet = billSet.addField("qtyunit2nd", "outqty2nd");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "inqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "inbaseqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "inqty2nd");
        }
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"transnumber", String.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"billType", String.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"outqty", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"outbaseqty", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"outqty2nd", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"inqty", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"inbaseqty", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"inqty2nd", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"configuredcode", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"tracknumber", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"producedate", Timestamp.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"expirydate", Timestamp.class);
        billSet = billSet.orderBy(new String[]{"id asc"});
        return billSet;
    }

    private static void initInvBillSet() {
        for (String invFormId : invFormIds) {
            invBillSet.add(invFormId);
        }
    }
}

